<!-----------------------------------------------------------------------------
Document:	auto_close.cfm
Purpose:	Set auto close date/time for entire auction or individual item.
					If the "no" parameter is passed in the URL, then it identifies the
					individual item no to set for auto close. If not passed, then its
					to close the entire auction.
------------------------------------------------------------------------------>
<!--- If del URL parameter, delete the auto close from DB and CF schedule --->
<cfif isdefined("url.del")>
	<cfif isdefined("url.no")>
		<cfquery datasource="#db#">
			update tblItems set itm_close_time = ''
			where itm_no = #url.no#
		</cfquery>
<!--- 		<cfschedule action="DELETE" task="auction_item#url.no#_auto_close"> --->
	<cfelse>
		<cfquery datasource="#db#">
			update tblMaster set mst_close_time = ''
			where mst_no = 1
		</cfquery>
		<!--- <cfschedule action="DELETE" task="auction_auto_close"> --->
	</cfif>
</cfif>

<!--- If upd URL parameter, set the auto close in DB and CF schedule --->
<cfif isdefined("url.upd")>
	<cfset cdate="#form.month#/#form.day#/#form.year#">
	<cfif not isdate(cdate)>
		<cfoutput>#form.month#/#form.day#/#form.year# es una fecha inv&aacute;lida.</cfoutput><p>
		<a href="javascript:history.back()">Atr&aacute;s a seleccionar fecha</a>
		<cfabort>
	</cfif>
	<cfif datediff("d",now(),cdate) lt 0>
		<cfoutput>#form.month#/#form.day#/#form.year# ya pas&oacute;.</cfoutput><p>
		<a href="javascript:history.back()">Atr&aacute;s a seleccionar fecha</a>
		<cfabort>
	</cfif>
	<cfif form.ampm eq "PM" and form.hour neq 12>
		<cfset form.hour = form.hour + 12>
	<cfelseif form.ampm eq "AM" and form.hour eq 12>
		<cfset form.hour = "00">
	</cfif>
	<cfset ctime="#form.hour#:#form.minute#:00">
	<cfif isdefined("url.no")>
		<cfquery datasource="#db#">
			update tblItems set itm_close_time = '#cdate# #ctime#'
			where itm_no = #url.no#
		</cfquery>
		<!--- <cfschedule action="UPDATE" task="auction_item#url.no#_auto_close"  operation="HTTPRequest" url="http://localhost#httppath#auc_admin/close_auction.cfm?close=yes&no=#url.no#&task=auction_item#url.no#_auto_close" startdate="#cdate#" starttime="#ctime#" interval="once" resolveurl="No" publish="No"> --->
	<cfelse>
		<cfquery datasource="#db#">
			update tblMaster set mst_close_time = '#cdate# #ctime#'
			where mst_no = 1
		</cfquery>
		<!--- <cfschedule action="UPDATE" task="auction_auto_close"  operation="HTTPRequest" url="http://localhost#httppath#auc_admin/close_auction.cfm?close=yes&task=auction_auto_close" startdate="#cdate#" starttime="#ctime#" interval="once" resolveurl="No" publish="No"> --->
	</cfif>
</cfif>

<!--- Query DB to get current close time --->
<cfif isdefined("url.no")>
	<cfquery name="getclose" datasource="#db#">
		select itm_name, itm_close_time from tblItems
		where itm_no = #url.no#
	</cfquery>
<cfelse>
	<cfquery name="getclose" datasource="#db#">
		select mst_close_time from tblMaster
		where mst_no = 1
	</cfquery>
</cfif>

<html>
<head>
<title>Cierre automatico remate</title>
<link rel="stylesheet" type="text/css" href="../auction.css">
</head>
<body bgcolor="#cccccc">
<div align="center">
<table border="0" cellpadding="5" cellspacing="0">
<tr><td align="center" bgcolor="#00ff00"><img src="../remates.gif" width="324" height="50" alt="Remates y Trueques" border="0"></td></tr>
<tr><td bgcolor="#ffffff">
<br>
<cfif isdefined("url.no")>
	<h2 align="center">Autocerrar item</h2>
	<cfoutput>Item: <b>#getclose.itm_name#</b><br>
	Cierre actual:
	<cfif getclose.itm_close_time eq "">
		<b>Ninguno</b>
	<cfelse>
		<b>#dateformat(getclose.itm_close_time,"dd/mm/yyyy")# -  #timeformat(getclose.itm_close_time,"h:mm tt")#</b>&nbsp;&nbsp;&nbsp;<a href="auto_close.cfm?del=yes&no=#url.no#">Borrar</a>
	</cfif>
	<form action="auto_close.cfm?upd=yes&no=#url.no#" method="post">
	</cfoutput>
<cfelse>
	<h2 align="center">Autocerrar remate o item</h2>
	Cierre actual:
	<cfif getclose.mst_close_time eq "">
		<b>Ninguno</b>
	<cfelse>
		<b><cfoutput>#dateformat(getclose.mst_close_time,"dd/mm/yyyy")# -  #timeformat(getclose.mst_close_time,"h:mm tt")#</cfoutput></b>&nbsp;&nbsp;&nbsp;<a href="auto_close.cfm?del=yes">Borrar</a>
	</cfif>
	<form action="auto_close.cfm?upd=yes" method="post">
</cfif>
<table>
<tr>
	<td align="right"><b>Cerrar remate el:</b></td>
	<td><select name="month">
   <option value="1">Ene
   <option value="2">Feb
   <option value="3">Mar
   <option value="4">Abr
   <option value="5">May
   <option value="6">Jun
   <option value="7">Jul
   <option value="8">Ago
   <option value="9">Sep
   <option value="10">Oct
   <option value="11">Nov
   <option value="12">Dic
	</select>
	<select name="day">
	<cfloop index="idx" from="1" to="31" step="1">
	<cfoutput><option value="#idx#">#idx#</cfoutput>
	</cfloop>
	</select>
	<select name="year">
	<cfloop index="idx" from="#dateformat(now(),'yyyy')#" to="#dateformat(dateadd('yyyy',3,now()),'yyyy')#" step="1">
  <cfoutput><option value="#idx#">#idx#</cfoutput>
	</cfloop>
	</select>
	</td>
</tr>
<tr>
	<td align="right"><b>A las:</b></td>
	<td><select name="hour">
   <option>1
   <option>2
   <option>3
   <option>4
   <option>5
   <option>6
   <option>7
   <option>8
   <option>9
   <option>10
   <option>11
   <option>12
   </select>
   <b>:</b>
   <select name="minute">
   <option>00
   <option>15
   <option>30
   <option>45
   </select>
   <select name="ampm">
   <option>AM
   <option>PM
   </select>
	</td>
</tr>
<tr>
	<td colspan="2" align="center"><input type="Submit" value="Setear hora cierre"></td>
</tr>
</table>
</form>
<p><a href="index.cfm">Menu Admin</a><br><br>
</td></tr></table>
</div>
</body>
</html>



