<!-----------------------------------------------------------------------------
Document:	submit_bid_update.cfm
Purpose:	Record bidders info into database.
------------------------------------------------------------------------------>
<cfif not isdefined("form.name")><cflocation url="index.cfm" addtoken="No"></cfif>

<!--- If complete auction is closed, don't let them bid --->
<cfquery name="getmaster" datasource="#db#">
	SELECT * FROM tblMaster
	WHERE mst_no = 1
</cfquery>
<cfif not getmaster.mst_status>
	<b>The auction is closed.</b><br>
	<a href="index.cfm">Back to Auction Items</a>
	<cfabort>
</cfif>
<!--- If this item is closed, don't let them bid --->
<cfquery name="getitem" datasource="#db#">
	select itm_status from tblItems
	where itm_no = #form.no# 
</cfquery>
<cfif not getitem.itm_status>
	<b>Bidding is closed on this item.</b><br>
	<a href="index.cfm">Back to Auction Items</a>
	<cfabort>
</cfif>

<!--- Validate email address --->
<cf_evalid myemail="#trim(form.email)#">
<cfif eValid gt 0>
	<script language="JavaScript" type="text/javascript">
		alert("The email entered is not a validly formatted email address. Please re-enter.");
		history.go(-1);
	</script>
	<cfabort>
</cfif>

<!--- See if bidder already on file by email. --->
<cfquery name="getbidder" datasource="#db#">
	SELECT bdr_no FROM tblBidders
	WHERE bdr_email = '#trim(form.email)#'
</cfquery>
<cfif getbidder.recordcount eq 0>
	<cfquery datasource="#db#">
		INSERT INTO tblBidders (bdr_name, bdr_phone, bdr_email)
		VALUES ('#form.name#', '#form.phone#', '#trim(form.email)#')
	</cfquery>
	<cfquery name="getbidder" datasource="#db#">
		SELECT bdr_no FROM tblBidders
		WHERE bdr_email = '#trim(form.email)#'
	</cfquery>
</cfif>

<!--- If configured, get the previous high bidder's e-mail to notify them someone else has bid higher --->
<cfif notify eq "Y">
	<cfquery name="getcurbidder" datasource="#db#">
		select bdr_email, bdr_name, itm_name from tblbidders, tblitems
		where itm_no = #form.no# and bdr_no = itm_bidder_no
	</cfquery>
	<cfif len(trim(getcurbidder.bdr_email)) neq 0>
		<cfmail to="#getcurbidder.bdr_email#" from="#emailaddr#" subject="Silent Auction Bid Eclipsed">#getcurbidder.bdr_name#
	
	Your bid on #getcurbidder.itm_name# in the Silent Auction has been surpassed. The new high bid is $#form.bid_amount#. You may re-bid on this by going to http://#cgi.server_name##httppath#submit_bid.cfm?no=#form.no#
		</cfmail>
	</cfif>
</cfif>

<!--- Get current bid from database and make sure this one is larger in case we have mutliple threads active --->
<cftransaction>
<cfquery name="getbid" datasource="#db#">
	SELECT itm_bid_amount FROM tblItems
	WHERE itm_no = #form.no#
</cfquery>
<cfif form.bid_amount lte getbid.itm_bid_amount>
	<script language="JavaScript" type="text/javascript">
		alert("Sorry, your bid has been eclipsed in the last few seconds.");
		<cfoutput>location.href="submit_bid.cfm?no=#form.no#";</cfoutput>
	</script>
	<cfabort>
</cfif>
<cfquery datasource="#db#">
	UPDATE tblItems
	SET itm_bid_amount = #form.bid_amount#,
		itm_bidder_no = #getbidder.bdr_no#
	WHERE itm_no = #form.no#
</cfquery>
<cfquery name="getitem" datasource="#db#">
	SELECT itm_name FROM tblItems
	WHERE itm_no = #form.no#
</cfquery>
</cftransaction>
<html>
<head>
	<title>Bid Successful</title>
<link rel=stylesheet type="text/css" href="auction.css">
</head>
<body bgcolor="#cccccc">
<div align="center">
<table border=0 cellpadding=5 cellspacing=0 width=324>
<tr><td align="center" bgcolor="#000000"><img src="auction.gif" width="324" height="49" alt="Simple Silent Auction" border="0"></td></tr>
<tr><td align=center bgcolor="#ffffff">
<h2>Bid Successful</h2>
<cfoutput query="getitem">
Your bid for the #itm_name# of #dollarformat(form.bid_amount)# is now the current high bid.<br>
<br>
</cfoutput>
</td></tr>
<tr><td bgcolor="#ffffff"><a href="index.cfm">List Auction Items</a></td>
</tr></table>
</div>
</body>
</html>
