<!-----------------------------------------------------------------------------
Document:	submit_bid.cfm
Purpose:	Submit a bid for the item number passed on URL line.
------------------------------------------------------------------------------>
<cfif not isdefined("url.no")><cflocation url="index.cfm" addtoken="No"></cfif>
<cfheader name="Pragma" value="no-cache">
<cfheader name="Expires" value="Wed, 20 Dec 2000 12:00:00 GMT">
<cfheader name="Cache-Control" value="no-cache, no-store, must-revalidate, max-age=0">

<!--- If complete auction is closed, don't let them bid --->
<cfquery name="getmaster" datasource="#db#">
	SELECT * FROM tblMaster
	WHERE mst_no = 1
</cfquery>
<cfif not getmaster.mst_status>
	<b>The auction is closed.</b><br>
	<a href="index.cfm">Back to Auction Items</a>
	<cfabort>
</cfif>
<!--- If this item is closed, don't let them bid --->
<cfquery name="getitem" datasource="#db#">
	select itm_status from tblItems
	where itm_no = #url.no# 
</cfquery>
<cfif not getitem.itm_status>
	<b>Bidding is closed on this item.</b><br>
	<a href="index.cfm">Back to Auction Items</a>
	<cfabort>
</cfif>

<cfquery name="getitem" datasource="#db#">
	SELECT itm_name, itm_bid_amount
	FROM tblItems
	WHERE itm_no = #url.no#
</cfquery>
<cfset bidamt = getitem.itm_bid_amount + 1.00>	<!--- prefill bid with $1 more --->

<html>
<head>
<title>Bid on Auction Item</title>
<link rel=stylesheet type="text/css" href="auction.css">
<script language = "JavaScript">
<!--
// Check for null and for empty

function isFilled(elm) {
    if (elm.value == "" ||
        elm.value == null) 
    return false;
    else return true;
}

function isReady(form) {

    if (isFilled(form.name) == false) {
    alert("Please enter your name.");
    return false;
    }

    if (isFilled(form.phone) == false) {
    alert("Please enter your phone number.");
    return false;
    }
		
    if (isFilled(form.email) == false) {
    alert("Please enter your email address.");
    return false;
    }
		
<cfoutput>
		if ((form.bid_amount.value * 1.00) <= (#getitem.itm_bid_amount# * 1.00)) {
</cfoutput>
	    alert("Amount to bid must be higher than current bid.");
	    form.bid_amount.focus();
	    return false;
    }

return true;
}
//-->
</script>
</head>
<body bgcolor="#cccccc" onload="document.entryform.name.focus()">
<div align="center">
<table border="0" cellpadding="5" cellspacing="0">
<tr><td align="center" bgcolor="#000000"><img src="auction.gif" width="324" height="49" alt="Simple Silent Auction" border="0"></td></tr>
<tr><td bgcolor="#ffffff" align="center">
<cfoutput query="getitem">
<b>Submit Bid For:<br>#itm_name#<br>
Current Bid: <font color="##ff0000">#dollarformat(getitem.itm_bid_amount)#</font></b></td></tr>
<tr><td bgcolor="##ffffff">
	<form action="submit_bid_update.cfm" method="POST" onSubmit="return isReady(this)" name="entryform">
	<table>
	<tr>
		<td align="right">Name</td><td><input type="text" name="name" size="40" maxlength="50"></td>
	</tr>
	<tr>
		<td align="right">Phone</td><td><input type="text" name="phone" size="15" maxlength="20"></td>
	</tr>
	<tr>
		<td align="right">Email</td><td><input type="text" name="email" size="30" maxlength="50"></td>
	</tr>
	<tr>
		<td align="right">Bid $</td><td><input type="text" name="bid_amount" value="#bidamt#" size="10" maxlength="10"></td>
	</tr>
	<tr><td colspan="2" align="center"><input type="submit" value="Submit Bid"></td></tr>
	</table>
<input type="Hidden" name="name_required" value="You must enter your name">
<input type="Hidden" name="phone_required" value="You must enter your phone">
<input type="Hidden" name="email_required" value="You must enter your email">
<input type="Hidden" name="bid_amount_float" value="You must enter only numeric values">
<input type="Hidden" name="no" value="#url.no#">
</form>
</cfoutput>
<a href="index.cfm">List Auction Items</a><br>
&nbsp;
</td></tr></table>
</div>
</body>
</html>



