<?php
/* This file is part of a copyrighted work; it is distributed with NO WARRANTY.
 * See the file COPYRIGHT.html for more details.
 */
 
/**********************************************************************************
 *   Instructions for translators:
 *
 *   All gettext key/value pairs are specified as follows:
 *     $trans["key"] = "<php translation code to set the $text variable>";
 *   Allowing translators the ability to execute php code withint the transFunc string
 *   provides the maximum amount of flexibility to format the languange syntax.
 *
 *   Formatting rules:
 *   - Resulting translation string must be stored in a variable called $text.
 *   - Input arguments must be surrounded by % characters (i.e. %pageCount%).
 *   - A backslash ('\') needs to be placed before any special php characters 
 *     (such as $, ", etc.) within the php translation code.
 *
 *   Simple Example:
 *     $trans["homeWelcome"]       = "\$text='Welcome to OpenBiblio';";
 *
 *   Example Containing Argument Substitution:
 *     $trans["searchResult"]      = "\$text='page %page% of %pages%';";
 *
 *   Example Containing a PHP If Statment and Argument Substitution:
 *     $trans["searchResult"]      = 
 *       "if (%items% == 1) {
 *         \$text = '%items% result';
 *       } else {
 *         \$text = '%items% results';
 *       }";
 *
 **********************************************************************************
 */

#****************************************************************************
#*  Common translation text shared among multiple pages
#****************************************************************************
$trans["circCancel"]              = "\$text = 'Cancelar';";
$trans["circDelete"]              = "\$text = 'Borrar';";
$trans["circLogout"]              = "\$text = 'Logout';";
$trans["circAdd"]                 = "\$text = 'Agregar';";
$trans["mbrDupBarcode"]           = "\$text = 'Numero codigo barras, %barcode%, esta en uso.';";

#****************************************************************************
#*  Translation text for page index.php
#****************************************************************************
$trans["indexHeading"]            = "\$text='Circulacion';";
$trans["indexCardHdr"]            = "\$text='Buscar miembro por numero de tarjeta:';";
$trans["indexCard"]               = "\$text='Tarjeta numero:';";
$trans["indexSearch"]             = "\$text='Buscar';";
$trans["indexNameHdr"]            = "\$text='Buscar miembro por apellido:';";
$trans["indexName"]               = "\$text='Apellido empieza con:';";

#****************************************************************************
#*  Translation text for page mbr_new_form.php, mbr_edit_form.php and mbr_fields.php
#****************************************************************************
$trans["Mailing Address:"] = "\$text='Direccion de correo:';";
$trans["mbrNewForm"]              = "\$text='Agregar nuevo';";
$trans["mbrEditForm"]             = "\$text='Editar';";
$trans["mbrFldsHeader"]           = "\$text='Miembro:';";
$trans["mbrFldsCardNmbr"]         = "\$text='Tarjeta numero:';";
$trans["mbrFldsLastName"]         = "\$text='Apellido:';";
$trans["mbrFldsFirstName"]        = "\$text='Nombre:';";
$trans["mbrFldsAddr1"]            = "\$text='Direccion linea 1:';";
$trans["mbrFldsAddr2"]            = "\$text='Direccion linea 2:';";
$trans["mbrFldsCity"]             = "\$text='Ciudad:';";
$trans["mbrFldsStateZip"]         = "\$text='C.P.:';";
$trans["mbrFldsHomePhone"]        = "\$text='Telefono casa:';";
$trans["mbrFldsWorkPhone"]        = "\$text='Telefono trabajo:';";
$trans["mbrFldsEmail"]            = "\$text='Email:';";
$trans["mbrFldsClassify"]         = "\$text='Classificacion:';";
$trans["mbrFldsGrade"]            = "\$text='Grado o Ao:';";
$trans["mbrFldsTeacher"]          = "\$text='Profesor:';";
$trans["mbrFldsSubmit"]           = "\$text='Enviar';";
$trans["mbrFldsCancel"]           = "\$text='Cancelar';";
$trans["mbrsearchResult"]         = "\$text='Pag. de Resultados: ';";
$trans["mbrsearchprev"]           = "\$text='prev';";
$trans["mbrsearchnext"]           = "\$text='sig';";
$trans["mbrsearchNoResults"]      = "\$text='No se encontraron resultados.';";
$trans["mbrsearchFoundResults"]   = "\$text=' resultados encontrados.';";
$trans["mbrsearchSearchResults"]  = "\$text='Resultados busqueda:';";
$trans["mbrsearchCardNumber"]     = "\$text='Tarjeta numero:';";
$trans["mbrsearchClassification"] = "\$text='Clasificacion:';";

#****************************************************************************
#*  Translation text for page mbr_new.php
#****************************************************************************
$trans["mbrNewSuccess"]           = "\$text='Miembro agregado exitosamente.';";

#****************************************************************************
#*  Translation text for page mbr_edit.php
#****************************************************************************
$trans["mbrEditSuccess"]          = "\$text='Miembro actualizado exitosamente.';";

#****************************************************************************
#*  Translation text for page mbr_view.php
#****************************************************************************
$trans["mbrViewHead1"]            = "\$text='Informacion del miembro:';";
$trans["mbrViewName"]             = "\$text='Nombre:';";
$trans["mbrViewAddr"]             = "\$text='Direccion:';";
$trans["mbrViewCardNmbr"]         = "\$text='Tarjeta numero:';";
$trans["mbrViewClassify"]         = "\$text='Classification:';";
$trans["mbrViewPhone"]            = "\$text='Telefono:';";
$trans["mbrViewPhoneHome"]        = "\$text='C:';";
$trans["mbrViewPhoneWork"]        = "\$text='T:';";
$trans["mbrViewEmail"]            = "\$text='Email:';";
$trans["mbrViewGrade"]            = "\$text='Grado o ao:';";
$trans["mbrViewTeacher"]          = "\$text='Profesor:';";
$trans["mbrViewHead2"]            = "\$text='Estadisticas Checkout:';";
$trans["mbrViewStatColHdr1"]      = "\$text='Material';";
$trans["mbrViewStatColHdr2"]      = "\$text='Cuenta';";
$trans["mbrViewStatColHdr3"]      = "\$text='Limites';";
$trans["mbrViewStatColHdr4"]      = "\$text='Checkout';";
$trans["mbrViewStatColHdr5"]      = "\$text='Renovado';";
$trans["mbrViewHead3"]            = "\$text='Check Out Bibliografia:';";
$trans["mbrViewBarcode"]          = "\$text='Numero cod de barras:';";
$trans["mbrViewCheckOut"]         = "\$text='Check Out';";
$trans["mbrViewHead4"]            = "\$text='Bibliografias Checked Out actualmente:';";
$trans["mbrViewOutHdr1"]          = "\$text='Checked Out';";
$trans["mbrViewOutHdr2"]          = "\$text='Material';";
$trans["mbrViewOutHdr3"]          = "\$text='Cod. barras';";
$trans["mbrViewOutHdr4"]          = "\$text='Titulo';";
$trans["mbrViewOutHdr5"]          = "\$text='Autor'";
$trans["mbrViewOutHdr6"]          = "\$text='Devolver';";
$trans["mbrViewOutHdr7"]          = "\$text='Dias tarde';";
$trans["mbrViewOutHdr8"]          = "\$text='Renovado';";
$trans["mbrViewOutHdr9"]          = "\$text='time/s';";
$trans["mbrViewNoCheckouts"]      = "\$text='No hay bibliografias actualmente checked out.';";
$trans["mbrViewHead5"]            = "\$text='Poner retencion:';";
$trans["mbrViewHead6"]            = "\$text='Bibliografias actualmente en retencion:';";
$trans["mbrViewPlaceHold"]        = "\$text='Poner retencion';";
$trans["mbrViewHoldHdr1"]         = "\$text='Funcion';";
$trans["mbrViewHoldHdr2"]         = "\$text='Puesto en retencion';";
$trans["mbrViewHoldHdr3"]         = "\$text='Material';";
$trans["mbrViewHoldHdr4"]         = "\$text='Cod. barras';";
$trans["mbrViewHoldHdr5"]         = "\$text='Titulo';";
$trans["mbrViewHoldHdr6"]         = "\$text='Author';";
$trans["mbrViewHoldHdr7"]         = "\$text='Status';";
$trans["mbrViewHoldHdr8"]         = "\$text='Due Back';";
$trans["mbrViewNoHolds"]          = "\$text='No hay bibliograpfias en retencion.';";
$trans["mbrViewBalMsg"]           = "\$text='Nota: El miembro tiene un balance de  %bal%.';";
$trans["mbrPrintCheckouts"]	  = "\$text='imprimir checkouts';";
$trans["mbrViewDel"]              = "\$text='borr';";

#****************************************************************************
#*  Translation text for page checkout.php
#****************************************************************************
$trans["checkoutBalErr"]          = "\$text='El miembro debe pagar outstanding account balance before checking out.';";
$trans["checkoutErr1"]            = "\$text='El numero de cod. de barras debe ser alfanumerico.';";
$trans["checkoutErr2"]            = "\$text='No se encontro bibliografia con ese numero de cod. barras.';";
$trans["checkoutErr3"]            = "\$text='Bibliografia con cod. barras %barcode% ya esta checked out.';";
$trans["checkoutErr4"]            = "\$text='Bibliografia con cod. barras %barcode% no disponible para checkout.';";
$trans["checkoutErr5"]            = "\$text='Bibliografia con cod. barras %barcode% esta en retencion para otro miembro.';";
$trans["checkoutErr6"]            = "\$text='El miembro alcanzo el limite checkout para este tipo de bibliografias.';";
$trans["checkoutErr7"]            = "\$text='Bibliografia con cod. barras %barcode% alcanzo el limite de renovaciones.';";
$trans["checkoutErr8"]            = "\$text='Bibliografia con cod. barras %barcode% no puede ser renovado por ser tarde.';";

#****************************************************************************
#*  Translation text for page shelving_cart.php
#****************************************************************************
$trans["shelvingCartErr1"]        = "\$text='Numero cod de barras debe ser todo alfanumenrico.';";
$trans["shelvingCartErr2"]        = "\$text='No se encontro bibliografia con ese numero de cod. barras.';";
$trans["shelvingCartTrans"]       = "\$text='Tasa demora (barcode=%barcode%)';";

#****************************************************************************
#*  Translation text for page checkin_form.php
#****************************************************************************
$trans["checkinFormHdr1"]         = "\$text='Check In bibliografia:';";
$trans["checkinFormBarcode"]      = "\$text='Numero cod. barras:';";
$trans["checkinFormShelveButton"] = "\$text='Agregar a destino estantera';";
$trans["checkinFormCheckinLink1"] = "\$text='Check in items seleccionados';";
$trans["checkinFormCheckinLink2"] = "\$text='Check in todos los items';";
$trans["checkinFormHdr2"]         = "\$text='Lista actual destino estanteria:';";
$trans["checkinFormColHdr1"]      = "\$text='Fecha escaneado';";
$trans["checkinFormColHdr2"]      = "\$text='Cod. barras';";
$trans["checkinFormColHdr3"]      = "\$text='Titulo';";
$trans["checkinFormColHdr4"]      = "\$text='Autor';";
$trans["checkinFormEmptyCart"]    = "\$text='No hay bibliografias en status estanteria.';";

#****************************************************************************
#*  Translation text for page checkin.php
#****************************************************************************
$trans["checkinErr1"]             = "\$text='No seleccion ningun item.';";

#****************************************************************************
#*  Translation text for page hold_message.php
#****************************************************************************
$trans["holdMessageHdr"]          = "\$text='La bibliografia fue puesta en retencion!';";
$trans["holdMessageMsg1"]         = "\$text='La bibliografia con cod barras %barcode% que intenta check in tiene uno o mas requerimientos de retencion puestos.  <b>Por favor archive esta bibliografia con sus elementos retenidos en lugar de destinado a estanteria.</b>  El codigo de status para esta bibliografia ha sido puesto a retener.';";
$trans["holdMessageMsg2"]         = "\$text='Volver a check in de bibliografia.';";

#****************************************************************************
#*  Translation text for page place_hold.php
#****************************************************************************
$trans["placeHoldErr1"]           = "\$text='Numero cod. barras debe ser numerico.';";
$trans["placeHoldErr2"]           = "\$text='No existe cod de barras.';";
$trans["placeHoldErr3"]           = "\$text='Este miembro ya checked out este item -- no poner retencion.';";

#****************************************************************************
#*  Translation text for page mbr_del_confirm.php
#****************************************************************************
$trans["mbrDelConfirmWarn"]       = "\$text = 'Member, %name%, has %checkoutCount% checkout(s) and %holdCount% hold request(s).  All checked out materials must be checked in and all hold requests deleted before deleting this member.';";
$trans["mbrDelConfirmReturn"]     = "\$text = 'return to member information';";
$trans["mbrDelConfirmMsg"]        = "\$text = 'Are you sure you want to delete the member, %name%?  This will also delete all checkout history for this member.';";

#****************************************************************************
#*  Translation text for page mbr_del.php
#****************************************************************************
$trans["mbrDelSuccess"]           = "\$text='Member, %name%, has been deleted.';";
$trans["mbrDelReturn"]            = "\$text='return to Member Search';";

#****************************************************************************
#*  Translation text for page mbr_history.php
#****************************************************************************
$trans["mbrHistoryHead1"]         = "\$text='Member Checkout History:';";
$trans["mbrHistoryNoHist"]        = "\$text='No history was found.';";
$trans["mbrHistoryHdr1"]          = "\$text='Barcode';";
$trans["mbrHistoryHdr2"]          = "\$text='Title';";
$trans["mbrHistoryHdr3"]          = "\$text='Author';";
$trans["mbrHistoryHdr4"]          = "\$text='New Status';";
$trans["mbrHistoryHdr5"]          = "\$text='Date of Status Change';";
$trans["mbrHistoryHdr6"]          = "\$text='Due Back Date';";

#****************************************************************************
#*  Translation text for page mbr_account.php
#****************************************************************************
$trans["mbrAccountLabel"]         = "\$text='Add a Transaction:';";
$trans["mbrAccountTransTyp"]      = "\$text='Transaction Type:';";
$trans["mbrAccountAmount"]        = "\$text='Amount:';";
$trans["mbrAccountDesc"]          = "\$text='Description:';";
$trans["mbrAccountHead1"]         = "\$text='Member Account Transactions:';";
$trans["mbrAccountNoTrans"]       = "\$text='No transactions found.';";
$trans["mbrAccountOpenBal"]       = "\$text='Opening Balance';";
$trans["mbrAccountDel"]           = "\$text='del';";
$trans["mbrAccountHdr1"]          = "\$text='Function';";
$trans["mbrAccountHdr2"]          = "\$text='Date';";
$trans["mbrAccountHdr3"]          = "\$text='Trans Type';";
$trans["mbrAccountHdr4"]          = "\$text='Description';";
$trans["mbrAccountHdr5"]          = "\$text='Amount';";
$trans["mbrAccountHdr6"]          = "\$text='Balance';";

#****************************************************************************
#*  Translation text for page mbr_transaction.php
#****************************************************************************
$trans["mbrTransactionSuccess"]   = "\$text='Transaction successfully completed.';";

#****************************************************************************
#*  Translation text for page mbr_transaction_del_confirm.php
#****************************************************************************
$trans["mbrTransDelConfirmMsg"]   = "\$text='Are you sure you want to delete this transaction?';";

#****************************************************************************
#*  Translation text for page mbr_transaction_del.php
#****************************************************************************
$trans["mbrTransactionDelSuccess"] = "\$text='Transaction successfully deleted.';";

#****************************************************************************
#*  Translation text for page mbr_print_checkouts.php
#****************************************************************************
$trans["mbrPrintCheckoutsTitle"]  = "\$text='Checkouts for %mbrName%';";
$trans["mbrPrintCheckoutsHdr1"]   = "\$text='Current Date:';";
$trans["mbrPrintCheckoutsHdr2"]   = "\$text='Member:';";
$trans["mbrPrintCheckoutsHdr3"]   = "\$text='Card Number:';";
$trans["mbrPrintCheckoutsHdr4"]   = "\$text='Classification:';";
$trans["mbrPrintCloseWindow"]     = "\$text='Close Window';";

?>
