dojo.provide('xg.video.index._shared');
dojo.provide('xg.video');

dojo.require('xg.shared.util');

xg.video = dojo.lang.mixin(xg.video, {

    fixImagesInIE: function(imgs, sync, width, height) { xg.shared.util.fixImagesInIE(imgs, sync, width, height); },
    fixTransparencyInIEProper: function(img, width, height) { xg.shared.util.fixTransparencyInIEProper(img, width, height); },
    fixTransparencyInIE: function(node) { xg.shared.util.fixTransparencyInIE(node); },

    trimTextInputsAndTextAreas: function(root) {
        dojo.lang.forEach(root.getElementsByTagName('textarea'), function(textarea) { textarea.value = dojo.string.trim(textarea.value); });
        dojo.lang.forEach(xg.video.select(root.getElementsByTagName('input'), function(input) { return input.type == 'text'; }), function(textInput) { textInput.value = dojo.string.trim(textInput.value); });
    },

    // From ningbar/js/LangHelper.js  [Jon Aquino 2006-07-03]
    select: function(array, f) {
        var result = [];
        dojo.lang.forEach(array, function(item) {
            if (f(item)) { result.push(item); }
        });
        return result;
    },

    collect: function(array, f) {
        var result = [];
        dojo.lang.forEach(array, function(item) {
            result.push(f(item));
        });
        return result;
    },

    /**
     * Returns the ancestor with a position other than the default ("static").
     * Useful for absolute positioning, which is relative to this ancestor
     *
     * @see Douglas Bowman, "Making the Absolute, Relative", http://www.stopdesign.com/articles/absolute/.
     */
    positionedAncestor: function(node) {
        if (node.parentNode.tagName == 'BODY') { return node.parentNode; }
        if (dojo.style.getStyle(node.parentNode, 'position') != 'static') { return node.parentNode; }
        return xg.video.positionedAncestor(node.parentNode);
    },

    /**
     * Toggles the open/closed state of a section (usuall a DIV) by making it visible/invisible
     * and changing the class of the toggling object to 'open'/'closed', respectively.
     *
     * @param toggleObj      The object that acts as the toggle, e.g. a H4 or P with an onclick
     *                       handler
     * @param idOfSectionObj The id of the section object
     * @param openText       Optional: the text of the toggle object when open
     * @param closedText     Optional: the text of the toggle object when closed
     */
    toggleSection: function(toggleObj, idOfSectionObj, openText, closedText) {
      var sectionObj = dojo.byId(idOfSectionObj);

      if (dojo.html.getClass(toggleObj) == 'open') {
        dojo.html.setClass(toggleObj, 'closed');
        if (closedText) {
            toggleObj.innerHTML = closedText;
        }
        sectionObj.style.display = 'none';
      } else {
        dojo.html.setClass(toggleObj, 'open');
        if (openText) {
            toggleObj.innerHTML = openText;
        }
        sectionObj.style.display = 'block';
      }
    },

    parseUrlParameters: function(url) {
        var urlParts   = url.split('?');
        var urlContent = new Object;

        if (urlParts.length > 1) {
            var urlPairs   = urlParts[1].split('&');

            for (var idx = 0; idx < urlPairs.length; idx++) {
                var kv = urlPairs[idx].split('=');

                urlContent[kv[0]] = kv[1];
            }
        }
        return urlContent;
    },

    /**
     * Returns an object that will execute the callback when its trigger() method is called, but only after a
     * given "quiescent period" in which trigger() is not called. Useful for triggering an expensive event; it will
     * run only after the triggers quiet down.
     */
    createQuiescenceTimer: function(milliseconds, callback) {
        var lastTriggerId = 0;
        return {
            trigger : function() {
                lastTriggerId++;
                var triggerId = lastTriggerId;
                window.setTimeout(function() {
                    if (triggerId == lastTriggerId) { callback(); }
                }, milliseconds);
            }
        };
    }
});

xg.video.openNingbarPanel = function(name) {
    ning.Bar.open(name);
    top.window.scrollTo(0, 0);
}

xg.video.openProfile = function(screenName) {
    ning.hooks.viewProfile(screenName);
    top.window.scrollTo(0, 0);
}

