dojo.provide('xg.shared.StarRater');

dojo.require('xg.shared.util');

/**
 * Ajax rating stars.
 */
dojo.widget.defineWidget('xg.shared.StarRater', dojo.widget.HtmlWidget, {

    /** The current rating, from 0 to 5 */
    _rating: 0,

    /** URL for the endpoint for changing a rating */
    _setRatingUrl: '',

    /** Whether the current user is a pending member */
    _isPending: false,

    /**
     * Initializes this widget.
     */
    fillInTemplate: function(args, frag) {
        var ul = this.getFragNodeRef(frag);
        dojo.lang.forEach(ul.getElementsByTagName('a'), dojo.lang.hitch(this, function(a) {
            dojo.event.connect(a, 'onclick', dojo.lang.hitch(this, function(event) {
                dojo.event.browser.stopEvent(event);
                if (this._isPending) { return xg.shared.util.promptIsPending(); }
                this.updateRating(a, ul);
            }));
        }));
    },

    /**
     * Saves the rating.
     *
     * @param a  the rating <a> that was clicked
     * @param ul  the <ul> containing the rating links
     */
    updateRating: function(a, ul) {
        var rating = parseInt(a.className.charAt(5));
        dojo.html.getElementsByClass('current', ul)[0].style.width = 13*rating + 'px';
        dojo.io.bind({
            url: this._setRatingUrl,
            method: 'post',
            content: { rating: rating },
            preventCache: true,
            encoding: 'utf-8',
            mimetype: 'text/javascript'
        });
    }

});
