dojo.provide('xg.shared.ContextHelpToggler');

dojo.require('xg.index.util.FormHelper');

/**
 * Shows/hides a help bubble.
 */
dojo.widget.defineWidget('xg.shared.ContextHelpToggler', dojo.widget.HtmlWidget, {
    fillInTemplate: function(args, frag) {
        var a = this.getFragNodeRef(frag);
        dojo.event.connect(a, 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            var popupCandidate = dojo.dom.nextElement(a);
            if (popupCandidate && dojo.html.hasClass(popupCandidate, 'context_help_popup')) {
                this.togglePopup(popupCandidate);
                return;
            }
            var popupCandidate = dojo.dom.getAncestors(a, function(element){
                return dojo.html.hasClass(element, 'context_help_popup');
            }, true);
            if (popupCandidate) {
                this.togglePopup(popupCandidate);
                return;
            }
        }));
    },
    togglePopup: function(popup) {
        if (! dojo.style.isShowing(popup)) {
            var popups = dojo.html.getElementsByClass('context_help_popup');
            for (var i=0; i<popups.length; i++) { 
                dojo.style.hide(popups[i]);
            }
        }
        dojo.style.toggleShowing(popup);
        if (dojo.style.isShowing(popup)) { xg.index.util.FormHelper.scrollIntoView(popup); }
    }
});

