dojo.provide('xg.shared.AddAsFriendLink');

dojo.require("dojo.fx.*");
dojo.require('xg.shared.util');

/**
 * An anchor tag that sends a friend request.
 */
dojo.widget.defineWidget('xg.shared.AddAsFriendLink', dojo.widget.HtmlWidget, {
    /** The username of the person */
    _screenName: '<required>',

    fillInTemplate: function(args, frag) {
        var a = this.getFragNodeRef(frag);
        dojo.event.connect(a, 'onclick', dojo.lang.hitch(this, function(evt) {
            this.doSendFriendRequest(a, evt);
        }));
    },

    doSendFriendRequest: function(a, evt) {
        dojo.event.browser.stopEvent(evt);
        var sendingMessage = dojo.html.createNodesFromText('<span>' + xg.shared.nls.html('sendingFriendRequest') + '</span>')[0];
        var sentMessage = dojo.html.createNodesFromText('<strong class="friend-pending desc">' + xg.shared.nls.html('requestSent') + '</strong>')[0];
        var currentMessage = a;
        var setMessage = function(newMessage) {
            currentMessage.parentNode.replaceChild(newMessage, currentMessage);
            currentMessage = newMessage;
        }
        setMessage(sendingMessage);
        var callbacks = {
            'success' : function() {
                setMessage(sentMessage);
                dojo.fx.html.highlight(sentMessage, 500, '#ff9');
            },
            'error' : dojo.lang.hitch(this, function(msg) {
                xg.shared.util.alert(msg);
                setMessage(a);
            })
        };
        ning.social.sendFriendRequest(this._screenName, callbacks);
    }
});
