dojo.provide('xg.shared.ActionTabs');

dojo.require('dojo.lfx.html');
dojo.require("dojo.lang");
dojo.require('xg.shared.util');

dojo.widget.defineWidget('xg.shared.ActionTabs', dojo.widget.HtmlWidget, {
    /** The url for the saving action */
    _actionUrl: "",
    /** Initial tags for the tag tab */
    _tags: "",
    /** Initial Rating value for the rating tab */
    _rating: 0,
    /** The text for the join prompt, or an empty string to skip the prompt */
    _joinPromptText: '',
    /** Whether the current user is a pending member */
    _isPending: false,
    /** The url for the signup page; used with _joinPromptText above */
    _signUpUrl: '',

    fillInTemplate: function(args, frag) {
        var li = this.getFragNodeRef(frag);
        var href = li.getElementsByTagName('a')[0];
        var action = href.className; //grab the action from the class attached to the anchor

        // determine the position, first or second
        var ul = li.parentNode;

        var nodeList = ul.getElementsByTagName('a');
        if (nodeList[0].className == action) {
            position = "first";
        } else {
            position = "second";
        }

        // add a form block after the ul element
        var formblock = dojo.html.createNodesFromText(dojo.string.trim(' \
        <form style="display: none;" class="dialog ' + position + '" id="actionForm_' + action +'"> \
            <fieldset style="display:none;"> \
            </fieldset> \
        </form>'))[0];

        dojo.html.insertAfter(formblock,ul);

        this.tabInitialize(li);

        var href = li.getElementsByTagName('a')[0];

        // attach onclick toggle
        dojo.event.connect(href, 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            if (this._joinPromptText.length || this._isPending) {
                xg.shared.util.promptToJoin(this._joinPromptText, this._isPending, dojo.lang.hitch(this, function() {
                    window.location = this._signUpUrl;
                }));
            } else {
                this.toggleState(li);
            }
        }));

    },

    tabInitialize: function(li) {
        var href = li.getElementsByTagName('a')[0];
        var action = href.className; //grab the action from the class attached to the anchor
        // add appropriate contents into the fieldset
        var actionForm = dojo.byId("actionForm_" + action);
        actionForm.action = this._actionUrl;
        var formContents = null;
        var ratingMessage = xg.shared.nls.html('youHaventRated');

        if (action == "tag") {
            formContents = dojo.html.createNodesFromText(dojo.string.trim(' \
            <fieldset style="display:block;"> \
            <dl>\
                <dt><label for="xn_action_tag">' + xg.shared.nls.html('addOrEditYourTags') + '</label></dt> \
                <dd><input id="xn_action_tag" class="textfield" type="text" size="30" maxlength="2000" value="" /></dd> \
                <dd class="note">' + xg.shared.nls.html('separateMultipleTagsWithCommas') + '</dd> \
            </dl> \
            <p class="submit"> \
                <input class="button" type="button" value="Cancel"/> \
                <input class="button" type="submit" value="Save"/> \
            </p> \
            </fieldset>'))[0];
        }

        if (action == "rate") {
            if (this._rating == 0) {
                pixels = 0;
            } else {
                ratingMessage = xg.shared.nls.html('yourRatedThis', this._rating);
                pixels = this._rating * 25;
            }
            formContents = dojo.html.createNodesFromText(dojo.string.trim(' \
            <fieldset style="display:block;"> \
                <p><strong>' + xg.shared.nls.html('addYourRating') + '</strong></p> \
                <ul class="rating" id="ratingBlock"> \
                    <li class="current" style="width: ' + pixels + 'px;">' + xg.shared.nls.html('nStarsOutOfM',0,5) + '</li> \
                    <li> \
                        <a class="stars1" title="' + xg.shared.nls.html('nStarsOutOfM',1,5) + '" href="#">1</a> \
                    </li> \
                    <li> \
                        <a class="stars2" title="' + xg.shared.nls.html('nStarsOutOfM',2,5) + '" href="#">2</a> \
                    </li> \
                    <li> \
                        <a class="stars3" title="' + xg.shared.nls.html('nStarsOutOfM',3,5) + '" href="#">3</a> \
                    </li> \
                    <li> \
                        <a class="stars4" title="' + xg.shared.nls.html('nStarsOutOfM',4,5) + '" href="#">4</a> \
                    </li> \
                    <li> \
                        <a class="stars5" title="' + xg.shared.nls.html('nStarsOutOfM',5,5) + '" href="#">5</a> \
                    </li> \
                </ul> \
                <p> \
                    <em id="ratingMessage">' + ratingMessage + '</em> \
                </p> \
            </fieldset>'))[0];
        }


        if (formContents) {
            actionForm.appendChild(formContents);
            if (action == "tag") {
                // wire up cancel button
                var formInputs = actionForm.getElementsByTagName('input');
                formInputs[0].value = this._tags;
                var cancelButton = formInputs[formInputs.length - 2];

                dojo.event.connect(cancelButton, 'onclick', dojo.lang.hitch(this, function(event) {
                    dojo.event.browser.stopEvent(event);
                    this.toggleState(li);
                }));
                dojo.event.connect(actionForm, 'onsubmit', dojo.lang.hitch(this, function(event) {
                    dojo.event.browser.stopEvent(event);
                    this.submitTags(actionForm,li);
                }));
            }
            if (action == "rate") {
                if (dojo.render.html.ie) {
                    dojo.byId('ratingBlock').style.display = 'none';
                }
                dojo.lang.forEach(actionForm.getElementsByTagName('a'), dojo.lang.hitch(this, function(a) {
                    dojo.event.connect(a, 'onclick', dojo.lang.hitch(this, function(event) {
                        dojo.event.browser.stopEvent(event);
                        var rating = parseInt(a.className.charAt(5));
                        dojo.html.getElementsByClass('current', actionForm)[0].style.width = 25*rating + 'px';
                        dojo.io.bind({
                            url: this._actionUrl,
                            method: "post",
                            content: { rating: rating },
                            preventCache: true,
                            encoding: 'utf-8',
                            mimetype: 'text/javascript',
                            load: dojo.lang.hitch(this, function(type, data, event){
                                if (data.html) {
                                    this.showMessage(actionForm,true,xg.shared.nls.html('yourRatingHasBeenAdded'));
                                    dojo.byId('ratingMessage').innerHTML = xg.shared.nls.html('yourRatedThis', rating);
                                } else {
                                    this.showMessage(actionForm,false,xg.shared.nls.html('thereWasAnErrorRating'));
                                }
                            })
                        });
                    }));
                }));
            }
        }

    },

    toggleState: function(li) {
        var action = li.className;
        var actionType = li.getElementsByTagName('a')[0].className;
        var actionForm = dojo.byId("actionForm_" + actionType);
        var successOrFailure = -1;
        if (action == "active") {
            // closing the active one
            this.toggleShut(li,actionForm);
        } else {
            // opening a non-active one
            var actionBar = li.parentNode.parentNode;
            var rawNodeList = actionBar.getElementsByTagName('li');
            var formList = actionBar.getElementsByTagName('form');
            var nodeList = new Array;
            // filter out any other li elements
            for (var i=0; i < rawNodeList.length; i++){
                if (rawNodeList[i].parentNode.className == "actions") {
                    nodeList.push(rawNodeList[i]);
                }
            }
            for (var i=0; i < nodeList.length; i++){
                if (nodeList[i].className = "active") {
                    nodeList[i].className = null;
                    formList[i].style.display = "none";
                    // reset class
                    successOrFailure = formList[i].className.indexOf(' success');
                    if (successOrFailure == -1) {
                        successOrFailure = formList[i].className.indexOf(' error');
                    }
                    if (successOrFailure != -1) {
                        formList[i].className = formList[i].className.substring(0,successOrFailure);
                        var fieldsets = formList[i].getElementsByTagName('fieldset');
                        fieldsets[0].style.display = "none";
                        fieldsets[1].style.display = "block";
                    }
                }
            }
            li.className = "active";
            dojo.lfx.wipeIn(actionForm, 300).play();
            if (actionType == 'rate' && dojo.render.html.ie) {
                dojo.lang.setTimeout(function() {
                    dojo.byId('ratingBlock').style.display = 'block';
                }, 350);
            }
        }
    },

    submitTags: function(form,li) {
        this._tags = form.getElementsByTagName('input')[0];
        dojo.io.bind({
            url: form.action,
            method  : "post",
            content: {tags: this._tags.value},
            encoding:'utf-8',
            preventCache: true,
            mimetype: 'text/javascript',
            load: dojo.lang.hitch(this, function(type, data, event){
                if (dojo.lang.has(data, "html")) {
                    this.showMessage(form,true,xg.shared.nls.html('yourTagsHaveBeenAdded'));
                } else {
                    this.showMessage(form,false,xg.shared.nls.html('thereWasAnErrorTagging'));
                }
            })
        });
    },

    toggleShut: function(li,form) {
        li.className = "";
        var actionType = li.getElementsByTagName('a')[0].className;
        dojo.lfx.wipeOut(form, 200).play();
        if (actionType == 'rate' && dojo.render.html.ie) {
            dojo.byId('ratingBlock').style.display = 'none';
        }
        // reset class
        successOrFailure = form.className.indexOf(' success');
        if (successOrFailure == -1) {
            successOrFailure = form.className.indexOf(' error');
        }
        if (successOrFailure != -1) {
            form.className = form.className.substring(0,successOrFailure);
            var fieldsets = form.getElementsByTagName('fieldset');
            fieldsets[0].style.display = "none";
            fieldsets[1].style.display = "block";
        }
    },

    showMessage: function(form,state,message) {
        var nodeList = form.parentNode.getElementsByTagName('li');
        for (var i=0; i < nodeList.length; i++){
            if (nodeList[i].className == "active") {
               li = nodeList[i];
            }
        }
        if (state) {
            form.className = form.className + ' success';
        } else {
            form.className = form.className + ' error';
        }
        var fieldsets = form.getElementsByTagName('fieldset');
        fieldsets[0].style.display = "block";
        fieldsets[1].style.display = "none";
        dojo.dom.removeChildren(fieldsets[0]);
        var wrappedMessage = dojo.html.createNodesFromText(dojo.string.trim('<p><strong>' + message + '</strong></p>'))[0];
        fieldsets[0].appendChild(wrappedMessage);
        dojo.lang.setTimeout(dojo.lang.hitch(this, function() {
            this.toggleShut(li,form);
        }), 3000);
    }



});