dojo.provide('xg.photo.index._shared');
dojo.provide('xg.photo');
dojo.require('xg.index.actionicons.ActionButton');
dojo.require('xg.shared.util');

xg.photo = dojo.lang.mixin(xg.photo, {
    fixImagesInIE: function(imgs, sync, width, height) { xg.shared.util.fixImagesInIE(imgs, sync, width, height); },
    fixTransparencyInIEProper: function(img, width, height) { xg.shared.util.fixTransparencyInIEProper(img, width, height); },
    fixTransparencyInIE: function(node) { xg.shared.util.fixTransparencyInIE(node); },

    trimTextInputsAndTextAreas: function(root) {
        dojo.lang.forEach(root.getElementsByTagName('textarea'), function(textarea) { textarea.value = dojo.string.trim(textarea.value); });
        dojo.lang.forEach(xg.photo.select(root.getElementsByTagName('input'), function(input) { return input.type == 'text'; }), function(textInput) { textInput.value = dojo.string.trim(textInput.value); });
    },

    // From ningbar/js/LangHelper.js  [Jon Aquino 2006-07-03]
    select: function(array, f) {
        var result = [];
        dojo.lang.forEach(array, function(item) {
            if (f(item)) { result.push(item); }
        });
        return result;
    },

    collect: function(array, f) {
        var result = [];
        dojo.lang.forEach(array, function(item) {
            result.push(f(item));
        });
        return result;
    },

    /**
     * Returns the ancestor with a position other than the default ("static").
     * Useful for absolute positioning, which is relative to this ancestor
     *
     * @see Douglas Bowman, "Making the Absolute, Relative", http://www.stopdesign.com/articles/absolute/.
     */
    positionedAncestor: function(node) {
        if (node.parentNode.tagName == 'BODY') {
            return node.parentNode;
        }
        if (dojo.style.getStyle(node.parentNode, 'position') != 'static') {
            return node.parentNode;
        }
        return xg.photo.positionedAncestor(node.parentNode);
    },

    /**
     * Toggles the open/closed state of a section (usuall a DIV) by making it visible/invisible
     * and changing the class of the toggling object to 'open'/'closed', respectively.
     *
     * @param toggleObj      The object that acts as the toggle, e.g. a H4 or P with an onclick
     *                       handler
     * @param idOfSectionObj The id of the section object
     * @param openText       Optional: the text of the toggle object when open
     * @param closedText     Optional: the text of the toggle object when closed
     */
    toggleSection: function(toggleObj, idOfSectionObj, openText, closedText) {
      var sectionObj = dojo.byId(idOfSectionObj);

      if (dojo.html.getClass(toggleObj) == 'open') {
        dojo.html.setClass(toggleObj, 'closed');
        if (closedText) {
            toggleObj.innerHTML = closedText;
        }
        sectionObj.style.display = 'none';
      } else {
        dojo.html.setClass(toggleObj, 'open');
        if (openText) {
            toggleObj.innerHTML = openText;
        }
        sectionObj.style.display = 'block';
      }
    },

    parseUrlParameters: function(url) {
        var urlParts   = url.split('?');
        var urlContent = new Object;

        if (urlParts.length > 1) {
            var urlPairs   = urlParts[1].split('&');

            for (var idx = 0; idx < urlPairs.length; idx++) {
                var kv = urlPairs[idx].split('=');

                urlContent[kv[0]] = kv[1];
            }
        }
        return urlContent;
    }
});

// Similar to AutoUpdatingText, but updates when a particular event is published, rather than
// on dojo.io.bind() [ David Sklar 2006-09-07 ]
dojo.provide('xg.photo.TopicUpdatingText');
dojo.widget.defineWidget('xg.photo.TopicUpdatingText', dojo.widget.HtmlWidget, {
    _url: '<required>',
    _topic: '<required>',
    _method: 'GET',
    fillInTemplate: function(args, frag) {
        var node = this.getFragNodeRef(frag);
        dojo.event.topic.subscribe(this._topic, dojo.lang.hitch(this, function() {
            if (this.isEnabled) {
                dojo.io.bind({ 'url': this._url,
                               'mimetype': 'text/json',
                               'method': this._method,
                               'encoding': 'utf-8',
                               'load': function(type, data, evt) {
                                   if ('html' in data) {
                                       node.innerHTML = data.html;
                                       xg.photo.fixImagesInIE(node.getElementsByTagName('img'));
                                   }
                                   // @todo -- What about JS that should run after the node is fixed up?
                               } // load()
                }); // bind()
            } // if (this.isEnabled)
        }) ); //hitch() and subscribe()
    } // fillInTemplate()
}); // defineWidget()

dojo.provide('xg.photo.AddRemoveButton');
dojo.widget.defineWidget('xg.photo.AddRemoveButton', xg.index.actionicons.ActionButton, {
    _addUrl: '<required>',
    _removeUrl: '<required>',
    _collection: '<required>',
    _dialogClass: 'dialog',
    _signedIn: true,
    _signInUrl: '<required>',
    _collectionUrl: '<required>',
    _hideAfterAdd: false,
    _removeTitle:'<required>',
    _addTitle:'<required>',

    fillInTemplate: function(args, frag) {
        this.init(frag);
        dojo.event.connect(this.actionButton.getElementsByTagName('a')[0], 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            if (!this._signedIn) {document.location.href=this._signInUrl;return;}
            if (! dojo.html.hasClass(this.actionButton, 'added')) {
                this.add();
                if (this._hideAfterAdd) { dojo.html.hide(this.actionButton); }
            } else {
                this.remove();
            }
        }));
    },
    add: function() {
        dojo.html.addClass(this.actionButton, 'added');
        this.setShowingAddedImage(true);
        var dialog = dojo.html.createNodesFromText(dojo.string.trim(' \
            <div class="' + this._dialogClass + '"> \
                <h4>Added!</h4> \
            </div>'))[0];
        this.showAndFadeDialog(dialog);
        this.actionButton.getElementsByTagName('a')[0].setAttribute('title', this._removeTitle);
        this.actionButton.getElementsByTagName('img')[0].setAttribute('alt', this._removeTitle);
        dojo.io.bind({
            url: this._addUrl,
            encoding: 'utf-8',
            preventCache: true,
            mimetype: 'text/javascript',
            method: 'post'
        });
    },
    remove: function() {
        dojo.html.removeClass(this.actionButton, 'added');
        this.setShowingAddedImage(false);
        var dialog = dojo.html.createNodesFromText(dojo.string.trim(' \
            <div class="' + this._dialogClass + '"> \
                <h4>Removed!</h4> \
            </div>'))[0];
        this.showAndFadeDialog(dialog);
        this.actionButton.getElementsByTagName('a')[0].setAttribute('title', this._addTitle);
        this.actionButton.getElementsByTagName('img')[0].setAttribute('alt', this._addTitle);
        dojo.io.bind({
            url: this._removeUrl,
            encoding: 'utf-8',
            preventCache: true,
            mimetype: 'text/javascript',
            method: 'post'
        });
    },
    /**
     * @param showingAddedImage Whether to show the added-image or the original image
     */
    setShowingAddedImage: function(showingAddedImage) {
        dojo.lang.forEach(this.actionButton.getElementsByTagName('img'), function(img) {
            dojo.html.setShowing(img, !showingAddedImage);
        });
        dojo.html.setShowing(dojo.html.getElementsByClass('added-image', this.actionButton)[0], showingAddedImage);
    },
    /**
     * @param showingAddedSpan Whether to show the added-span or the original span
     */
    setShowingAddedSpan: function(showingAddedSpan) {
        dojo.lang.forEach(this.actionButton.getElementsByTagName('span'), function(span) {
            dojo.html.setShowing(span, !showingAddedSpan);
        });
        dojo.html.setShowing(dojo.html.getElementsByClass('added-span', this.actionButton)[0], showingAddedSpan);
    }
});

xg.photo.openNingbarPanel = function(name) {
    ning.Bar.open(name);
    top.window.scrollTo(0, 0);
}

xg.photo.openProfile = function(screenName) {
    ning.hooks.viewProfile(screenName);
    top.window.scrollTo(0, 0);
}

xg.photo.openClonePanel = function() {
    if (!ning.Bar.open('clone')) {
        // for the app owner, cloning is only available on the manage panel
        ning.Bar.open('managePanel');
    }
    top.window.scrollTo(0, 0);
}