dojo.provide('xg.page.page.show');

dojo.require('xg.shared.util');

(function() {

    xg.page.validate = function() {
        var errors = {}
        if (form.text.value.length == 0) {
            errors['text'] = xg.page.nls.html('pleaseEnterAComment');
        }
        if (form.text.value.length > 4000) {
            errors['text'] = xg.page.nls.html('numberOfCharactersExceedsMaximum', form.text.value.length, 4000);
        }
        return errors;
    };

    var form = dojo.byId('comment-form');
    if (form) {
        dojo.require('xg.index.util.FormHelper');
        xg.index.util.FormHelper.configureValidation(form, xg.page.validate);
    }

}());

dojo.provide('xg.page.AddCommentForm');
dojo.widget.defineWidget('xg.page.AddCommentForm', dojo.widget.HtmlWidget, {
    fillInTemplate: function(args, frag) {
        var form = this.getFragNodeRef(frag);
        form.action = form.action + '&xn_out=json';
        var saving = false;
        dojo.event.connect(form, 'onsubmit', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            if (! dojo.lang.isEmpty(xg.page.validate())) { return; }
            if (saving) { return; }
            saving = true;
            dojo.html.show(dojo.html.getElementsByClass('spinner', form)[0]);
            dojo.io.bind({
                encoding: 'utf-8',
                formNode: form,
                preventCache: true,
                mimetype: 'text/javascript',
                load: function(type, data, event){
                    saving = false;
                    dojo.html.hide(dojo.html.getElementsByClass('spinner', form)[0]);
                    var comment = document.createElement('div');
                    dojo.style.setOpacity(comment, 0);
                    var moduleBody = dojo.html.getElementsByClass('xg_module_body', dojo.byId('comments_module'))[0];
                    dojo.html.show(moduleBody);
                    var pagination = dojo.html.getElementsByClass('pagination', moduleBody)[0];
                    if (pagination) {
                        dojo.dom.insertBefore(comment, pagination);
                    } else {
                        dojo.dom.insertAtPosition(comment, moduleBody, 'last');
                    }
                    if(data){
                        comment.innerHTML = data.html;
                    }
                    dojo.require("dojo.lfx.*");
                    dojo.lfx.fadeIn(comment, 500, dojo.lfx.easeIn).play();
                    form.text.value = '';
                    xg.shared.util.parseWidgets(comment);
                    var comment_counters = dojo.html.getElementsByClass('comment-count');
                    for(var i=0; i<comment_counters.length; i++) {
                        comment_counters[i].innerHTML = parseInt(comment_counters[i].innerHTML)+1
                    }
                }
            });
        }));
    }
});

dojo.provide('xg.page.DeleteCommentLink');
dojo.widget.defineWidget('xg.page.DeleteCommentLink', dojo.widget.HtmlWidget, {
    _id: '<required>',
    fillInTemplate: function(args, frag) {
        var a = this.getFragNodeRef(frag);
        var deleting = false;
        dojo.event.connect(a, 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            if (deleting) { return; }
            xg.shared.util.confirm({ bodyText: xg.page.nls.text('deleteThisComment'), onOk: dojo.lang.hitch(this, function() {
                deleting = true;
                var dl = dojo.html.getFirstAncestorByTag(a, 'dl');
                dojo.require("dojo.lfx.*");
                dojo.lfx.fadeOut(dl, 500, dojo.lfx.easeIn, function() {
                    dojo.dom.removeNode(dl);
                    var moduleBody = dojo.html.getElementsByClass('xg_module_body', dojo.byId('comments_module'))[0];
                    if (dojo.string.trim(dojo.html.renderedTextContent(moduleBody)).length == 0) {
                        dojo.html.hide(moduleBody);
                    }
                }).play();
                dojo.io.bind({
                    encoding: 'utf-8',
                    method: 'post',
                    url: '/index.php/' + xg.global.currentMozzle + '/comment/delete' + '?xn_out=json',
                    preventCache: true,
                    content: { id: this._id },
                    mimetype: 'text/javascript',
                    load: function(){
                        var comment_counters = dojo.html.getElementsByClass('comment-count');
                        for(var i=0; i<comment_counters.length; i++) {
                            comment_counters[i].innerHTML = parseInt(comment_counters[i].innerHTML)-1;
                        }
                    }
                });
            }) });
        }));
    }
});

function incrementViewCount(pageId) {
    dojo.lang.setTimeout(dojo.lang.hitch(this, function() {
        dojo.io.bind({
            url     : '/index.php/'+xg.global.currentMozzle+'/page/registershown?xn_out=json',
            content : { id: pageId },
            method  : 'post',
            encoding: 'utf-8',
            load    : dojo.lang.hitch(this, function(type, data, event) {})
        });
    }), 5000);
}