dojo.provide('xg.index.panel');

dojo.require('xg.shared.util');

xg.index.panel = dojo.lang.mixin(xg.index.panel, {
    fixImagesInIE: function(imgs, sync, width, height) { xg.shared.util.fixImagesInIE(imgs, sync, width, height); },
    fixTransparencyInIEProper: function(img, width, height) { xg.shared.util.fixTransparencyInIEProper(img, width, height); },
    fixTransparencyInIE: function(node) { xg.shared.util.fixTransparencyInIE(node); }
});

dojo.require('ning.Bar');
dojo.require('ning.social');
dojo.require('trimpath.template');

(function(){

// Open panel if requested (BAZ-720)
// Open other panels if requested (BAZ-1472)
ning.Bar.whenLoaded(function() {
    var result = window.location.search.match(/(?:xgp|xn_panel)=(\w+)/);
    if (result && result[1]) {
        var name = result[1];
        // For URL shortening
        if (name == 'friend') { name = 'friend-requests'; }
        if (ning.Bar.panelExists(name)) {
            ning.Bar.open(name);
        }
        else if (!ning.CurrentProfile) {
            // panel probably doesn't exist because user isn't signed in
            window.location = '/main/authorization/signIn?target=' + encodeURIComponent(String(window.location))
        }
    }

    //  Fix transparency of header images for IE (BAZ-1795)
    var sitename = dojo.byId('xg_sitename');
    if (sitename) {
        var images = sitename.getElementsByTagName('img');
        if (images) {
            xg.index.panel.fixImagesInIE(images, true);
        }
    }
});

var sendFriendNotification = function(invocation) {
    /* When this is called because someone sent a friend request,
     * args[0] == the person the friend request is being sent to
     *
     * When this is called because someone accepted a friend request,
     * args[0] == the person whose friend request is accepted
     */
     var notificationArgs = {'from': ning.CurrentProfile.id,
                             'to': invocation.args[0] };

     /* If a success function has been specified, then we'll call that after our
      * work */
     if (invocation.args[1] && invocation.args[1].success) {
         var oldSuccessFunction = invocation.args[1].success;
         invocation.args[1].success = function() {
            ning.api.post('/main/notification/friendRequest?xn_out=json', notificationArgs);
            oldSuccessFunction();
         };
     } else {
         invocation.args[1] = { success: function() { ning.api.post('/main/notification/friendRequest?xn_out=json', notificationArgs); } }
     }
     return invocation.proceed();
}

var sendMessageNotification = function(invocation) {
    // When ning.social.sendMessage() is invoked from openSendMessageBox(), the
    // recipient argument is different
    if (! dojo.lang.isArray(invocation.args[0].recipient)) {
        invocation.args[0].recipient = [ { to: invocation.args[0].recipient } ];
        // Also get rid of the default 'Hello' subject that the sendMessageBox() supplies
        if (invocation.args[0].subject == 'Hello') {
            invocation.args[0].subject = '';
        }
    }
    var oldSuccessFunction = invocation.args[0].success;
    invocation.args[0].success = function() {
        dojo.lang.forEach(invocation.args[0].recipient, function(recip) {
            var args = {
                to: recip.to,
                from: ning.CurrentProfile.id,
                subject: invocation.args[0].subject,
                body: invocation.args[0].body,
                /* Send along the URL in case we have to convert to an invitation */
                url: window.location.href
            };
            if (recip.name) {
                /* Send along display name in case we have to convert to an invitation */
                args.to_name = recip.name;
            }
            ning.api.post("/main/notification/messageReceived?xn_out=json", args);
        }, false);
        if (oldSuccessFunction) { oldSuccessFunction(); }
    };
    return invocation.proceed();
}

dojo.event.connect('around', ning.social, 'sendFriendRequest', sendFriendNotification);
dojo.event.connect('around', ning.social, 'sendMessage', sendMessageNotification);

}()); /* file-wide closure */
