dojo.provide('xg.index.invitation.chooseInvitationMethod');

dojo.require('xg.shared.util');
dojo.require('xg.index.util.FormHelper');
dojo.require('xg.index.message.friendList');
dojo.require('dojo.lfx.*');
dojo.require('dojo.lfx.html');
dojo.require('dojo.event.topic');

/**
 * Behavior for the chooseInvitationMethod page.
 */
(function() {

    /** The form elements */
    var forms = dojo.byId('xg_body').getElementsByTagName('form');

    /**
     * Returns whether the given form is open.
     *
     * @param form  the form element to check
     * @return  true if the form is open; false if closed
     */
    var isOpen = function(form) {
        return dojo.html.isShowing(form.getElementsByTagName('div')[0]);
    };

    /**
     * Returns the section that is currently open.
     *
     * @return  the form element, or null if no form was open
     */
    var formCurrentlyOpen = function() {
        for (var i = 0; i < forms.length; i++) {
            if (isOpen(forms[i])) { return forms[i]; }
        }
        return null;
    };

    /**
     * Opens the form if it is closed, and vice versa.
     *
     * @param form  the form element to open or close
     */
    var toggle = function(form) {
        var duration = 200;
        var animations = [];
        if (isOpen(form)) {
            form.getElementsByTagName('a')[0].getElementsByTagName('span')[0].innerHTML = '&#9658;';
            animations.push(dojo.lfx.html.wipeOut(form.getElementsByTagName('div')[0], duration))
        } else {
            form.getElementsByTagName('a')[0].getElementsByTagName('span')[0].innerHTML = '&#9660;';
            animations.push(dojo.lfx.html.wipeIn(form.getElementsByTagName('div')[0], duration, null, function() {
                xg.index.util.FormHelper.scrollIntoView(form);
            }))
        }
        dojo.lfx.combine(animations).play();
    };

    /**
     * Sets up the friend list, if it hasn't been set up already.
     */
    var initializeFriendListIfNecessary = function() {
        if (initializeFriendListIfNecessary.done) { return; }
        initializeFriendListIfNecessary.done = true;
        xg.index.message.friendList.initialize();
    };

    /**
     * Attaches the onclick handlers for accordion behavior.
     */
    dojo.lang.forEach(forms, function(form) {
        dojo.event.connect(form.getElementsByTagName('a')[0], 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            toggle(form);
            if (form.id == 'invite_friends_form') { initializeFriendListIfNecessary(); }
        }));
    });

    xg.index.util.FormHelper.scrollIntoView(formCurrentlyOpen());

	var maxMsgLength = 200, inviteByEmails = dojo.byId('invite_by_emails'), inviteFriends = dojo.byId('invite_friends_form');

	xg.shared.util.setAdvisableMaxLength(inviteByEmails.message, maxMsgLength);
	dojo.event.connect(inviteByEmails.inviteEmailsSend, 'onclick', function(event) {
		if (inviteByEmails.message.value.length > maxMsgLength) {
			dojo.event.browser.stopEvent(event);
			xg.shared.util.alert({
				title: xg.index.nls.html('error'),
				bodyHtml: xg.index.nls.html('messageIsTooLong',maxMsgLength)
			});
		}
	});

	if (inviteFriends) {
		xg.shared.util.setAdvisableMaxLength(inviteFriends.inviteFriendsMessage, maxMsgLength);
		dojo.event.connect(inviteFriends.inviteFriendsSend, 'onclick', function (event) {
			if (inviteFriends.inviteFriendsMessage.value.length > maxMsgLength) {
				dojo.event.browser.stopEvent(event);
				xg.shared.util.alert({
					title: xg.index.nls.html('error'),
					bodyHtml: xg.index.nls.html('messageIsTooLong',maxMsgLength)
				});
			}
		});
	}

    /**
     * Initializes the Invite Friends form.
     */
    if (dojo.byId('invite_friends_form')) {
        dojo.event.topic.subscribe('xg.index.message.friendList.pageBuilt', function() {
            if (isOpen(dojo.byId('invite_friends_form'))) {
                // Re-scroll, as spinner div is shorter than actual div [Jon Aquino 2007-12-31]
                xg.index.util.FormHelper.scrollIntoView(dojo.byId('invite_friends_form'));
            }
        });
        if (isOpen(dojo.byId('invite_friends_form'))) { initializeFriendListIfNecessary(); }
        dojo.event.connect(dojo.byId('invite_friends_form'), 'onsubmit', function(event) {
            xg.index.message.friendList.onSubmit();
        });
    }

    if (dojo.byId('bulk_invitation_url_field')) {
        xg.shared.util.selectOnClick(dojo.byId('bulk_invitation_url_field'));
    }
}());
