dojo.provide('xg.index.dom');

/**
 * Useful functions for working with the DOM.
 */

xg.index.dom = {

    /**
     * Walks the DOM tree starting at a given point. If test returns true, it stops walking.
     * Alternatively, if test never returns true, this is a handy way to traverse the tree.
     *
     * @param Node parent The root node of the subtree to walk
     * @param function test Function that is passed a Node; returns whether to stop walking the tree.
     */
    findProper: function(parent, test) {
        if (parent instanceof dojo.widget.Widget) { return ning._.dom.findProper(parent.domNode, test); }
        for (var i = 0; i < parent.childNodes.length; i++) {
            if (test(parent.childNodes[i])) { return parent.childNodes[i]; }
        }
        for (i = 0; i < parent.childNodes.length; i++) {
            var result = ning._.dom.findProper(parent.childNodes[i], test);
            if (result) { return result; }
        }
        return null;
    }

};

