dojo.provide('xg.html.embed.embed');
dojo.require('xg.shared.util');
dojo.require('xg.shared.SimpleToolbar');

// Possible Dojo bug: the widget doesn't get defined if "html"
// is in the package name. So use "_html". [Jon Aquino 2006-11-18]

dojo.provide('xg._html.embed.embed.HtmlModule');
dojo.widget.defineWidget('xg._html.embed.embed.HtmlModule', dojo.widget.HtmlWidget, {
    // Use '<required>' as there is a Dojo bug preventing the attributes from being recognized if the defaults are instead null [Jon Aquino 2006-11-18]
    url: '<required>',
    /** The title string. */
    _title: '',
    /** The maximum string length allowed for the html. */
    _maxLength: 0,
    hasDefaultContent: false,
    /** URL for the "Add a widget to this textbox" link, or null to hide the link */
    addWidgetUrl: '',
    /** The spinner image */
    spinner: null,
    fillInTemplate: function(args, frag) {
        this.module = this.getFragNodeRef(frag);
        //prevent double parsing
        var head = dojo.html.getElementsByClass('xg_module_head', this.module)[0];
        if (head.getElementsByTagName('a').length == 0) {
            this.addEditLink();
            this.html = dojo.string.trim(dojo.html.getElementsByClass('html_code',this.module)[0].value);
        }
        // Technically the widget gets parsed twice. TODO: Try eliminating the second
        // parse by removing the dojoType attribute (wonder why Dojo allows an element
        // to be parsed more than once?) [Jon Aquino 2007-03-24]
    },
    addEditLink: function() {
        var h2 = this.module.getElementsByTagName('h2')[0];
        dojo.dom.insertAfter(dojo.html.createNodesFromText('<p class="edit"><a class="button" href="#">' + xg.html.nls.html('edit') + '</a></p>')[0], h2);
        dojo.event.connect(this.module.getElementsByTagName('a')[0], 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            this.showForm();
        }));
    },
    showForm: function() {
        var curDate = new Date();
        this.taID = 'txt' + curDate.getTime();
        dojo.html.addClass(this.module, 'editing_html_module');
        this.head = dojo.html.getElementsByClass('xg_module_head', this.module)[0];
        this.body = dojo.html.getElementsByClass('xg_module_body', this.module)[0];
        dojo.html.removeClass(this.body, "notification");
        this.head.innerHTML = '<form><input type="text" class="textfield"/></form>';
        this.body.innerHTML = ' \
                <p class="errordesc" style="display: none">' + xg.html.nls.html('contentsTooLong', this._maxLength) + '</p> \
                <p><div class="texteditor"><textarea id="' + this.taID + '"></textarea></div></p> \
                ' + (this.addWidgetUrl && ! this.hasDefaultContent ? '<span class="left">' + xg.html.nls.html('addAWidget', dojo.string.escape('html', this.addWidgetUrl)) + '</span>' : '') + ' \
                <span class="right"> \
                    <img src="/xn_resources/widgets/index/gfx/spinner.gif" alt="" style="display: none; width:20px; height:20px; margin-right:3px; vertical-align:top;" /> \
                    <input type="button" class="button submit" value="' + xg.html.nls.html('save') + '" /> \
                    <input type="button" class="button" value="' + xg.html.nls.html('cancel') + '" /> \
                </span>';
        this.input = this.head.getElementsByTagName('input')[0];
        this.textarea = this.body.getElementsByTagName('textarea')[0];
        var saveButton = dojo.html.getElementsByClass('button', this.body)[0];
        var cancelButton = dojo.html.getElementsByClass('button', this.body)[1];
        this.spinner = dojo.dom.prevElement(cancelButton, 'img');
        this.input.value = this._title;
        var html = this.html.replace(/(\r\n|\n|\r)/g,"\n");
        this.textarea.value = this.hasDefaultContent ? '' : html.replace(/<br[^>]*>\n?/ig, "\n").replace(/<\/p>\n?/ig, "</p>\n");
        dojo.require('xg.index.util.FormHelper');
        xg.index.util.FormHelper.scrollIntoView(this.module);
        var toolbar = dojo.widget.createWidget("SimpleToolbar", {_id: this.taID});
        dojo.event.connect(saveButton, 'onclick', dojo.lang.hitch(this, this.save));
        dojo.event.connect(cancelButton, 'onclick', dojo.lang.hitch(this, this.cancel));
        dojo.event.connect(this.head.getElementsByTagName('form')[0], 'onsubmit', dojo.lang.hitch(this, this.save));
        this.input.focus();
    },
    hideForm: function() {
        dojo.html.removeClass(this.module, 'editing_html_module');
        this.head.innerHTML = '<h2></h2>';
        var h2 = this.module.getElementsByTagName('h2')[0];
        h2.innerHTML = this._title ? dojo.string.escape('html', this._title) : '&nbsp;';  // &nbsp; to accomodate Edit-button height. [Jon Aquino 2008-01-14]
        this.body.innerHTML = xg.html.nls.html('saving');
    },
    save: function(event) {
        dojo.event.browser.stopEvent(event);
        var errorMessage = dojo.html.getElementsByClass('errordesc', this.body)[0];
        if (this.textarea.value.length > this._maxLength && this._maxLength > 0) {
            dojo.style.show(errorMessage);
            xg.index.util.FormHelper.scrollIntoView(errorMessage);
            return;
        }
        dojo.style.hide(errorMessage);
        this._title = this.input.value;
        this.html = xg.shared.util.nl2br(this.textarea.value);
        if (dojo.style.isShowing(this.spinner)) { return; }
        dojo.style.show(this.spinner);
        dojo.io.bind({
            url: this.url,
            method: 'post',
            content: { title: this._title, html: this.html },
            preventCache: true,
            mimetype: 'text/javascript',
            encoding: 'utf-8',
            load: dojo.lang.hitch(this, function(type, data, event) {
                dojo.style.hide(this.spinner);
                if (data.errorCode == 'TOO_LONG') {
                    dojo.style.show(errorMessage);
                    xg.index.util.FormHelper.scrollIntoView(errorMessage);
                    return;
                }
                this.hasDefaultContent = data.hasDefaultContent;
                if (data.html.match(/<script/i)) {
                    window.location.reload(true);
                }
                this.hideForm();
                this.body.innerHTML = this.html = data.html;
                this.addEditLink();
            })
        });
    },
    cancel: function(event) {
        dojo.event.browser.stopEvent(event);
        if (dojo.style.isShowing(this.spinner)) { return; }
        this.hideForm();
        this.body.innerHTML = this.html;
        this.addEditLink();
    }
});
