dojo.provide('xg.forum.embed.ForumModule');
dojo.require('xg.index.util.FormHelper');
dojo.require('xg.index.panel');
dojo.require('dojo.animation.Animation');

/**
 * The Forum module, which displays recent or popular topics on the homepage and profile page.
 */
dojo.widget.defineWidget('xg.forum.embed.ForumModule', dojo.widget.HtmlWidget, {
    /** Endpoint for saving the values */
    _setValuesUrl: '',
    /** Which topics/comments to display (popular, recent, or promoted) */
    _topicSet: '',
    /** How to display the topics/comments (titles or detail) */
    _displayOptionsJson: '',
    /** JSON array of objects, each with the following properties: label, value */
    _optionsJson: '',
    /** Number of topics/comments to display */
    _itemCount: '',
    fillInTemplate: function(args, frag) {
        this.module = this.getFragNodeRef(frag);
        this.h2 = this.module.getElementsByTagName('h2')[0];
        dojo.dom.insertAfter(dojo.html.createNodesFromText('<p class="edit"><a class="button" href="#">' + xg.forum.nls.html('edit') + '</a></p>')[0], this.h2);
        dojo.event.connect(this.module.getElementsByTagName('a')[0], 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            if ((! this.form) || (this.form.style.height == "0px")) {
                this.showForm();
            } else {
                this.hideForm();
            }
        }));
    },
    showForm: function() {
        var editbutton = this.module.getElementsByTagName('a')[0];
        dojo.html.addClass(editbutton, 'close');
        var displayOptions = dj_eval(this._displayOptionsJson);
        var options = dj_eval(this._optionsJson);
        var nonCategoriesOptions = dojo.lang.filter(options, function(option) { return ! option.value.match(/category_/); });
        var categoriesOptions = dojo.lang.filter(options, function(option) { return option.value.match(/category_/); });
        var displayOptionsHtml = '';
        dojo.lang.forEach(displayOptions, function(option) {
            displayOptionsHtml += '<option value="' + dojo.string.escape('html', option.value) + '">' + dojo.string.escape('html', option.label) + '</option>';
        });
        var optionsHtml = '';
        dojo.lang.forEach(nonCategoriesOptions, function(option) {
            optionsHtml += '<option value="' + dojo.string.escape('html', option.value) + '">' + dojo.string.escape('html', option.label) + '</option>';
        });
        if (categoriesOptions.length) {
            optionsHtml += '<optgroup label="' + xg.forum.nls.html('discussionsFromACategory') + '">';
            dojo.lang.forEach(categoriesOptions, function(option) {
                optionsHtml += '<option value="' + dojo.string.escape('html', option.value) + '">' + dojo.string.escape('html', option.label) + '</option>';
            });
            optionsHtml += '</optgroup>';
        }
        if(!this.form) {
            this.form = dojo.html.createNodesFromText(dojo.string.trim(' \
                <form class="xg_module_options"> \
                    <fieldset> \
                        <dl>\
                            <dt><label for="' + this.widgetId + '_display">' + xg.forum.nls.html('display') + '</label></dt>\
                            <dd>\
                                <select id="' + this.widgetId + '_display"> \
                                    ' + displayOptionsHtml  + '\
                                </select> \
                            </dd>\
                            <dt><label for="' + this.widgetId + '_select">' + xg.forum.nls.html('from') + '</label></dt>\
                            <dd>\
                                <select id="' + this.widgetId + '_select"> \
                                    ' + optionsHtml + ' \
                                </select> \
                            </dd>\
                            <dt><label for="' + this.widgetId + '_item_count">' + xg.forum.nls.html('show') + '</label></dt>\
                            <dd>\
                                <select id="' + this.widgetId + '_item_count"> \
                                    <option value="0">0</option> \
                                    <option value="1">1</option> \
                                    <option value="2">2</option> \
                                    <option value="3">3</option> \
                                    <option value="4">4</option> \
                                    <option value="5">5</option> \
                                    <option value="10">10</option> \
                                    <option value="20">20</option> \
                                </select> ' + xg.forum.nls.html('discussions') + '\
                            </dd>\
                        </dl>\
                        <p class="buttongroup">\
                            <input type="submit" value="' + xg.forum.nls.html('save') + '" class="button submit"/> \
                            <input type="button" value="' + xg.forum.nls.html('cancel') + '" class="button"  id="' + this.widgetId + '_cancelbtn"/> \
                        </p>\
                    </fieldset> \
                </form> \
                '))[0];
            this.head = dojo.html.getElementsByClass('xg_module_head', this.module)[0];
            dojo.dom.insertAfter(this.form, this.head);
            this.formHeight = this.form.offsetHeight;
        } else {
            dojo.html.removeClass(this.form, 'collapsed');
         }
        this.form.style.height = "0px";
        xg.index.util.FormHelper.select(this._topicSet, dojo.byId(this.widgetId + '_select'));
        xg.index.util.FormHelper.select(this._itemCount, dojo.byId(this.widgetId + '_item_count'));
        xg.index.util.FormHelper.scrollIntoView(this.form.getElementsByTagName('fieldset')[0]);
        dojo.event.connect(this.form, 'onsubmit', dojo.lang.hitch(this, function(event) {
            this.save(event);
        }));
        dojo.event.connect(dojo.byId(this.widgetId + '_cancelbtn'), 'onclick', dojo.lang.hitch(this, function(event) {
            this.hideForm();
        }));
        // @todo  Replace the code below with a call to xg.shared.util.showModuleForm  [Jon Aquino 2007-07-27]
        var node = this.form
        var openanim1 = new dojo.animation.Animation(new dojo.math.curves.Line( [0,0], [0,this.formHeight+5]), 300, .8, 0);
        var openanim2 = new dojo.animation.Animation(new dojo.math.curves.Line( [0,this.formHeight+5], [0,this.formHeight]), 20, -.8, 0);
        dojo.event.connect(openanim1, "onAnimate", function(e) { node.style.height = (e.y) + "px"; });
        dojo.event.connect(openanim2, "onAnimate", function(e) { node.style.height = (e.y) + "px"; });
        dojo.event.connect(openanim1, "onEnd", function(e) { openanim2.play(); });
        openanim1.play();
    },
    hideForm: function() {
        // @todo  Replace the code below with a call to xg.shared.util.hideModuleForm  [Jon Aquino 2007-07-27]
        var node = this.form
        var openanim4 = new dojo.animation.Animation(new dojo.math.curves.Line( [0,this.formHeight+5], [0,0]), 300, -.8, 0);
        var openanim3 = new dojo.animation.Animation(new dojo.math.curves.Line( [0,this.formHeight],[0,this.formHeight+5]), 20, .8, 0);
        var editbutton = this.module.getElementsByTagName('a')[0];
        dojo.html.removeClass(editbutton, 'close');
        dojo.event.connect(openanim3, "onAnimate", function(e) { node.style.height = (e.y) + "px"; });
        dojo.event.connect(openanim3, "onEnd", function(e) { openanim4.play(); });
        dojo.event.connect(openanim4, "onAnimate", function(e) { node.style.height = (e.y) + "px"; });
        dojo.event.connect(openanim4, "onEnd", function(e) { dojo.html.addClass(node, 'collapsed');  });
        openanim3.play();
    },
    save: function(event) {
        dojo.event.browser.stopEvent(event);
        this._displaySet = xg.index.util.FormHelper.selectedOption(dojo.byId(this.widgetId + '_display')).value;
        this._topicSet = xg.index.util.FormHelper.selectedOption(dojo.byId(this.widgetId + '_select')).value;
        this._itemCount = xg.index.util.FormHelper.selectedOption(dojo.byId(this.widgetId + '_item_count')).value;
        this.hideForm();
        dojo.io.bind({
            url: this._setValuesUrl,
            method: 'post',
            content: { displaySet: this._displaySet, topicSet: this._topicSet, itemCount: this._itemCount },
            preventCache: true,
            mimetype: 'text/javascript',
            encoding: 'utf-8',
            load: dojo.lang.hitch(this, dojo.lang.hitch(this, function(type, data, event){
                dojo.lang.forEach(dojo.html.getElementsByClass('xg_module_body', this.module), function(moduleBody) {
                    dojo.dom.removeNode(moduleBody);
                });
                var footer = dojo.html.getElementsByClass('xg_module_foot', this.module)[0];
                if (footer) { dojo.dom.removeNode(footer); }
                dojo.lang.forEach(dojo.html.createNodesFromText(data.moduleBodyAndFooterHtml), dojo.lang.hitch(this, function(node) {
                    dojo.dom.insertAtPosition(node, this.module, 'last');
                }));
                xg.index.panel.fixImagesInIE(this.module.getElementsByTagName('img'));
            }))
        });
    }
});

