<?php

XG_App::includeFileOnce('/lib/XG_Embed.php');

class Profiles_EmbedController extends W_Controller {

    // see http://jira.ninginc.com/browse/BAZ-2659
    // and http://neuromancer.ninginc.com:8080/clearspace/docs/DOC-1110/version/1

    //  Default display is blog posts
    public function action_embed2($args) {
        $this->forwardTo('embed2blogposts', NULL, array($args));
    }

    public function action_embed1($args) {
        $this->forwardTo('embed2blogposts', NULL, array($args));
    }

    /**
     * The title of the page
     */
    public function action_embed3pagetitle($args) {
        $this->embed = $args['embed'];
        $screenName = $this->embed->get('screenName');
        $this->profile = XG_Cache::profiles($screenName);
        $user = User::load($this->profile);
        $titleAttributeName = XG_App::widgetAttributeName($this->_widget, 'pageTitle');
        $title = $user->my->{$titleAttributeName};
        if (isset($title)) {
            $this->pageTitle = $title;
        }
        else {
            $this->pageTitle = $this->embed->isOwnedByCurrentUser() ? xg_text('MY_PAGE') : xg_text('XS_PAGE', ucfirst(xg_username($this->profile)));
        }
    }

    /** The badge that appears on the top left of the profile page */
    public function action_embed1smallbadge($args) {
        $this->embed = $args['embed'];
        $screenName = $this->embed->get('screenName');
        $this->hideLinks = $this->embed->get('hideLinks');
        $this->profile = XG_Cache::profiles($screenName);
        //  Can the logged in user ban the user displayed?
        if ($this->profile->isLoggedIn()) {
            // The page belongs to the logged in user - don't show ban option
            $this->canBan = FALSE;
        } else {
            $this->canBan = XG_SecurityHelper::currentUserCanDeleteUser(
                    $this->profile->screenName);
        }
        $this->user = User::load($this->profile);
        XG_App::includeFileOnce('/lib/XG_ContactHelper.php');
        $this->friendStatus = XG_ContactHelper::getFriendStatusFor($this->_user->screenName, $screenName);
        $this->modulesLinks = array();
        $enabledModules = XG_ModuleHelper::getEnabledModules();
        // list of mozzles we want to display the link if enabled and if the user has contributed content for
        $modulesLinkList = array(
            'photo' => array (
                'attributeName' => XG_App::widgetAttributeName(W_Cache::getWidget('photo'), 'photoCount'),
                'linkText'      => xg_html('PHOTOS'),
                'linkUrl'       => W_Cache::getWidget('photo')->buildUrl('photo', 'listForContributor', array('screenName' => $screenName))
                ),
            'video' => array (
                'attributeName' => XG_App::widgetAttributeName(W_Cache::getWidget('video'), 'videoCount'),
                'linkText'      => xg_html('VIDEOS'),
                'linkUrl'       => W_Cache::getWidget('video')->buildUrl('video', 'listForContributor', array('screenName' => $screenName))
                ),
              'forum' => array (
                  'attributeName' => XG_App::widgetAttributeName(W_Cache::getWidget('forum'), 'activityCount'),
                  'linkText'      => xg_html('DISCUSSIONS'),
                  'linkUrl'       => W_Cache::getWidget('forum')->buildUrl('topic', 'listForContributor', array('user' => $screenName))
                  )
            );
        foreach ($modulesLinkList as $moduleName => $moduleEntry) {
            if (array_key_exists($moduleName, $enabledModules) && ($this->user->my->{$modulesLinkList[$moduleName]['attributeName']} > 0) ) {
                $this->modulesLinks[$moduleName] = array(
                    'name'  => $modulesLinkList[$moduleName]['linkText'],
                    'url'   => $modulesLinkList[$moduleName]['linkUrl'],
                    'count' => $this->user->my->{$modulesLinkList[$moduleName]['attributeName']}
                    );
            }
        }
        if (array_key_exists('events',$enabledModules)) {
            XG_App::includeFileOnce('/widgets/events/lib/helpers/Events_UserHelper.php');
            $upcomingEventCount = Events_UserHelper::determineUpcomingEventCount($this->user);
            if ($upcomingEventCount) {
                $this->modulesLinks['events'] = array(
                    'name'  => xg_html('EVENTS'),
                    'url'   => W_Cache::getWidget('events')->buildUrl('event', 'listUserEvents', array('user' => $screenName)),
                    'count' => $upcomingEventCount
                    ); 
            }
        }
    }

    public function action_embed1badge() {
        $this->app = XN_Application::load();
        if (XG_SecurityHelper::userIsOwner()) {
            $this->owner = $this->_user;
        }
        else {
            $this->owner = XG_Cache::Profiles($this->app->ownerName);
        }
        if (XG_App::onMyProfilePage()) {
            W_Cache::getWidget('profiles')->dispatch('embed', 'getBadge');
        }
        else {
            W_Cache::getWidget('main')->dispatch('embed', 'getBadge');
        }
        $this->renderNothing();
    }

    /** Profile questions and answers */
    public function action_embed1profileqa($args) {
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_ProfileQuestionFormHelper.php');
        $this->embed = $args['embed'];
        $screenName = $this->embed->get('screenName');
        $this->profile = XG_Cache::profiles($screenName);
        $user = User::load($screenName);
        $this->canSeePrivate = $this->embed->isOwnedByCurrentUser() || XG_SecurityHelper::userIsAdmin();
        $qa = Profiles_ProfileQuestionFormHelper::read($user);
        $this->questions = $qa['questions'];
        $this->questionsAndAnswers = $qa['answers'];
        $this->maxEmbedWidth = $args['maxEmbedWidth'];
    }
    public function action_embed2profileqa($args) {
        $this->forwardTo('embed1profileqa', NULL, array($args));
    }

    public function action_embed1friends($args) {
        $this->forwardTo('friendsProper', 'embed', array($args, 1));
    }

    public function action_embed2friends($args) {
        $this->forwardTo('friendsProper', 'embed', array($args, 2));
    }

    public function action_friendsProper($args, $columnCount) {
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_UserHelper.php');
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_FeedHelper.php');
        $this->embed = $args['embed'];
        $screenName = $this->embed->get('screenName');
        $this->profile = XG_Cache::profiles($screenName);
        $friendInfo = Profiles_UserHelper::findFriendsOf($screenName, 0, 6 * $columnCount);
        $this->friends = $friendInfo['friends'];
        // Load all the profile objects corresponding to all the friends
        $screenNames = array();
        foreach ($this->friends as $friend) {
            $screenNames[$friend->contributorName] = $friend->contributorName;
        }
        $this->friendProfiles = XG_Cache::profiles($screenNames);
        $this->feedUrl = Profiles_FeedHelper::feedUrl($this->_buildUrl('friend','feed',array('user' => $screenName, 'xn_auth' => 'no')));

        // BAZ-1235: If the current user is the owner of the page, get the friend request
        // count and display a message if there are friend requests
        if ($this->embed->isOwnedByCurrentUser()) {
            $query = XN_Query::create('Contact')
                ->filter('owner','eic',$screenName)
                ->filter('relationship','=','groupie')
                ->begin(0)
                ->end(1);
            $contacts = $query->execute();
            $this->friendRequestCount = $query->getTotalCount();
        } else {
            $this->friendRequestCount = null;
        }
        if (! $this->friendProfiles && ! $this->friendRequestCount && $this->embed->getType() == 'profiles') { return $this->render('blank'); }
    }

    /** Active members */
    public function action_embed1activeMembers($args, $columnCount=1) {
        $this->embed = $args['embed'];
        if (! $this->embed->isOwnedByCurrentUser()) {
            $this->setCaching(array(md5(implode(',', array('/profiles/embed/embed1activeMembers',
                    $columnCount,
                    $this->embed->get('displaySet'),
                    $this->embed->get('sortSet'),
                    $this->embed->get('rowsSet'),
                    $args['maxEmbedWidth'])))), 300);
        }

        // When adding a new option to this embed, be sure to add it to the md5 hash above (BAZ-5679) [Jon Aquino 2008-01-04]

        $this->display_options = array(array('label' => xg_text('LARGE_THUMBNAILS'), 'value' => 'large'), array('label' => xg_text('SMALL_THUMBNAILS'), 'value' => 'small'));
        $this->sort_options = array( array('label' => xg_text('RECENTLY_JOINED'), 'value' => 'recent'), array('label' => xg_text('MOST_POPULAR_MEMBERS'), 'value' => 'popular'), array('label' => xg_text('FEATURED'), 'value' => 'featured'));
        $this->smallthumbs = ($this->embed->get('displaySet') =='small');
        $this->setValuesUrl = $this->_buildUrl('embed', 'membersSetValues', array('id' => $this->embed->getLocator(), 'maxEmbedWidth' => $args['maxEmbedWidth'], 'xn_out' => 'json', 'columnCount' => $columnCount));
        $this->embed->set('displaySet'  , $this->embed->get('displaySet')           ? $this->embed->get('displaySet')   : 'large'   );
        $this->embed->set('sortSet'     , $this->embed->get('sortSet')              ? $this->embed->get('sortSet')      : 'popular' );
        $this->embed->set('rowsSet'     , (!is_null($this->embed->get('rowsSet')))  ? $this->embed->get('rowsSet')      : 4         );
        //20 thumbnails is not allowed anymore (BAZ-2799, BAZ-4894, BAZ-5062)
        if ($this->embed->get('rowsSet') > 5) { $this->embed->set('rowsSet', 5); }
        $rows_numbers = array(0,1,2,3,4,5);
        if ($columnCount > 1) { // BAZ-3866 [Jon Aquino 2007-08-14]
            if ($this->embed->get('rowsSet') > 3) { $this->embed->set('rowsSet', 3); }
            $rows_numbers = array(0,1,2,3);
        }
        $this->rows_options = array();
        foreach ($rows_numbers as $i) {
            $this->rows_options[] = array('label' => (string)($i), 'value' => (string)($i));
        }
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_UserHelper.php');
        $this->usersPerRow = $this->usersPerRow($this->embed, $args['maxEmbedWidth']);
        $membersCount = $this->embed->get('rowsSet') * $this->usersPerRow;
        $this->inviteUrl = XG_App::canSeeInviteLinks($this->_user) ? '/invite' : null;
        $this->viewAllUrl = $this->_buildUrl('friend','list');
        if ($membersCount>0) {
            if($this->embed->get('sortSet') == 'recent') {
                $this->activeProfiles = XG_Cache::profiles(Profiles_UserHelper::getActiveUsers($membersCount,'createdDate'));
            } elseif($this->embed->get('sortSet') == 'featured') {
                $this->activeProfiles = XG_Cache::profiles(Profiles_UserHelper::getPromotedUsers($membersCount));
            } else {
                $this->activeProfiles = XG_Cache::profiles(Profiles_UserHelper::getActiveUsers($membersCount,'updatedDate'));
            }
        } else {
            $this->activeProfiles = array();
        }
    }

    public function action_embed2activeMembers($args) {
        $this->forwardTo('embed1activeMembers', NULL, array($args, 2));
    }

    /**
     * Displays the body and footer for a Members module.
     * Called by the profiles widget and the groups widget.
     *
     * @param $args array  configuration parameters: profiles (array of XN_Profiles),
     *         smallthumbs (whether to use small thumbnails),
     *         usersPerRow (number of avatars per row),
     *         inviteUrl (URL for the Invite More link, or null to hide the link),
     *         viewAllUrl (URL for the View All link, or null to hide the link)
     *         sortSet (the type of sort/filter that's being performed)
     *         user (the user object, for main page promotion)
     */
    public function action_membersBodyAndFooter($args) {
        $this->activeProfiles = $args['profiles'];
        $this->smallthumbs = $args['smallthumbs'];
        $this->usersPerRow = $args['usersPerRow'];
        $this->inviteUrl = $args['inviteUrl'];
        $this->viewAllUrl = $args['viewAllUrl'];
        $this->sortSet = $args['sortSet'];
        $this->user = $args['user'];
    }

    /** Blog posts
     *
     * Regular user can have posts they've recently added or posts across the site
     * Admin can have promoted posts or posts across the site -- title is 'Blogs'
    */
    public function action_embed2blogposts($args) {
        $this->embed = $args['embed'];
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_FeedHelper.php');
        $this->display_options = array(
            array('label' => xg_text('DETAIL_VIEW'), 'value' => 'detail'),
            array('label' => xg_text('TITLES_ONLY'), 'value' => 'titles')
        );
        $this->maxEmbedWidth = $args['maxEmbedWidth'];
        $this->embedLayoutType = $this->embed->getType();
        if ($this->embedLayoutType == 'homepage') {
            $this->sort_options = array(
                array('label' => xg_text('RECENTLY_ADDED_POSTS'),   'value' => 'recent'),
                array('label' => xg_text('MOST_POPULAR'),           'value' => 'popular2'),
                array('label' => xg_text('POPULAR_POSTS'),          'value' => 'popular'),
                array('label' => xg_text('PROMOTED_POSTS'),         'value' => 'promoted'),
                array('label' => (XG_SecurityHelper::userIsOwner()?xg_text('MY_POSTS_ONLY'):xg_text('OWNER_POSTS_ONLY')), 'value' => 'owner')
            );
        }
        $this->posts_options = array();
        $options = array(0, 1, 2, 3, 4, 5, 10, 20);
        foreach ($options as $option) {
            $this->posts_options[] = array('label' => (string)($option), 'value' => (string)($option));
        }
        $this->embedSelected = mb_strlen($this->embed->get('selected')) ? $this->embed->get('selected') : 'recent';
        $this->embed->set('displaySet'  , $this->embed->get('displaySet')           ? $this->embed->get('displaySet')   : 'detail'   );
        $this->embed->set('postsSet'     , (!is_null($this->embed->get('postsSet')))  ? $this->embed->get('postsSet')      : 5         );

        $screenName = $this->embed->get('screenName');
        $this->profile = mb_strlen($screenName) ? XG_Cache::profiles($screenName) : null;
        $info = $this->getPostInfo($this->embedLayoutType, $this->embedSelected, $this->profile, $this->embed, $this->embed->isOwnedByCurrentUser() && $this->embed->get('postsSet') == 0 ? 1 : $this->embed->get('postsSet'));
        $this->postInfo = $info['postInfo'];
        $this->feedUrl = $info['feedUrl'];
        $this->archiveUrl = $info['archiveUrl'];
        $this->embedTitle = $info['embedTitle'];
        // Only show promotion links with each post if it's the homepage
        // and we're showing promoted posts
        // On profile pages, hide promotion links if the current user isn't
        // the layout owner to hide them on 'view as others see it' view
        $this->showPromotionLinks = $info['showPromotionLinks'];
        if (($this->embedLayoutType == 'profiles') && XG_SecurityHelper::userIsAdmin($this->profile) && (! $this->embed->isOwnedByCurrentUser())) {
            $this->showPromotionLinks = false;
        }

        $this->posts = $this->postInfo['posts'];
        if ((! $this->posts && $this->embed->getType() == 'profiles') || (! $this->posts && ! $this->embed->isOwnedByCurrentUser()) || (!$this->embed->isOwnedByCurrentUser() && $this->embed->get('postsSet') == 0)) { return $this->renderNothing(); }  
        
        $this->embedUrl = $this->_buildUrl('embed','blogpostsSetValues', array('id' => $this->embed->getLocator(), 'xn_out' => 'json', 'maxEmbedWidth' => $this->maxEmbedWidth));
        XG_App::includeFileOnce('/lib/XG_SecurityHelper.php');
        $this->showCreateLink = XG_SecurityHelper::currentUserCanSeeAddContentLink($this->embed, $this->posts);

        // BAZ-4889: Preload user info
        XG_Cache::profiles($this->posts);
    }


    /** Configuring blog posts */
    public function action_blogpostsSetValues() {
        try {
            $this->_widget->includeFileOnce('/lib/helpers/Profiles_FeedHelper.php');
            if (! isset($_GET['id'])) {
                throw new Exception("No embed locator provided");
            }
            $embed = XG_Embed::load($_GET['id']);
            if (! $embed->isOwnedByCurrentUser()) {
                throw new Exception("You are not the embed owner!");
            }
            $embed->set('selected', $_POST['sortSet']);
            $embed->set('postsSet', (float)$_POST['postsSet']);
            $embed->set('displaySet', $_POST['displaySet']);
            $embed->set('screenName', $embed->get('screenName')?$embed->get('screenName'):$this->_user->screenName);
            $screenName = $embed->get('screenName');
            $profile = mb_strlen($screenName) ? XG_Cache::profiles($screenName) : null;
            $info = $this->getPostInfo($embed->getType(), $_POST['sortSet'], $profile, $embed, $embed->get('postsSet') );
            $this->embedTitle = $info['embedTitle'];
            list($junk, $this->moduleBodyHtml) = W_Cache::current('W_Widget')->capture('embed','blogpostsBody', array($info['postInfo']['posts'], $embed->isOwnedByCurrentUser(), $info['archiveUrl'], $info['feedUrl'], $embed, $info['showPromotionLinks'], $_GET['maxEmbedWidth']));
        } catch (Exception $e) {
            $this->message = $e->getMessage();
        }
    }

    public function action_blogpostsBody($posts, $showCreateLink, $archiveUrl, $feedUrl, $embed, $showPromotionLinks, $maxEmbedWidth) {
        $this->posts = $posts;
        $this->showCreateLink = $showCreateLink;
        $this->archiveUrl = $archiveUrl;
        $this->feedUrl = $feedUrl;
        $this->embed = $embed;
        $this->showPromotionLinks = $showPromotionLinks;
        $this->maxEmbedWidth = $maxEmbedWidth;
    }

    private function getPostInfo($layoutType, $embedSelected, $profile = null, $embed, $end=5) {
        $r = array();
        $r['embedTitle'] = xg_text('BLOG_POSTS');
        if ($end == 0) return $r;
        if ($layoutType == 'profiles') {
            // Load up the five most recent blog posts this user can see
            if ($embedSelected == 'site') {
                $r['postInfo'] = BlogPost::find(array('my->publishStatus' => 'publish'), 0, $end);
                $r['feedUrl'] = Profiles_FeedHelper::feedUrl($this->_buildUrl('blog','feed',array('xn_auth' => 'no')));
                $r['archiveUrl'] = $this->_buildUrl('blog','list');
                $r['embedTitle'] = xg_text('BLOG_POSTS');
                $r['showPromotionLinks'] = true;
            } else {
                $r['postInfo'] = BlogPost::find(array('my->publishStatus' => 'publish', 'contributorName' => $profile->screenName), 0, $end);
                $r['feedUrl'] = Profiles_FeedHelper::feedUrl($this->_buildUrl('blog','feed',array('user' => $profile->screenName, 'xn_auth' => 'no')));
                $r['archiveUrl'] = $this->_buildUrl('blog','list',array('user' => $profile->screenName));
                $r['embedTitle'] = $embed->isOwnedByCurrentUser() ? xg_text('MY_BLOG') : xg_text('XS_BLOG', ucfirst(xg_username($profile)));
                $r['showPromotionLinks'] = true;
            }
        } else { //homepage
            switch ($embedSelected) {
                case 'promoted':
                    $r['postInfo'] = BlogPost::find(array('my->publishStatus' => 'publish', 'promoted' => true, 'ignoreVisibility' => true, 'my.visibility' => 'all'), 0, $end);
                    $r['feedUrl'] = Profiles_FeedHelper::feedUrl($this->_buildUrl('blog','feed',array('promoted' => 1, 'xn_auth' => 'no')));
                    $r['archiveUrl'] = $this->_buildUrl('blog','list',array('promoted' => 1));
                    $r['showPromotionLinks'] = true;
                    break;
                case 'owner':
                    $this->app = XN_Application::load();
                    $r['postInfo'] = BlogPost::find(array('my->publishStatus' => 'publish', 'contributorName' => $this->app->ownerName, 'ignoreVisibility' => true, 'my.visibility' => 'all'), 0, $end);
                    $r['feedUrl'] = Profiles_FeedHelper::feedUrl($this->_buildUrl('blog','feed',array('user' => $this->app->ownerName, 'xn_auth' => 'no')));
                    $r['archiveUrl'] = $this->_buildUrl('blog','list',array('user' => $this->app->ownerName));
                    $r['showPromotionLinks'] = true;
                    break;
                case 'popular':
                    $r['postInfo'] = BlogPost::find(array('my->publishStatus' => 'publish', 'ignoreVisibility' => true, 'my.visibility' => 'all'), 0, $end, 'my->xg_profiles_commentCount', 'desc');
                    $r['feedUrl'] = Profiles_FeedHelper::feedUrl($this->_buildUrl('blog','feed',array('xn_auth' => 'no')));
                    $r['archiveUrl'] = $this->_buildUrl('blog','list');
                    $r['showPromotionLinks'] = true;
                    break;
                case 'popular2':
                    $r['postInfo'] = BlogPost::find(array('my->publishStatus' => 'publish', 'ignoreVisibility' => true, 'my.visibility' => 'all'), 0, $end, 'my->popularityCount', 'desc');
                    $r['feedUrl'] = Profiles_FeedHelper::feedUrl($this->_buildUrl('blog','feed',array('xn_auth' => 'no')));
                    $r['archiveUrl'] = $this->_buildUrl('blog','list');
                    $r['showPromotionLinks'] = true;
                    break;
                case 'recent':
                default:
                    $r['postInfo'] = BlogPost::find(array('my->publishStatus' => 'publish', 'ignoreVisibility' => true, 'my.visibility' => 'all'), 0, $end);
                    $r['feedUrl'] = Profiles_FeedHelper::feedUrl($this->_buildUrl('blog','feed',array('xn_auth' => 'no')));
                    $r['archiveUrl'] = $this->_buildUrl('blog','list');
                    $r['showPromotionLinks'] = false;
                    break;
            }
        }
        return $r;
    }

    /** Chatterwall display */
    public function action_embed2chatterwall($args) {
        $max_chatters = 10;

        $this->embed = $args['embed'];
        $screenName = $this->embed->get('screenName');
        $this->profile = XG_Cache::profiles($screenName);
        $user = User::load($this->profile);
        if ($this->embed->isOwnedByCurrentUser()) {
            $approved = null; // Get all chatters;
            // If the current user is the owner of the embed, also set things
            // up so they can edit settings (change chatter moderation) (BAZ-960)
            $moderationAttributeName = XG_App::widgetAttributeName($this->_widget, 'moderateChatters');
            $this->userModeratesChatters = ($user->my->{$moderationAttributeName} == 'Y') ? 'Y' : 'N';
            $this->embedUrl = $this->_buildUrl('comment','setModeration', array('xn_out' => 'json'));
        } else {
            $approved = 'Y'; // Only get approved chatters
        }
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_CommentHelper.php');

        $this->chatterInfo = Comment::getCommentsFor($user->id, 0,
                $max_chatters, $approved, 'createdDate', 'desc');
        if ($this->embed->isOwnedByCurrentUser() && $this->chatterInfo['numComments']) {
            //  Get friend status for all commenters on the page
            XG_App::includeFileOnce('/lib/XG_ContactHelper.php');
            $commenters = array();
            foreach ($this->chatterInfo['comments'] as $comment) {
                $commenters[$comment->contributorName] = $comment->contributorName;
            }
            $this->friendStatus = XG_ContactHelper::getFriendStatusFor($screenName,
                    array_keys($commenters));
            /* BAZ-4878: pre-load all the user/profile info for the chatter owners */
            $commenterProfiles = XG_Cache::profiles($commenters);
        }
        $this->moreChatters = ($this->chatterInfo['numComments'] > $max_chatters);
    }

    /** The welcome message that appears until hidden */
    public function action_embed3welcome($args) {
        XG_App::includeFileOnce('/lib/XG_ModuleHelper.php');
        $this->embed = $args['embed'];
        $visible = $this->embed->get('visible');
        if (! ($visible && $this->embed->isOwnedByCurrentUser())) {
            $this->render('blank');
            return;
        }
        $this->embedLocator = $this->embed->getLocator();
     }
    public function action_welcomeSetValues() {
        $embed = XG_Embed::load($_GET['id']);
        if (! $embed->isOwnedByCurrentUser()) { throw new Exception('Not layout owner.'); }
        $embed->set('visible', 0);
    }

    public function action_membersSetValues() {
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_UserHelper.php');
        $embed = XG_Embed::load($_GET['id']);
        if (! $embed->isOwnedByCurrentUser()) { throw new Exception('Not embed owner.'); }
        $embed->set('displaySet', $_POST['displaySet']  );
        $embed->set('sortSet'   , $_POST['sortSet']     );
        $embed->set('rowsSet'   , $_POST['rowsSet']     );
        $this->smallthumbs = ($embed->get('displaySet') =='small');
        $this->usersPerRow = $this->usersPerRow($embed, $_GET['maxEmbedWidth']);
        $membersCount = $embed->get('rowsSet') * $this->usersPerRow;
        if($membersCount>0) {
            if($embed->get('sortSet') == 'recent') {
                $this->activeProfiles = XG_Cache::profiles(Profiles_UserHelper::getActiveUsers($membersCount,'createdDate'));
            } elseif($embed->get('sortSet') == 'featured') {
                $this->activeProfiles = XG_Cache::profiles(Profiles_UserHelper::getPromotedUsers($membersCount));
            } else {
                $this->activeProfiles = XG_Cache::profiles(Profiles_UserHelper::getActiveUsers($membersCount,'updatedDate'));
            }
        } else {
            $this->activeProfiles = array();
        }
        ob_start();
        $this->_widget->dispatch('embed', 'membersBodyAndFooter', array(array(
                'profiles' => $this->activeProfiles, 'smallthumbs' => $this->smallthumbs, 'usersPerRow' => $this->usersPerRow,
                'inviteUrl' => XG_App::canSeeInviteLinks($this->_user) ? '/invite' : null,
                'sortSet' => $embed->get('sortSet'),
                'viewAllUrl' => $this->_buildUrl('friend','list'))));
        $this->moduleBodyAndFooterHtml = trim(ob_get_contents());
        ob_end_clean();
    }

    /**
     * Returns the number of avatars to display per row
     *
     * @param $embed XG_Embed  Stores the module data.
     * @param $maxEmbedWidth integer  the maximum width for <embed>s, in pixels
     * @return integer  the number of pictures to show on each row
     */
    protected function usersPerRow($embed, $maxEmbedWidth) {
        $columnWidth = $embed->get('displaySet') == 'small' ? 55 : 96;
        return floor($maxEmbedWidth / $columnWidth);
    }

    public function action_error() {
        $this->render('blank');
    }

    /**
     * Displays a module promoting profile badges
     */
    public function action_getBadge() {}

    /* For actions outside of the profiles mozzle (XG_AppearanceTemplateHelper) that
     * need to render the navigation.
     */
    public function action_navigation($screenName) {
        $this->screenName = $screenName;
    }


}
