<?php

XG_App::includeFileOnce('/lib/XG_Message.php');

/**
 * This class is responsible for sending notification messages that result
 * from in-app actions
 *
 */
class Index_NotificationController extends W_Controller {

    /**
     * Generic authentication checks that apply to all actions
     * in this controller
     */
    protected function _before() {
        // Everything should be a POST
        if ($_SERVER['REQUEST_METHOD'] != 'POST') {
            $this->render('blank');
        }
        // Requests must come from a logged in user that is the same as the
        // specified 'from' post parameter
        if (! (isset($_POST['from']) && $this->_user->isLoggedIn() &&
               ($this->_user->screenName == $_POST['from']))) {
            $this->render('blank');
        }

        // Everything needs a to and a from
        if (! (isset($_POST['from']) && mb_strlen(trim($_POST['from'])) &&
            isset($_POST['to'])   && mb_strlen(trim($_POST['to'])))) {
            $this->render('blank');
        }
    }

    /**
     * This action is invoked whenever a user-to-user message is sent
     * from within the app
     *
     */
    public function action_messageReceived() {

        /* Per BAZ-2770, do NOT implicitly create an invitation when sending a
         *   message to a non-member!
         */
         $this->sendNotification(XG_Message_Notification::EVENT_USER_MESSAGE);
    }

    /**
     * This action is invoked whenever a friend request is sent OR accepted
     * from within the app. The method must get the up-to-date relationship
     * status between the two users to determine which message to send.
     */
    public function action_friendRequest() {
        $contact = XN_Query::create('Contact')
                   ->filter('owner','=',$_POST['from'])
                   ->filter('contact','=',$_POST['to'])
                   ->uniqueResult();
        if ($contact) {
            if ($contact->relationship == 'friend') {
                // $event = XG_Message_Notification::EVENT_FRIEND_ACCEPTED;
                return; /* BAZ-1591 -- no acceptance notifications for now */
            } elseif ($contact->relationship == 'pending') {
                $event = XG_Message_Notification::EVENT_FRIEND_REQUEST;
            } else {
                error_log("Friend status is {$contact->relationship} between {$_POST['from']} and {$_POST['to']}");
                return;
            }
            $this->sendNotification($event);
        }
    }

    protected function sendNotification($event) {
        $opts = array('profile' => $_POST['from']);
        // The user message notifications use the subject, if available
        if (isset($_POST['subject'])) {
            $opts['subject'] = $_POST['subject'];
        }
        // BAZ-2363: only include the text of the original message if configured to do so
        //we have to do this inversion because private config vars don't support defaults and no value = zero, and we need the default to be "with message"
        $useMessageInNotification = !$this->_widget->privateConfig['noMessageInNotification'];
        if (isset($_POST['body']) && $useMessageInNotification) {
            $opts['body'] = $_POST['body'];
        }
        $user = User::load($_POST['to']);
        if (! $user) {
            $user = $_POST['to'];
        }
        XG_Message_Notification::create($event, $opts)->send($user);
    }
}
