<?php
XG_App::includeFileOnce('/lib/XG_Layout.php');
XG_App::includeFileOnce('/lib/XG_LayoutHelper.php');
XG_App::includeFileOnce('/lib/XG_ModuleHelper.php');
XG_App::includeFileOnce('/lib/XG_Message.php');
XG_App::includeFileOnce('/lib/XG_MetatagHelper.php');
XG_App::includeFileOnce('/lib/XG_FullNameHelper.php');

class Index_IndexController extends W_Controller {

    /**
     * Displays the network's main page.
     */
    public function action_index() {
        /** Cache approach index-signedout */
        if (! ($this->_user->isLoggedIn() || XG_App::getLogoutCookie())) {
            $this->setCaching(array(crc32($_SERVER['QUERY_STRING'])), 300);
            // TODO: Better to use md5(XG_HttpHelper::currentUrl())  [Jon Aquino 2007-10-25]
        }

        $this->app = XN_Application::load();
        $this->navEntries = XG_ModuleHelper::getNavEntries();
        $this->navHighlight = 'Home';

        $this->enabledModules = XG_ModuleHelper::getEnabledModules();
        $this->disabledModules = XG_ModuleHelper::getDisabledModules();
        $this->layoutName = 'index';
        $this->xgLayout = XG_Layout::load($this->layoutName);
        //  Use the contents of the 'layout' element within the document
        $this->layout = $this->xgLayout->getLayout()->documentElement;
        $this->layoutName = $this->xgLayout->getName();
        $this->layoutType = $this->xgLayout->getType();

    } // action_index()

    /** @deprecated 2.0  Use XG_AuthorizationHelper::signUpUrl instead */
    public function action_sign() {
        header('Location: ' . XG_AuthorizationHelper::signUpUrl($this->getSuccessTarget(), $_GET['groupToJoin']));
    }

    /** @deprecated 2.0  Use XG_AuthorizationHelper::signUpUrl instead */
    public function action_signUp() {
        header('Location: ' . XG_AuthorizationHelper::signUpUrl($this->getSuccessTarget(), $_GET['groupToJoin']));
    }

    /** @deprecated 2.0  Use XG_AuthorizationHelper::signUpUrl instead */
    public function action_join() {
        header('Location: ' . XG_AuthorizationHelper::signUpUrl($this->getSuccessTarget(), $_GET['groupToJoin']));
    }

    /** @deprecated 2.0  Use XG_AuthorizationHelper::signInUrl instead */
    public function action_signIn() {
        header('Location: ' . XG_AuthorizationHelper::signInUrl($this->getSuccessTarget(), $_GET['groupToJoin']));
    }


    public function action_invite() {
        $this->redirectTo('new', 'invitation');
    }

    /**
     * What a non-owner sees before the app is launched
     */
    public function action_notLaunched() {
        if (XG_App::appIsLaunched()) {
            $this->redirectTo('index');
            return;
        }
    }

    public function action_banned() {
        $this->user = User::load($this->_user);
        if (!User::isBanned($this->user)) {
            $this->redirectTo('index', 'index');
            return;
        }

        //  Send submitted message if present / allowed
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && User::canSendBannedMessage($this->user)) {
            $opts = array();
            $opts['body'] = isset($_POST['message']) ? trim($_POST['message']) : '';
            $from = $this->_user;
            try {
                $msg = XG_Message_From_Banned::create($opts);
                $msg->send($from);
            } catch (Exception $e) {
            }

            User::sentBannedMessage($this->user);
            //  Notify of success
            $this->showNotification = true;
            $this->notificationMessage = xg_text('YOUR_REQUEST_HAS_BEEN_SENT');
            $this->notificationClass = 'success';
        }
        $this->showMessageArea = User::canSendBannedMessage($this->user);

    }

    /**
     * What someone sees if they are signed in and their membership is pending
     *
     * Expected GET variables:
     *     target - (optional) URL for the "Continue" link
     */
    public function action_pending() {
        if (! $this->_user->isLoggedIn()) {
            $this->redirectTo('index','index');
            return;
        }
        $this->user = User::load($this->_user);
        if (! User::isPending($this->user)) {
            $this->redirectTo('index','index');
            return;
        }
        $target = $_GET['target'] ? $_GET['target'] : '/';
        if (XG_HttpHelper::isMyPage($target)) { $target = '/'; }
        if (XG_HttpHelper::isHomepage($target) && XG_App::homepageIsVisible()) {
            $this->continueUrl = $target;
        } elseif (XG_App::everythingIsVisible()) {
            $this->continueUrl = $target;
        }
    }

    public function action_summary() {
        if (XG_App::appIsLaunched()) {
            $this->_widget->dispatch('index');
        }
        $this->backLink = XG_App::getPreviousStepUrl();
        $this->nextLink = XG_App::getNextStepUrl();
        $this->steps = XG_App::getLaunchbarSteps();
        $this->stateDisplayName = array(
                'complete'   => xg_html('COMPLETE'),
                'incomplete' => xg_html('INCOMPLETE')
            );
    }

    public function action_report() {
        $this->ownerName = XG_FullNameHelper::fullName(XN_Application::load()->ownerName);
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $opts = array('category' => $_POST['category'],
                          'body' => $_POST['issue'],
                          'url' => $_POST['referrer']);
            XG_Message_ReportThis::create($opts)->send($this->_user->screenName);

            //  Notify of success
            $this->showNotification = true;
            $this->notificationMessage = xg_text('THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT');
            $this->notificationClass = 'success';
        }
        $defaults = array();
        $defaults['category'] = 'Other';
        $defaults['referrer'] = $_SERVER['HTTP_REFERER'];
        $this->form = new XNC_Form($defaults);
    }

    public function action_feedback() {
        $this->ownerName = XG_FullNameHelper::fullName(XN_Application::load()->ownerName);
        if (XN_Profile::current()->isLoggedIn()) {
            $feedbackSenderName = XG_UserHelper::getFullName($this->_user);
        } else {
            $feedbackSenderName = xg_text('SOMEBODY');
        }
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $heading = xg_text('X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y', $feedbackSenderName, XN_Application::load()->name);
            $body = $_POST['feedback'];
            XG_Message_Feedback::create(array('body' => $body, 'heading' => $heading))->send($this->_user->screenName);

            //  Notify of success
            $this->showNotification = true;
            $this->notificationMessage = xg_text('THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT');
            $this->notificationClass = 'success';
        }
        $this->form = new XNC_Form();
        if (! $this->_user->isLoggedIn()) {
            $signUrl = XG_AuthorizationHelper::signInUrl();
            header("Location: $signUrl");
            exit();
        }
    }

    /**
     * The /xn/detail/ID URL mapping should be mapped to this action, so that
     * the action can look up the mozzle that owns the content object, see if
     * that mozzle has an index/detail action, and then dispatch that action.
     */
    public function action_detail() {
        // If we can't find a URL, then just go to the homepage
        $url = 'http://' . $_SERVER['HTTP_HOST'] . '/';
        $dispatched = false;
        try {
            if (! isset($_GET['id'])) {
                throw new Exception("No content object ID specified");
            }
            if (mb_strpos($_GET['id'], 'u_') === 0) {
                $screenName = str_replace('/', '', mb_substr($_GET['id'], 2)); // Remove trailing slash if necessary [Jon Aquino 2007-10-11]
                header('Location: ' . XG_HttpHelper::addParameter(xg_absolute_url(User::profileUrl($screenName)), 'xgp', $_GET['xgp']));
                exit;
            }
            if (mb_strpos($_GET['id'], 'f_') === 0) {
                $screenName = str_replace('/', '', mb_substr($_GET['id'], 2)); // Remove trailing slash if necessary [Jon Aquino 2007-10-11]
                header('Location: ' . xg_absolute_url('/friends/' . User::profileAddress($screenName)));
                exit;
            }
            $object = XN_Content::load($_GET['id']);
            if ($object && $object->my->mozzle) {
                // If the object is owned by the main mozzle then figure out
                // what to do right here.
                if ($mozzle == 'main') {
                    if ($object->type == 'User') {
                        $url = 'http://' . $_SERVER['HTTP_HOST'] . '/profile/' . User::profileAddress($object->contributorName);
                    }
                }
                // Otherwise, hand off control to index/detail in the appropriate
                // mozzle
                else {
                    $mozzle = W_Cache::getWidget($object->my->mozzle);
                    if (in_array('index', $mozzle->getControllerNames()) && ($mozzle->controllerHasAction('index','detail'))) {
                        $mozzle->dispatch('index','detail', array($object));
                        $dispatched = true;
                    }
                }
            }
        } catch (Exception $e) {
            error_log("/xn/detail problem: " . $e->getMessage());
            header("Location: $url");
            exit();
        }
        if (! $dispatched) {
            header("Location: $url");
            exit();
        }

    }

    /**
     * When a user signs out, we clean things up and take them to a special
     * version of the homepage (BAZ-1236). This action should be the target of
     * all sign out activity (e.g. where identity will redirect the user after
     * actually signing them out. In this action, we do any necessary clean up,
     * such as setting a special 'just logged out'
     * cookie, and redirect to the homepage. The homepage, if it notices the
     * special 'just logged out' cookie, unsets that cookie and displays the
     * "you have just signed out" message. (Putting the just-signed-out status
     * in a cookie keeps it out of the URL and potential bookmarks, etc.
     *
     * @deprecated 2.0  Use XG_AuthorizationHelper::signOutUrl instead
     */
    public function action_signOut() {
        header('Location: ' . XG_AuthorizationHelper::signOutUrl($_GET['target'] ? $_GET['target'] : xg_absolute_url('/')));
    }

    /**
     * Outputs the app's locale string - should be called with ?xn_auth=no
     */
    public function action_getLocale() {
        echo $this->_widget->config['locale'];
    }

    protected function getSuccessTarget() {
        $target = NULL;
        if ($_GET['target']) {
            $target = $_GET['target'];
        // Use referrer as target only if it's within this application!  BAZ-2481
        } else if (isset($_SERVER['HTTP_REFERER'])) {
            $parts = parse_url($_SERVER['HTTP_REFERER']);
            $host = $parts['host'];
            if ((!$host) || ($host == $_SERVER['HTTP_HOST'])) {
                $target = $_SERVER['HTTP_REFERER'];
            }
        }
        if (!$target) {
            $target = $_SERVER['HTTP_HOST'];
        }
        if (mb_substr($target, 0, 7) != 'http://') {
            $target = 'http://' . $target;
        }
        return $target;
    }

    /**
     * The SearchController in the main widget is interested to know what this widget
     * has to say about app-wide search queries. @see BAZ-3821
     *
     * @param $query XN_Query The query object to modify
     */
    public function action_annotateSearchQuery($query) {
        /* Exclude banned/blocked users (BAZ-4024) */
        User::addBlockedFilter($query, true);
        /* Exclude pending users (BAZ-4427) */
        User::addPendingFilter($query, true);
    }

    /**
     * Stub just to render the error template
     */
    public function action_error() { }
}
