<?php
XG_App::includeFileOnce('/lib/XG_LangHelper.php');
XG_App::includeFileOnce('/lib/XG_LayoutHelper.php');
XG_App::includeFileOnce('/lib/XG_ModuleHelper.php');

class Index_FeatureController extends W_Controller {

    protected function _before() {
        XG_SecurityHelper::redirectIfNotAdmin();
    }

    public function action_add() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            //  validation should go here
            $this->forwardTo('addSave');
            return;
        }
        if (isset($_GET['saved']) && $_GET['saved']) {
            $this->showNotification = true;
            $this->notificationMessage = xg_text('YOUR_SITES_FEATURE_LIST');
            $this->notificationClass = 'success';
        }

        XG_LangHelper::browserNeverCache();

        $this->embeds = self::getEmbedList();

        // Find any standard embeds already in the layout and display them
        $xgLayout = XG_Layout::load('index');
        $xgLayout = XG_LayoutHelper::updateSidebarIfNecessary($xgLayout);

        // Don't interfere with the default layout if we've just loaded it.
        if (XG_App::appIsLaunched()) {
            // Let's check that the required modules are there for any pay services they aren't paying for.
            $xgLayout = XG_LayoutHelper::putPayServicesInSidebarIfNecessary($xgLayout);
        }
        $xpath = new DOMXPath($xgLayout->getLayout());

        // Determine the version we have just retrieved for later staleness test on the client side.
        $rootElement = $xpath->query('/layout')->item(0);
        $this->layoutIteration = ($rootElement->hasAttribute('iteration') ? $rootElement->getAttribute('iteration') : 0);

        $this->initialEmbeds = array();
        $this->initialEmbeds['sidebar'] = array();
        for ($col = 1; $col <= 3; $col++) {
            $this->initialEmbeds[$col] = array();
            if ($col === 1) {
                $path = '/layout/colgroup/column/colgroup/column';
                $width = 1;
            } else if ($col === 2) {
                $path = '/layout/colgroup/column/colgroup/column[2]';
                $width = 2;
            } else if ($col === 3) {
                $path = '/layout/colgroup/column[2]';
                $width = 1;
            }
            $nodeList = $xpath->query($path);
            $column = $nodeList->item(0);
            if ($column && $column->getAttribute('width') == $width) {
                $node = $column->firstChild;
                while ($node) {
                    $attrList = array();
                    XG_LayoutHelper::getAttributes($node, $attrList);
                    $attrList = array_pop($attrList);
                    foreach ($this->embeds as $name => $embed) {
                        if ($attrList['widgetName'] == $embed['widgetName']
                                && $attrList['action'] == $embed['col' . $width . 'Action']) {
                            $initialEmbed = array();
                            $initialEmbed['embedName'] = $name;
                            $initialEmbed['embedInstanceId'] = $attrList['embedInstanceId'];
                            if (isset($attrList['sitewide']) && $attrList['sitewide']) {
                                $this->initialEmbeds['sidebar'][] = $initialEmbed;
                            } else {
                                $this->initialEmbeds[$col][] = $initialEmbed;
                            }
                            continue;
                        }
                    }
                    $node = $node->nextSibling;
                }
            }
        }

        //  If we're in the prelaunch ('gyo') sequence, the buttons at the bottom
        //    change
        $this->displayPrelaunchButtons = !XG_App::appIsLaunched();
        if ($this->displayPrelaunchButtons) {
            $this->backLink = XG_App::getPreviousStepUrl();
            $this->nextLink = XG_App::getNextStepUrl();
        }
    } // action_add()

    public function action_addSave() {
        XG_App::includeFileOnce('/lib/XG_ActivityHelper.php');
        $embedsAvailable = self::getEmbedList();

        //  true if any element was successfully dropped into a drop target
        $successfulDrop = (isset($_POST['successfulDrop']) && $_POST['successfulDrop']);
        $embedsAdded = 0;
        $json = new NF_JSON();

        if (isset($_POST['xg_feature_layout']) && mb_strlen($_POST['xg_feature_layout'])) {
            $submitted = $json->decode($_POST['xg_feature_layout']);
            $xgLayout = XG_Layout::load('index');
            $previousLayout = new DOMXPath($xgLayout->getLayout());

            // Check that we are saving a new layout based on the current layout.
            $currentIteration = XG_Layout::getIteration($xgLayout->getLayout());
            if ($submitted->iteration != $currentIteration) {
                throw new Exception("Cannot save this layout - it is based on an earlier iteration (" . $submitted->iteration . "), not the current iteration ($currentIteration).");
            }

            //  Build the new layout with default or previous settings

            $xgLayout->clear();
            // Increment the iteration so that old versions of the Add Features page (in browser cache) become stale.
            XG_Layout::setIteration($xgLayout->getLayout(), $submitted->iteration + 1);

            $columnDetails = array(
                array($submitted->col1, '/layout/colgroup/column/colgroup/column', 1, false),
                array($submitted->col2, '/layout/colgroup/column/colgroup/column[2]', 2, false),
                array($submitted->sidebar, '/layout/colgroup/column[2]', 1, true),
                array($submitted->col3, '/layout/colgroup/column[2]', 1, false)
            );
            foreach ($columnDetails as $column) {
                list($embeds, $path, $width, $sitewide) = $column;
                $actionKey = 'col' . $width . 'Action';
                foreach ($embeds as $embed) {
                    $chosen = $embedsAvailable[$embed->xg_feature_name];
                    if ($embed->xg_embed_instance_id) {
                        //  Embed existed in previous layout - import it and
                        //    transform it if necessary
                        $embedId = $embed->xg_embed_instance_id;
                        $query = "//module[@embedInstanceId='$embedId']";
                        $module = $previousLayout->query($query)->item(0);
                        if ($module instanceof DOMElement) {
                            $module->setAttribute('action', $chosen[$actionKey]);
                            $module->setAttribute('sitewide', $sitewide);
                            $xgLayout->importElement($module, $path);
                        }
                    }
                    else {
                        //  Embed is new - create it
                        $xgLayout->addModule($chosen['widgetName'], $chosen[$actionKey],
                                $path, array('sitewide' => $sitewide), TRUE /* append at bottom */);
                        if(self::publicizeWidgetAddition($chosen['widgetName'])) XG_ActivityHelper::logActivityIfEnabled(XG_ActivityHelper::CATEGORY_NETWORK, XG_ActivityHelper::SUBCATEGORY_MESSAGE_NEW_FEATURE, null, null, null, $chosen['widgetName']);
                        XN_Event::fire('feature/add/after', array($chosen['widgetName']));
                    }
                    $embedsAdded++;
                }
                NF_Controller::invalidateCache(NF::INVALIDATE_ALL); // to ensure RSS embeds are properly sized if they've changed columns. BAZ-5213
            }
        }

        if ($embedsAdded < 1 || (!$successfulDrop && !XG_App::stepCompleted('Features'))) {
            //  No layout submitted or user left the layout blank
            //  Or user didn't change anything and we're processing the first visit
            //  Use the default layout
            $xgLayout = XG_Layout::load('index');
            $xgLayout->reInitialize();
        }

        //  Update the enabled mozzles based on the new layout
        $this->_widget->includeFileOnce('/lib/helpers/Index_FeatureHelper.php');
        Index_FeatureHelper::updateMozzleStatusFromLayout($xgLayout->getLayout());

        //  Mark the step completed if we haven't yet
        if (!XG_App::allStepsCompleted()) {
            //  Mark the prelaunch step as completed if necessary
            XG_App::markStepCompleted('Features');
        }

        //  Check for an explicit success target (e.g. launch)
        if (isset($_POST['successTarget']) && mb_strlen($_POST['successTarget']) > 0) {
            header('Location: ' . $_POST['successTarget']);
            exit;
        }
        else {
            if (XG_App::appIsLaunched()) {
                //  We're editing post-sequence - back to the manage page
                $this->redirectTo('manage', 'admin', '?saved=1');
            } else {
                //  Redirect to the new current step
                $nextStep = XG_App::currentLaunchStepRoute();
                $this->redirectTo($nextStep['actionName'], $nextStep['controllerName']);
            }
        }
    } // action_addSave

    function publicizeWidgetAddition($widgetName){
        return in_array($widgetName, array('photo', 'video', 'music', 'groups', 'forum', 'events', 'notes'));
    }

    protected function getEmbedList() {
        $embeds = array();
        $embeds['_members'] = array('title' => xg_text('MEMBERS'), 'widthOption' => 'w12',
                    'widgetName' => 'profiles', 'col1Action' => 'embed1activeMembers',
                    'col2Action' => 'embed2activeMembers',
                    'iconName' => 'members.gif', 'embedLimit' => 1, 'fixed' => false,
                    'about' => xg_text('A_LIST_OF_MEMBERS'));

        $firstOrderEmbeds = array();
        $secondOrderEmbeds = array();
        $modules = XG_ModuleHelper::getAllModules('addFeatures');
        foreach ($modules as $name => $module) {
            //  Don't include permanent mozzles
            if ((isset($module->config['isPermanent']) && $module->config['isPermanent'])
                    && $name !== 'profiles') {
                continue;
            }

            $moduleDesc = array();
            $moduleDesc['widgetName'] = $name;
            $moduleDesc['iconName'] = $name . '.gif';
            $moduleDesc['fixed'] = false;
            if ($module->config['title'] === 'Groups') {
                $moduleDesc['title'] = xg_text('GROUPS');
                $moduleDesc['about'] = xg_text('ALLOW_MEMBERS_TO_CREATE_GROUPS');
            } else if ($module->config['title'] === 'Forum') {
                $moduleDesc['title'] = xg_text('FORUM');
                $moduleDesc['about'] = xg_text('A_THREADED_DISCUSSION_FORUM');
            } else if ($module->config['title'] === 'Photos') {
                $moduleDesc['title'] = xg_text('PHOTOS');
                $moduleDesc['about'] = xg_text('ALLOW_USERS_PHOTOS');
            } else if ($module->config['title'] === 'Blog') {
                $moduleDesc['title'] = xg_text('BLOG');
                $moduleDesc['about'] = xg_text('FEATURE_POSTS_FROM_YOUR_BLOG');
            } else if ($module->config['title'] === 'Videos') {
                $moduleDesc['title'] = xg_text('VIDEOS');
                $moduleDesc['about'] = xg_text('ALLOW_USERS_VIDEOS');
            } else if (trim($module->config['title']) === 'Music') {
                $moduleDesc['title'] = xg_text('MUSIC');
                $moduleDesc['about'] = xg_text('ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO');
            } else if ($module->config['title'] === 'Text Box') {
                $moduleDesc['title'] = xg_text('TEXT_BOX');
                $moduleDesc['about'] = xg_text('PUT_ANY_TEXT_WIDGET_OR_HTML');
            } else if ($module->config['title'] === 'RSS') {
                $moduleDesc['title'] = xg_text('RSS');
                $moduleDesc['about'] = xg_text('ADD_FEEDS_FROM_ACROSS_THE_WEB');
            } else if ($module->config['title'] === 'Activity') {
                $moduleDesc['title'] = xg_text('ACTIVITY');
                $moduleDesc['about'] = xg_text('FOLLOW_LATEST_ACTIVITY');
            } else if ($module->config['title'] === 'Gadgets') {
                $moduleDesc['title'] = xg_text('GADGETS_BETA');
                $moduleDesc['about'] = xg_text('TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL');
            } else if ($module->config['title'] === 'Events') {
                $moduleDesc['title'] = xg_text('EVENTS');
                $moduleDesc['about'] = xg_text('ALLOW_PEOPLE_ORGANIZE_RSVP_EVENTS');
            } else if ($module->config['title'] === 'Notes') {
                $moduleDesc['title'] = xg_text('NOTES');
                $moduleDesc['about'] = xg_text('ALLOW_ADMINS_CREATE_EDIT_FEATURE_NOTES');
            } else {
                $moduleDesc['title'] = $module->config['title'];
                $moduleDesc['about'] = $module->config['title'];
            }

            //  Determine possible widths
            $width = 'w';
            if ($module->controllerHasAction('embed', 'embed1')) {
                $width .= '1';
                $moduleDesc['col1Action'] = 'embed1';
            }
            if ($module->controllerHasAction('embed', 'embed2')) {
                $width .= '2';
                $moduleDesc['col2Action'] = 'embed2';
            }
            //  Ensure that there's at least one
            if ($width == 'w') { continue; }
            $moduleDesc['widthOption'] = $width;

            //  Include it as a first-order or second-order feature
            //    for placement
            if (isset($module->config['isFirstOrderFeature']) && $module->config['isFirstOrderFeature']) {
                $moduleDesc['embedLimit'] = 1;
                $firstOrderEmbeds[$name] = $moduleDesc;
            }
            else {
                $embedLimit = $this->_widget->config['secondOrderEmbedLimit'];
                if (mb_strlen($embedLimit)) {
                    $moduleDesc['embedLimit'] = $embedLimit;
                }
                /* If the configuration variable isn't set */
                else if ($embedLimit == 0) {
                    $moduleDesc['embedLimit'] = 10;
                }
                $secondOrderEmbeds[$name] = $moduleDesc;
            }
        }

        $embeds += $firstOrderEmbeds;
        $embeds += $secondOrderEmbeds;
        $embeds['_description'] = array('title' => xg_text('DESCRIPTION'), 'widthOption' => 'w1',
                    'widgetName' => 'main', 'col1Action' => 'embed1siteDescription',
                    'col2Action' => 'embed2siteDescription', 'iconName' => 'sitedesc.gif',
                    'embedLimit' => 1, 'fixed' => false,
                    'about' => xg_text('SHOW_NETWORK_DESCRIPTION'));
        $embeds['_you'] = array('title' => xg_text('HELLO_USERNAME'), 'widthOption' => 'w1',
                    'widgetName' => 'main', 'col1Action' => 'embed1you', 'iconName' => 'layout_account.gif',
                    'embedLimit' => 1, 'fixed' => true, 'about' => xg_text('INFORMATION_ABOUT_THE_USER'));
        $embeds['_ads'] = array('title' => xg_text('ADS'), 'widthOption' => 'w1',
                    'widgetName' => 'main', 'col1Action' => 'embed1ads', 'col2Action' => 'embed2ads',
                    'iconName' => 'ads.gif','embedLimit' => 1, 'fixed' => (! XG_App::runOwnAds()),
                    'about' => xg_text('MONETIZE_WITH_ADS'));
        $embeds['_createdBy'] = array('title' => xg_text('CREATED_BY'), 'widthOption' => 'w1',
                    'widgetName' => 'main', 'col1Action' => 'embed1createdBy', 'iconName' => 'createdby.gif',
                    'embedLimit' => 1, 'fixed' => (! XG_App::protectYourNetwork()),
                    'about' => xg_text('LET_MEMBERS_KNOW_WHO_CREATED_NETWORK'));
        $embeds['_badges'] = array('title' => xg_text('GET_BADGES'), 'widthOption' => 'w1',
                    'widgetName' => 'profiles', 'col1Action' => 'embed1badge',
                    'iconName' => 'badges.gif', 'embedLimit' => 1,
                    'fixed' => false, 'about' => xg_text('PROMOTE_NETWORK_WITH_BADGES'));
        return $this->sortEmbeds($embeds);
    }

    /**
     * Sort the specified embeds according to addFeaturesSortOrder (configuration option in main widget).
     *
     * @param   $embeds Array   'name' => W_Widget pairs to sort.
     * @return          Array   'name' => W_Widget pairs.
     */
    protected function sortEmbeds($embeds) {
        $sortOrder = unserialize(W_Cache::getWidget('main')->config['addFeaturesSortOrder']);
        $sortables = array();
        foreach ($embeds as $name => &$embed) {
            $sortValue = ($sortOrder[$name] ? $sortOrder[$name] : 9999);
            $sortables[] = array('name' => $name, 'embed' => $embed, 'sortValue' => $sortValue);
        }
        XG_LangHelper::aasort($sortables, 'sortValue_a,title_a');
        $sorted = array();
        foreach ($sortables as $sortable) {
            $sorted[$sortable['name']] = $sortable['embed'];
        }
        return $sorted;
    }
}
