<?php

XG_App::includeFileOnce('/lib/ext/facebook/XG_FacebookHelper.php');

/**
 * Dispatches requests pertaining to obtaining a Flickr key.
 */
class Index_FacebookController extends W_Controller {

    //connect timeout in seconds

    protected function _before() {
        XG_SecurityHelper::redirectIfNotAdmin();
    }

    public function action_postInstructions() {
        $app = XN_Application::load();
        $this->appName = $app->name;
    }

    public function action_setup() {
        $app = XN_Application::load();
        $this->appName = $app->name;
        $this->fbVideoEnabled = XG_App::appIsFacebookEmbedEnabled('video');
        $this->fbPhotoEnabled = XG_App::appIsFacebookEmbedEnabled('photo');
        $this->fbMusicEnabled = XG_App::appIsFacebookEmbedEnabled('music');
        $this->fbVideoType = XG_App::getFacebookDisplayType('video');
        $this->fbPhotoType = XG_App::getFacebookDisplayType('photo');
        $this->fbMusicType = XG_App::getFacebookDisplayType('music');
        $this->fbVideoUrl = XG_App::getFacebookEmbedAppUrl('video');
        $this->fbPhotoUrl = XG_App::getFacebookEmbedAppUrl('photo');
        $this->fbMusicUrl = XG_App::getFacebookEmbedAppUrl('music');
        //$curWidget = W_Cache::getWidget('photo');
    } // action_keys()


    public function action_setupNewEmbed() {
        $fbKey = trim($_POST['fbApiKey']);
        $fbSecret = trim($_POST['fbApiSecret']);
        $embedType = $_POST['embedType'];
        $fbAppUrl =  mb_strtolower(trim($_POST['fbAppUrl']));

        XG_FacebookHelper::enableEmbedAndCanvas($embedType, $fbKey, $fbSecret, $fbAppUrl);
        XG_FacebookHelper::updateEmbedFeed($embedType);

        $this->redirectTo('setup', 'facebook');
    }

    public function action_updateEmbedOptions() {
        $embedType = $_POST['embedType'];
        $displayType =  $_POST['displayType'];

            XG_FacebookHelper::setFacebookDisplayType($embedType, $displayType);

            $this->redirectTo('setup', 'facebook');
    }

    public function action_disableEmbed() {
        $embedType = $_POST['embedType'];
      XG_FacebookHelper::disablePlayer($embedType);
            $this->redirectTo('setup', 'facebook');
    }

    public function action_enableEmbed() {
        $embedType = $_POST['embedType'] ? $_POST['embedType'] : $_GET['embedType'];
      $app = XN_Application::load();
      $this->appName = $app->name;
      $this->appUrl = $app->relativeUrl;
      $this->currentStep = $_GET['step'] ? $_GET['step'] : '1';
      if ($embedType == 'photo') {
        $pageTitle = xg_html('FACEBOOK_SLIDESHOW_PLAYER_TITLE');
      }
      else if ($embedType == 'video') {
        $pageTitle = xg_html('FACEBOOK_VIDEO_PLAYER_TITLE');
      }
      else if ($embedType == 'music') {
        $pageTitle = xg_html('FACEBOOK_MUSIC_PLAYER_TITLE');
      }

      if ($this->currentStep == '1') {
        XG_FacebookHelper::setupPlayer($embedType);
          $this->stepOneClass = 'class="this"';
      }
      else if ($this->currentStep == '2') {
          $this->stepTwoClass = 'class="this"';
      }
      else {
          $this->stepThreeClass = 'class="this"';
      }


      $this->embedType = $embedType;
      $this->embedCode = XG_FacebookHelper::getDefaultPlayerEmbedCode($embedType);
      $this->callbackUrl = 'http://' . $app->relativeUrl . '.ning.com/ext/facebook/' . $embedType . '/';
      $this->messageCallbackUrl = 'http://' . $app->relativeUrl . '.ning.com/ext/facebook/' . $embedType . '/';

      $this->fbKey = XG_App::getFacebookApiKey($embedType);
        $this->fbSecret = XG_App::getFacebookApiSecret($embedType);
        $this->fbAppUrl = XG_App::getBaseFacebookEmbedAppUrl($embedType);

      $this->pageTitle = $pageTitle;
      $this->render('instructions');
    }
}
