<?php
XG_App::includeFileOnce('/lib/XG_Embed.php');
XG_App::includeFileOnce('/lib/XG_ModuleHelper.php');
XG_App::includeFileOnce('/lib/XG_MetatagHelper.php');

/**
 * Dispatches requests pertaining to page modules, also known as "embeds".
 * These <div> elements typically have the "xg_embed" CSS class.
 */
class Index_EmbedController extends W_Controller {

    /**
     * @param profileThemeCssUrl  (optional) URL for the theme CSS chosen by the owner of the page
     * @param profileCustomCssUrl  (optional) URL for the custom CSS chosen by the owner of the page
     */
    public function action_header($highlight = NULL, $title = NULL, $moduleCssFiles = NULL,
                  $typographyCssUrl = NULL, $profileThemeCssUrl = NULL, $profileCustomCssUrl = NULL, $options = NULL) {

        $isAdmin = XG_SecurityHelper::userIsAdmin();
        //  Load this later only if needed
        $appInfo = NULL;
        
        $this->typographyCssUrl = $typographyCssUrl;

        /*  Refer to custom.css only if it's available - if we refer to an unavailable
         *    CSS file Safari will parse the 404 page for CSS!
         */
        W_Cache::getWidget('main')->includeFileOnce('/lib/helpers/Index_AppearanceHelper.php');
        $customCssPath = Index_AppearanceHelper::getCustomCssUrl();
        $this->includeCustomCss = is_readable($_SERVER['DOCUMENT_ROOT'] . $customCssPath);
        $this->customCssUrl = $customCssPath;

        //  Callers of this action can supply module or profile CSS files which
        //    go in specific places
        $this->moduleCssFiles = $moduleCssFiles;
        $this->profileThemeCssUrl = $profileThemeCssUrl;
        $this->profileCustomCssUrl = $profileCustomCssUrl;
        $this->displayHeader = TRUE;
        $this->displayLaunchBar = FALSE;
        $this->displayBlankLaunchBar = FALSE;
        $this->displayInvitePanelButton = FALSE;
        $this->includeActionBarCss = $options['includeActionBarCss'];
        $this->xgDivClass = $options['xgDivClass'];
        $this->userObject = $options['userObject'];
        $this->hideAdColors = $options['hideAdColors'];
        $this->hideNingbar = $options['hideNingbar'];

        /*
         * See BAZ-2808.  We need to read the sitewide theme CSS to see if the
         *   ning logo is hidden there - if so, we need to hide it ourselves on
         *   member pages, as the sitewide theme is no longer applied there
         */
        if (mb_strlen($profileThemeCssUrl) > 0) {
            $defaults = array();
            $imagePaths = array();
            Index_AppearanceHelper::getAppearanceSettings(NULL, $defaults,$imagePaths);
            $this->hideNingLogo = (mb_substr($defaults['ningLogoDisplay'], 0, 4) == 'none');
        } else {
            //  the logo will be hidden by the sitewide theme CSS if desired
            $this->hideNingLogo = false;
        }

        if (isset($options['blankLaunchBar'])) {
            $this->displayBlankLaunchBar = TRUE;
            $options['hideLaunchBar'] = TRUE;
        }

        if (isset($options['displayHeader'])) {
            $this->displayHeader = $options['displayHeader'];
        }
        $this->hideNavigation = (isset($options['hideNavigation']));

        // <meta/> description and keywords (BAZ-1025 and friends)
        if (isset($options['metaDescription'])) {
            // false means "don't display a meta description element
            if ($options['metaDescription'] === false || $options['metaDescription'] === '' || is_null($options['metaDescription'])) {
                $this->metaDescription = false;
            }
            // Anything else means "use this as the meta description"
            else {
                $this->metaDescription = $options['metaDescription'];
            }
        } else {
            //  Default to the description set by the app owner on the directory
            //    profile page
            $this->metaDescription = XG_MetatagHelper::appDescription();
        }
        if (isset($options['metaKeywords'])) {
            // false means "don't display a meta keywords element
            if ($options['metaKeywords'] === false || $options['metaKeywords'] === '' || is_null($options['metaKeywords'])) {
                $this->metaKeywords = false;
            }
            // Anything else means "use this as the meta keywaords"
            else {
                $this->metaKeywords = $options['metaKeywords'];
            }
        } else {
            //  Default to app keywords
            $this->metaKeywords = XG_MetatagHelper::appTags();
        }
        if (isset($options['videoThumbnail'])) {
            $this->videoThumbnail = $options['videoThumbnail'];
        }
        if (!XG_App::appIsLaunched() && !isset($options['hideLaunchBar'])) {
            //  If we're not yet launched, show launch bar
            $this->displayLaunchBar = TRUE;
            $this->includeCustomCss = FALSE;
            $this->prelaunchSteps = XG_App::getLaunchbarSteps();
            $this->requestedStep = XG_App::getRequestedStep();
            $this->backLink = XG_App::getPreviousStepUrl();
            $this->nextLink = XG_App::getNextStepUrl();
        }

        //  If prelaunch steps have not been completed, we use the default theme
        //    rather than the app's custom CSS
        //  Also hide the standard app header
        if (!XG_App::appIsLaunched()) {
            $this->userCssFilename = $this->_widget->buildResourceUrl('css/theme-ning.css');
            $this->displayHeader = FALSE;
        }
        else {
            //  User CSS filename changes with every update to avoid cache problems
            $filename = Index_AppearanceHelper::getThemeCssUrl();
            $filepath = $_SERVER['DOCUMENT_ROOT'] . $filename;
            $startTime = time();

            //  newly updated CSS might not be available yet if NFS is really slow -
            //  wait for it for a bit
            if (!is_readable($filepath)) {
                error_log("Waiting to read unavailable user CSS file " . $filename . "...");
                while (!is_readable($filepath) && ((time() - $startTime) < 3)) {
                    usleep(500000);
                    clearstatcache();
                }
            }

            //  If we timed out, log an error
            if (!is_readable($filepath)) {
                error_log("Timed out attempting to read user CSS file " . $filename);
                $filename = '/xn_resources/widgets/index/css/themes/Blue%20Jeans.css';
            }

            $this->userCssFilename = $filename;
        }

        $this->app = XN_Application::load();

        if ($this->displayHeader) {
            if ($this->_widget->config['logoImageUrl']) {
                $this->logoImage = $this->_widget->config['logoImageUrl'];
            } else {
                $this->logoImage = NULL;
            }
            $this->navEntries = XG_ModuleHelper::getNavEntries($isAdmin);
            $this->navHighlight = (isset($highlight) ? $highlight : 'home');
            $this->tagline = $this->_widget->config['tagline'];
        }

        if (is_null($title)) {
            $this->title = $this->app->name;
        } else {
            $this->title = $title;
        }

        /* BAZ-4641: if the user's logged in and there's a user object for them,
         * use the app-specific full name and thumbnail URL for them in the
         * Ningbar
         */
        if ($this->_user->isLoggedIn()) {
            $this->fullNameForNingbar = XG_UserHelper::getFullName($this->_user);
            $this->thumbnailUrlForNingbar = str_replace("'","\\'",XG_UserHelper::getThumbnailUrl($this->_user, null, null));
        }
        else {
            $this->fullNameForNingbar = $this->thumbnailUrlForNingbar = '';
        }
    }

    public function action_footer($extraHtml=null, $options = null) {
        $this->app = XN_Application::load();
        $this->profile = XG_Cache::Profiles($this->app->ownerName);

        //  Get widget names for xg.* prefixes
        $this->widgets = XG_ModuleHelper::getAllModules();

        $this->extraHtml = $extraHtml;
        $this->hideLinks = ! XG_App::appIsLaunched();
        $this->displayFooter = $options['displayFooter'] !== false;
        // Setting parseWidgets to false can speed up the page load for large pages
        // with no Dojo widgets [Jon Aquino 2007-12-04]
        $this->parseWidgets = $options['parseWidgets'] !== false;

        /* BAZ-4567: sync some User objects with system profiles */
        XG_UserHelper::syncMapWithProfiles();
    }

    /* For actions outside of the index mozzle (add profile) that
     * need to render the back/next button
     */
    public function action_backNext() {
        $this->backLink = XG_App::getPreviousStepUrl();
        $this->nextLink = XG_App::getNextStepUrl();
    }

    /**
     * Renders the sitewide sidebar embeds.
     */
    public function action_sidebar() {
        XG_LayoutHelper:: renderSitewideSidebarEmbeds($this);
    }

    /**
     * Action which renders either the sidebar box describing the logged in user
     *   or a sign in box if no user is signed in
     * Designed to be called from the sidebar action
     */
    public function action_sidebarUserBox() {
        //  Display announcement if there's one to display (BAZ-2654)
        XG_App::includeFileOnce('/lib/XG_Announcement.php');
        $announcementInfo = XG_Announcement::getAnnouncement();
        if ($announcementInfo) {
            $this->announcementId = $announcementInfo[0];
            $this->announcement = $announcementInfo[1];
        }
        $this->approvalLinks = array();
        foreach(XG_ModuleHelper::getEnabledModules() as $module) {
            if ($module->controllerHasAction('index', 'approvalLink')) {
                $result = $module->capture('index', 'approvalLink');
                if ($result) {
                    list($retval, $output) = $result;
                    $output = trim($output);
                    // Don't add output if it just contains the template start / end comments [Jon Aquino 2006-11-30]
                    if (preg_match('/<a/u', $output)) { $this->approvalLinks[] = $output; }
                }
            }
        }
    }

    /** For actions outside of the index mozzle that need to render the
     * next button for the join-the-app flow
     */
    public function action_joinBackNext($backLabel = NULL, $nextLabel = NULL) {
        $this->backLabel = $backLabel;
        $this->nextLabel = $nextLabel;
    }

    /** A message that appears until hidden */
    public function action_tempMessage($args) {
        $embed = $args['embed'];
        $visible = $embed->get('visible');
        if (! ($visible && $embed->isOwnedByCurrentUser())) {
            $this->render('blank');
            return;
        }
        $this->embedLocator = $embed->getLocator();
        $this->message = $embed->get('message');
    }

    public function action_hideTempMessage() {
        $embed = XG_Embed::load($_GET['id']);
        if (! $embed->isOwnedByCurrentUser()) { throw new Exception('Not layout owner.'); }
        $embed->set('visible', 0);
    }

    /** A message for just-logged-out folks */
    public function action_justLoggedOut() {
        if (XG_App::getLogoutCookie()) {
            XG_App::setLogoutCookie(false);
        } else {
            $this->render('blank');
        }
    }

    /**
     *   Builds a script tag containing colors for Google ads based on the theme
     *     CSS file found at the supplied URL.
     *
     *   NOTE:  Due to change on 20070301 to avoid HTTP request, this no longer
     *     works with URLs that point to the content store (e.g. all user theme
     *     URLs)
     */
    public function action_adColorBlock($url) {
        $this->_widget->includeFileOnce('/lib/helpers/Index_AppearanceHelper.php');
        //  URL can be relative - we have to make it absolute for file_get_contents
        // REMOVING this ends up going through the front end resolvers $url = xg_absolute_url($url);
        $url = mb_substr($url, 1); //remove the trailing slash that this seems to always have.
        $themeCss = @file_get_contents($url);
        if (!$themeCss) {
            //  Display a variable block with empty strings to avoid js errors
            return;
        }
        //  Get theme settings - ignore image paths
        list($this->themeSettings,) = Index_AppearanceHelper::parseCss($themeCss);
    }

    public function action_embed1siteDescription() {
        $this->description = XG_MetatagHelper::appDescription();
    }

    public function action_embed2siteDescription() {
        $this->forwardTo('embed1siteDescription');
    }

    public function action_embed1you() {
        //TODO This item has several names.  Rationalize?
        $this->forwardTo('sidebarUserBox');
    }

    public function action_embed1ads() {
        $this->render('_ad');
    }

    public function action_embed2ads() {
        $this->forwardTo('embed1ads');
    }

    public function action_embed1createdBy() {
        $this->app = XN_Application::load();
        // We no longer send them to the clone page but rather to the home page for a better user experience because the home page does not force login.  See BAZ-4930.
        $this->cloneLink = 'http://' . XN_AtomHelper::HOST_APP('www');
        if (XG_SecurityHelper::userIsOwner()) {
            $this->owner = $this->_user;
        }
        else {
            $this->owner = XG_Cache::Profiles($this->app->ownerName);
        }
        $this->route = XG_App::getRequestedRoute();
        $this->render('_networkCreator');
    }

    public function action_error() {
        $this->render('blank');
    }

    /** The welcome message that appears until hidden */
    public function action_embed2welcome($args) {
        XG_App::includeFileOnce('/lib/XG_ModuleHelper.php');
        $this->embed = $args['embed'];
        $visible = $this->embed->get('visible') || $_GET['test_welcome'];
        if (! ($visible && $this->embed->isOwnedByCurrentUser())) {
            $this->render('blank');
            return;
        }
        $this->embedLocator = $this->embed->getLocator();
    }

    public function action_welcomeSetValues() {
        $embed = XG_Embed::load($_GET['id']);
        if (! $embed->isOwnedByCurrentUser()) { throw new Exception('Not layout owner.'); }
        $embed->set('visible', 0);
    }

    /**
     * Called asynchronously via dojo with xn_out=json to acknowledge an
     *   announcement when a link in it is clicked
     */
    public function action_acknowledgeAnnouncement() {
        if (!isset($_POST['id'])) {
            $this->error = 'No ID specified';
            return;
        }
        $id = $_POST['id'];
        XG_App::includeFileOnce('/lib/XG_Announcement.php');
        XG_Announcement::acknowledge($_POST['id']);
    }

    /**
     * Displays a module promoting network badges
     */
    public function action_getBadge() {
    }

}