<?php

XG_App::includeFileOnce('/lib/XG_Embed.php');

class Html_EmbedController extends XG_GroupEnabledController {
    public function action_embed1($args) { $this->renderEmbed($args['embed'], $args['maxEmbedWidth']); }
    public function action_embed2($args) { $this->renderEmbed($args['embed'], $args['maxEmbedWidth']); }
    public function action_embed3($args) { $this->renderEmbed($args['embed'], $args['maxEmbedWidth']); }
    private function renderEmbed($embed, $maxEmbedWidth) {
        $this->fixTitle($embed);
        $this->embed = $embed;
        $this->maxEmbedWidth = $maxEmbedWidth;
        $this->title = $this->embed->get('title');
        $this->html = $this->embed->get('html');
        $this->html_isempty = ($embed->get('html') == null);
        if (! $this->html && ! $this->embed->isOwnedByCurrentUser()) {
            $this->render('blank');
            return;
        }
        list($this->title, $this->html, $this->hasDefaultContent) = $this->getValues($embed, $maxEmbedWidth);
        if ($this->title) {
            $this->moduleHead = '<div class="xg_module_head"><h2>' . xnhtmlentities($this->title) . '</h2></div>';
        } elseif ($this->embed->isOwnedByCurrentUser() && $this->hasDefaultContent) {
            $this->moduleHead = '<div class="xg_module_head"><h2>' . xg_html('YOUR_X_BOX', xnhtmlentities($this->nameOfGroupOrNetwork())) . '</h2></div>';
        } elseif ($this->embed->isOwnedByCurrentUser()) {
            $this->moduleHead = '<div class="xg_module_head"><h2>&nbsp;</h2></div>'; // Accomodate Edit-button height. [Jon Aquino 2008-01-14]
        } else {
            $this->moduleHead = '<div class="xg_module_head notitle"></div>';
        }
        if ($this->embed->isOwnedByCurrentUser()) {
            $this->maxLength = self::getMaxLength($this->_widget);
        }
        $this->render('embed');
    }
    public function action_setValues() {
        $embed = XG_Embed::load($_GET['id']);
        if (! $embed->isOwnedByCurrentUser()) { throw new Exception('Not embed owner.'); }
        XG_HttpHelper::trimGetAndPostValues();
        $embed->set('title', $_POST['title']);
        $xhtml = $_POST['html'];
        $this->sourceHtml = $xhtml;
        // Use strlen rather than mb_strlen (BAZ-5729) [Jon Aquino 2008-02-04]
        if (self::getMaxLength($this->_widget) > 0 && strlen($xhtml) > self::getMaxLength($this->_widget)) {
            $this->errorCode = 'TOO_LONG';
            return;
        }
        if(XG_SecurityHelper::userIsAdmin()){
            //@TODO create a centralized xg_light_scrub function
            // Commented for BAZ-4980. Will be removed soon.
            // $xhtml = str_replace("\n", '(newline)',$xhtml);
            $xhtml = tidy_repair_string($xhtml, array('output-xhtml' => true,
                                                     'numeric-entities' => true,
                                                     'wrap' => 0,
                                                     'drop-empty-paras' => false
                                                     ), 'utf8');
            $xhtml = preg_replace('/<(\!DOCTYPE[^>]*|html[^>]*|\/html|head|\/head|body|\/body|title|\/title)>\r?\n*/u','',$xhtml);

            /** Commented for BAZ-4980. Will be removed soon.
            $xhtml = str_replace("(newline)", "\n", $xhtml);
            /$xhtml = preg_replace("@</p>[ \t]*\n@u", "</p>", $xhtml);
            // Hack: The list-style:none elements appear when the scrubber encounters "(newline)" between <li> elements [Jon Aquino 2007-03-02]
            $xhtml = preg_replace('@<li style="list-style: none">\s*</li>@u', '', $xhtml);
            */
            // Change <div /> to <div></div> (VID-478)  [Jon Aquino 2006-09-06]
            $xhtml = preg_replace('@></(br|hr|img)>@u', ' />', preg_replace('@<([a-z]+) ([^>]+)/>@u', '<${1} ${2}></${1}>', $xhtml));
        } else {
            $xhtml = preg_replace('/\r?\n/u', '', xg_scrub($xhtml));
        }
        $xhtml = self::limitConsecutiveLineBreaks($xhtml, 10); // BAZ-2604 [Jon Aquino 2008-03-03]
        $embed->set('html', $xhtml);
        list($this->title, $this->html, $this->hasDefaultContent) = $this->getValues($embed, $_GET['maxEmbedWidth']);
    }

    /**
     * Ensures that the maximum number of consecutive <br> tags is $n.
     *
     * @param $html string  the original HTML
     * @param $n integer  the maximum number of consecutive line breaks
     * @return string  the HTML with the consecutive <br> limit enforced
     */
    protected static function limitConsecutiveLineBreaks($html, $n) {
        $br = '(?:<br ?/?>\r?\n?)';
        return preg_replace('@(' . $br . '{' . $n . '})' . $br . '+@ui', '\1', $html);
    }

    /**
     * Returns the maximum multibyte string length allowed for the html.
     *
     * @param $widget W_Widget  the HTML widget
     * @return integer  the max length
     */
    protected static function getMaxLength($widget) {
        if (mb_strlen($widget->config['maxLength']) == 0) {
            $widget->config['maxLength'] = 500000;
            $widget->saveConfig();
        }
        return $widget->config['maxLength'];
    }

    /**
     * Returns the name of the current group or, if we are not in a group context,
     * the name of the network.
     *
     * @return string  the name of the current group or of the network
     */
    private function nameOfGroupOrNetwork() {
        return XG_GroupHelper::inGroupContext() ? XG_GroupHelper::currentGroup()->title : XN_Application::load()->name;
    }

    private function getValues($embed, $maxEmbedWidth) {
        $title = $embed->get('title');
        $html = $embed->get('html');
        $hasDefaultContent = false;
        if (! $html && XG_SecurityHelper::userIsAdmin()) {
            $html = '<p>' . xg_html('CLICK_EDIT_TO_ADD_TEXT', 'href="' . xnhtmlentities($this->_buildUrl('embed', 'widgets')) . '"', xnhtmlentities($this->nameOfGroupOrNetwork())) . ' ' . xg_html('BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT') . '</p>';
            $hasDefaultContent = true;
        }
        if (! $html && ! XG_SecurityHelper::userIsAdmin()) {
            $html = xg_html('MAKE_YOUR_X_PAGE_YOUR_OWN', xnhtmlentities($this->nameOfGroupOrNetwork()));
            $hasDefaultContent = true;
        }
        $html = self::cleanScripts($html);
        $html = xg_resize_embeds($html, $maxEmbedWidth);
        $html = str_replace('//<![CDATA[','',$html);
        $html = str_replace('//]]>','',$html);
        return array($title, $html, $hasDefaultContent);
    }

    public function action_error() {
        $this->render('blank');
    }

    /**
     * Displays an information page describing how to get started with widget providers.
     */
    public function action_widgets() {
    }


    /**
    * Strips <br /> tags inserted inside script tags, since this breaks things. BAZ-2989
    * this is being called on getValues; consider calling during setValues for greater efficiency.
    */
    private function cleanScripts($html) {
        $scripts = explode('//<![CDATA[', $html);
        if (count($scripts) > 1) {
            // loop through
            for ($i = 1; $i <= count($scripts); $i++) {
                $scriptEnd = explode('//]]>',$scripts[$i]);
                if (count($scriptEnd) == 2) {
                    $scriptEnd[0] = str_replace('<br />','',$scriptEnd[0]);
                    $scripts[$i] = implode('//]]>',$scriptEnd);
                }
            }
            // reassemble
            return implode('//<![CDATA[', $scripts);
        } else {
            return $html;
        }
    }

    /**
     * Fixes BAZ-2253.
     *
     * @param XG_Embed  the embed to fix, if necessary
     */
    private function fixTitle($embed) {
        if ($embed->get('title') == xg_html('YOUR_X_BOX', $this->nameOfGroupOrNetwork())) { $embed->set('title', ''); }
    }

}