<?php
 /**
 * Brief summary of a group, for embeds.
 *
 * @param $group XN_Content|W_Content  the Group object
 * @param $avatarWidth integer  the width to use for avatars, in pixels
 * @param $showCreatedBy boolean  whether to show the name of the person who created the group
 * @
 */ ?>
    <li>
        <a href="<%= xnhtmlentities($this->_buildUrl('group', 'show', array('id' => $group->id))) %>">
            <img src="<%= xnhtmlentities(Group::iconUrl($group, $avatarWidth)) %>" width="<%= $avatarWidth %>" alt="" />
            <span><%= xnhtmlentities($group->title) %></span>
        </a>
        <span><%= xg_html('N_MEMBERS_PARENTHESIZED', $group->my->memberCount) %></span>
    </li>