<?php

class Gadget_ContentHelper {

    /**
     * Sorts the given objects according to the given attribute values.
     *
     * @param objects    The objects to sort; note that this array will be changed
     * @param attrValues The values to sort after
     * @param attrName   The name of the attribute
     */
    public static function sortByAttribute(&$objects, $attrValues, $attrName = 'id') {
        if (count($objects) > 0) {
            $comparator = new Gadget_ByAttributeComparator($attrName, $attrValues);
            usort($objects, array($comparator, 'compare'));
        }
    }
}    
class Gadget_ByAttributeComparator {
    private $attrName;
    private $attrValues;
    public function __construct($attrName, $attrValues) {
        $this->attrName   = $attrName;
        $this->attrValues = $attrValues;
    }
    function compare($objA, $objB) {
        $attrName = $this->attrName;
        $idxA     = array_search($objA->$attrName, $this->attrValues);
        $idxB     = array_search($objB->$attrName, $this->attrValues);

        return $idxA == $idxB ? 0 : ($idxA < $idxB ? -1 : 1);
    }
}
?>