<?php

class Gadgets_IndexController extends W_Controller {
    protected function _before() {
    }

	public function action_index() {
	    $this->currentUser = XN_Profile::current()->screenName;
	    $this->_widget->includeFileOnce('/lib/helpers/Gadgets_SecurityHelper.php');
	    $this->start = time();
		//safety measure, so Ning can disable the feature entirely if something goes badly wrong
		if (Gadgets_SecurityHelper::disabled()) {
			$this->render('blankIndex');
			return;
		}
		$pageNum = (isset($_GET['page']) ? (integer) $_GET['page'] : 1);
        ob_start();
        W_Cache::getWidget('gadgets')->dispatch('index', 'listHtml', array('pageNum' => $pageNum));
        $listHtml = trim(ob_get_contents());
        ob_end_clean();
        $this->listHtml = $listHtml;
    }

    public function action_listHtml($pageNum) {
        if (!$this->_user->isLoggedIn()) {
            //  Users not logged in can see a cached page
            $this->setCaching(array(crc32($_SERVER['QUERY_STRING'])), 300);
        }        
		XG_App::includeFileOnce('/lib/XG_PaginationHelper.php');
        $this->_widget->includeFileOnce('/lib/helpers/Gadget_ContentHelper.php');

        $this->pageSize = 10;

        $startAt = ($pageNum - 1) * $this->pageSize;
        $endAt = $startAt + $this->pageSize;

        $contentQuery = XN_Query::create('Content');
        $contentQuery->filter('owner->relativeUrl', '=', 'opensocial');
        $contentQuery->filter('type', '=', 'OpenSocialGadget')
        ->begin($startAt)
        ->end($endAt)
        ->order('my->averageRating', 'desc', XN_Attribute::NUMBER )
        ->alwaysReturnTotalCount(true);
		
		$this->results = $contentQuery->execute();
		$this->totalGadgets = $contentQuery->getTotalCount();
		$this->currentUser = XN_Profile::current()->screenName;
		
		$thumbnailIds = array();
		foreach ($this->results as $gadgetEntry){
		    if($gadgetEntry->my->image) $thumbnailIds[] = $gadgetEntry->my->image;
		}

        $thumbnailIds = array();
        foreach ($this->results as $gadgetEntry){
            if($gadgetEntry->my->image) $thumbnailIds[] = $gadgetEntry->my->image;
        }

        $query = XN_Query::create('Content');
        $query->filter('owner->relativeUrl', '=', 'opensocial');
        $query->filter('id', 'in', $thumbnailIds);
        $existingThumbnails = $query->execute();
        Gadget_ContentHelper::sortByAttribute($existingThumbnails, $thumbnailIds);
        $thumbnails = array();
        $count = 0;
        foreach ($this->results as $gadgetEntry){
            $thumbnails[] = ($gadgetEntry->my->image)?$existingThumbnails[$count++]:null;
        }

        $this->thumbnails = $thumbnails;
    }

	public function action_canvas() {
	    XG_App::includeFileOnce('/lib/XG_CryptoHelper.php');
	    $this->_widget->includeFileOnce('/lib/helpers/Gadgets_SecurityHelper.php');
        if (Gadgets_SecurityHelper::disabled()) {
			$this->render('blank');
			return;
		}

		//$this->status = 'gadgets!';
		$this->title = $_GET['title'];
		$this->feedUrl = $_GET['feedUrl'];
		$this->currentUser = XN_Profile::current()->screenName;
		//TODO: embed has no value at this point?  Canvas view is broken?  Need to look in svn and work out what is going on here and also work out what a canvas URL should look like.
        $this->embedOwnerName = $embed->getOwnerName();
	}

	public function action_backendApi() {
	    XG_App::includeFileOnce('/lib/XG_CryptoHelper.php');
	    $this->_widget->includeFileOnce('/lib/helpers/Gadgets_SecurityHelper.php');
        if (Gadgets_SecurityHelper::disabled()) {
			$this->render('blank');
			return;
		}
	}
	
	public function action_publicKey() {
	    XG_App::includeFileOnce('/lib/XG_CryptoHelper.php');
	    echo serialize(array('key' => XG_CryptoHelper::appPublicKey(), 'modulo' => ''));
	}

	public function action_iframeWrapper() {
	    XG_App::includeFileOnce('/lib/XG_CryptoHelper.php');
	    $this->_widget->includeFileOnce('/lib/helpers/Gadgets_SecurityHelper.php');
        if (Gadgets_SecurityHelper::disabled()) {
			$this->render('blank');
			return;
		}
	}
	
	/**
	 * Page to be loaded into the Gadgets iframe when an error has occurred on the proxy end.
	 *
	 * Expected $_GET variables:
	 *
	 *    'status' => HTTP status code that the proxy would have issued if not wrapping in a friendly error.
	 *    'message' => Message describing the problem.
	 */
	public function action_proxyError() {
	    $this->status = $_GET['status'];
	    $this->message = $_GET['message'];
	}
}
