<?php

XG_App::includeFileOnce('/lib/XG_Embed.php');

class Gadgets_EmbedController extends W_Controller {
    const CACHE_MAX_MINUTES = 60;

    protected function _before() {
        $this->_widget->includeFileOnce('/lib/helpers/Gadgets_SecurityHelper.php');
        //safety measure, so Ning can disable the feature entirely if something goes badly wrong
        if (Gadgets_SecurityHelper::disabled()) {
            $this->render('blank');
            return;
        }
        $this->trimGetAndPostValues();
    }

    public function action_embed1($args) { $this->renderEmbed($args['embed']); }
    public function action_embed2($args) { $this->renderEmbed($args['embed']); }
    public function action_embed3($args) { $this->renderEmbed($args['embed']); }

    private function renderEmbed($embed) {
        $this->_widget->includeFileOnce('/lib/helpers/Gadgets_SecurityHelper.php');
        $this->embed = $embed;
        
        if ($embed->isOwnedByCurrentUser() && ($_GET['op'] == 'set')) {
            if ($_GET['title']) {
	        	$embed->set('title', $_GET['title']);
	        } else {
	        	$embed->set('title', xg_text('GADGET'));
	        }
        	$embed->set('feedUrl', $_GET['url']); //TODO feedUrl is a bad name for a gadgetUrl.
        	
            //TODO Location should take a complete URL and not just a path according to the RFC I am pretty sure.
            if (isset($_GET['target'])) {
                header('Location: ' . $_GET['target']);
            } else {
                header('Location: ' . User::quickProfileUrl(XN_Profile::current()->screenName));
            }
            exit;
        }
        
        
        $this->title = $embed->get('title');
        $this->feedUrl = $embed->get('feedUrl');
        $this->currentUser = XN_Profile::current()->screenName;
        if ((! $this->feedUrl && ! $embed->isOwnedByCurrentUser())) {
            $this->render('blank');
            return;
        }
        $this->embedOwnerName = $embed->getOwnerName();
        $this->title = $this->title ? $this->title : $this->_widget->title;
        $this->render('embed');
    }
    
    public function action_setValues() {
        $embed = XG_Embed::load($_GET['id']);
        if (! $embed->isOwnedByCurrentUser()) { throw new Exception('Not embed owner'); }
        //TODO need a better way to automatically determine title if not provided (load from feed)
       	$embed->set('title', $_POST['title']);
        $embed->set('feedUrl', $_POST['feedUrl']);
        $this->embedOwnerName = $embed->getOwnerName();
        $this->currentUser = XN_Profile::current()->screenName;
        $this->title = $embed->get('title');
        ob_start();
        $this->renderPartial('fragment_moduleBodyAndFooter', array('feedUrl' => $_POST['feedUrl'], 'embedOwnerName' => $this->embedOwnerName, 'currentUser' => $this->currentUser, 'title' => $embed->get('title')));
        $this->moduleBodyAndFooterHtml = trim(ob_get_contents());
        ob_end_clean();
    }
    /**
     * Displays the feed items.
     *
     * @param $feedUrl string  the url for the feed
     * @param $itemCount integer  the maximum number of feed items to display
     * @param $showDescriptions boolean  whether to show titles and descriptions, or just titles
     */
    public function action_moduleBodyAndFooterProper($feedUrl) {
        if (! $feedUrl) { $this->render('blank'); return; }
        $this->feedUrl = $feedUrl;
        //$this->feed = $this->feed($feedUrl);
        //if (! $this->feed->data) { $this->render('blank'); return; }
    }
    
     //TODO this doesn't do anything now.
    private function cacheDirectory() {
        //$cacheDirectory = $_SERVER['DOCUMENT_ROOT'] . '/xn_private/xn_volatile/simplepie-cache';
        //if (! file_exists($cacheDirectory)) { @mkdir($cacheDirectory, 0777, true); }
        return $cacheDirectory;
    }
    
    //TODO this doesn't do anything now
    private function feed($feedUrl) {
        //$this->_widget->includeFileOnce('/lib/SimplePie/simplepie.inc');
        // Subtract 1 from CACHE_MAX_MINUTES to ensure that it is less than the moduleBodyAndFooterProper action cache [Jon Aquino 2007-05-09]
        //return new SimplePie($feedUrl, $this->cacheDirectory(), self::CACHE_MAX_MINUTES - 1);
    }
    private function trimGetAndPostValues() {
        foreach ($_GET as $key => $value) {
            $_GET[$key] = trim($value);
        }
        foreach ($_POST as $key => $value) {
            $_POST[$key] = trim($value);
        }
    }

    public function action_error() {
        $this->render('blank');
    }
}
