<?php xg_header(W_Cache::current('W_Widget')->dir, $this->titleText); ?>
<div id="xg_body">
    <div class="xg_colgroup">
        <div class="xg_3col first-child">
            <%= $this->renderPartial('fragment_navigation', '_shared') %>
            <h1><%= $this->titleHtml %> (<%= $this->totalCount %>)</h1>
            <%= XG_GroupHelper::groupLink() %>
            <div class="xg_colgroup">
                <?php
                if ($this->showSidebar) {
                    $this->_widget->dispatch('embed', 'sidebar');
                } ?>
                <div class="<%= $this->showSidebar ? 'xg_2col' : 'xg_3col first-child' %>">
                    <div class="xg_module">
                        <div class="xg_module_head notitle"></div>
                        <div class="xg_module_body">
                            <?php
                            if (! $this->showSidebar) { ?>
                                <form action="<%= xnhtmlentities($this->_buildUrl('topic', 'search')) %>">
                                    <%= XG_GroupHelper::hiddenFieldForGetForm() %>
                                    <p class="left">
                                        <input name="q" type="text" class="textfield" size="19" value="<%= xnhtmlentities($_GET['q']) %>" /> <input type="submit" class="button" value="<%= xg_html('SEARCH_DISCUSSIONS') %>" />
                                    </p>
                                </form>
                            <?php
                            } elseif (Forum_SecurityHelper::currentUserCanEditCategories()) { ?>
                                <p class="left" style="margin:0"><strong><a href="<%= xnhtmlentities($this->_buildUrl('category', 'edit')) %>" class="desc settings"><%= xg_html('ADD_MANAGE_CATEGORIES') %></a></strong></p>
                            <?php
                            }
                            if (! $this->hideSorts) {
                                XG_App::ningLoaderRequire('xg.shared.PagePicker'); ?>
                                <p class="right" style="display:none"><%= xg_html('SORT_BY') %> <select dojoType="PagePicker" _options="<%= xnhtmlentities($this->pagePickerOptionsJson) %>"></select></p>
                            <?php } ?>
                        </div>
                        <div class="xg_module_body">
                            <?php
                            if ($this->description) {
                                echo '<p>' . $this->description . '</p>';
                            }
                            foreach ($this->topicsAndComments as $topicOrComment) {
                                $comment = $topicOrComment->type == 'Comment' ? $topicOrComment : NULL;
                                $topic = $topicOrComment->type == 'Comment' ? $this->topics[$topicOrComment->my->attachedTo] : $topicOrComment;
                                $this->renderPartial('fragment_topic', '_shared', array('topic' => $topic, 'comment' => $comment, 'showListForContributorLink' => $this->showListForContributorLinks, 'showContributorName' => $this->showContributorName));
                            }
                            XG_PaginationHelper::outputPagination($this->totalCount, $this->pageSize); ?>
                        </div><!--/.xg_module_body-->
                        <?php
                        if ($this->showFeedLink || $this->showFollowLink) { ?>
                            <div class="xg_module_foot">
                                <?php
                                if ($this->showFeedLink) {
                                    xg_autodiscovery_link($this->feedUrl, $this->titleText, 'atom'); 
                                    if ($this->feedUrlReplies) {
                                        xg_autodiscovery_link($this->feedUrlReplies, xg_text('LATEST_REPLIES') , 'atom'); 
                                    }
                                    ?>
                                    <p class="left"><a class="desc rss" href="<%= xnhtmlentities($this->feedUrl) %>"><%= xg_html('RSS') %></a></p>
                                <?php
                                }
                                if ($this->showFollowLink) {
                                    $this->renderPartial('fragment_follow', '_shared');
                                } ?>
                            </div><!--/.xg_module_foot-->
                        <?php
                        } ?>
                    </div><!--/.xg_module-->
                </div><!--/xg_col-->
            </div><!--/xg_colgroup-->
        </div><!--/xg_col-->
        <div class="xg_1col last-child">
            <?php xg_sidebar($this); ?>
        </div><!--/xg_1col-->
    </div><!--/xg_colgroup-->
</div><!--/#xg_body-->
<?php xg_footer(); ?>
