<?php
$this->_widget->includeFileOnce('/lib/helpers/Forum_SecurityHelper.php');
if ($this->embed->get('itemCount') == 0 && $this->embed->isOwnedByCurrentUser()) { ?>
    <div class="xg_module_body">
        <h3><%= xg_html('NO_DISCUSSION_TO_DISPLAY') %></h3>
        <p><%= xg_html('BOX_WILL_NOT_SHOW_DISCUSSION') %></p>
    </div>
<?php
} else{
    foreach($this->topicsAndComments as $topicOrComment) {
        $comment = $topicOrComment->type == 'Comment' ? $topicOrComment : NULL;
        $topic = $topicOrComment->type == 'Comment' ? $this->topics[$topicOrComment->my->attachedTo] : $topicOrComment; ?>
        <div class="xg_module_body">
            <?php $this->renderPartial('fragment_topic', '_shared', array(
                    'topic' => $topic, 'comment' => $comment, 
                    'showListForContributorLink' => FALSE, 'showContributorName' => $this->showContributorName,
                    'showAvatar' => FALSE, 
                    'avatarSize' => $this->embed->getType() == 'groups' ? 32:36, 
                    'lineBreakAfterTitle' => $this->columnCount >= 1,
                    'showExcerptAndTags' => $this->embed->get('displaySet') !== 'titles')); ?>
        </div>
    <?php
    }
    if (! $this->topicsAndComments && $this->embed->isOwnedByCurrentUser() && $this->embed->getType() == 'profiles' && Forum_SecurityHelper::currentUserCanSeeAddTopicLinks()) { ?>
        <div class="xg_module_body">
            <h3><%= xg_html('YOU_HAVE_NOT_ADDED_DISCUSSIONS_2') %></h3>
            <p><%= xg_html('ADD_DISCUSSIONS_AND_SHARE') %></p>
            <p><a <%= XG_JoinPromptHelper::promptToJoin(Topic::newTopicUrl()) %> class="desc add"><%= xg_html('START_A_DISCUSSION') %></a></p>
        </div>
    <?php
    } elseif (! $this->topicsAndComments && $this->embed->isOwnedByCurrentUser() && $this->embed->get('topicSet') == 'promoted') { ?>
        <div class="xg_module_body">
            <h3><%= xg_html('THERE_ARE_NO_FEATURED_X', mb_strtolower(xg_html('DISCUSSIONS'))) %></h3>
            <p><%= xg_html('START_FEATURING_X_CLICK_Y', mb_strtolower(xg_html('DISCUSSIONS')), 'href="' . xnhtmlentities(W_Cache::getWidget('main')->buildRelativeUrl('admin','customization','#a1-11')) .'"') %></p>
        </div>
    <?php
    } elseif (! $this->topicsAndComments && $this->embed->isOwnedByCurrentUser() && $this->embed->get('topicSet') == 'ownerDiscussions') { ?>
        <div class="xg_module_body">
            <h3><%= xg_html('THERE_ARE_NO_X_THAT_MATCH_SETTINGS', mb_strtolower(xg_html('DISCUSSIONS'))) %></h3>
            <p><%= xg_html('CLICK_EDIT_AND_CHANGE_SETTINGS', mb_strtolower(xg_html('DISCUSSIONS')), 'href="' . xnhtmlentities(W_Cache::getWidget('main')->buildRelativeUrl('admin','customization','#a1-11')) .'"') %></p>
        </div>
    <?php
    } elseif (! $this->topicsAndComments && $this->embed->isOwnedByCurrentUser() && preg_match('/category_(.+)/u', $this->embed->get('topicSet'))) { ?>
        <div class="xg_module_body">
            <h3><%= xg_html('THERE_ARE_NO_X_THAT_MATCH_SETTINGS', mb_strtolower(xg_html('DISCUSSIONS'))) %></h3>
            <p><%= xg_html('CLICK_EDIT_AND_CHANGE_SETTINGS', mb_strtolower(xg_html('DISCUSSIONS')), 'href="' . xnhtmlentities(W_Cache::getWidget('main')->buildRelativeUrl('admin','customization','#a1-11')) .'"') %></p>
        </div>
    <?php
    // On the Groups page, we always display something, even if the current user is not the embed owner.
    // Otherwise the center column of the page will be blank. [Jon Aquino 2007-05-07]
    } elseif (! $this->topicsAndComments && $this->embed->getType() == 'groups' && ! $this->groupHasTopics && Forum_SecurityHelper::currentUserCanSeeAddTopicLinks()) { ?>
        <div class="xg_module_body">
            <h3><%= xg_html('START_A_DISCUSSION') %></h3>
            <p><%= xg_html('NOBODY_HAS_ADDED_DISCUSSIONS_ADD') %></p>
            <p><a <%= XG_JoinPromptHelper::promptToJoin(Topic::newTopicUrl()) %> class="desc add"><%= xg_html('START_A_DISCUSSION') %></a></p>
        </div>
    <?php
    } elseif (! $this->topicsAndComments && $this->embed->getType() == 'groups' && ! $this->groupHasTopics) { ?>
        <div class="xg_module_body">
            <p><%= xg_html('GROUP_HAS_NO_DISCUSSIONS') %></p>
        </div>
    <?php
    } elseif (! $this->topicsAndComments && $this->embed->getType() == 'groups' && $this->groupHasTopics) { ?>
        <div class="xg_module_body">
            <p><%= xg_html('VIEW_DISCUSSIONS_IN_GROUP_FORUM', 'href="' . xnhtmlentities($this->_buildUrl('index', 'index')) . '"', xnhtmlentities(XG_GroupHelper::currentGroup()->title)) %></p>
        </div>
    <?php
    } elseif (! $this->topicsAndComments && $this->embed->isOwnedByCurrentUser() && Forum_SecurityHelper::currentUserCanSeeAddTopicLinks()) { ?>
        <div class="xg_module_body">
            <p><a <%= XG_JoinPromptHelper::promptToJoin(Topic::newTopicUrl()) %> class="desc add"><%= xg_html('START_A_DISCUSSION') %></a></p>
        </div>
    <?php
    } elseif ($this->topicsAndComments) {
        $moreUrl = $this->embed->getType() == 'profiles' ? $this->_buildUrl('topic', 'listForContributor', array('user' => $this->embed->getOwnerName())) : $this->_buildUrl('index', 'index');
        $showCreateLink = ($this->embed->getType() != 'profiles' || $this->embed->isOwnedByCurrentUser()) && Forum_SecurityHelper::currentUserCanSeeAddTopicLinks();
        $feedUrl = XG_HttpHelper::addParameters($moreUrl, array('feed' => 'yes', 'xn_auth' => 'no'));
        if ($this->feedAutoDiscoveryTitle) { xg_autodiscovery_link($feedUrl, $this->feedAutoDiscoveryTitle, 'atom'); }
        $showFeedLink = ! is_null($this->showFeedLink) ? $this->showFeedLink: ! XG_App::appIsPrivate() && ! XG_GroupHelper::groupIsPrivate() && ($this->columnCount > 1 || ! $showCreateLink); ?>
        <div class="xg_module_foot">
            <ul>
            <?php
            if ($showCreateLink) { ?>
                <li class="left"><a <%= XG_JoinPromptHelper::promptToJoin(Topic::newTopicUrl()) %> class="desc add"><%= xg_html('START_DISCUSSION') %></a></li>
            <?php
            }
            if ($showFeedLink) { ?>
                <li class="left"><a class="rss" href="<%= xnhtmlentities($feedUrl) %>"><%= xg_html('RSS') %></a></li>
            <?php
            } ?>
                <li class="right"><a href="<%= xnhtmlentities($moreUrl) %>"><%= xg_html('VIEW_ALL') %></a></li>
            </ul>
        </div><!--/.xg_module_foot-->
    <?php
    }
} ?>
