<?php xg_header(W_Cache::current('W_Widget')->dir, $title = xg_text('FORUM_CATEGORIES')); ?>
<div id="xg_body">
    <div class="xg_colgroup">
        <div class="xg_3col first-child">
            <%= $this->renderPartial('fragment_navigation', '_shared') %>
            <h1><%= xnhtmlentities($title) %></h1>
            <%= XG_GroupHelper::groupLink() %>
            <div class="xg_colgroup">
                <div class="xg_3col first-child">
                    <div class="xg_module">
                        <?php
                        if (Forum_SecurityHelper::currentUserCanEditCategories()) { ?>
                            <div class="xg_module_body">
                                <p style="margin:0"><strong><a href="<%= xnhtmlentities($this->_buildUrl('category', 'edit')) %>" class="desc settings"><%= xg_html('ADD_MANAGE_CATEGORIES') %></a></strong></p>
                            </div>
                        <?php
                        } ?>
                        <div class="xg_module_body pad category">
                            <?php foreach ($this->categories as $category) { 
                                $link = $this->_buildUrl('topic', 'listForCategory', array('categoryId' => $category->id)); ?>
                                <h2><a href="<%= xnhtmlentities($link) %>"><%= xnhtmlentities($category->title) %></a></h2>
    							<p><%= xnhtmlentities($category->description) %> <a href="<%= xnhtmlentities($link) %>"><%= xg_html('VIEW_DISCUSSIONS') %></a></p>
                            <?php }
                            XG_PaginationHelper::outputPagination($this->totalCategories, $this->numPerPage);
                            ?>
                        </div><!--/.xg_module_body-->
                    </div><!--/.xg_module-->
                </div><!--/xg_col-->
            </div><!--/xg_colgroup-->
        </div><!--/xg_col-->
        <div class="xg_1col last-child">
            <?php xg_sidebar($this); ?>
        </div><!--/xg_1col-->
    </div><!--/xg_colgroup-->
</div><!--/#xg_body-->
<?php xg_footer(); ?>