<?php xg_header(W_Cache::current('W_Widget')->dir, $title = xg_text('MANAGE_CATEGORIES')); ?>
<div id="xg_body">
    <div class="xg_colgroup">
        <div class="xg_3col first-child">
            <%= $this->renderPartial('fragment_navigation', '_shared') %>
            <h1><%= xnhtmlentities($title) %></h1>
            <form action="<%= xnhtmlentities($this->_buildUrl('category', 'update')) %>" method="post">
                <div <%= count($this->categories) == 0 ? '' : 'style="display:none"' %> class="xg_module" id="no_categories_section" >
                    <div class="xg_module_body">
                        <h3><%= xg_html('ADD_A_CATEGORY') %></h3>
                        <p><%= xg_html('YOU_HAVE_NOT_ADDED_CATEGORIES') %></p>
                        <p class="buttongroup"><button><%= xg_html('ADD_A_CATEGORY') %></button></p>
                    </div>
                </div>
                <div <%= count($this->categories) > 0 ? '' : 'style="display:none"' %> class="xg_module">
                    <div id="category_container" class="xg_module_body pad">
                        <?php
                        for ($i = 0; $i < count($this->categories); $i++) {
                            $this->renderPartial('fragment_categoryEditor', 'category', array('category' => $this->categories[$i], 'topicCount' => $this->topicCounts[$i]));
                        } ?>
                    </div>
                </div><!--/.xg_module-->
                <p><input id="save_button" style="display:none" type="submit" class="button" value="<%= xg_html('SAVE_CHANGES') %>" /></p>
                <input type="hidden" name="data" value="" />
            </form>
            <?php
            $templateCategory = Category::create('', '');
            $templateCategory->my->membersCanAddTopics = 'Y';
            $templateCategory->my->membersCanReply = 'Y';
            ob_start();
            $this->renderPartial('fragment_categoryEditor', 'category', array('category' => $templateCategory));
            $categoryEditorTemplate = ob_get_contents();
            ob_end_clean(); ?>
            <input type="hidden" id="category_editor_template" value="<%= xnhtmlentities(str_replace("\n", " ", $categoryEditorTemplate)) %>" />
        </div><!--/xg_col-->
        <div class="xg_1col last-child">
            <?php xg_sidebar($this); ?>
        </div><!--/xg_1col-->
    </div><!--/xg_colgroup-->
</div><!--/#xg_body-->
<?php XG_App::ningLoaderRequire('xg.forum.category.CategoryEditor', 'xg.forum.category.edit'); ?>
<?php xg_footer(); ?>

