<?php
/**
 * The Forum-specific links at the top of the page.
 *
 * @param $categoryId string  ID of the initial category for new discussions (optional)
 * @param $hideStartDiscussionLink boolean  Whether to hide the "Start a New Discussion" link
 */ ?>
<ul class="navigation">
    <li><a href="<%= xnhtmlentities($this->_buildUrl('index', 'index')) %>"><%= xg_html('ALL_DISCUSSIONS') %></a></li>
    <li><a href="<%= xnhtmlentities($this->_buildUrl('topic', 'listForContributor', array('user' => XN_Profile::current()->screenName))) %>"><%= xg_html('MY_DISCUSSIONS') %></a></li>
    <?php
    $this->_widget->includeFileOnce('/lib/helpers/Forum_SecurityHelper.php');
    if (Forum_SecurityHelper::currentUserCanSeeAddTopicLinks() && ! $hideStartDiscussionLink) { ?>
        <li class="right"><a <%= XG_JoinPromptHelper::promptToJoin(Topic::newTopicUrl($categoryId)) %> class="bigdesc add"><strong><%= xg_html('START_A_DISCUSSION') %></strong></a></li>
    <?php
    } ?>
</ul>

