<?php
/**
 * Displays the date (and, optionally, the author) of a Topic or Comment
 *
 * @param $topicOrComment XN_Content|W_Content  The Topic or Comment object
 * @param $showContributorName boolean  Whether to show the name of the contributor
 * @param $terse boolean  Whether to use shorter strings
 */
$contributorLink = xg_userlink(XG_Cache::profiles($topicOrComment->contributorName), NULL, TRUE, $this->_buildUrl('topic', 'listForContributor', array('user' => $topicOrComment->contributorName)));
if ($topicOrComment->type == 'Topic') {
    $topic = $topicOrComment;
    if ($topic->my->lastCommentContributorName && ! $terse) {
        $lastReplyHref = 'href="' . $this->_buildUrl('topic', 'showLastReply', array('id' => $topic->id)) . '"';
        $lastReplyContributorLink = xg_userlink(XG_Cache::profiles($topic->my->lastCommentContributorName), NULL, TRUE, $this->_buildUrl('topic', 'listForContributor', array('user' => $topic->my->lastCommentContributorName)));
        if ($showContributorName) {
            echo  xg_html('STARTED_BY_X_LAST_REPLY_LINK_BY_X_T', $contributorLink, $lastReplyHref, $lastReplyContributorLink, xg_elapsed_time($topic->my->lastCommentCreatedDate));
        } else {
            echo  xg_html('STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T',  $lastReplyHref, $lastReplyContributorLink, xg_elapsed_time($topic->my->lastCommentCreatedDate));
        }
    } elseif ($showContributorName) {
        echo  xg_html('STARTED_BY_X_T', $contributorLink, xg_elapsed_time($topic->createdDate));
    } else {
        echo  xg_html($terse ? 'STARTED_T' : 'STARTED_DISCUSSION_T',  xg_elapsed_time($topic->createdDate));
    }
    if ($_GET['test_lastEntryDate']) { echo '<p style="background:yellow">lastEntryDate: ' . $topic->my->lastEntryDate . '</p>'; }
} else {
    $comment = $topicOrComment;
    if ($showContributorName) {
        echo  xg_html('ADDED_BY_X_T', $contributorLink, xg_elapsed_time($comment->createdDate));
    } elseif (Forum_CommentHelper::getAncestorCommentCount($comment)) {
        echo  xg_html('ADDED_REPLY_T',  xg_elapsed_time($comment->createdDate));
    } else {
        echo  xg_html('ADDED_POST_T',  xg_elapsed_time($comment->createdDate));
    }
}
