<?php

XG_App::includeFileOnce('/lib/XG_PagingList.php');
XG_App::includeFileOnce('/widgets/events/lib/helpers/Events_EventHelper.php');

/**
 * Common code for saving and querying User objects.
 */
class Events_UserHelper {

    /**
     *  gets the value for the named attribute for the user.
     *
     * @param $user XN_Content | W_Content
     * @param $name string The attribute name
     * @return the value of the attribute
     */
    public static function get($user, $name) {
        return $user->my->raw(XG_App::widgetAttributeName(W_Cache::getWidget('events'),$name));
    }

    /**
     *  sets the value for the named attribute for the user.
     *
     * @param $user XN_Content | W_Content
     * @param $name string The attribute name
     * @param $value  The attribute value
     * @param $type   The attribute type; defaults to string
     * @return void
     */
    public static function set($user, $name, $value, $type = XN_Attribute::STRING) {
        $user->my->set(XG_App::widgetAttributeName(W_Cache::getWidget('events'),$name), $value, $type);
    }
    
    
    /**
     *  determines if the nominated user has any upcoming events.
     *
     * @param $user XN_Content | W_Content
     * @return numeric; the number of upcoming events
     */
    public static function determineUpcomingEventCount($user) {
        $eventCount = self::get($user,'eventCount');
        $nextEventEndDate = self::get($user,'nextEventEndDate');
        if ($eventCount) {
            if ($nextEventEndDate > Events_EventHelper::dateToStr()) {
                return $eventCount;
            } else {
                self::updateEventCount($user);
                return self::get($user,'eventCount');
            }
        }
        return 0;
    }
    
    
    /**
     *  calculates a user's upcoming event count and nextEventDate and updates their user object accordingly
     *
     * @param $user XN_Content | W_Content
     * @param $saveUser boolean; option flag to save the user object; defaults to true
     * @return void
     */
    public static function updateEventCount($user, $saveUser = true) {
        EventWidget::init();
        $events = EventAttendee::getUpcomingEvents($user->contributorName, 1, true);
        if ($events->totalCount) {
            $nextEvent = $events->getList();
            $nextEvent = $nextEvent[0];
            self::set($user, 'eventCount', $events->totalCount, XN_Attribute::NUMBER);
            self::set($user, 'nextEventEndDate', $nextEvent->my->endDate);
        } else {
            self::set($user, 'eventCount', 0, XN_Attribute::NUMBER);
            self::set($user, 'nextEventEndDate', null);
        }
        if ($saveUser) {
            $user->save();  
        }
    }
    

}