<?php
/**
* @param item
* @param isProfile
* @param profileOwner
* @param removeOptionOff
*
**/

// TODO: Redesign this page to be cleaner, scalable,
// free of duplicate code, and I18N-friendly. [Jon Aquino 2008-02-23]

$titleMaxLength = 160;
try {
    ob_start();
    XG_App::includeFileOnce('/lib/XG_ActivityHelper.php');
    XG_App::includeFileOnce('/lib/XG_FullNameHelper.php');
    XG_App::includeFileOnce('/lib/XG_TemplateHelpers.php');
    W_Cache::getWidget('activity')->includeFileOnce('/lib/helpers/Activity_LogHelper.php');
    $members         = explode(',',$item->my->members);
    $username       = $members[0];
    $fullname       = XG_FullNameHelper::fullName($username);
    $contentIds     = explode(',',$item->my->contents);
    $screenNames    = explode(',',$item->my->members);
    $titles         = explode(',',$item->my->titles);
    $idList         = ($item->my->tempIdList) ? $item->my->tempIdList : $item->id;
    $currentpage    = urlencode('http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
    $avatarSize     = 32;
    $app            = XN_Application::load();
    $appName        = $app->name;
    $fmt            = $fmt ? $fmt : 'html';

    //fact, statement, or neither
    $isFact         = Activity_LogHelper::isFact($item);
    $isStatement    = Activity_LogHelper::isStatement($item); ?>
    <div class="xg_module_body activityitem <%= $item->my->subcategory %>_activity_item" <%= '_owners="'.xnhtmlentities($item->my->members).'" _idList="'.xnhtmlentities($idList).'"' %>><?php
    if($isFact || $isStatement){ ?>
            <div class="<%= $isFact?'question':'statement' %>"></div>
        <?php
    }
    //log item starts with the avatar link in the following cases
    if (Activity_LogHelper::hasAvatar($item)){
        if(! $isProfile) { ?>
                <%= xg_avatar(XG_Cache::profiles($username), $avatarSize, 'thumb') %> <?php
        }
        if((!$isProfile)||($username != $profileOwner)){
            $who = '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($username)).'">'.xnhtmlentities($fullname).'</a>';
        } else {
            $who = xnhtmlentities($fullname);
        }
    }

    //new group created
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_GROUP)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_CONTENT)){
        XG_App::includeFileOnce('/lib/XG_GroupHelper.php');
        $group = XG_Cache::content($contentIds[0]); ?>
        <span class="message"><?php
        if(count($contentIds) == 1){
            $item->title    = xg_text('X_CREATED_A_GROUP_Y', $fullname, xg_excerpt($group->title,$titleMaxLength));
            $item->my->link = XG_GroupHelper::buildUrl('groups', 'group', 'show', array('id' => $contentIds[0]));
            $groupLink = '<a href="'.xnhtmlentities($item->my->link).'">'.xnhtmlentities(xg_excerpt($group->title,$titleMaxLength)).'</a>'; ?>
            <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_CREATED_A_GROUP_Y', $groupLink):xg_html('X_CREATED_A_GROUP_Y',$who, $groupLink) %></span><?php
        } else {
            $item->title    = xg_text('X_CREATED_Y_NEW_GROUPS', $fullname, xg_excerpt($group->title,$titleMaxLength));
            $item->my->link = W_Cache::getWidget('groups')->buildUrl('group', 'list'); ?>
            <%= xg_html('X_CREATED_Y_NEW_GROUPS', $who, count($contentIds)) %>. <a href="<%= $item->my->link %>"><%= xg_html('VIEW_GROUPS')%></a></span><?php
        }
    }

    //new blog post created
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_BLOG)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_CONTENT)){
        $blogPost = XG_Cache::content($contentIds[0]); ?>
        <span class="message"><?php
        if(count($contentIds) == 1){
            $item->title    = xg_text('X_ADDED_THE_BLOG_POST_Y', $fullname, BlogPost::getTextTitle($blogPost, $titleMaxLength));
            $item->my->link = 'http://' . $_SERVER['HTTP_HOST'] .'/xn/detail/' . $contentIds[0];
            $postLink = '<a href="'.xnhtmlentities($item->my->link).'">'.xnhtmlentities(BlogPost::getTextTitle($blogPost, $titleMaxLength)).'</a>'; ?>
            <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_ADDED_THE_BLOG_POST_Y', $postLink):xg_html('X_ADDED_THE_BLOG_POST_Y', $who, $postLink) %></span><?php
        } else {
            $item->title    = xg_text('X_ADDED_Y_BLOG_POSTS', $fullname,  count($contentIds));
            $item->my->link = W_Cache::getWidget('profiles')->buildUrl('blog', 'list', array('user' => $item->contributorName)); ?>
            <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_ADDED_Y_BLOG_POSTS', count($contentIds)):xg_html('X_ADDED_Y_BLOG_POSTS', $who, count($contentIds)) %>. <a href="<%= xnhtmlentities($item->my->link) %>"><%=
            ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('VIEW_YOUR_BLOG_POSTS'):xg_html('VIEW_XS_BLOG_POSTS', xnhtmlentities($fullname)) %></a></span><?php
        }
    }

    //new topic created
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_TOPIC)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_CONTENT)){
        $topic = XG_Cache::content($contentIds[0]); ?>
        <span class="message"><?php
        if(count($contentIds) == 1){
            $item->title    = xg_text('X_STARTED_A_DISCUSSION_Y', $fullname, xg_excerpt($topic->title,$titleMaxLength));
            $item->my->link = 'http://' . $_SERVER['HTTP_HOST'] .'/xn/detail/' . $contentIds[0];
            $postLink = '<a href="'.xnhtmlentities($item->my->link).'">'.xnhtmlentities(xg_excerpt($topic->title,$titleMaxLength)).'</a>'; ?>
            <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_STARTED_A_DISCUSSION_Y', $postLink):xg_html('X_STARTED_A_DISCUSSION_Y', $who, $postLink) %></span><?php
        } else {
            $item->title    = xg_text('X_STARTED_Y_FORUM_POSTS', $fullname,  count($contentIds));
            $item->my->link = W_Cache::getWidget('forum')->buildUrl('topic', 'listForContributor', array('user' => $item->contributorName)); ?>
            <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_STARTED_Y_FORUM_POSTS', count($contentIds)):xg_html('X_STARTED_Y_FORUM_POSTS', $who, count($contentIds)) %>. <a href="<%= xnhtmlentities($item->my->link) %>"><%=
            ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('VIEW_YOUR_DISCUSSIONS'):xg_html('VIEW_XS_DISCUSSIONS', xnhtmlentities($fullname)) %></a></span><?php
        }
    }

    //new topic created in a group
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_GROUP_TOPIC)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_CONTENT)){
        XG_App::includeFileOnce('/lib/XG_GroupHelper.php');
        $topic = XG_Cache::content($contentIds[0]);
        $item->my->link = 'http://' . $_SERVER['HTTP_HOST'] .'/xn/detail/' . $contentIds[0];
        $titles = explode(',', $item->my->titles); ?>
        <span class="message"><?php
        $groupTitleLink = '<a href="' . XG_GroupHelper::buildUrl('groups','group','show',array('id' => $topic->my->groupId)) . '">' . urldecode($titles[0]) . '</a>';
        if(count($contentIds) == 2){
            $item->title    = xg_text('X_STARTED_A_DISCUSSION_Y_IN_GROUP', $fullname, xg_excerpt($topic->title,$titleMaxLength), urldecode($titles[0]));
            $postLink = '<a href="'.xnhtmlentities($item->my->link).'">'.xnhtmlentities(xg_excerpt($topic->title,$titleMaxLength)).'</a>'; ?>
            <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_STARTED_A_DISCUSSION_Y_IN_GROUP', $postLink, $groupTitleLink ):xg_html('X_STARTED_A_DISCUSSION_Y_IN_GROUP', $who, $postLink, $groupTitleLink) %></span><?php
        } else {
            $contentIds = array_unique($contentIds);
            $item->title    = xg_text('X_STARTED_Y_FORUM_POSTS_IN_GROUP', $fullname,  count($contentIds)-1, $groupTitleLink);?>
            <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_STARTED_Y_FORUM_POSTS_IN_GROUP', count($contentIds)-1,$groupTitleLink ):xg_html('X_STARTED_Y_FORUM_POSTS_IN_GROUP', $who, count($contentIds)-1, $groupTitleLink) %></span><?php
        }
    }

    //new reply to a topic
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_TOPIC)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_COMMENT)){
        W_Cache::getWidget('forum')->includeFileOnce('/lib/helpers/Forum_CommentHelper.php');
        $comment = XG_Cache::content($contentIds[0]);
        $commentHref = 'href="' . xnhtmlentities(Forum_CommentHelper::url($comment)). '"';
        $item->title    = xg_text('X_COMMENTED_ON_POST_TITLE', $fullname, xg_excerpt(urldecode($titles[0]),$titleMaxLength));
        $item->my->link = 'http://' . $_SERVER['HTTP_HOST'] .'/xn/detail/' . $contentIds[0];
        $replyHref =  'href="' . xnhtmlentities($item->my->link) . '"';
        $replyTitle = xnhtmlentities(xg_excerpt(urldecode($titles[0]),$titleMaxLength));
         ?>
        <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_LINK_COMMENTED_ON_POST_LINK_TITLE', $commentHref, $replyHref , $replyTitle):xg_html('X_LINK_COMMENTED_ON_POST_LINK_TITLE', $who, $commentHref, $replyHref , $replyTitle) %>
    <?php
    }

    //new comment on blog post
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_BLOG)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_COMMENT)){
        W_Cache::getWidget('profiles')->includeFileOnce('/lib/helpers/Profiles_CommentHelper.php');
        $comment = XG_Cache::content($contentIds[0]);
        $blogPost = XG_Cache::content($contentIds[1]);
        $commentHref = 'href="' . xnhtmlentities(Profiles_CommentHelper::url($comment)). '"';
        $item->title    = xg_text('X_COMMENTED_ON_BLOG_POST_TITLE', $fullname, BlogPost::getTextTitle($blogPost,$titleMaxLength));
        $item->my->link = 'http://' . $_SERVER['HTTP_HOST'] .'/xn/detail/' . $contentIds[1];
        $postHref =  'href="' . xnhtmlentities($item->my->link) . '"';
        $postTitle = xnhtmlentities(BlogPost::getTextTitle($blogPost,$titleMaxLength));
         ?>
        <%= ((XG_App::onMyProfilePage())&&($isProfile)&&($this->_user->screenName == $username))?xg_html('YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE', $commentHref, $postHref , $postTitle):xg_html('X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE', $who, $commentHref, $postHref , $postTitle) %>
    <?php
    }

    //new comment on photo
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_PHOTO)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_COMMENT)){
        W_Cache::getWidget('photo')->includeFileOnce('/lib/helpers/Photo_CommentHelper.php');
        $comment = XG_Cache::content($contentIds[1]);
        $photo = XG_Cache::content($contentIds[0]);
        $item->my->link = W_Cache::getWidget('photo')->buildUrl('photo', 'show', array('id' => $photo->id));
        $href = 'href="' . $item->my->link . '"';
        if (!$photo->title) {
            $photo->title = xg_text('UNTITLED');
        }
        $userSet = $who;
        if (count($screenNames > 1)) {
            // remove dups so our count doesn't get weird
            $screenNames = array_unique($screenNames);
        }
        if (count($screenNames) == 2) {
            $userSet .= ' ' . xg_text('AND') . ' ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>';
        }
        if (count($screenNames) == 3) {
            $userSet .= ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>' . ' ' . xg_text('AND') . ' ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[2])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[2])).'</a>';
        }
        if (count($screenNames) > 3) {
            $userSet .= ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>' . ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[2])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[2])).'</a> ' . xg_text('AND_X_OTHER_PEOPLE',count($screenNames)-3) . ' ';
        }

         ?>
        <%= ((XG_App::onMyProfilePage())&&($isProfile)&&($this->_user->screenName == $username))?xg_html('YOU_COMMENTED_ON_PHOTO_TITLE',$href, $photo->title):xg_html('X_LINK_COMMENTED_ON_PHOTO_TITLE', $userSet, $href, $photo->title) %>
    <?php
    }

    //new comment on album
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_ALBUM)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_COMMENT)){
        $comment = XG_Cache::content($contentIds[1]);
        $album = XG_Cache::content($contentIds[0]);
        $item->my->link = W_Cache::getWidget('photo')->buildUrl('album', 'show', array('id' => $album->id));
        $href = 'href="' . $item->my->link . '"';
        if (!$album->title) {
            $album->title = xg_text('UNTITLED');
        }
        $userSet = $who;
        if (count($screenNames > 1)) {
            // remove dups so our count doesn't get weird
            $screenNames = array_unique($screenNames);
        }
        if (count($screenNames) == 2) {
            $userSet .= ' ' . xg_text('AND') . ' ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>';
        }
        if (count($screenNames) == 3) {
            $userSet .= ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>' . ' ' . xg_text('AND') . ' ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[2])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[2])).'</a>';
        }
        if (count($screenNames) > 3) {
            $userSet .= ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>' . ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[2])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[2])).'</a> ' . xg_text('AND_X_OTHER_PEOPLE',count($screenNames)-3) . ' ';
        } ?>
        <%= ((XG_App::onMyProfilePage())&&($isProfile)&&($this->_user->screenName == $username))?xg_html('YOU_COMMENTED_ON_ALBUM_TITLE',$href, $album->title):xg_html('X_LINK_COMMENTED_ON_ALBUM_TITLE', $userSet, $href, $album->title) %>
    <?php
    }

    //new comment on event
	if ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_EVENT) {
        $event = XG_Cache::content($contentIds[0]);
        $item->my->link = W_Cache::getWidget('events')->buildUrl('event', 'show', array('id' => $event->id));
		$href = 'href="' . xg_xmlentities($item->my->link) . '"';

		switch ($item->my->category) {
			case XG_ActivityHelper::CATEGORY_NEW_COMMENT:
        		$comment = XG_Cache::content($contentIds[1]);
        		$userSet = $who;
        		if (count($screenNames > 1)) {
            		// remove dups so our count doesn't get weird
            		$screenNames = array_unique($screenNames);
        		}
        		if (count($screenNames) == 2) {
            		$userSet .= ' ' . xg_text('AND') . ' ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>';
        		}
        		if (count($screenNames) == 3) {
            		$userSet .= ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>' . ' ' . xg_text('AND') . ' ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[2])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[2])).'</a>';
        		}
        		if (count($screenNames) > 3) {
            		$userSet .= ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>' . ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[2])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[2])).'</a> ' . xg_text('AND_X_OTHER_PEOPLE',count($screenNames)-3) . ' ';
				}
				if (XG_App::onMyProfilePage() && $isProfile && $this->_user->screenName == $username) {
					echo '<span class="message">' . xg_html('YOU_COMMENTED_ON_EVENT_TITLE', $href, xnhtmlentities($event->title)) . '</span>';
				} else {
					echo '<span class="message">' . xg_html('X_LINK_COMMENTED_ON_EVENT_TITLE', $userSet, $href, xnhtmlentities($event->title)) . '</span>';
				}
				break;
			case XG_ActivityHelper::CATEGORY_STATUS_CHANGE:
				$attend = (bool)($item->description == EventAttendee::ATTENDING);
				$might = (bool)($item->description == EventAttendee::MIGHT_ATTEND);
				if (XG_App::onMyProfilePage() && $isProfile) {
					echo '<span class="message">' . xg_html($attend ? 'YOU_CHANGED_EVENT_STATUS_ATTEND' : 'YOU_CHANGED_EVENT_STATUS_MIGHT', $href, xnhtmlentities($event->title)) . '</span>';
				} else {
					echo '<span class="message">' . xg_html($attend ? 'X_CHANGED_EVENT_STATUS_ATTEND' : 'X_CHANGED_EVENT_STATUS_MIGHT', $who, $href, xnhtmlentities($event->title)) . '</span>';
				}
				break;
			case XG_ActivityHelper::CATEGORY_NEW_CONTENT:
				if (XG_App::onMyProfilePage() && $isProfile) {
					echo '<span class="message">' . xg_html('YOU_CREATED_EVENT', $href, xnhtmlentities($event->title)) . '</span>';
				} else {
					echo '<span class="message">' . xg_html('X_CREATED_EVENT_TITLE', $who, $href, xnhtmlentities($event->title)) . '</span>';
				}
				break;
			case XG_ActivityHelper::CATEGORY_UPDATE:
				if (XG_App::onMyProfilePage() && $isProfile) {
					echo '<span class="message">' . xg_html('YOU_UPDATED_EVENT', $href, xnhtmlentities($event->title)) . "</span>";
				} else {
					echo '<span class="message">' . xg_html('X_UPDATED_EVENT_TITLE', $who, $href, xnhtmlentities($event->title)) . "</span>";
				}
				break;
		}
    }

    //new comment on video
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_VIDEO)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_COMMENT)){
        W_Cache::getWidget('video')->includeFileOnce('/lib/helpers/Video_CommentHelper.php');
        $comment = XG_Cache::content($contentIds[1]);
        $video = XG_Cache::content($contentIds[0]);
        $item->my->link = W_Cache::getWidget('video')->buildUrl('video', 'show', array('id' => $video->id));
        $href = 'href="' . $item->my->link . '"';
        if (!$video->title) {
            $video->title = xg_text('UNTITLED');
        }
        $userSet = $who;
        if (count($screenNames > 1)) {
            // remove dups so our count doesn't get weird
            $screenNames = array_unique($screenNames);
        }
        if (count($screenNames) == 2) {
            $userSet .= ' ' . xg_text('AND') . ' ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>';
        }
        if (count($screenNames) == 3) {
            $userSet .= ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>' . ' ' . xg_text('AND') . ' ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[2])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[2])).'</a>';
        }
        if (count($screenNames) > 3) {
            $userSet .= ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[1])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[1])).'</a>' . ', ' . '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($screenNames[2])).'">'.xnhtmlentities(XG_FullNameHelper::fullName($screenNames[2])).'</a> ' . xg_text('AND_X_OTHER_PEOPLE',count($screenNames)-3) . ' ';
        }

         ?>
        <%= ((XG_App::onMyProfilePage())&&($isProfile)&&($this->_user->screenName == $username))?xg_html('YOU_COMMENTED_ON_VIDEO_TITLE',$href, $video->title):xg_html('X_LINK_COMMENTED_ON_VIDEO_TITLE', $userSet, $href, $video->title) %>
    <?php
    }

    //new music tracks
    if( ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_HOME_TRACK)||
        (($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_TRACK)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_CONTENT))
        ){
        $firstTracks = array();
        for($i=0; $i < 4; $i++){
            if ($i >= count($contentIds)) continue;
            $firstTracks[] = XG_Cache::content($contentIds[$i]);
        }
        if($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_HOME_TRACK){
            $item->title    = xg_text('X_NEW_SONGS_ADDED_TO_APPNAME', count($contentIds), $appName);
            $item->my->link = 'http://' . $_SERVER['HTTP_HOST'];
            ?><span class="message"> <%= xnhtmlentities($item->title) %></span><?php
        } else {
            $item->title    = xg_text('Y_ADDED_X_SONGS', count($contentIds), $fullname);
            $item->my->link = 'http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($username);
            ?><span class="message"> <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_ADDED_X_SONGS', count($contentIds)):xg_html('Y_ADDED_X_SONGS', count($contentIds), $who) %></span><?php
        }
        //@TODO generate enclosure if rss
                $this->renderPartial('fragment_thumb_tracks', 'log', array('tracks' => $firstTracks));?>
                <?php
    }

    //new videos
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_VIDEO)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_CONTENT)) {
        W_Cache::getWidget('video')->includeFileOnce('/lib/helpers/Video_SecurityHelper.php');
        $firstVideos = array();
        for($i=0; $i < 3; $i++){
            if ($i >= count($contentIds)) continue;
            $video = XG_Cache::content($contentIds[$i]);
            if ( (($isProfile)&&(! $error = Video_SecurityHelper::checkVisibleToCurrentUser($this->_user, $video)))||
                 ((!$isProfile)&&($video->my->visibility == 'all')) ) {
                $firstVideos[] = $video;
            }
        }
        if(count($firstVideos)==0) { throw new Exception("Empty item."); }
        W_Cache::getWidget('video')->includeFileOnce('/lib/helpers/Video_VideoHelper.php');
        $item->title    = xg_text('Y_ADDED_X_VIDEOS', count($contentIds), $fullname);
        $item->my->link = (count($contentIds)>1) ?
         W_Cache::getWidget('video')->buildUrl('video', 'listForContributor', array('screenName' => $username)) :
         W_Cache::getWidget('video')->buildUrl('video', 'show', array('id' => $firstVideos[0]->id)) ;
        //@TODO generate enclosure if rss
         ?><span class="message"> <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_ADDED_X_VIDEOS', count($contentIds)):xg_html('Y_ADDED_X_VIDEOS', count($contentIds), $who) %> <a href="<%= $item->my->link
          %>"><%=  xnhtmlentities((count($contentIds)>1)?xg_text('VIEW_VIDEOS'):xg_excerpt($firstVideos[0]->title,$titleMaxLength)) %></a></span><?php
        $this->renderPartial('fragment_thumb_videos', 'log', array('videos' => $firstVideos));
    }

    //new photos
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_PHOTO)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_CONTENT)) {
        W_Cache::getWidget('photo')->includeFileOnce('/lib/helpers/Photo_SecurityHelper.php');
        $firstPhotos = array();
        for($i=0; $i < 4; $i++){
            if ($i >= count($contentIds)) continue;
            $photo = XG_Cache::content($contentIds[$i]);
            if ( (($isProfile)&&(! $error = Photo_SecurityHelper::checkVisibleToCurrentUser($this->_user, $photo)))||
                 ((!$isProfile)&&($photo->my->visibility == 'all')) ) {
                $firstPhotos[] = $photo;
            }
        }
        if(count($firstPhotos)==0) { throw new Exception("Empty item."); }
        $item->title    = xg_text('Y_ADDED_X_PHOTOS', count($contentIds), $fullname);
        $item->my->link = (count($contentIds)>1) ?
            W_Cache::getWidget('photo')->buildUrl('photo', 'listForContributor', array('screenName' => $username)) :
             W_Cache::getWidget('photo')->buildUrl('photo', 'show', array('id' => $firstPhotos[0]->id));
        ?><span class="message"> <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_ADDED_X_PHOTOS', count($contentIds)):xg_html('Y_ADDED_X_PHOTOS', count($contentIds), $who) %> <a href="<%= $item->my->link
         %>"><%=  xnhtmlentities((count($contentIds)>1)?xg_text('VIEW_PHOTOS'):xg_excerpt($firstPhotos[0]->title,$titleMaxLength)) %></a></span><?php
         $this->renderPartial('fragment_thumb_photos', 'log', array('photos' => $firstPhotos));
    }

    //new albums
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_ALBUM)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_CONTENT)) {
        W_Cache::getWidget('photo')->includeFileOnce('/lib/helpers/Photo_SecurityHelper.php');
        $firstAlbums = array();
        for($i=0; $i < 4; $i++){
            if ($i >= count($contentIds)) continue;
            $album = XG_Cache::content($contentIds[$i]);
            if ($album->my->hidden != 'Y') {
                $firstAlbums[] = $album;
            }
        }
        if(count($firstAlbums)==0) { throw new Exception("Empty item."); }
        $item->title    = xg_text('Y_ADDED_X_ALBUMS', count($contentIds), $fullname);
        $item->my->link = (count($contentIds)>1) ?
            W_Cache::getWidget('photo')->buildUrl('album', 'listForOwner', array('screenName' => $username)) :
             W_Cache::getWidget('photo')->buildUrl('album', 'show', array('id' => $firstAlbums[0]->id));
        ?><span class="message"> <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_ADDED_X_ALBUMS', count($contentIds)):xg_html('Y_ADDED_X_ALBUMS', count($contentIds), $who) %> <a href="<%= $item->my->link
         %>"><%=  xnhtmlentities((count($contentIds)>1)?xg_text('VIEW_ALBUMS'):xg_excerpt($firstAlbums[0]->title,$titleMaxLength)) %></a></span><?php
         $this->renderPartial('fragment_thumb_albums', 'log', array('albums' => $firstAlbums));
    }

    //member joined a group
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_GROUP)&&($item->my->category == XG_ActivityHelper::CATEGORY_CONNECTION)){
        $contentIds = array_unique($contentIds);
        XG_App::includeFileOnce('/lib/XG_GroupHelper.php');
        $group = XG_Cache::content($contentIds[0]);
         ?>
        <span class="message"><?php
        if(count($contentIds) == 1){
            $item->title    = xg_text('X_JOINED_THE_GROUP_Y', $fullname, xg_excerpt($group->title,$titleMaxLength));
            $item->my->link = XG_GroupHelper::buildUrl('groups', 'group', 'show', array('id' => $contentIds[0]));
            $groupLink = '<a href="'.xnhtmlentities($item->my->link) .'">'.xnhtmlentities(xg_excerpt($group->title,$titleMaxLength)).'</a>'; ?>
            <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_JOINED_THE_GROUP_X', $groupLink):xg_html('X_JOINED_THE_GROUP_Y', $who, $groupLink) %></span><?php
        } else {
            $item->title    = xg_text('X_JOINED_Y_GROUPS', $fullname, count($contentIds));
            $item->my->link = W_Cache::getWidget('groups')->buildUrl('group', 'list'); ?>
            <%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOU_JOINED_X_GROUPS', count($contentIds)):xg_html('X_JOINED_Y_GROUPS', $who, count($contentIds)) %>. <a href="<%= $item->my->link %>"><%= xg_html('VIEW_GROUPS')%></a></span><?php
        }
    }

    //member joined the network
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_PROFILE)&&($item->my->category == XG_ActivityHelper::CATEGORY_CONNECTION)){
        $memberNumber = $item->my->raw(XG_App::widgetAttributeName(W_Cache::getWidget('main'), 'memberNumber'));
        $item->title    = xg_text('X_JOINED_APPNAME', $fullname, $appName);
        $item->my->link = 'http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($username);
            if (XG_App::onMyProfilePage() && $memberNumber && $this->_user->screenName == $username && XG_App::canSeeInviteLinks(XN_Profile::current())) { ?>
                <span class="message"> <%= xg_html('WELCOME_MEMBER_N_OF_APPNAME_INVITE', $who, $memberNumber, xnhtmlentities($appName), 'href="' . xnhtmlentities('/invite') . '"') %></span>
            <?php
            } elseif (XG_App::onMyProfilePage() && $memberNumber) { ?>
            <span class="message"> <%= xg_html('WELCOME_MEMBER_N_OF_APPNAME', $who, $memberNumber, xnhtmlentities($appName)) %></span>
        <?php
        } elseif (XG_App::onProfilePage() && $memberNumber) { ?>
            <span class="message"> <%= xg_html('X_IS_MEMBER_N_OF_APPNAME', $who, $memberNumber, xnhtmlentities($appName)) %></span>
        <?php
        } else {
            $commentWallUrl = xnhtmlentities(W_Cache::getWidget('profiles')->buildUrl('comment','list',array('attachedToType' => 'User','attachedTo'=> $username))); ?>
            <span class="message"> <%= xg_html('X_JOINED_APPNAME', $who, $appName, 'href="' . $commentWallUrl .'"', xnhtmlentities($fullname)) %></span>
         <?php
        }
    }

    //member updated profile
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_PROFILE)&&($item->my->category == XG_ActivityHelper::CATEGORY_UPDATE)){
        $item->title    = xg_text('XS_PROFILE_CHANGED', $fullname);
        $item->my->link = 'http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($username); ?>
         <span class="message"><%= ((XG_App::onMyProfilePage())&&($isProfile))?xg_html('YOUR_PROFILE_CHANGED'):xg_html('XS_PROFILE_CHANGED', $who) %></span><?php
    }

    //new chatter on the chatterwall
    if(($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_PROFILE)&&($item->my->category == XG_ActivityHelper::CATEGORY_NEW_COMMENT)){
        $item->title    = xg_text('X_LEFT_A_COMMENT_FOR_Y', $fullname, XG_FullNameHelper::fullName($members[1]));
        $item->my->link = 'http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($members[1]);

        if ((!$isProfile)||($members[1] != $profileOwner)){
            $commentedProfileLink = '<a href="'.xnhtmlentities($item->my->link).'">'.xnhtmlentities(XG_FullNameHelper::fullName($members[1])).'</a>';
        }else {
            $commentedProfileLink = xnhtmlentities(XG_FullNameHelper::fullName($members[1]));
        }
         ?><span class="message"> <?php if((XG_App::onMyProfilePage())&&(!$_GET['viewAsOther'])&&($isProfile)){
             if($this->_user->screenName == $username){
                 echo xg_html('YOU_LEFT_A_COMMENT_FOR_X', $commentedProfileLink);
             }else {
                 echo xg_html('X_LEFT_A_COMMENT_FOR_YOU', '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($username)).'">'.xnhtmlentities($fullname).'</a>');
             }
         }else {
             echo xg_html('X_LEFT_A_COMMENT_FOR_Y', $who, $commentedProfileLink);
         }  ?></span><?php
    }

    //network facts and messages
    if($item->my->category == XG_ActivityHelper::CATEGORY_NETWORK){
        $item->my->link = 'http://' . $_SERVER['HTTP_HOST'];
        $item->title    = xg_text('ANNOUNCEMENT');
        if($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_MESSAGE) { ?>
            <h5><%= xg_html('ANNOUNCEMENT') %></h5>
            <%= xnhtmlentities(xg_excerpt($item->description,140)) %><?php
        }else if($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_MESSAGE_QUESTIONS_UPDATE) { ?>
            <h5><%= xg_html('ANNOUNCEMENT') %></h5>
            <%= xg_html('APPNAME_HAS_NEW_PROFILE_QUESTIONS', $appName, 'href="' . xnhtmlentities(W_Cache::getWidget('profiles')->buildUrl('profile', 'edit')) . '"') %><?php
        }else if($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_MESSAGE_NEW_FEATURE) {
            if($itemWidget = W_Cache::getWidget($item->my->widgetName)) { $itemWidgetIndex = $itemWidget->buildUrl('index', 'index'); }
            ?>
                <h5><%= xg_html('ANNOUNCEMENT') %></h5>
            <%= xg_html('APPNAME_NOW_HAS_'.mb_strtoupper($item->my->widgetName), $appName, 'href="' . xnhtmlentities($itemWidgetIndex) . '"' ) %><?php
            }else if($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_NETWORK_CREATED && $this->_user->isOwner()) { ?>
                <h5><%= xg_html('CONGRATULATIONS') %></h5>
                <%= xg_html('YOU_CREATED_APPNAME', xnhtmlentities($appName)) %><?php
            }else if($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_NETWORK_CREATED && ! $this->_user->isOwner()) { ?>
                <h5><%= xg_html('ANNOUNCEMENT') %></h5>
                <%= xg_html('USER_CREATED_APPNAME', xnhtmlentities(xg_username(XG_Cache::profiles(XN_Application::load()->ownerName))), xnhtmlentities($appName)) %><?php
        }else {
            $item->title    = xg_text('DID_YOU_KNOW');  ?>
            <h5><%= xg_html('DID_YOU_KNOW') %></h5> <?php
            if($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_FACT_MESSAGE) { ?>
                <%= html_entity_decode($item->description) %><?php
            } else if ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_FACT_PHOTO_CHAMPION) { ?>
                <%= xg_html('X_HAS_POSTED_THE_MOST_PHOTOS', '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($username)).'">'.xnhtmlentities($fullname).'</a>','<a href="'.xnhtmlentities(W_Cache::getWidget('photo')->buildUrl('photo', 'index')).'">', '</a>') %><?php
            } else if ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_FACT_VIDEO_CHAMPION) { ?>
                <%= xg_html('X_HAS_POSTED_THE_MOST_VIDEOS', '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($username)).'">'.xnhtmlentities($fullname).'</a>','<a href="'.xnhtmlentities(W_Cache::getWidget('video')->buildUrl('video', 'index')).'">', '</a>') %><?php
            } else if ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_FACT_MUSIC_CHAMPION) { ?>
                <%= xg_html('X_HAS_POSTED_THE_MOST_MUSIC', '<a href="'.xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . User::quickProfileUrl($username)).'">'.xnhtmlentities($fullname).'</a>') %><?php
            } else if ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_FACT_TOP_PHOTO) {
                $photo = XG_Cache::content($contentIds[0]); ?>
                <%= xg_html('X_IS_THE_MOST_POPULAR_PHOTO',  '<a href="'. W_Cache::getWidget('photo')->buildUrl('photo', 'show', array('id' => $photo->id)).'">'.xnhtmlentities($photo->title?xg_excerpt($photo->title,$titleMaxLength):xg_text('UNTITLED')).'</a>') %><?php
                $this->renderPartial('fragment_thumb_photos', 'log', array('photos' => array($photo)));
            } else if ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_FACT_TOP_VIDEO) {
                W_Cache::getWidget('video')->includeFileOnce('/lib/helpers/Video_VideoHelper.php');
                $video = XG_Cache::content($contentIds[0]); ?>
                <%= xg_html('X_IS_THE_MOST_POPULAR_VIDEO',  '<a href="'. W_Cache::getWidget('video')->buildUrl('video', 'show', array('id' => $video->id)).'">'.xnhtmlentities($video->title?xg_excerpt($video->title,$titleMaxLength):xg_text('UNTITLED')).'</a>') %><?php
                $this->renderPartial('fragment_thumb_videos', 'log', array('videos' => array($video)));
            } else if ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_FACT_TOP_MUSIC) {
                $track = XG_Cache::content($contentIds[0]); ?>
                <%= xg_html('X_IS_THE_MOST_POPULAR_MUSIC', xnhtmlentities($track->my->artist.' '.(($track->my->artist && $track->my->trackTitle)?' &mdash;':'').' '.$track->my->trackTitle)) %><?php
                $this->renderPartial('fragment_thumb_tracks', 'log', array('tracks' => array($track)));
            } else if ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_FACT_TOP_TOPIC) {
                $topic = XG_Cache::content($contentIds[0]);
                if ($topic->my->groupId) {
                    $link = xnhtmlentities('http://' . $_SERVER['HTTP_HOST'] . '/group/' . Group::idToUrl($topic->my->groupId) . '/forum/topic/show?id=' . $topic->id);
                } else {
                    $link = xnhtmlentities((W_Cache::getWidget('forum')->buildUrl('topic', 'show', array('id' => $topic->id))));
                }
                ?>
                <%= xg_html('X_IS_THE_MOST_POPULAR_TOPIC', '<a href="'.$link.'">'.xg_excerpt($topic->title,$titleMaxLength).'</a>') %><?php
            } else if ($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_FACT_TOP_BLOGPOST) {
                $blogPost = XG_Cache::content($contentIds[0]); ?>
                <%= xg_html('X_IS_THE_MOST_POPULAR_BLOG_POST', '<a href="'.xnhtmlentities((W_Cache::getWidget('profiles')->buildUrl('blog', 'show', array('id' => $blogPost->id)))).'">'.xg_excerpt($blogPost->title?$blogPost->title:BlogPost::getTextTitle($blogPost),$titleMaxLength).'</a>') %><?php
            }
        }
    }

    //network facts and messages
    if($item->my->category == XG_ActivityHelper::CATEGORY_GADGET){
        $item->my->link = $item->my->link;
        $item->title    = $item->title;
        //@TODO find a proper javascript: links remover and use it instead of str_replace
        if($item->my->subcategory == XG_ActivityHelper::SUBCATEGORY_MESSAGE) { ?>
            <h5><%= xnhtmlentities(xg_excerpt($item->title,140)) %></h5>
            <a href="<%=xnhtmlentities(xg_scrub(str_replace('javascript','',$item->my->link))) %>"><%= xnhtmlentities(xg_excerpt($item->description,140)) %></a><?php
        }
    }

    if ($fmt=='html') {?>
    <span class="time"><%= xg_elapsed_time($item->createdDate) %></span> <?php
        } ?>
            </div>
    <?php
    $output = ob_get_contents();
    ob_end_clean();
    echo $output;
} catch (Exception $e) {
    ob_end_clean();
    if ($_GET['test_show_bad_activity_log_item_ids']) { echo 'Bad: ' . $item->id; }
    // Don't expose this error to the user (BAZ-4209) [Jon Aquino 2007-08-29]
}
