<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/widgets/index/controllers/SearchController.php');
XG_App::includeFileOnce('/widgets/profiles/controllers/BulkController.php');

class Syntax3Test extends UnitTestCase {

    private static function contentTypes() {
        $contentTypes = array();
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== FALSE) { continue; }
            $pattern = "/Content::create\('(.*?)'/i";
            $contents = file_get_contents($file);
            if (preg_match($pattern, $contents)) {
                foreach (explode("\n", $contents) as $line) {
                    if (preg_match($pattern, $line, $matches)) {
                        $contentTypes[$matches[1]] = $matches[1];
                    }
                }
            }
        }
        return $contentTypes;
    }

    public function testAllContentTypesHaveSearchHandlers() {
        // Skip types that have already been noted in BAZ-492 [Jon Aquino 2007-02-01]
        foreach (array_diff(self::contentTypes(), TestSearchController::getTypesToExclude()) as $contentType) {
            foreach(XG_TestHelper::globr(NF_APP_BASE . '/widgets', 'IndexController.php') as $indexFile) {
                $searchHandlerFound = FALSE;
                if (preg_match("/action_detail.*'${contentType}'/s", file_get_contents($indexFile))) {
                    $searchHandlerFound = TRUE;
                    break;
                }
            }
            // These content types have been noted in BAZ-3208  [Jon Aquino 2007-06-20]
            if (in_array($contentType, array('AudioAttachment', 'ImageAttachment', 'Playlist', 'Track'))) { continue; }
            $this->assertTrue($searchHandlerFound, 'No search handler found for content type ' . $contentType);
        }
    }

    public function testTypesToExcludeFromRemovalByUser() {
        $typesToInclude = array('Note', 'Event', 'EventCalendar', 'EventWidget', 'ContactList', 'ActivityLogItem', 'ImageAttachment', 'UploadedFile', 'Topic', 'TopicCommenterLink', 'GroupInvitationRequest', 'GroupMembership', 'Comment', 'InvitationRequest', 'AudioAttachment', 'Playlist', 'Track', 'Page', 'Album', 'Photo', 'BlogPost', 'Video', 'VideoAttachment', 'VideoPreviewFrame');
        foreach (array_diff(self::contentTypes(), TestBulkController::getTypesToExcludeFromRemovalByUser(), $typesToInclude) as $contentType) {
            $this->assertTrue(false, 'New content type detected: ' . $contentType . '. Add it to $typesToExcludeFromRemovalByUser?');
        }
    }

    public function testBaz1997() {
        $this->assertEqual(
                trim(preg_replace('@//.*@', '', file_get_contents($_SERVER['DOCUMENT_ROOT'] . '/xn_resources/widgets/index/js/bulk.js'))),
                trim(preg_replace('@//.*@', '', file_get_contents($_SERVER['DOCUMENT_ROOT'] . '/xn_resources/widgets/index/js/BulkActionLink.js'))));
    }

    public function testInPlaceEditorValueSpecified() {
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== FALSE) { continue; }
            $contents = file_get_contents($file);
            if (strpos($contents, '"InPlaceEditor"') !== false && strpos($contents, '_html="true"') !== false) {
                $this->assertTrue(strpos($contents, '_getValueUrl=') !== false || strpos($contents, '_value=') !== false, $file);
            }
        }
    }

    public function testPagesWithFeedLinksHaveFeedAutodiscoveryLinks() {
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== FALSE) { continue; }
            $pattern = '@class=.[^"\']*rss@';
            $contents = str_replace("\n", ' ', preg_replace('@//.*@', ' ', file_get_contents($file)));
            $contents = preg_replace('@<!--.*?-->@', '', file_get_contents($file));
            if (preg_match($pattern, $contents)) {
                $this->assertTrue(preg_match('@xg_autodiscovery_link|outputFeedAutoDiscoveryLink@u', $contents), $file . ' *****');
            }
        }
    }

    public function testUnusedPartials() {
        $names = array();
        foreach(XG_TestHelper::globr(NF_APP_BASE, 'fragment_*.php') as $file) {
            $name = str_replace('.php', '', basename($file));
            $names[$name] = $name;
        }
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            $contents = file_get_contents($file);
            foreach ($names as $name) {
                if (strpos($contents, $name) !== FALSE) { unset($names[$name]); }
            }
        }
        $this->assertEqual(0, count($names), 'Unused partials: ' . implode(', ', $names));
    }

    public function testPopupZIndexFixInstalled() {
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.js') as $file) {
            $this->assertTrue(strpos($contents, 'xg_module_options') === FALSE || strpos($contents, 'fixPopupZIndexAfterShow') !== FALSE, $file);
            $this->assertTrue(! preg_match('/class=.[^\'"]*dialog/', $contents) || strpos($contents, 'fixPopupZIndexAfterShow') !== FALSE || strpos($contents, 'xg.index.actionicons.ActionButton') !== FALSE, $file);
        }
    }

}

class TestSearchController extends Index_SearchController {
    public static function getTypesToExclude() { return self::$typesToExclude; }
}

class TestBulkController extends Profiles_BulkController {
    public static function getTypesToExcludeFromRemovalByUser() { return self::$typesToExcludeFromRemovalByUser; }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
