<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';

class Syntax17Test extends UnitTestCase {

    public function testRemoveProbableScreenName() {
        // Martin says probableScreenName() should no longer be used [Jon Aquino 2007-09-21]
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            $contents = file_get_contents($file);
            if (strpos($contents, 'probableScreenName') === false) { continue; }
            $previousLine = '';
            $i = 0;
            foreach (explode("\n", $contents) as $line) {
                $i++;
                $this->assertTrue(strpos($line, 'probableScreenName') === false , $line . ' - ' . $file . ' line ' . $i);
                $previousLine = $line;
            }
        }
    }

    public function testNoIncludeOrRequire() {
        // See "include/require'ing PHP files in Bazel", http://clearspace.ninginc.com/clearspace/docs/DOC-1417  [Jon Aquino 2008-01-22]
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            if (strpos($file, '/error.php') !== false) { continue; }
            if (strpos($file, '/index.php') !== false) { continue; }
            if (strpos($file, '/lib/scripts/') !== false) { continue; }
            if (strpos($file, '/lib/bots/') !== false) { continue; }
            if (strpos($file, '/ext/facebook/facebook.php') !== false) { continue; }
            $contents = file_get_contents($file);
            preg_match_all('@^\s*(require|include).*@m', $contents, $matches);
            foreach ($matches[0] as $match) {
                if (strpos($match, 'need to preserve scope') !== false) { continue; }
                $this->fail($file . ' - ' . $match);
            }
        }
    }

    public function testProfileSetLoadAccompaniedByExistenceCheck() {
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $filename) {
            if (strpos($filename, '/test') !== false) { continue; }
            $contents = file_get_contents($filename);
            if (strpos($contents, 'XN_ProfileSet::load(') === false) { continue; }
            $lineNumber = 0;
            $previousLine = '';
            foreach (explode("\n", $contents) as $line) {
                $lineNumber++;
                $surroundingLines = $previousLine . ' ' . $line;
                if (! preg_match('@^\*@u', trim($line))
                        && strpos($surroundingLines, '$set = XN_ProfileSet::load($setName);') === false
                        && strpos($previousLine, 'return XN_ProfileSet::load(self::profileSetId($group->id));') === false
                        && strpos($previousLine, 'echo "$setName') === false
                        && strpos($line, '// Build the message we\'re going to send') === false
                        && strpos($previousLine, 'XN_ProfileSet::load(') !== false) {
                    $this->assertTrue(preg_match('@\bif\b@u', $surroundingLines), 'Should check that XN_ProfileSet::load() exists: ' . $surroundingLines . ' *** Line ' . $lineNumber . ', ' . $filename);
                }
                $previousLine = $line;
            }
        }
    }

    public function testUseConstantForMembersAlias() {
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $filename) {
            if (strpos($filename, '/test') !== false) { continue; }
            $contents = file_get_contents($filename);
            if (strpos($contents, 'XN_ProfileSet::') === false) { continue; }
            $lineNumber = 0;
            foreach (explode("\n", $contents) as $line) {
                $lineNumber++;
                if ((strpos($line, 'XN_ProfileSet::') !== false) &&
                    (strpos($line, 'members') !== false)) {
                       $this->fail("Use XN_ProfileSet::USERS: $line **** Line $lineNumber, $filename");
                    }
            }
        }
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
