<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/widgets/index/lib/helpers/Index_ProfileInfoFormHelper.php');

class Index_ProfileInfoFormHelperTest extends UnitTestCase {

    public function testRead() {
        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $user = XN_Content::create('User');
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $this->assertNull($values['fullName']);
        $this->assertNull($values['birthdateYear']);
        $this->assertNull($values['birthdateMonth']);
        $this->assertNull($values['birthdateDay']);
        $profile->birthdate = '';
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $this->assertNull($values['fullName']);
        $this->assertNull($values['birthdateYear']);
        $this->assertNull($values['birthdateMonth']);
        $this->assertNull($values['birthdateDay']);
        $profile->birthdate = '1977-02-15';
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $this->assertNull($values['fullName']);
        $this->assertEqual(1977, $values['birthdateYear']);
        $this->assertEqual(2, $values['birthdateMonth']);
        $this->assertEqual(15, $values['birthdateDay']);
        $profile->birthdate = '1977-01-32';
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $this->assertNull($values['fullName']);
        $this->assertEqual(1977, $values['birthdateYear']);
        $this->assertEqual(1, $values['birthdateMonth']);
        $this->assertEqual(32, $values['birthdateDay']);
        $this->assertEqual('x', $values['gender']);
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $profile->gender = 'm';
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $this->assertEqual('m', $values['gender']);
        $profile->gender = 'f';
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $this->assertEqual('f', $values['gender']);
        $profile->gender = '';
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $this->assertNull($values['fullName']);
        $this->assertEqual('x', $values['gender']);
        $this->assertNull($values['location']);
        $this->assertNull($values['country']);
        $profile->location = 'Victoria';
        $profile->country = 'AU';
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $this->assertEqual('Victoria', $values['location']);
        $this->assertEqual('AU', $values['country']);
        $profile->fullName = 'Boswell';
        $values = Index_ProfileInfoFormHelper::read($profile, $user);
        $this->assertEqual('Boswell', $values['fullName']);
    }

    public function testWrite() {
        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $user = XN_Content::create('User');
        $_POST = array();
        Index_ProfileInfoFormHelper::write($profile, $user, true);
        $this->assertEqual(null, $profile->fullName);
        $this->assertEqual(null, $profile->gender);
        $this->assertEqual(null, $profile->birthdate);
        $this->assertEqual(null, $profile->location);
        $this->assertEqual(null, $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $_POST = array('fullName' => 'Sue', 'gender' => 'f', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'location' => 'Victoria', 'country' => 'CA');
        Index_ProfileInfoFormHelper::write($profile, $user, true);
        $this->assertEqual('Sue', $profile->fullName);
        $this->assertEqual('f', $profile->gender);
        $this->assertEqual(null, $profile->birthdate);
        $this->assertEqual('Victoria', $profile->location);
        $this->assertEqual('CA', $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $_POST = array('fullName' => 'Sue', 'gender' => 'f', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '2', 'birthdateDay' => '15', 'location' => 'Victoria', 'country' => 'CA');
        Index_ProfileInfoFormHelper::write($profile, $user, true);
        $this->assertEqual('Sue', $profile->fullName);
        $this->assertEqual('f', $profile->gender);
        $this->assertEqual('1977-02-15', $profile->birthdate);
        $this->assertEqual('Victoria', $profile->location);
        $this->assertEqual('CA', $profile->country);

        $_POST = array('aboutQuestionsShown' => 'Y');
        Index_ProfileInfoFormHelper::write($profile, $user, true);
        $this->assertEqual('Sue', $profile->fullName);
        $this->assertEqual('f', $profile->gender);
        $this->assertEqual('1977-02-15', $profile->birthdate);
        $this->assertEqual('Victoria', $profile->location);
        $this->assertEqual('CA', $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $_POST = array('fullName' => 'Sue', 'gender' => 'f', 'birthdateYear' => '1977', 'location' => 'Victoria', 'country' => 'CA');
        Index_ProfileInfoFormHelper::write($profile, $user, true);
        $this->assertEqual('Sue', $profile->fullName);
        $this->assertEqual(null, $profile->gender);
        $this->assertEqual(null, $profile->birthdate);
        $this->assertEqual(null, $profile->location);
        $this->assertEqual(null, $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $_POST = array('fullName' => 'Jason', 'gender' => 'm', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '2', 'birthdateDay' => '15');
        Index_ProfileInfoFormHelper::write($profile, $user, true);
        $this->assertEqual('Jason', $profile->fullName);
        $this->assertEqual('m', $profile->gender);
        $this->assertEqual('1977-02-15', $profile->birthdate);
        $this->assertEqual(null, $profile->location);
        $this->assertEqual(null, $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $_POST = array('fullName' => 'Jason', 'gender' => 'x', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '2', 'birthdateDay' => '31');
        Index_ProfileInfoFormHelper::write($profile, $user, true);
        $this->assertEqual('Jason', $profile->fullName);
        $this->assertEqual(null, $profile->gender);
        $this->assertEqual('1977-03-03', $profile->birthdate);
        $this->assertEqual(null, $profile->location);
        $this->assertEqual(null, $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $_POST = array('fullName' => 'Jason', 'gender' => 'x', 'aboutQuestionsShown' => 'N', 'birthdateYear' => '1977', 'birthdateMonth' => '1', 'birthdateDay' => '33');
        Index_ProfileInfoFormHelper::write($profile, $user, true);
        $this->assertEqual('Jason', $profile->fullName);
        $this->assertEqual(null, $profile->gender);
        $this->assertEqual(null, $profile->birthdate);
        $this->assertEqual(null, $profile->location);
        $this->assertEqual(null, $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $_POST = array('fullName' => 'Jason', 'gender' => 'x', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '1', 'birthdateDay' => '2');
        Index_ProfileInfoFormHelper::write($profile, $user, true);
        $this->assertEqual('Jason', $profile->fullName);
        $this->assertEqual(null, $profile->gender);
        $this->assertEqual('1977-01-02', $profile->birthdate);
        $this->assertEqual(null, $profile->location);
        $this->assertEqual(null, $profile->country);
    }

    public function testWrite2() {
        // BAZ-4716 [Jon Aquino 2007-10-02]
        $user = XN_Content::create('User');

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $_POST = array('fullName' => 'Sue', 'gender' => 'f', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '2', 'birthdateDay' => '15', 'location' => 'Victoria', 'country' => 'CA');
        Index_ProfileInfoFormHelper::write($profile, $user, false);
        $this->assertEqual('Sue', $profile->fullName);
        $this->assertEqual('f', $profile->gender);
        $this->assertEqual('1977-02-15', $profile->birthdate);
        $this->assertEqual('Victoria', $profile->location);
        $this->assertEqual('CA', $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $profile->fullName = '0';
        $_POST = array('fullName' => 'Sue', 'gender' => 'f', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '2', 'birthdateDay' => '15', 'location' => 'Victoria', 'country' => 'CA');
        Index_ProfileInfoFormHelper::write($profile, $user, false);
        $this->assertEqual('0', $profile->fullName);
        $this->assertEqual('f', $profile->gender);
        $this->assertEqual('1977-02-15', $profile->birthdate);
        $this->assertEqual('Victoria', $profile->location);
        $this->assertEqual('CA', $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $profile->fullName = 'Ann';
        $profile->gender = 'x';
        $_POST = array('fullName' => 'Sue', 'gender' => 'f', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '2', 'birthdateDay' => '15', 'location' => 'Victoria', 'country' => 'CA');
        Index_ProfileInfoFormHelper::write($profile, $user, false);
        $this->assertEqual('Ann', $profile->fullName);
        $this->assertEqual('x', $profile->gender);
        $this->assertEqual('1977-02-15', $profile->birthdate);
        $this->assertEqual('Victoria', $profile->location);
        $this->assertEqual('CA', $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $profile->fullName = 'Ann';
        $profile->gender = 'x';
        $profile->birthdate = '2007-01-01';
        $_POST = array('fullName' => 'Sue', 'gender' => 'f', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '2', 'birthdateDay' => '15', 'location' => 'Victoria', 'country' => 'CA');
        Index_ProfileInfoFormHelper::write($profile, $user, false);
        $this->assertEqual('Ann', $profile->fullName);
        $this->assertEqual('x', $profile->gender);
        $this->assertEqual('2007-01-01', $profile->birthdate);
        $this->assertEqual('Victoria', $profile->location);
        $this->assertEqual('CA', $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $profile->fullName = 'Ann';
        $profile->gender = 'x';
        $profile->birthdate = '2007-01-01';
        $profile->location = 'Melbourne';
        $_POST = array('fullName' => 'Sue', 'gender' => 'f', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '2', 'birthdateDay' => '15', 'location' => 'Victoria', 'country' => 'CA');
        Index_ProfileInfoFormHelper::write($profile, $user, false);
        $this->assertEqual('Ann', $profile->fullName);
        $this->assertEqual('x', $profile->gender);
        $this->assertEqual('2007-01-01', $profile->birthdate);
        $this->assertEqual('Melbourne', $profile->location);
        $this->assertEqual('CA', $profile->country);

        $profile = XN_Profile::create('charlie@example.net', 'z3braMu55e1');
        $profile->fullName = 'Ann';
        $profile->gender = 'x';
        $profile->birthdate = '2007-01-01';
        $profile->location = 'Melbourne';
        $profile->country = 'AU';
        $_POST = array('fullName' => 'Sue', 'gender' => 'f', 'aboutQuestionsShown' => 'Y', 'birthdateYear' => '1977', 'birthdateMonth' => '2', 'birthdateDay' => '15', 'location' => 'Victoria', 'country' => 'CA');
        Index_ProfileInfoFormHelper::write($profile, $user, false);
        $this->assertEqual('Ann', $profile->fullName);
        $this->assertEqual('x', $profile->gender);
        $this->assertEqual('2007-01-01', $profile->birthdate);
        $this->assertEqual('Melbourne', $profile->location);
        $this->assertEqual('AU', $profile->country);
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
