<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/widgets/index/lib/helpers/Index_MessageHelper.php');
Mock::generate('TestRest');

class Index_MessageHelperTest extends UnitTestCase {

    private $mockRest;

    public function setUp() {
        $this->mockRest = new ExceptionMockDecorator(new MockTestRest());
    }

    public function tearDown() {
        TestRest::setInstance(null);
    }

    public function testCreateJobForAllFriends() {
        $job = Index_MessageHelper::createJobForAllFriends('Test', 'Hello world!', 246);
        $this->assertEqual(XN_Job::CREATED, $job->status);
        $this->assertEqual(3, count($job->tasks));
        $this->assertNull($job->completionCallback);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[0]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[0]->type);
        $this->assertEqual(array('begin' => 0, 'end' => 100, 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[0]->content);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[1]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[1]->type);
        $this->assertEqual(array('begin' => 100, 'end' => 200, 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[1]->content);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[2]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[2]->type);
        $this->assertEqual(array('begin' => 200, 'end' => 246, 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[2]->content);
    }

    public function testCreateJobForAllFriends2() {
        $job = Index_MessageHelper::createJobForAllFriends('Test', 'Hello world!', 200);
        $this->assertEqual(XN_Job::CREATED, $job->status);
        $this->assertEqual(2, count($job->tasks));
        $this->assertNull($job->completionCallback);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[0]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[0]->type);
        $this->assertEqual(array('begin' => 0, 'end' => 100, 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[0]->content);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[1]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[1]->type);
        $this->assertEqual(array('begin' => 100, 'end' => 200, 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[1]->content);
    }

    public function testCreateJobForScreenNames() {
        $job = Index_MessageHelper::createJobForScreenNames('Test', 'Hello world!', $this->screenNames(0, 246));
        $this->assertEqual(XN_Job::CREATED, $job->status);
        $this->assertEqual(3, count($job->tasks));
        $this->assertNull($job->completionCallback);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[0]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[0]->type);
        $this->assertEqual(array('screenNames' => $this->screenNames(0, 100), 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[0]->content);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[1]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[1]->type);
        $this->assertEqual(array('screenNames' => $this->screenNames(100, 200), 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[1]->content);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[2]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[2]->type);
        $this->assertEqual(array('screenNames' => $this->screenNames(200, 246), 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[2]->content);
    }

    public function testCreateJobForScreenNames2() {
        $job = Index_MessageHelper::createJobForScreenNames('Test', 'Hello world!', $this->screenNames(0, 200));
        $this->assertEqual(XN_Job::CREATED, $job->status);
        $this->assertEqual(2, count($job->tasks));
        $this->assertNull($job->completionCallback);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[0]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[0]->type);
        $this->assertEqual(array('screenNames' => $this->screenNames(0, 100), 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[0]->content);
        $this->assertEqual(W_Cache::getWidget('main')->buildUrl('message', 'send'), $job->tasks[1]->executionCallback);
        $this->assertEqual('application/x-www-form-urlencoded', $job->tasks[1]->type);
        $this->assertEqual(array('screenNames' => $this->screenNames(100, 200), 'subject' => 'Test', 'message' => 'Hello world!'), $job->tasks[1]->content);
    }

    private function screenNames($begin, $end) {
        $screenNames = array();
        for ($i = $begin; $i < $end; $i++) {
            $screenNames[] = 'foo' . $i;
        }
        return $screenNames;
    }

    public function testAcceptingMessagesSentToAllFriends() {
        $this->assertTrue($this->doTestAcceptingMessagesSentToAllFriends(null, null));
        $this->assertTrue($this->doTestAcceptingMessagesSentToAllFriends(null, 'Y'));
        $this->assertFalse($this->doTestAcceptingMessagesSentToAllFriends(null, 'N'));
        $this->assertTrue($this->doTestAcceptingMessagesSentToAllFriends('Y', null));
        $this->assertTrue($this->doTestAcceptingMessagesSentToAllFriends('Y', 'Y'));
        $this->assertTrue($this->doTestAcceptingMessagesSentToAllFriends('Y', 'N'));
        $this->assertFalse($this->doTestAcceptingMessagesSentToAllFriends('N', null));
        $this->assertFalse($this->doTestAcceptingMessagesSentToAllFriends('N', 'Y'));
        $this->assertFalse($this->doTestAcceptingMessagesSentToAllFriends('N', 'N'));
    }

    private function doTestAcceptingMessagesSentToAllFriends($emailAllFriendsPref, $emailNewMessagePref) {
        $user = XN_Content::create('User');
        $user->my->emailAllFriendsPref = $emailAllFriendsPref;
        $user->my->emailNewMessagePref = $emailNewMessagePref;
        return TestMessageHelper::acceptingMessagesSentToAllFriends($user);
    }

    public function testTo() {
        $this->assertEqual(XG_UserHelper::getFullName(XN_Profile::current()) . ' <' . XN_Profile::current()->screenName . '>',
                TestMessageHelper::to(XN_Profile::current()->screenName));
    }

}

class TestMessageHelper extends Index_MessageHelper {
    public static function acceptingMessagesSentToAllFriends($user) {
        return parent::acceptingMessagesSentToAllFriends($user);
    }
    public static function to($screenName) {
        return parent::to($screenName);
    }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
