<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/widgets/index/lib/helpers/Index_MessageCatalogWriter.php');
XG_App::includeFileOnce('/widgets/index/lib/helpers/Index_LanguageHelper.php');

class Index_MessageCatalogWriterTest extends UnitTestCase {

    public function testWrite1() {
        $writer = new Index_MessageCatalogWriter();
        list($php, $javaScript) = $writer->write('fr_CA', array(
            'xg.shared.nls.uploadAPhotoEllipsis' => ' Hey, upload a Photo… ',
            'xg.shared.nls.youHaventRated' => ' Hey, you haven\'t rated this item yet. ',
            'xg.shared.nls.yourRatedThis' => " function(n) {
        return 'Hey, you\'ve rated this item with ' + n + ' stars.';  // A comment
    } ",
            'xg.groups.nls.pleaseChooseAName' => ' Hey, please choose a name
for your group. ',
        ));
        $expectedJavaScript = '
dojo.provide(\'xg.custom.shared.messagecatalogs.fr_CA\');

dojo.require(\'xg.index.i18n\');

/**
 * Texts for the fr_CA locale. This file was generated by the Manage > Language page.
 */
// Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;  [Jon Aquino 2007-01-10]


dojo.evalObjPath(\'xg.shared.nls\', true);
dojo.lang.mixin(xg.shared.nls, xg.index.i18n, {
    uploadAPhotoEllipsis: \'Hey, upload a Photo…\',
    youHaventRated: \'Hey, you haven\\\'t rated this item yet.\',
    yourRatedThis: function(n) {
        return \'Hey, you\\\'ve rated this item with \' + n + \' stars.\';  // A comment
    }
});


dojo.evalObjPath(\'xg.groups.nls\', true);
dojo.lang.mixin(xg.groups.nls, xg.index.i18n, {
    pleaseChooseAName: \'Hey, please choose a name for your group.\'
});';
        $expectedPhp = '
<?php

XG_App::includeFileOnce(\'/lib/XG_MessageCatalog_fr_CA.php\');

/**
 * Texts for the fr_CA locale. This file was generated by the Manage > Language page.
 */
class XG_CustomMessageCatalog_fr_CA extends XG_MessageCatalog_fr_CA {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., \'ADD_A_PHOTO\'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];

        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array(\'sprintf\', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}';
        $this->assertEqual($this->normalize($expectedPhp), $this->normalize($php));
        $this->assertEqual($this->normalize($expectedJavaScript), $this->normalize($javaScript));
    }

    public function testWrite2() {
        $writer = new Index_MessageCatalogWriter();
        list($php, $javaScript) = $writer->write('fr_CA', array(
            'I_AM_MEMBER' => ' Hey, I\'m a member of: ',
            'X_SAID' => '%s said…',
        ));
        $expectedJavaScript = '
dojo.provide(\'xg.custom.shared.messagecatalogs.fr_CA\');

dojo.require(\'xg.index.i18n\');

/**
 * Texts for the fr_CA locale. This file was generated by the Manage > Language page.
 */
// Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;  [Jon Aquino 2007-01-10]';
        $expectedPhp = '
<?php

XG_App::includeFileOnce(\'/lib/XG_MessageCatalog_fr_CA.php\');

/**
 * Texts for the fr_CA locale. This file was generated by the Manage > Language page.
 */
class XG_CustomMessageCatalog_fr_CA extends XG_MessageCatalog_fr_CA {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., \'ADD_A_PHOTO\'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];

        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array(\'sprintf\', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        \'I_AM_MEMBER\' => \'Hey, I\\\'m a member of:\',
        \'X_SAID\' => \'%s said…\',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}';
        $this->assertEqual($this->normalize($expectedPhp), $this->normalize($php));
        $this->assertEqual($this->normalize($expectedJavaScript), $this->normalize($javaScript));
    }

    public function testWrite3() {
        $writer = new Index_MessageCatalogWriter();
        list($php, $javaScript) = $writer->write('fr_CA', array(
            'I_AM_MEMBER' => ' Hey, I\'m a member of: ',
            'X_SAID' => '%s said…',
                    'ABC' => 'a
  b
  c',
            'xg.shared.nls.uploadAPhotoEllipsis' => ' Hey, upload a Photo… ',
            'xg.shared.nls.youHaventRated' => ' Hey, you haven\'t rated this item yet. ',
            'xg.shared.nls.yourRatedThis' => " function(n) {
        return 'Hey, you\'ve rated this item with ' + n + ' stars.';  // A comment
    } ",
            'xg.groups.nls.pleaseChooseAName' => ' Hey, please choose a name for your group. ',
            Index_LanguageHelper::SPECIAL_RULES_KEY => '// Music widget
        if ($s == \'N_TRACKS_REMOVED_FROM_PLAYLIST\') {
            if ($args[1] == 1) {
                return $args[1].\' song from this playlist can\\\'t be displayed because it has been deleted or is no longer shared.\';
            } elseif ($args[1] > 1) {
                return $args[1].\' songs from this playlist can\\\'t be displayed because they have been deleted or are no longer shared.\';
            }
        }',
            Index_LanguageHelper::TAB_NAMES_KEY => '      if ($widgetTitle == \'Blog\') { return \'Blog\'; }
        if ($widgetTitle == \'RSS\') { return \'RSS\'; }
        if ($widgetTitle == \'Forum\') { return \'Forum\'; }
        if ($widgetTitle == \'Videos\') { return \'Videos\'; }
        if ($widgetTitle == \'Photos\') { return \'Photos\'; }
        if ($widgetTitle == \'Text Box\') { return \'Text Box\'; }
        if ($widgetTitle == \'Groups\') { return \'Groups\'; }
        if ($widgetTitle == \'Music\') { return \'Music\'; }',
        ));
        $expectedJavaScript = '
dojo.provide(\'xg.custom.shared.messagecatalogs.fr_CA\');

dojo.require(\'xg.index.i18n\');

/**
 * Texts for the fr_CA locale. This file was generated by the Manage > Language page.
 */
// Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;  [Jon Aquino 2007-01-10]


dojo.evalObjPath(\'xg.shared.nls\', true);
dojo.lang.mixin(xg.shared.nls, xg.index.i18n, {
    uploadAPhotoEllipsis: \'Hey, upload a Photo…\',
    youHaventRated: \'Hey, you haven\\\'t rated this item yet.\',
    yourRatedThis: function(n) {
        return \'Hey, you\\\'ve rated this item with \' + n + \' stars.\';  // A comment
    }
});


dojo.evalObjPath(\'xg.groups.nls\', true);
dojo.lang.mixin(xg.groups.nls, xg.index.i18n, {
    pleaseChooseAName: \'Hey, please choose a name for your group.\'
});';
        $expectedPhp = '
<?php

XG_App::includeFileOnce(\'/lib/XG_MessageCatalog_fr_CA.php\');

/**
 * Texts for the fr_CA locale. This file was generated by the Manage > Language page.
 */
class XG_CustomMessageCatalog_fr_CA extends XG_MessageCatalog_fr_CA {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., \'ADD_A_PHOTO\'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        // Music widget
        if ($s == \'N_TRACKS_REMOVED_FROM_PLAYLIST\') {
            if ($args[1] == 1) {
                return $args[1].\' song from this playlist can\\\'t be displayed because it has been deleted or is no longer shared.\';
            } elseif ($args[1] > 1) {
                return $args[1].\' songs from this playlist can\\\'t be displayed because they have been deleted or are no longer shared.\';
            }
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array(\'sprintf\', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        \'I_AM_MEMBER\' => \' Hey, I\\\'m a member of: \',
        \'X_SAID\' => \'%s said…\',
        \'ABC\' => \'a
  b
  c\',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {
        if ($widgetTitle == \'Blog\') { return \'Blog\'; }
        if ($widgetTitle == \'RSS\') { return \'RSS\'; }
        if ($widgetTitle == \'Forum\') { return \'Forum\'; }
        if ($widgetTitle == \'Videos\') { return \'Videos\'; }
        if ($widgetTitle == \'Photos\') { return \'Photos\'; }
        if ($widgetTitle == \'Text Box\') { return \'Text Box\'; }
        if ($widgetTitle == \'Groups\') { return \'Groups\'; }
        if ($widgetTitle == \'Music\') { return \'Music\'; }
        return $widgetTitle;
    }

}';
        $this->assertEqual($this->normalize($expectedPhp), $this->normalize($php));
        $this->assertEqual($this->normalize($expectedJavaScript), $this->normalize($javaScript));
    }

    private function normalize($s) {
        return trim(preg_replace('@\s@', '', $s));
    }

    public function testAddSlashes() {
        $writer = new TestMessageCatalogWriter();
        $this->assertEqual('foo', $writer->addSlashes('foo'));
        $this->assertEqual('\\\'hello\\\' "world" 1\\\\2', $writer->addSlashes('\'hello\' "world" 1\\2'));
    }

}

class TestMessageCatalogWriter extends Index_MessageCatalogWriter {
    public function addSlashes($s) { return parent::addSlashes($s); }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
