<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/widgets/index/lib/helpers/Index_AppearanceHelper.php');

class Index_AppearanceHelperTest extends UnitTestCase {

    protected static $baseSubstitutions =  array('textFont' => '"Helvetica Neue", Arial, Helvetica, sans-serif', 'moduleBodyTextColor' => 'DDDDDD',
        'siteLinkColor' => 'FF4A12', 'siteBgColor' => '8BCFF2', 'siteBgImage' => null, 'siteBgImage_repeat' => 'repeat', 'pageHeaderTextColor' => 'FFFFFF',
        'headBgColor' => '3E4F4F', 'headBgImage' => null, 'headBgImage_repeat' => 'no-repeat', 'pageBgColor' => '222D2D', 'pageBgImage' => null,
        'pageBgImage_repeat' => 'repeat', 'ningbarColor' => 'FFFFFF', 'ningLogoDisplay' => 'none!important',  'customCss' => null);

    public function testCssify() {
        $this->assertEqual('#ffffff;', Index_AppearanceHelper::cssify('moduleBgColor', 'ffffff'));
        $this->assertEqual('#FFFFFF;', Index_AppearanceHelper::cssify('moduleBgColor', 'FFFFFF'));
        $this->assertEqual('#fa0;', Index_AppearanceHelper::cssify('moduleBgColor', 'fa0'));
        $this->assertEqual('url(http://ning.com/foo.png);', Index_AppearanceHelper::cssify('moduleBgImage', 'http://ning.com/foo.png'));
        $this->assertEqual('no-repeat;', Index_AppearanceHelper::cssify('moduleBgImage_repeat', null));
        $this->assertEqual('no-repeat;', Index_AppearanceHelper::cssify('moduleBgImage_repeat', 'no-repeat'));
        $this->assertEqual('repeat;', Index_AppearanceHelper::cssify('moduleBgImage_repeat', 'repeat'));
    }

    public function testMigrationRequired() {
        $this->assertTrue(Index_AppearanceHelper::migrationRequired(array('headTabColor' => 'CCCCCC')));
        $this->assertFalse(Index_AppearanceHelper::migrationRequired(array('pageBgColor' => 'CCCCCC')));
        $this->assertFalse(Index_AppearanceHelper::migrationRequired(array()));
        $this->assertFalse(Index_AppearanceHelper::migrationRequired(self::$baseSubstitutions));
        $this->assertTrue(Index_AppearanceHelper::migrationRequired(array_merge(self::$baseSubstitutions, array('headTabColor' => 'CCCCCC'))));
    }
    
    public function testAbsolutifyCssResourceUrls() {
        $this->assertEqual("background: url(http://{$_SERVER['HTTP_HOST']}/hello.png)", 
            Index_AppearanceHelper::absolutifyCssResourceUrls("background: url(/hello.png)"));
        $this->assertEqual("background: url(http://{$_SERVER['HTTP_HOST']}/foo/bar/baz/hello.png)", 
            Index_AppearanceHelper::absolutifyCssResourceUrls("background: url(/foo/bar/baz/hello.png)"));
        $this->assertEqual('background: url(hello.png)', Index_AppearanceHelper::absolutifyCssResourceUrls("background: url(hello.png)"));
    }

    public function testGetMigrationCss() {
        $substitutions = array_merge(self::$baseSubstitutions, array('pageTitleColor' => 'CCCCCC', 'headTabColor' => 'FF0000'));
        $expected = '/* Page Title */
#xg_body h1,
#xg_body ul.navigation a,
#xg_navigation ul li.this a,
#xg_navigation ul li a:hover {
    color:/* %pageTitleColor% */ #CCCCCC;
}
/* Tab Color */
#xg_navigation ul li a {
    background-color:/* %headTabColor% */ #FF0000;
}
/* Module Body: Background & Text */
.xg_module_body,
.xg_module_body legend,
.xg_module_body legend.toggle a,
.xg_module_foot,
ul.page_tabs li.this {
    background-color:/* %moduleBodyBgColor% */ #720000;
    background-image:/* %moduleBgImage% */ none;
    background-repeat:/* %moduleBgImage_repeat% */ no-repeat;
}
/* Module Body: Headings */
.xg_module_body h3,
.xg_module_body caption {
    color:/* %moduleHeadingColor% */ #EEE7AA;
}';
        $actual = Index_AppearanceHelper::getMigrationCss($substitutions);
        $this->assertEqual(preg_replace('@\s+@', ' ', $expected), preg_replace('@\s+@', ' ', $actual));
    }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
