<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/lib/XG_MessageCatalog_en_US.php');

class I18NTest extends UnitTestCase {

    public function __construct() {
        $this->allPhpFiles = XG_TestHelper::globr(NF_APP_BASE, '*.php');
        $this->enUsLines = explode("\n", file_get_contents(NF_APP_BASE . '/lib/XG_MessageCatalog_en_US.php'));
    }

    public function testUnusedJavascriptMessages() {
        foreach (XG_TestHelper::javascriptI18NKeys(XG_LanguageHelper::javaScriptCatalogPath('en_US')) as $namespace => $messages) {
            if ($namespace == 'xg.uploader.nls') { continue; }
            foreach(XG_TestHelper::globr(NF_APP_BASE . '/xn_resources/widgets' . str_replace('xg', '', str_replace('nls', '', str_replace('.' , '/', $namespace))) . 'js', '*.js') as $file) {
                $contents = file_get_contents($file);
                foreach (explode("\n", $contents) as $line) {
                    if (strpos($line, 'nls') === FALSE) { continue; }
                    foreach ($messages as $name => $message) {
                        if (strpos($line, $name) !== FALSE) { unset($messages[$name]); }
                    }
                }
            }
            if ($namespace == 'xg.shared.nls') {
                unset($messages['addTags']);
                unset($messages['editLocation']);
                unset($messages['editYourTags']);
                unset($messages['editTypes']);
            }
            $this->assertEqual(0, count($messages), 'Unused JavaScript messages in ' . $namespace . ': ' . implode(', ', array_keys($messages)));
        }
    }

    public function testMissingJavascriptMessages() {
        foreach (XG_TestHelper::javascriptI18NKeys(XG_LanguageHelper::javaScriptCatalogPath('en_US')) as $namespace => $messages) {
            foreach(XG_TestHelper::globr(NF_APP_BASE . '/xn_resources/widgets' . str_replace('xg', '', str_replace('nls', '', str_replace('.' , '/', $namespace))) . 'js', '*.js') as $file) {
                $contents = file_get_contents($file);
                foreach (explode("\n", $contents) as $line) {
                    if (strpos($line, 'nls') === FALSE) { continue; }
                    preg_match_all('/(?:nls.text|nls.html)\(.(\w+)./', $line, $matches);
                    foreach ($matches[1] as $name) {
                        if (mb_strpos($line, 'this._addKey') !== false) { continue; }
                        if (mb_strpos($line, 'this._editKey') !== false) { continue; }
                        $this->assertTrue($messages[$name], 'Missing JavaScript message "' . $name . '" in ' . $line . ', ' . $file);
                    }
                }
            }
        }
    }

    public function testDuplicatePhpMessages() {
        $messages = array();
        foreach ($this->enUsLines as $line) {
            if (preg_match("/'(.+)' *=> *'(.+)'/", $line, $matches)) {
                if ($messages[$matches[1]]) {
                    $this->assertEqual($matches[1] . ' => ' . $messages[$matches[1]], $matches[1] . ' => ' . $matches[2]);
                }
                $messages[$matches[1]] = $matches[2];
            }
        }
    }

    public function testUnusedPhpMessages() {
        $messages = array();
        foreach ($this->enUsLines as $line) {
            if (strpos($line, 'APPNAME_NOW_HAS_') !== false) { continue; }
            if (preg_match("/'(?!COUNTRY|GENDER)(.+)' *=>/", $line, $matches)) {
                $messages[$matches[1]] = $matches[1];
            }
        }
        foreach($this->allPhpFiles as $file) {
            if (strpos($file, 'XG_MessageCatalog') !== FALSE) { continue; }
            $contents = file_get_contents($file);
            foreach ($messages as $message) {
                $pos = 0;
                while (FALSE !== ($pos = strpos($contents, $message,$pos))) {
                    $p	= $contents[$pos-1];
                    $n	= $contents[$pos+strlen($message)];
                    if( ($p=='"' || $p=="'") && ($n=='"' || $n=="'") ) { unset($messages[$message]); continue 2;}
                    $pos += strlen($message);
                }
            }
        }
        $this->assertEqual(0, count($messages), 'Unused PHP messages: ' . implode(', ', $messages));
    }

    public function testMissingPhpMessages() {
        $messages = array();
        $files = array();
        foreach($this->allPhpFiles as $file) {
            if (strpos($file, '/test') !== false) { continue; }
            $contents = file_get_contents($file);
            preg_match_all('/(?:xg_xml|xg_html|xg_text)\(["\'](\w+)./', $contents, $matches);
            foreach ($matches[1] as $message) {
                if (strpos($message, 'APPNAME_NOW_HAS_') !== false) { continue; }
                $messages[$message] = $message;
                $files[$message][] = mb_substr($file, mb_strlen($_SERVER['DOCUMENT_ROOT']));
            }
        }
        $contents = file_get_contents(NF_APP_BASE . '/lib/XG_MessageCatalog_en_US.php');
        foreach ($messages as $message) {
            if (mb_strpos($contents, "'$message'") !== false) {
                unset($messages[$message]);
            }
        }
        unset($messages['COUNTRY_']);
        foreach ($messages as $message) {
            $this->fail("Missing: $message (used in " . implode(', ', $files[$message]));
        }
    }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
