<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';

/**
 * Tests JavaScript dependencies
 */
class Dependency3Test extends UnitTestCase {

    public function setUp() {
        list($this->fileToRequires, $this->requireToFiles, $this->fileToProvides, $this->provideToFiles) = XG_TestHelper::buildDependencyGraph();
    }

    public function testJsFilesMissingRequires() {
        foreach (XG_TestHelper::globr(NF_APP_BASE, '*.js') as $file) {
            if (strpos($file, 'messagecatalogs') !== false) { continue; }
            $contents = str_replace(".' + xg.global.locale", "'", file_get_contents($file));
            $contents = str_replace("a call to xg.shared.util", "", $contents);
            $contents = str_replace('based on xg.shared.PostLink', '', $contents);
            $contents = preg_replace('@//.*@ui', '', $contents);
            foreach (array_keys($this->provideToFiles) as $moduleName) {
                if (strpos($moduleName, '.nls') !== FALSE) { continue; }
                if ($moduleName == 'xg.profiles.blog.show' && basename($file) == 'chatterwall.js') { continue; }
                if ($moduleName == 'xg.video' && basename($file) == 'player.js') { continue; }
                if ($moduleName == 'xg.index.BulkActionLink' && strpos($contents, 'xg.index.bulk') !== FALSE) { continue; }
                $this->assertFalse(preg_match('/(?<!require|provide)..' . str_replace('.', '\.', $moduleName) . '/', $contents) && ! preg_match('/(require|provide)..' . $moduleName . '/', $contents),
                        "dojo.require('" . $moduleName . "'); missing in " . $file);
            }
        }
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
