<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';

/**
 * Tests JavaScript dependencies for the other half of the JavaScript files.
 * Split into two tests to avoid timeout.
 */
class Dependency2bTest extends UnitTestCase {

    public function setUp() {
        list($this->fileToRequires, $this->requireToFiles, $this->fileToProvides, $this->provideToFiles) = XG_TestHelper::buildDependencyGraph();
    }

    public function testUnnecessaryRequires() {
        $files = XG_TestHelper::globr(NF_APP_BASE, '*.js');
        $n = round(count($files)/2);
        foreach (array_slice($files, $n) as $file) {
            if (strpos($file, 'js/actionicons/')) { continue; } // Workaround for BAZ-1997 [Jon Aquino 2007-02-27]
            $contents = str_replace(".' + xg.global.locale", "'", file_get_contents($file));
            foreach (array_keys($this->provideToFiles) as $moduleName) {
                preg_match('/[^.]+$/', $moduleName, $matches);
                $moduleNameLastPart = $matches[0];
                if ($moduleName == 'xg.index.InviteCustomizer') { continue; }
                if ($moduleName == 'xg.music.playlist.edit' && strpos($file, 'RemoveTrackLink.js') !== false) { continue; }
                if ($moduleName == 'xg.shared.SimpleToolbar' && preg_match('/createWidget..SimpleToolbar/', $contents)) { continue; }
                if ($moduleName == 'xg.shared.FriendLink' && preg_match('/createWidget..FriendLink/', $contents)) { continue; }
                if ($moduleName == 'xg.shared.SendMessageLink' && preg_match('/dojoType="SendMessageLink"/', $contents)) { continue; }
                $this->assertFalse(!preg_match('/(?<!require|provide)..' . str_replace('.', '\.', $moduleName) . '/', $contents) && !preg_match('/getWidgetsByType..' . $moduleNameLastPart . '/', $contents) && preg_match('/require..' . $moduleName . "'/", $contents),
                        'Unnecessary require in ' . $file . ': ' . $moduleName);
            }
        }
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
