<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/lib/XG_SecurityHelper.php');
Mock::generate('stdClass', 'MockW_Widget', array('saveConfig'));

class XG_SecurityHelperTest extends UnitTestCase {

    public function testGetAdministrators() {
        $ownerCount = 0;
        foreach (XG_SecurityHelper::getAdministrators() as $user) {
            if ($user->title == XN_Application::load()->ownerName) { $ownerCount++; }
        }
        $this->assertEqual(1, $ownerCount);
    }

    public function testGetAdministratorsBesidesOwner() {
        $ownerCount = 0;
        foreach (XG_SecurityHelper::getAdministratorsBesidesOwner() as $user) {
            if ($user->title == XN_Application::load()->ownerName) { $ownerCount++; }
        }
        $this->assertEqual(0, $ownerCount);
    }

    public function testCheckCsrfTokenProper() {
        $this->assertTrue(TestSecurityHelper::checkCsrfTokenProper('a1', strtotime('2008-04-22T18:20:47+00:00'), array('2008-04-22T18:20:47+00:00' => 'a1')));
        $this->assertTrue(TestSecurityHelper::checkCsrfTokenProper('b1', strtotime('2008-04-22T18:20:47+00:00'), array('2008-04-22T18:20:47+00:00' => 'a1')));
        $this->assertTrue(TestSecurityHelper::checkCsrfTokenProper('b1', strtotime('2008-04-22T19:15:47+00:00'), array('2008-04-22T18:20:47+00:00' => 'a1')));
        $this->assertFalse(TestSecurityHelper::checkCsrfTokenProper('b1', strtotime('2008-04-22T20:20:47+00:00'), array('2008-04-22T18:20:47+00:00' => 'a1')));
        $this->assertTrue(TestSecurityHelper::checkCsrfTokenProper('a1', strtotime('2008-04-22T18:20:47+00:00'), array('2008-04-22T18:20:47+00:00' => 'a1', '2008-04-22T18:22:47+00:00' => 'a1')));
        $this->assertFalse(TestSecurityHelper::checkCsrfTokenProper('b1', strtotime('2008-04-22T18:20:47+00:00'), array('2008-04-22T18:20:47+00:00' => 'a1', '2008-04-22T18:22:47+00:00' => 'a1')));
        $this->assertFalse(TestSecurityHelper::checkCsrfTokenProper('b1', strtotime('2008-04-22T19:15:47+00:00'), array('2008-04-22T18:20:47+00:00' => 'a1', '2008-04-22T18:22:47+00:00' => 'a1')));
        $this->assertFalse(TestSecurityHelper::checkCsrfTokenProper('b1', strtotime('2008-04-22T20:20:47+00:00'), array('2008-04-22T18:20:47+00:00' => 'a1', '2008-04-22T18:22:47+00:00' => 'a1')));
    }

    public function testGetCsrfTokensProper() {
        $this->assertEqual(array(), TestSecurityHelper::getCsrfTokensProper('jane', array()));
        $this->assertEqual(array('3a18aacd193d5be8f39a443d5d0eb220', 'd5a5635c7e2cfc0d40bab54200b11620'), TestSecurityHelper::getCsrfTokensProper('jane', array('1', '2')));
    }

    public function testGetCsrfSaltsProper1() {
        $this->doTestGetCsrfSaltsProper(1, array(), array('2008-04-22T18:22:47+00:00' => 11111));
    }

    public function testGetCsrfSaltsProper2() {
        $this->doTestGetCsrfSaltsProper(0, array('2008-04-20T18:22:47+00:00' => 11111), array('2008-04-20T18:22:47+00:00' => 11111));
    }

    public function testGetCsrfSaltsProper3() {
        $this->doTestGetCsrfSaltsProper(1, array('2008-04-18T18:22:47+00:00' => 22222), array('2008-04-22T18:22:47+00:00' => 11111, '2008-04-18T18:22:47+00:00' => 22222));
    }

    public function testGetCsrfSaltsProper4() {
        $this->doTestGetCsrfSaltsProper(1, array('2008-04-18T18:22:47+00:00' => 22222, '2008-04-10T18:22:47+00:00' => 33333), array('2008-04-22T18:22:47+00:00' => 11111, '2008-04-18T18:22:47+00:00' => 22222));
    }

    private function doTestGetCsrfSaltsProper($saveConfigCount, $oldSalts, $newSalts) {
        $mainWidget = new MockW_Widget();
        $mainWidget->privateConfig = array('csrfSalts' => serialize($oldSalts));
        $mainWidget->expectCallCount('saveConfig', $saveConfigCount);
        TestSecurityHelper::getCsrfSaltsProper($mainWidget, 1208888567, 3600*24*3, 'test-' . mt_rand(), 11111);
        $this->assertEqual(serialize($newSalts), $mainWidget->privateConfig['csrfSalts']);
    }

}

class TestSecurityHelper extends XG_SecurityHelper {
    public static function getCsrfTokenProper($currentProfile) {
        return parent::getCsrfTokenProper($currentProfile);
    }
    public static function getCsrfTokensProper($screenName, $salts) {
        return parent::getCsrfTokensProper($screenName, $salts);
    }
    public static function getCsrfSaltsProper($mainWidget, $time, $maxAge, $lockId = 'generate-csrf-salts', $newSalt = null) {
        return parent::getCsrfSaltsProper($mainWidget, $time, $maxAge, $lockId, $newSalt);
    }
    public static function checkCsrfTokenProper($token, $time, $validTokens) {
        return parent::checkCsrfTokenProper($token, $time, $validTokens);
    }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
