<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/lib/XG_LayoutHelper.php');
Mock::generate('XG_Layout');

class XG_LayoutHelperTest extends UnitTestCase {

    // Delete these tests if they become too fragile [Jon Aquino 2008-02-29]

    public function testRenderHomepageLayout() {
        $this->doTestRenderLayout('index', 'homepage',
'<layout iteration="1" nextEmbedInstanceId="100">
    <colgroup locked="1">
        <column width="3">
            <colgroup>
                <column width="1">
                    <module widgetName="main" action="embed1siteDescription" embedInstanceId="' . ++$embedInstanceId . '"/>
                    <module widgetName="profiles" action="embed1activeMembers" embedInstanceId="' . ++$embedInstanceId . '"/>
                    <module widgetName="video" action="embed1" embedInstanceId="' . ++$embedInstanceId . '"/>
                </column>
                <column width="2">
                    <module widgetName="activity" action="embed2" embedInstanceId="' . ++$embedInstanceId . '"/>
                    <module widgetName="photo" action="embed2" embedInstanceId="' . ++$embedInstanceId . '"/>
                    <module widgetName="forum" action="embed2" embedInstanceId="' . ++$embedInstanceId . '"/>
                </column>
            </colgroup>
        </column>
        <column width="1" locked="1">
            <module widgetName="main" action="embed1you" fixed="1" sitewide="1" embedInstanceId="' . ++$embedInstanceId . '"/>
            <module widgetName="main" action="embed1ads" fixed="1" sitewide="1" embedInstanceId="' . ++$embedInstanceId . '"/>
            <module widgetName="main" action="embed1createdBy" fixed="1" sitewide="1" embedInstanceId="' . ++$embedInstanceId . '"/>
            <module widgetName="profiles" action="embed1badge" sitewide="1" embedInstanceId="' . ++$embedInstanceId . '"/>
        </column>
    </colgroup>
</layout>',

"<div  class='xg_colgroup first-child last-child'>
<div  class='xg_3col first-child'>
<div  class='xg_colgroup first-child last-child'>
<div  class='xg_1col first-child'>
main/index/homepage; profiles/index/homepage; video/index/homepage; &nbsp;</div><!--/xg_column-->
<div  class='xg_2col last-child'>
activity/index/homepage; photo/index/homepage; forum/index/homepage; &nbsp;</div><!--/xg_column-->
        <!-- div class='clear'></div -->
</div><!--/xg_colgroup-->
&nbsp;</div><!--/xg_column-->
<div  class='xg_1col last-child'>
main/index/homepage; main/index/homepage; main/index/homepage; profiles/index/homepage; &nbsp;</div><!--/xg_column-->
        <!-- div class='clear'></div -->
</div><!--/xg_colgroup-->");
    }

    public function testRenderProfileLayout() {
        $this->doTestRenderLayout('123:User:456', 'profiles',
'<layout nextEmbedInstanceId="100" version="5">
    <colgroup locked="1">
        <column width="3">
          <module widgetName="profiles" action="embed3pagetitle" embedInstanceId="10"><screenName>$safeName</screenName></module>
          <colgroup>
            <column width="1">
              <module widgetName="profiles" action="embed1smallbadge" embedInstanceId="0"><screenName>$safeName</screenName></module>
              <module widgetName="profiles" action="embed1friends" embedInstanceId="6"><screenName>$safeName</screenName></module>
              <module widgetName="music" action="embed1" embedInstanceId="14" />
              <module widgetName="groups" action="embed1" embedInstanceId="13" />
              <module widgetName="forum" action="embed1" embedInstanceId="11" />
              <module widgetName="feed" action="embed1" embedInstanceId="4"/>
            </column>
            <column width="2">
              <module widgetName="profiles" action="embed3welcome" embedInstanceId="12"><visible>1</visible></module>
              <module widgetName="activity" action="embed2" embedInstanceId="15"><screenName>$safeName</screenName></module>
              <module widgetName="profiles" action="embed2profileqa" embedInstanceId="3"><screenName>$safeName</screenName></module>
              <module widgetName="html" action="embed2" embedInstanceId="5" />
              <module widgetName="gadgets" action="embed2" embedInstanceId="16"/>
              <module widgetName="photo" action="embed2" embedInstanceId="1" />
              <module widgetName="video" action="embed2" embedInstanceId="2" />
              <module widgetName="profiles" action="embed2blogposts" embedInstanceId="7"><screenName>$safeName</screenName></module>
              <module widgetName="profiles" action="embed2chatterwall" embedInstanceId="8"><screenName>$safeName</screenName></module>
            </column>
          </colgroup>
        </column>
        <column width="1" locked="1">
          <module widgetName="main" action="sidebar"/>
        </column>
    </colgroup>
</layout>',

"<div  class='xg_colgroup first-child last-child'>
<div  class='xg_3col first-child'>
profiles/123:User:456/profiles; <div  class='xg_colgroup last-child'>
<div  class='xg_1col first-child'>
profiles/123:User:456/profiles; profiles/123:User:456/profiles; music/123:User:456/profiles; groups/123:User:456/profiles; forum/123:User:456/profiles; feed/123:User:456/profiles; &nbsp;</div><!--/xg_column-->
<div  class='xg_2col last-child'>
profiles/123:User:456/profiles; activity/123:User:456/profiles; profiles/123:User:456/profiles; html/123:User:456/profiles; gadgets/123:User:456/profiles; photo/123:User:456/profiles; video/123:User:456/profiles; profiles/123:User:456/profiles; profiles/123:User:456/profiles; &nbsp;</div><!--/xg_column-->
        <!-- div class='clear'></div -->
</div><!--/xg_colgroup-->
&nbsp;</div><!--/xg_column-->
<div  class='xg_1col last-child'>
main/123:User:456/profiles; &nbsp;</div><!--/xg_column-->
        <!-- div class='clear'></div -->
</div><!--/xg_colgroup-->");
    }

    public function testRenderGroupLayout() {
        //TODO: This is not a group layout it is a profiles layout? [Thomas David Baker 2008-03-18]
        $this->doTestRenderLayout('123:Group:456', 'groups',
'<layout nextEmbedInstanceId="100" version="5">
    <colgroup locked="1">
        <column width="3">
          <module widgetName="profiles" action="embed3pagetitle" embedInstanceId="10"><screenName>$safeName</screenName></module>
          <colgroup>
            <column width="1">
              <module widgetName="profiles" action="embed1smallbadge" embedInstanceId="0"><screenName>$safeName</screenName></module>
              <module widgetName="profiles" action="embed1friends" embedInstanceId="6"><screenName>$safeName</screenName></module>
              <module widgetName="music" action="embed1" embedInstanceId="14" />
              <module widgetName="groups" action="embed1" embedInstanceId="13" />
              <module widgetName="forum" action="embed1" embedInstanceId="11" />
              <module widgetName="feed" action="embed1" embedInstanceId="4"/>
            </column>
            <column width="2">
              <module widgetName="profiles" action="embed3welcome" embedInstanceId="12"><visible>1</visible></module>
              <module widgetName="activity" action="embed2" embedInstanceId="15"><screenName>$safeName</screenName></module>
              <module widgetName="profiles" action="embed2profileqa" embedInstanceId="3"><screenName>$safeName</screenName></module>
              <module widgetName="html" action="embed2" embedInstanceId="5" />
              <module widgetName="gadgets" action="embed2" embedInstanceId="16"/>
              <module widgetName="photo" action="embed2" embedInstanceId="1" />
              <module widgetName="video" action="embed2" embedInstanceId="2" />
              <module widgetName="profiles" action="embed2blogposts" embedInstanceId="7"><screenName>$safeName</screenName></module>
              <module widgetName="profiles" action="embed2chatterwall" embedInstanceId="8"><screenName>$safeName</screenName></module>
            </column>
          </colgroup>
        </column>
        <column width="1" locked="1">
          <module widgetName="main" action="sidebar"/>
        </column>
    </colgroup>
</layout>',

"<div  class='xg_colgroup first-child last-child'>
<div  class='xg_span-12 xg_column first-child'>
profiles/123:Group:456/groups; <div  class='xg_colgroup last-child'>
<div  class='xg_span-4 xg_column first-child'>
profiles/123:Group:456/groups; profiles/123:Group:456/groups; music/123:Group:456/groups; groups/123:Group:456/groups; forum/123:Group:456/groups; feed/123:Group:456/groups; &nbsp;</div><!--/xg_column-->
<div  class='xg_span-8 xg_column last-child'>
profiles/123:Group:456/groups; activity/123:Group:456/groups; profiles/123:Group:456/groups; html/123:Group:456/groups; gadgets/123:Group:456/groups; photo/123:Group:456/groups; video/123:Group:456/groups; profiles/123:Group:456/groups; profiles/123:Group:456/groups; &nbsp;</div><!--/xg_column-->
        <!-- div class='clear'></div -->
</div><!--/xg_colgroup-->
&nbsp;</div><!--/xg_column-->
<div  class='xg_span-4 xg_column last-child'>
main/123:Group:456/groups; &nbsp;</div><!--/xg_column-->
        <!-- div class='clear'></div -->
</div><!--/xg_colgroup-->");
    }

    private function doTestRenderLayout($name, $type, $xml, $expectedOutput) {
        TestLayoutHelper::setRenderModuleClass('TestLayoutHelper');
        $layout = new DOMDocument();
        $layout->loadXML(TestLayout::removeWhitespaceBetweenTags($xml));
        $xgLayout = new MockXG_Layout();
        $xgLayout->setReturnValue('getLayout', $layout);
        $xgLayout->setReturnValue('getName', $name);
        $xgLayout->setReturnValue('getType', $type);
        $controller->layout = $xgLayout->getLayout();
        $controller->layoutName = $xgLayout->getName();
        $controller->layoutType = $xgLayout->getType();
        $controller->disabledModules = array();
        ob_start();
        XG_LayoutHelper::renderLayout($xgLayout, $controller);
        $output = trim(ob_get_contents());
        ob_end_clean();
        // echo '<hr><pre>' . xnhtmlentities($output) . '</pre><hr>';
        $this->assertEqual($expectedOutput, str_replace("\t", "    ", $output));
    }

}

abstract class TestLayout extends XG_Layout {
    public static function removeWhitespaceBetweenTags($xml) {
        return parent::removeWhitespaceBetweenTags($xml);
    }
}

class TestLayoutHelper extends XG_LayoutHelper {
    public static function setRenderModuleClass($renderModuleClass) {
        parent::$renderModuleClass = $renderModuleClass;
    }
    public static function renderModule(DOMElement $element, $controller, $layoutName, $layoutType, $xgLayout) {
        echo $element->getAttribute('widgetName') . '/' . $xgLayout->getName() . '/' . $layoutType . '; ';
    }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
