<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/lib/XG_Cache.php');

class XG_Cache2Test extends UnitTestCase {

    public function testOutputCacheStart() {
        $file = $_SERVER['DOCUMENT_ROOT'] . '/xn_private/xn_volatile/cacheUnitTestFile';
        touch($file);
        $fileSystemTime = filemtime($file);
        $phpTime = time();
        if ($phpTime != $fileSystemTime) {
            $this->assertTrue(false, "PHP clock ($phpTime) does not match file-system clock ($fileSystemTime)" );
            return;
        }
        // This doesn't test concurrent long operations though.  [Jon Aquino 2007-09-04]
        $this->assertEqual('apple', $this->doTestOutputCacheStart('apple'));
        $this->assertEqual('apple', $this->doTestOutputCacheStart('pear'));
        sleep(3);
        $this->assertEqual('banana', $this->doTestOutputCacheStart('banana'));
    }

    private function doTestOutputCacheStart($outputForCacheRebuild) {
        ob_start();
        if (! XG_Cache::outputCacheStart('testOutputCacheStart', 2)) {
            echo $outputForCacheRebuild;
            XG_Cache::outputCacheEnd('testOutputCacheStart');
        }
        $output = trim(ob_get_contents());
        ob_end_clean();
        return $output;
    }

    public function testLoad() {
        // XN_Profile::load throws an exception if the profile cannot be found.
        // XG_Cache::profiles does not. [Jon Aquino 2007-09-21]
        $this->assertNotNull(XG_Cache::profiles('NingDev'));
        if (XN_Profile::current()->screenName == 'NingDev') {
            $this->assertNotNull(XG_Cache::profiles('NingDev')->email);
        }
        $this->assertNull(XG_Cache::profiles('blahblahblahfoo'));
    }

    public function testLockAndUnlock() {
        $this->assertTrue(XG_Cache::unlock('profile-address-' . md5('never-locked')));
        $this->doTestLockAndUnlock('profile-address-' . md5('any-old-thing'));
        //TODO put in a non-md5-ed id and test checking of format?
    }

    private function doTestLockAndUnlock($id) {
        $this->assertTrue(XG_Cache::lock($id, 1));
        $this->assertFalse(XG_Cache::lock($id, 1));
        sleep(2);
        $this->assertTrue(XG_Cache::lock($id, 10));
        $this->assertFalse(XG_Cache::lock($id, 1));
        $this->assertTrue(XG_Cache::unlock($id));
        $this->assertTrue(XG_Cache::lock($id, 10));
        $this->assertFalse(XG_Cache::lock($id, 1));
        $this->assertFalse(XG_Cache::lock($id, 1));
    }
}

XG_App::includeFileOnce('/test/test_footer.php');

