<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';

class XG_AppTest extends UnitTestCase {

    public function testSymlinked() {
        XG_App::symlinked();
        $this->assertTrue(true, 'No exception');
    }

    public function testCanSeeInviteLinksCalledWhenNecessaryBaz4230() {
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $filename) {
            if (strpos($filename, '/apps/devbazjon/widgets/profiles/templates/embed/embed1friends.php') !== false) { continue; }
            if (strpos($filename, '/index/templates/embed/embed2welcome.php') !== false) { continue; }
            if (strpos($filename, 'TEMP_') !== false) { continue; }
            if (strpos($filename, '/index/templates/membership/listBanned.php') !== false) { continue; }
            if (strpos($filename, '/index/templates/membership/listInvited.php') !== false) { continue; }
            if (strpos($filename, '/index/templates/membership/listMembers.php') !== false) { continue; }
            if (strpos($filename, '/index/templates/membership/listAdministrators.php') !== false) { continue; }
            if (strpos($filename, '/index/templates/membership/listRequested.php') !== false) { continue; }
            if (strpos($filename, '/index/templates/membership/listPending.php') !== false) { continue; }
            $contents = file_get_contents($filename);
            $this->assertTrue(strpos($contents, '"/invite') === false || strpos($contents, 'canSeeInviteLinks') !== false, $filename);
        }
    }

    public function testNoXnHead() {
        // Ignore test files that reference xn:head
        $filesToIgnore = array(__FILE__ => true,
                               dirname(__FILE__) . '/SectionMarkerTest.php' => true);
        foreach (XG_TestHelper::globr(NF_APP_BASE, '*.php') as $filename) {
            if (isset($filesToIgnore[$filename])) { continue; }
            $contents = file_get_contents($filename);
            $this->assertFalse(strpos($contents, 'xn:head'), "$filename contains xn:head");
            $this->assertFalse(strpos($contents, 'ning:xnhtml-head'),
                               "$filename contains ning:xnhtml-head");
        }
    }
}

class Test_XG_App extends XG_App {
    public static function setRequestedRouteForTesting($requestedRoute) {
        parent::setRequestedRouteForTesting($requestedRoute);
    }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
