<?php
/**
 * Pre-creates new shapes and new attributes, for BAZ-6553.
 * Generated by diffShapes.php
 */

try {
    $shape = XN_Shape::create('BlogArchive');
    $shape->setAttribute('my.buildStatus', 'string');
    $shape->setAttribute('my.counts', 'string');
    $shape->setAttribute('my.mozzle', 'string');
    $shape->save();
} catch(Exception $e) {
    // Shape already exists
}

$shape = XN_Shape::load('Album');
if ($shape) {
    $shape->setAttribute('my.newContentLogItem', 'string');
    $shape->setAttribute('my.xg_main_promotedOn', 'date');
    $shape->setAttribute('my.xg_photo_commentCount', 'number');
    $shape->save();
}

$shape = XN_Shape::load('AudioAttachment');
if ($shape) {
    $shape->setAttribute('my.audio', 'string');
    $shape->save();
}

$shape = XN_Shape::load('BlogPost');
if ($shape) {
    $shape->setAttribute('my.dailyViewCountsForLastMonth', 'string');
    $shape->setAttribute('my.lastViewedOn', 'date');
    $shape->setAttribute('my.popularityCount', 'number');
    $shape->setAttribute('my.viewCount', 'number');
    $shape->save();
}

$shape = XN_Shape::load('Group');
if ($shape) {
    $shape->setAttribute('my.activityScore', 'number');
    $shape->setAttribute('my.allowMemberMessaging', 'string');
    $shape->setAttribute('my.dailyActivityScoresForLastMonth', 'string');
    $shape->setAttribute('my.lastActivityOn', 'date');
    $shape->setAttribute('my.location', 'string', 'text');
    $shape->setAttribute('my.xg_groups_commentCount', 'number');
    $shape->setAttribute('my.xg_index_promotedOn', 'string');
    $shape->setAttribute('my.groupActivityId', 'string');
    $shape->save();
}

$shape = XN_Shape::load('Page');
if ($shape) {
    $shape->setAttribute('my.xg_page_commentCount', 'number');
    $shape->save();
}

$shape = XN_Shape::load('Photo');
if ($shape) {
    $shape->setAttribute('my.location', 'string', 'phrase');
    $shape->save();
}

$shape = XN_Shape::load('Video');
if ($shape) {
    $shape->setAttribute('my.duration', 'number');
    $shape->setAttribute('my.location', 'string', 'phrase');
    $shape->save();
}

echo 'Done';
