<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 *  Texts for the traditional Chinese
 */
class XG_MessageCatalog_zh_TW extends XG_AbstractMessageCatalog  {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_INVITATIONS_RESENT']['1'] = '已重新發出一封邀請信件。 ';
            $a['N_INVITATIONS_RESENT']['n'] = '已重新發出 %s 封邀請信件。 ';
            $a['N_SECONDS_AGO']['1'] = '1秒鐘以前 ';
            $a['N_SECONDS_AGO']['n'] = '%s秒鐘以前 ';
            $a['N_MINUTES_AGO']['1'] = '1分鐘以前 ';
            $a['N_MINUTES_AGO']['n'] = '%s分鐘以前 ';
            $a['N_HOURS_AGO']['1'] = '1小時以前 ';
            $a['N_HOURS_AGO']['n'] = '%s小時以前 ';
            $a['N_VIDEOS']['1'] = '<strong>1個</strong>視頻 ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong>個視頻 ';
            $a['N_VIEWS']['1'] = '1項點閱 ';
            $a['N_VIEWS']['n'] = '%s項點閱 ';
            $a['N_COMMENTS']['1'] = '<span class=" comment-count ">1</span>評論 ';
            $a['N_COMMENTS']['n'] = '<span class=" comment-count ">%s</span>評論 ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = '該視頻是<strong>1個人</strong>的<strong>最愛</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = '該視頻是<strong>人們</strong> 的<strong>%s最愛</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s已添加一個視頻: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s已添加 %s 個視頻。 ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = '您已添加一個視頻: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = '您已添加 %s個視頻. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = '有一個視頻在 %2$s上面 ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = '有 %1$s個視頻在%2$s上面 ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = '有1個<a href="%3$s">視頻</a> 在%2$s上面 ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = '有%1$s <a href="%3$s">個視頻</a> 在%2$s上面 ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '本專輯中一個照片已被刪除或不再公開，所以不能顯示。 ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '本專輯中的%s照片已被刪除或不再公開，所以不能顯示。 ';
            $a['N_PHOTOS']['1'] = '<strong>1幅</strong>照片 ';
            $a['N_PHOTOS']['n'] = '<strong>%s幅</strong>照片 ';
            $a['N_PHOTOS_2']['1'] = '1幅照片 ';
            $a['N_PHOTOS_2']['n'] = '%s幅照片 ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = '以下文件上傳時出現問題:: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = '以下多個文件上傳時出現問題: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = '該幅照片是<strong>一個人</strong> 的 <strong>最愛</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = '該幅照片是<strong>人</strong> 的 <strong>%s最愛</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>評分:</strong> %2$s ，1項投票的結果 ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>評分:</strong> %2$s， %s項投票的結果 ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s ，1項投票的結果 ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s， %s項投票的結果 ';
            $a['N_PEOPLE']['1'] = '1個人 ';
            $a['N_PEOPLE']['n'] = '%s  人 ';
            $a['N_OF_5_STARS']['1'] = '1/5星 ';
            $a['N_OF_5_STARS']['n'] = '%s/5星 ';
            $a['YOUR_RATING_X_STARS']['1'] = '您的評分: 1星 ';
            $a['YOUR_RATING_X_STARS']['n'] = '您的評分: %s星 ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s已添加一幅照片: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s已添加%s幅照片. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = '您已添加一幅照片: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = '您已添加%s幅照片。 ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = '在%2$s上面有1幅照片 ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = '在%2$s上面有%1$s幅照片 ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = '有%1$s <a href="%3$s">幅照片</a>在%2$s上面 ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = '有%1$s <a href="%3$s">幅照片</a>在 %2$s上面 ';
            $a['AND_X_OTHER_PEOPLE']['1'] = '和 1 位其他人 ';
            $a['AND_X_OTHER_PEOPLE']['n'] = '和 %s 位其他人 ';
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1項</strong>部落格評論 ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s項</strong>部落格評論 ';
            $a['N_YEARS_OLD']['1'] = '1歲 ';
            $a['N_YEARS_OLD']['n'] = '%s歲 ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1 項</strong>設定檔評論 ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s 項</strong>設定檔評論 ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = '您有1項朋友的請求！ ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = '您有%s項朋友的請求！ ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = '評論墻 (1 項評論) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = '評論牆(%s評論) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '過去一週1位新成員加入 ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '過去一週%s位新成員加入 ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '過去一週1 位<a href="%2$s">新成員 </a>加入 ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '過去一週%1$s <a href="%2$s">新成員們</a>加入 ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = '在%2$s上面有1位成員 ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = '在%2$s上面有%1$s位成員 ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = '有1 位<a href="%3$s">成員</a> 在%2$s上面 ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = '有%1$s <a href="%3$s">位成員</a> 在%2$s上面 ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = '在%2$s上面有一個部落格的貼文 ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = '在 %2$s上面有%1$s個部落格的貼文 ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1位</strong>新成員 ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s位</strong>新成員 ';
            $a['N_REPLIES']['1'] = '1項回覆 ';
            $a['N_REPLIES']['n'] = '%s項回覆 ';
            $a['N_MINUTES']['1'] = '.您還剩下1分鐘可以編輯您的評論。 ';
            $a['N_MINUTES']['n'] = '您還剩下%s分鐘可以編輯您的評論。 ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = '在 %2$s上面有1個論壇話題 ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = '在%2$s上面有%1$s個論壇話題 ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = '在%2$s上面有1個<a href="%3$s">論壇話題</a> ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = '在 %2$s上面有%1$s <a href="%3$s">個論壇話題</a> ';
            $a['N_INVITES']['1'] = '%s項邀請 ';
            $a['N_INVITES']['n'] = '%s項邀請 ';
            $a['N_MEMBERS']['1'] = '1位成員 ';
            $a['N_MEMBERS']['n'] = '%s位成員 ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1位成員) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s位成員) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = '在 %2$s上面有1個小組 ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = '在%2$s上面有%1$s個小組 ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = '在 %2$s上面有%1$s <a href="%3$s">group個小組</a> ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = '在%2$s上面有%1$s <a href="%3$s">小組</a> ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '該播放清單上的1首歌不能再播放，因為已刪除或不再共享。 ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '該播放清單上的%s首歌不能再播放，因為已刪除或不再共享。 ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = '一首新歌已添加至 %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s首新歌已添加至 %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s已添加一首歌: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s已添加 %s首歌。 ';
            $a['YOU_ADDED_X_SONGS']['1'] = '您已添加一首歌: ';
            $a['YOU_ADDED_X_SONGS']['n'] = '您已添加%s首歌。 ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1首歌已添加至本播放清單。 ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s首歌已添加至本播放清單。 ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = '在%2$s上面有1首歌 ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = '在 %2$s上面有%1$s首歌 ';
        }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => '瀏覽',
        'MORE_VIDEOS' => '更多視頻',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => '該網絡還沒有任何視頻。',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => '該網絡還沒有任何被特選的的視頻。',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => '該成員還沒有任何視頻。',
        'COPY_TO_CLIPBOARD' => '拷貝到剪貼板',
        'COPIED_TO_CLIPBOARD' => '已拷貝到剪貼板',
        'NO_VIDEOS_TO_DISPLAY' => '您現在沒有顯示任何視頻。',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => '只有當您選中至少一個視頻，其他人才能看得見該視頻框。',
        'WATERMARK_LOGO' => '水印標誌',
        'CHOOSE_HEADER_OR_WATERMARK' => '您可以為您的視頻播放器挑選一個標題或者水印標誌。',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => '標誌會顯示在你的%s上方。如果不添加標誌，網站的名稱將會顯示。 標誌必須是.jpg, .gif 或者 .png 格式。 超過20像素的標誌將會被自動調整。',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => '水印標誌顯示在視頻的右下角.',
        'HEADER_LOGO' => '標題圖標',
        'WATERMARK' => '水印',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => '制定您的視頻播放器！',
        'VIDEO_PLAYER' => '視頻播放器',
        'HEADER' => '標題',
        'SAVE_CHANGES' => '保存修改',
        'THUMBNAIL' => '縮略圖',
        'CONVERSION_FAILED' => '轉換失敗',
        'CONVERSION_IN_PROGRESS' => '正在轉換中',
        'MAP' => '地圖',
        'WHAT_IS_THIS' => '這是什麼？',
        'EDIT_VIDEO_INFORMATION' => '編輯視頻資訊',
        'ALL_VIDEOS' => '全部視頻',
        'VIDEOS_HOME' => '視頻主頁',
        'MY_VIDEOS' => '我的視訊',
        'MY_FRIENDS_VIDEOS' => '朋友視頻',
        'MY_FAVORITES' => '我的最愛',
        'XS_FAVORITES' => '%s的最愛',
        'ADD_A_VIDEO' => '添加視頻',
        'JUST_NOW' => '剛剛',
        '1_DAY_AGO' => '1 天以前',
        'M_J' => 'M j',
        'ME' => '我',
        'X_SAID' => '%s說...',
        'DELETE_COMMENT' => '刪除評論',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => '您還沒添加何視頻！',
        'ADD_VIDEOS_AND_SHARE' => '添加視頻，並和你的朋友、家人或者其他人分享！',
        'THERE_ARE_NO_VIDEOS' => '您的社交網絡還沒有視頻',
        'THIS_BOX_WILL_NOT_SHOW' => '這裡至少要有一個視頻，其他人才能看得見該視頻框。 現在就添加一個吧！',
        'ADD_VIDEOS' => '添加視頻',
        'VIEW_VIDEOS' => '觀看視頻',
        'YIKES' => '糟了﹗',
        'A_PROBLEM_SEEMS' => '發生了錯誤',
        'FOR_FURTHER_ASSISTANCE' => '如果您需要更多的協助,請<a %s>和我們聯繫</a>.',
        'OR_YOU_CAN_GO' => '您可以返回到<a %s> %s首頁</a>, 或瀏覽其它<a %s>Ning的社交網絡</a>.',
        'TAGS' => '標籤：',
        'POPULAR_TAGS' => '熱門標籤',
        'MY_FRIENDS' => '我的朋友們',
        'VIEW_ALL_MY_FRIENDS' => '瀏覽所有朋友',
        'VIEW_ALL_XS_FRIENDS' => '瀏覽%s的所有朋友',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => '抱歉 - 沒有找到您要搜索的人.',
        'VIEW_POPULAR_CONTRIBUTORS' => '瀏覽最有人氣的發貼者',
        'POPULAR_CONTRIBUTORS' => '最有人氣的發貼者',
        'VIEW_MORE_CONTRIBUTORS' => '瀏覽更多發貼者',
        'ADD_AS_FRIEND' => '加入您的朋友名單中',
        'SEND_A_MESSAGE' => '發送訊息',
        'IS_YOUR_FRIEND' => '是您的朋友',
        'IS_BLOCKED' => '被屏蔽了',
        'SORT_BY' => '按此排序：',
        'CLOSE' => '關閉',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => '還沒任何視頻, 您現在就可以加添！',
        'SEARCH_PEOPLE' => '找人',
        'INVITE_YOUR_FRIENDS_TO' => '邀請朋友到%s.',
        'INVITE' => '邀請',
        'INVITE_TAB_TEXT' => '邀請',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => '您還沒有在%裡添加任何朋友',
        'SEARCH_FRIENDS' => '搜索朋友',
        'ADD_YOUR_FIRST_VIDEO' => '添加您的第一段視頻',
        'USE_HTML_EMBED_CODE' => '使用HTML內嵌代碼',
        'UPLOAD_A_VIDEO_FROM' => '從您的電腦上傳視頻。我們接受所有常用格式！',
        'WE_SUPPORT_MOV' => '我們支援 .mov、.mpg、.avi 和 .wmv  格式的檔案。檔案必須不超過100MB。',
        'NEED_HELP_HERE_ARE' => '需要幫助嗎？這些說明是給<a %s>YouTube</a>和<a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => '添加標題和描述',
        'DESCRIPTION_COLON' => '描述：',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => '給剛上傳的視頻添加一個標題，描述和其他資訊',
        'EVERYTHING_IS_OPTIONAL' => '所有項目都是可選擇的，如果您不想加添任何東西，可以點擊右邊的「跳過該步驟」',
        'SKIP_THIS_STEP' => '跳過該步驟',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => '給該視頻添加一個標題，描述和其他資訊。',
        'CANCEL_AND_RETURN_TO_VIDEO' => '取消並回到視頻',
        'TITLE' => '標題',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => '標籤是較短的描述, 可以幫您搜索您的視頻。  請用逗號分隔多個標籤, 如果是多字標籤，可用引號 (“) 將標籤括起來，比如“ San Francisco ”',
        'WHO_CAN_VIEW_VIDEO' => '誰可觀看該視頻？',
        'MOST_POPULAR' => '最有人氣的',
        'HIGHEST_RATED' => '最高評分的',
        'MOST_RECENT' => '最新的',
        'MOST_FAVORITED' => '最受喜愛的',
        'MOST_POPULAR_VIDEOS' => '最有人氣的視頻',
        'HIGHEST_RATED_VIDEOS' => '最高評分的視頻',
        'MOST_RECENT_VIDEOS' => '最新的視頻',
        'MOST_FAVORITED_VIDEOS' => '最受喜愛的視頻',
        'ANYONE' => '任何人',
        'JUST_MY_FRIENDS' => '只有我的朋友',
        'JUST_ME' => '只有我',
        'VIEWABLE_BY_FRIENDS' => '只有<strong>朋友</strong>可觀看',
        'PRIVATE_VIDEO' => '<strong>私人</strong>視頻',
        'VIEWABLE_BY_EVERYONE' => '<strong>任何人</strong>都可以看',
        'LOCATION' => '地點:',
        'NO_LOCATION' => '無地點',
        'CLICK_ON_LOCATION' => '在地圖上按一下一個地點：',
        'FIND_AN_ADDRESS' => '找地址',
        'LOCATE' => '找出',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => '您可以<a %s>添加您自己的視頻</a>到%s！',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => '為您的網絡視頻播放器增加一個標誌或水印. <a %s>現在就開始裝置吧！</a>！',
        'APPROVE' => '批准',
        'DELETE' => '刪除',
        'APPLY_TO_VIDEOS_ADDED_BY' => '應用到所有由%s添加的視頻',
        'NO_TITLE' => '無標題',
        'ADDED_BY_STRONG_X' => '<strong>%s</strong>添加的',
        'NO_DESCRIPTION' => '無描述',
        'BY_X' => '由%s上傳的',
        'YOU_HAVE_FINISHED_MODERATING' => '您已完成協管',
        'NO_VIDEOS_AWAITING_APPROVAL' => '現在沒有視頻需要您的批准。看看最新的視頻吧﹗',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => '您的社交網絡還沒有視頻。今天就添加第一個吧！',
        'ADDED_ON_DATE_BY_X' => '%s由%s添加',
        'REMOVE_FROM_FAVORITES' => '從最愛中刪除',
        'REMOVE_VIDEO_FROM_FAVORITES' => '從您的最愛中刪除？',
        'COLLECTED_BY_X' => '由%s收集',
        'ADD_FAVORITES' => '添加最愛',
        'YOU_CAN_MARK_VIDEO' => '您可以把任何視頻標記為最愛。只需在您看見視頻上的“添加到最愛”圖標時點擊即可 。',
        'VIEW_RECENT_VIDEOS' => '觀看最新視頻',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s還沒添加任何最愛.',
        'APPROVE_VIDEOS' => '批准視頻',
        'YOUR_SITE_REQUIRES_YOU' => '您要求在每一張照片和每一個視頻在發布前先接受您的審查。 若要改變這個選項，<a %s>點擊此處到隱私頁</a>把“批准新照片和視頻” 設置改為“否”。。',
        'YOUR_SITE_ALLOWS_USERS' => '您社交網絡現在的設定是不要您審查每一個照片和視頻。若要改變這個選項，<a %s>點擊此處到隱私頁</a>把“批准新照片和視頻” 設置改為“是”。',
        'APPROVE_ALL_VIDEOS' => '批准所有視頻？',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => '您確定要批准所有的視頻？ 該過程可能會需要好幾分鐘。',
        'APPROVING' => '正在批准中...',
        'APPROVE_ALL' => '批准全部',
        'DELETE_ALL_VIDEOS' => '刪除所有視頻？',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => '您確定要刪除所有未經批准的視頻？該過程可能會需要好幾分鐘。',
        'DELETING' => '正在刪除中...',
        'DELETE_ALL' => '刪除全部',
        'XS_VIDEOS' => '%s的視頻',
        'DELETE_ALL_XS_VIDEOS_Q' => '刪除所有%s的視頻？',
        'DELETE_ALL_XS_VIDEOS' => '刪除所有%s的視頻',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => '您確定要刪除所有%s的視頻？該過程可能會需要好幾分鐘.',
        'DELETE_THIS_VIDEO_Q' => '刪除該視頻？',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => '您確定要刪除該視頻？該過程可能會需要好幾分鐘。',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => '您還沒添加任何視頻，現在就加一個吧！',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s還沒添加任何視頻。',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => '您的朋友還沒添加任何視頻。',
        'ALL_VIDEOS_TAGGED_X' => '所有被標籤為%s的視頻',
        'ALL_VIDEOS_TAGGED_X_2' => '所有被標籤為<em>%s</em>的視頻',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => '沒有任何標籤為"%1$s"的視頻。 您可以看看標籤為<a %2$s>"%1$s"標籤的論談</a>, 或<a %3$s>"%1$s"標籤的照片</a>，或添加您自己的視頻並加標籤﹗',
        'FILES_MUST_BE_100MB' => '文件必須不超過100MB。我們支持.mov、.mpg、.avi、.3pg、和.wmv 檔案格式。',
        'NEED_HELP' => '需要幫忙？',
        'HERE_ARE_INSTRUCTIONS' => '這是 <a %s>YouTube</a> 和<a %s>Google Video</a>的說明',
        'PERSON_IN_CHARGE' => '%s網絡的負責人需要先批准您的視頻後才能發布。',
        'LEAVE_WINDOW_OPEN' => '正在上傳，請不要關閉該瀏覽窗口。',
        'KEEP_PAGE_OPEN' => '請不要關閉該瀏覽窗口﹐以便完成視頻的上傳。一旦被批准﹐我們會通知您﹗',
        'MEANWHILE_FEEL_FREE' => '在此同時，您可以<a %s>另開一個窗口</a>繼續瀏覽 %s。 上傳結束後，您可以為視頻添加標題和描述。',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => '該視頻正在<strong>等待</strong>%s的負責人批准.',
        'LOADING' => '正在載入...',
        'EDIT_VIDEO' => '編輯視頻',
        'DELETE_VIDEO' => '刪除視頻',
        'YOU_NEED_TO_BE_MEMBER' => '您必須是成員才能加評論！',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>加入該網絡</a>',
        'ADD_A_COMMENT' => '添加評論',
        'LEAVE_A_COMMENT_FOR_USERNAME' => '給%s留言',
        'MORE' => '其他',
        'PREVIOUS' => '前',
        'NEXT' => '下一步',
        'ABOUT_THIS_VIDEO' => '關於該視頻',
        'ABOUT_YOUR_VIDEO' => '關於該視頻',
        'ADDED_ON_DATE_BY' => '由<strong>%s</strong>添加：',
        'VIEWS' => '點閱:',
        'COMMENTS' => '評論：',
        'COMMENTS_COLON' => '評論：',
        'LOCATION_OF_VIDEO' => '該視頻的地點：',
        'RELATED_VIDEOS' => '相關的視頻',
        'ALL_VIDEOS_TAGGED_X_X' => '所有標籤為%s的視頻(%s)',
        'XS_VIDEOS_X' => '%s的視頻(%s)',
        'XS_FAVORITES_X' => '%s的最愛(%s)',
        'VIDEO_DETAILS' => '視頻細節',
        'NEITHER_FILE_NOR_EMBED_CODE' => '您沒指定一個文件或內嵌代碼。',
        'VIDEO_UPLOADED_ON_X' => '視頻已上傳到%s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => '轉換該視頻到Flash格式時出現錯誤： %s',
        'STATUS_N' => '狀態%s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => '無法上傳您的視頻"%s"到%s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => '無法上傳您的視頻到%s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => '您剛才試圖上傳視頻到 %s。很抱歉，因為您不是%s成員，我們不能發送這個視頻。',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => '您上傳到 %s 的視頻沒有完成。',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => '您的視頻上傳到%s失敗了.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => '上傳您的視頻到%s時發生錯誤',
        'THE_PROBLEM_WAS_X' => '問題是：%s',
        'FOR_FURTHER_ASSISTANCE_2' => '要獲得進一步協助，請瀏覽：',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => '您的視頻已成功上傳到 %s。',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => '視頻%s（所屬%s）在轉換格式過程中發生了錯誤',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '當%s上傳視頻時發生了轉換格式錯誤。',
        'ERROR_MESSAGE' => '錯誤訊息﹕',
        'APPLICATION_NAME' => '網絡名稱﹕',
        'APPLICATION_ID' => '網絡ID ﹕',
        'VIDEO_ID' => '視頻 ID ﹕',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => '您上傳到 %s 的視頻已完成。',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => '上傳視頻到%s成功',
        'YOUR_VIDEO_WAS_UPLOADED' => '上傳視頻到%s成功！',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => '該視頻還在等待批准。',
        'THIS_VIDEO_IS_BEING_PROCESSED' => '視頻正在轉換中。',
        'ADD_VIDEO' => '添加視頻',
        'VIDEO_BY_X' => '%s的視頻',
        'NO_PHOTOS_TAGGED_X_CHECK' => '沒有任何標籤為"%1$s"的照片。您可以看看<a %2$s>"%1$s"標籤的論談</a>、<a %4$s>"%1$s"標籤的部落格帖子</a>或<a %3$s> "%1$s"標籤的視頻</a>。或添加您自己的照片並加標籤﹗',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => '您的對於"%s" 的視頻"%s"有一條新評論。',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => '您%s裡的的一個視頻有一條新評論',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => '有人在您添加於%s的一個視頻上發表了一條新評論',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => '有人在%s裡上傳了一個視頻',
        'MORE_WAYS_TO_ADD_VIDEOS' => '更多添加視頻的方法...',
        'FROM_YOUTUBE_OR_GOOGLE' => '...來自 YouTube 或 Google',
        'GRAB_THE_HTML_EMBED_CODE' => '從任何熱門視頻網站抓取 HTML 內嵌代碼 （embed）, 並添加該視頻到這個社交網絡裡。',
        'ADD_A_VIDEO_FROM_YOUTUBE' => '從YouTube或Google添加視頻',
        'PASTE_IN_EMBED' => '請在此貼入視頻內嵌代碼 (embed)：',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => '通過手機或電子郵件添加視頻',
        'VIDEO' => '視頻',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => '沒有視頻符合您的搜索要求。',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => '您若要其他人也可看到這個框， 請點擊編輯, 然後更改設置。',
        'PLAY_AGAIN' => '再次播放',
        'SHARE' => '分享',
        'EMBED' => '內嵌',
        'REWIND' => '回倒',
        'CHANGE_SIZE' => '改變大小',
        'FULLSCREEN' => '全屏',
        'EXIT_FULLSCREEN' => '退出全屏模式',
        'HIDE' => '關閉',
        'COPY_AND_PASTE_LINK' => '複製並貼入該鏈接到電子郵件或短信裡。',
        'FIND_MORE_VIDEOS_LIKE_THIS' => '在 <em>%s</em> 上面找更多類似的視頻',
        'SEE_VIDEO_ON_NETWORK' => '在 %s 上觀看該視頻',
        'GET_EMBED_CODE' => '獲取內嵌代碼',
        'MORE_PHOTOS' => '更多照片',
        'THIS_ALBUM' => '該相冊',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => '該網絡還沒有任何照片。',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => '該成員還沒有任何照片。',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => '該相冊還沒有任何照片。',
        'FIND_MORE_PHOTOS_LIKE_THIS' => '在 <em>%s</em> 上面找更多類似的照片',
        'NO_PHOTOS_AVAILABLE' => '該相冊里沒有照片。  <a %s>點擊此處觀看所有的相冊</a>。',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => '該相冊或是只有您可以觀看﹐或是還在等待批准﹐所以網絡上的其他人目前看不見。',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => '定制您的幻燈片播放器。',
        'ADD_SLIDESHOW_LOGO' => '您可以為您的社交網絡的幻燈片加個標誌。<a %s>現在就設置吧！</a>',
        'PHOTO_BY_X' => '%s提交的照片',
        'UPLOAD_PHOTOS' => '上傳照片',
        'PLAYER_COLOR' => '播放器的顏色',
        'SLIDESHOW_PLAYER' => '幻燈片播放器',
        'SLIDESHOW' => '幻燈片',
        'FILTER' => '過濾器',
        'SAVE_ALBUM' => '保存相冊',
        'APPLY_THIS_INFO_TO_PHOTOS' => '應用本資訊到以下照片',
        'CLICK_TO_ADD_A_DESCRIPTION' => '點擊此處 以添加描述',
        'CHECK' => '檢查',
        'YOU_NEED_TO_BE_X' => '抱歉, 您必須是%s才能進行這項操作。',
        'ALL_PHOTOS' => '所有照片',
        'POPULAR_PHOTOS' => '最有人氣的照片',
        'FEATURED_PHOTOS' => '特選的照片',
        'PHOTOS_HOME' => '照片主頁',
        'ALL_ALBUMS' => '所有相冊',
        'MY_PHOTOS' => '我的照片',
        'MY_ALBUMS' => '我的相冊',
        'ADD_PHOTOS' => '添加照片',
        'ADD_PHOTOS_SENTENCE_CASE' => '添加照片',
        'EDIT' => '編輯',
        'CHOOSE_PHOTOS' => '選擇照片',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>把照片拖放到右邊以便添加</strong>。 要刪除照片就把它們拖回來。',
        'TITLE_YOUR_ALBUM' => '<strong>給您的相冊取名</strong>，再加個封面和描述。',
        'SAVE_YOUR_ALBUM' => '儲存您的相冊！',
        'CHOOSE_FROM' => '從這裡選擇：',
        'EVERYONES_PHOTOS' => '每個人的照片',
        'TAGGED' => '標籤：',
        'OLDER_PHOTOS' => '較舊的照片',
        'MORE_RECENT_PHOTOS' => '較新的照片',
        'YOUR_ALBUM' => '您的相冊',
        'DRAG_ALBUM_COVER_HERE' => '把相冊的封面拖放到這',
        'ALBUM_TITLE' => '相冊標題：',
        'ALBUM' => '專輯',
        'DRAG_PHOTOS_HERE' => '把您的照片拖放到這裡',
        'PREVIOUS_ALBUM_PAGE' => '相冊上一頁',
        'NEXT_ALBUM_PAGE' => '相冊下一頁',
        'ADDED_ON_DATE' => '%s上傳',
        'VIEW_AS_SLIDESHOW' => '以幻燈片方式顯示',
        'CREATED_BY_ME' => '<a %s>我</a>創建的',
        'CREATED_BY_X' => '%s創建的',
        'OUR_APOLOGIES' => '抱歉！',
        'ADD_PHOTOS_TO_ALBUM' => '從以下的選項中挑選照片，放入該相冊。',
        'YOU_CAN_ADD_PHOTOS' => '您現在就可<a %s>為該相冊添加新的照片</a>。',
        'SITE_IS_GETTING_STARTED' => '該社交網絡剛剛開始﹗',
        'NO_ONE_CREATED_ALBUMS' => '這裡還沒有任何相冊。  您現在就<a %s>創建一個吧</a>。',
        'EDIT_YOUR_ALBUM' => '編輯您的相冊',
        'ALBUMS_WITH_THIS_PHOTO' => '所有包含該照片的相冊',
        'ALBUMS_WITH_X' => '所有包含"%s"的相冊',
        'ALBUMS_WITH_X_2' => '所有包含<em>%s</em>的相冊',
        'NO_ALBUMS_CONTAINING_PHOTO' => '沒有任何相冊包含該照片。 您可<a %s>創建一個新的相冊</a>。',
        'XS_ALBUMS' => '%s的相冊',
        'CREATE_AN_ALBUM' => '創建新的相冊',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => '您還沒有任何相冊。現在就<a %s>創建一個吧</a>。',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s沒有任何相冊。',
        'MAKE_AN_ALBUM' => '創建新相冊',
        'ABOUT_THIS_ALBUM' => '關於此相冊',
        'ABOUT_YOUR_ALBUM' => '關於您的相冊',
        'EDIT_ALBUM' => '編輯相冊',
        'DELETE_THIS_ALBUM' => '刪除該相冊？',
        'DELETE_ALBUM' => '刪除相冊',
        'START_SLIDESHOW' => '播放幻燈片',
        'ALBUM_IS_NOW_EMPTY' => '該相冊是空的了。',
        'YOU_ARE_GETTING_STARTED' => '您馬上要開始！',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => '您還沒有任何照片！',
        'ADD_PHOTOS_AND_SHARE' => '添加照片，並和你的朋友，家人或者其他人分享！',
        'ADD_A_PHOTO' => '添加照片',
        'NO_PHOTOS_ON_SITE' => '您的社交網絡還沒有照片。',
        'BOX_WILL_NOT_SHOW_PHOTOS' => '這裡至少要有一張照片，其他人才能看得見這個框。現在就添加一張吧﹗',
        'VIEW_EMBED_CODE' => '看內嵌代碼',
        'VIEW_SLIDESHOW' => '看幻燈片',
        'VIEW_PHOTOS' => '觀看照片',
        'ADD_YOUR_FIRST_PHOTOS' => '添加您第一張照片',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => '您可以<a %s>添加自己的照片</a>到%s！',
        'UPLOAD_PHOTOS_FROM' => '從您的電腦上傳照片',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => '為您的照片添加標題及描述',
        'EDIT_PHOTO_INFORMATION' => '編輯照片的信息',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => '您可為剛上傳的照片添加標題， 描述， 及資訊。',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => '您可為該照片添加標題， 描述，及資訊。',
        'CANCEL_AND_RETURN_TO_PHOTO' => '取消並回到照片',
        'WHO_CAN_VIEW_PHOTO' => '誰可以看此照片？',
        'CAN_BE_VIEWED_BY' => '誰能觀看：',
        'BY_ME' => '由<a %s>我</a>上傳的',
        'RSS_FEED_LABEL' => '<a %s>提供真簡單聯合供稿</a> –  %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => '現在沒有照片需要您的批准。看看最新的照片吧。',
        'APPROVE_ALL_PHOTOS' => '批准所有照片？',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => '您確定要批准所有的照片？ 該過程可能會需要好幾分鐘。',
        'DELETE_ALL_PHOTOS' => '刪除所有照片？',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => '您確定要刪除所有未經批准的照片？該過程可能會需要好幾分鐘。',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => '在批准照片的過程中請不要關閉該窗口。該過程可能會需要好幾分鐘。',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => '在刪除照片的過程中請不要關閉該窗口。該過程可能會需要好幾分鐘。',
        'APPLY_TO_PHOTOS_ADDED_BY' => '應用到所有由%s添加的照片',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => '您的社交網絡還沒有照片。您今天就<a %s>添加第一張吧！</a>',
        'UNTITLED' => '無標題',
        'A_PROBLEM_OCCURRED' => '有錯誤發生',
        'PHOTOS_EXCEEDED_LIMIT' => '照片的大小超過了10MB的限制。',
        'GET_A_SLIDESHOW_OF' => '獲取 %s的幻燈片',
        'GET_A_SLIDESHOW' => '獲取幻燈片！',
        'GET_SLIDESHOW_OF_PHOTOS' => '獲取這些照片的幻燈片',
        'COPY_AND_PASTE_SLIDESHOW' => '您只要複製並粘貼下面的代碼就可以把這些照片的幻燈片放在您的網站﹐MySpace 或其他 Ning 網絡上。',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => '您只要複製並粘貼下面的代碼就可以把此相冊的幻燈片放在您的網站﹐MySpace 或其他 Ning 網絡上。',
        'LARGE_VERSION' => '大型版本',
        'SMALL_VERSION' => '小型版本',
        'VIEW_SLIDESHOW_FULL_SIZE' => '全屏幕幻燈片方式觀看',
        'PHOTOS' => '照片',
        'XS_PHOTOS' => '%s的照片',
        'XS_PHOTO' => '%s的照片',
        'YOU_CAN_MARK_PHOTO' => '您可以把任何照片記為最愛。只需點擊該照片的"添加到最愛"圖標即可。',
        'VIEW_RECENT_PHOTOS' => '瀏覽最近照片',
        'APPROVE_PHOTOS' => '批准照片',
        'DELETE_ALL_XS_PHOTOS_Q' => '刪除所有%s的照片？',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => '您確定要刪除所有%s的照片？該過程可能會需要好幾分鐘。',
        'REMOVE_X_AND_ALL_CONTENT' => '從您的社交網絡刪除%1$s及所有%1$s的內容',
        'SUCCESS' => '成功。',
        'DELETING_CONTENT' => '刪除內容...',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => '刪除內容的過程中請勿關閉此視窗。該過程可能會需要好幾分鐘。',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => '刪除成員的過程中請勿關閉此視窗。該過程可能會需要好幾分鐘。',
        'DELETE_ALL_XS_PHOTOS' => '刪除所有%s的照片',
        'CREATE_A_NEW_ALBUM' => '創建一個新相冊',
        'VIEW_ALL_XS_ALBUMS' => '瀏覽所有%s的相冊',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => '您還沒有添加任何照片。開始添加一些圖片吧！',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s還沒有添加任何照片。',
        'MY_FRIENDS_PHOTOS' => '我朋友的照片',
        'VIEW_PHOTOS_IN_SLIDESHOW' => '用幻燈片觀看這些照片！',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => '您的朋友們還沒有任何照片',
        'ALL_PHOTOS_TAGGED_X' => '所有標記為%s的照片',
        'ALL_PHOTOS_TAGGED_X_2' => '所有標記為<em>%s</em>的照片',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => '沒有任何標記為"%1$s"的照片。您可以看看<a %2$s>"%1$s"標籤的討論</a>﹐ 或a %3$s>"%1$s"標籤的視頻</a>﹐ 或添加您自己的照片並加標籤。',
        'SELECT_YOUR_PHOTOS' => '選擇照片',
        'PHOTO_MAY_BE_10MB' => '每張照片最大可以達到 10MB，但照片越小上傳越快。我們支援 .jpg、.gif 和 .png 格式的照片檔案。',
        'KEEP_PAGE_OPEN_PHOTOS' => '正在上傳照片，請勿關閉此頁面。 照片被批准後候我們會通知你。',
        'MEANWHILE_FEEL_FREE_PHOTOS' => '與此同時, 您可以<a %s>另開一個瀏覽視窗</a>繼續瀏覽%s。上傳結束後, 您可以為照片添加標題和描述。',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => '該照片正在<strong>等待</strong>%s的負責人批准。',
        'ADD_TO_FAVORITES' => '添加到最愛',
        'EDIT_PHOTO' => '編輯照片',
        'DELETE_PHOTO' => '刪除照片',
        'ABOUT_THIS_PHOTO' => '關於該照片',
        'LOCATION_OF_PHOTO' => '該照片的地點:',
        'ALBUMS_FEATURING_PHOTO' => '所有推薦該照片的相冊',
        'VIEW_ALBUMS_WITH_PHOTO' => '瀏覽所有包含該照片的相冊',
        'RETURN_TO_X' => '回到%s',
        'RETURN_TO_PHOTOS_HOME' => '返回照片主頁',
        'WE_COULD_NOT_FIND_ANYONE' => '抱歉 - 沒有找到任何人',
        'NOBODY_HAS_ADDED_PHOTOS' => '還沒有任何人添加照片！ 開始添加一些照片吧。',
        'DEFAULT_TITLE' => '標題',
        'DEFAULT_DESCRIPTION' => '描述',
        'UPLOAD_LIMIT_EXCEEDED' => '上傳文件的大小超過了限制。',
        'SLOW_DOWN_THERE_CHIEF' => '真抱歉',
        'I_DO_NOT_KNOW_USER' => '對不起, 我不認識此人。',
        'I_DO_NOT_HAVE_PHOTO' => '對不起, 我沒有這張照片。',
        'I_DO_NOT_HAVE_ALBUM' => '對不起, 我沒有這個相冊。',
        'ALBUM_BY_X_ON_X' => '%s的相冊 - %s',
        'SENT' => '已發送！',
        'I_HAVE_RECENTLY_ADDED' => '我最近新添加的',
        'FROM_THE_BAZEL' => '從該網絡',
        'RECENTLY_ADDED' => '最近添加',
        'RECENT_PUBLIC_PHOTOS_ON_X' => '%s上近期新加的共享照片',
        'X_ALL_PHOTOS' => '%s - 所有照片',
        'NO_TAG_WAS_SPECIFIED' => '沒有指定任何標籤',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => '被加了%s標籤於%s的共享照片',
        'XS_PUBLIC_PHOTOS_ON_X' => '%s的%s共享照片',
        'WE_DO_NOT_KNOW_USER' => '我們不認識此人。',
        'XS_FRIENDS_PHOTOS' => '%s朋友的照片',
        'XS_FAVORITE_PHOTOS_ON_X' => '%s的最愛照片（在%s上）',
        'PHOTO_UPLOADED_ON_X' => '上傳到%s的照片',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => '文件的大小超過了限制',
        'PART_OF_FILE_WAS_UPLOADED' => '該文件只上傳了一部分',
        'NO_FILE_WAS_UPLOADED' => '上傳失敗；文件名可能不正確',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => '上傳時出錯。',
        'ALPHABETICAL' => '按字母順序',
        'MOST_VIEWS' => '點閱率最高的',
        'RATING_NOT_RATED_YET' => '<strong>評分:</strong> 還未評分',
        'NOT_RATED_YET' => '還未評分',
        'HMM_SOMETHING_WENT_AWRY' => '嗯...有些不對呀',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => '標題為 "%s" 的照片不能被添加到 %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => '您的照片不能被添加到 %s',
        'YOU_JUST_TRIED_TO_SEND' => '您剛才試圖上傳照片到 %s。抱歉，由於您不是%s成員，我們不能發送這個照片。',
        'ONLY_MY_FRIENDS' => '只有我的朋友',
        'ANYBODY' => '任何人',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => '只有我的朋友才能看到該照片',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => '只有%s的朋友才能看到該照片',
        'ONLY_I_CAN_SEE_PHOTO' => '只有我才能看到該照片',
        'ONLY_X_CAN_SEE_PHOTO' => '只有%s才能看到該照片',
        'EVERYONE_CAN_SEE_PHOTO' => '任何人看到該照片',
        'PRIVATE_PHOTO' => '<strong>私有</strong>照片',
        'HOWDY_STRANGER' => '您好, 朋友！',
        'YOU_NEED_TO_BE_SIGNED_IN' => '您得先登錄到Ning才能進行這項操作。',
        'JUST_CLICK_ON_SIGN_IN' => '請點擊上面的“登錄”。 您若沒有Ning帳戶﹐請點擊"注冊"。',
        'YOU_NEED_TO_BE_' => '抱歉, 您必須是%s才能進行這項操作。',
        'YOU_NEED_TO_BE_OWNER' => '您必須是網絡創建者才能行這項操作。',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => '該照片正在等待批准。',
        'YOU_NEED_TO_BE_A_FRIEND' => '您必須是%s的朋友才能進行這項操作。',
        'MOST_ACTIVE' => '最活躍的',
        'HOW_IT_WORKS' => '如何運作',
        'MORE_WAYS_TO_ADD_PHOTOS' => '更多添加視頻的方法',
        'BY_PHONE_OR_EMAIL' => '通過手機或電子郵件',
        'FROM_FLICKR' => '...從 Flickr',
        'FROM_YOUR_COMPUTER' => '...從您的電腦上',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => '把您在Flickr的照片加進來。',
        'MORE_INFORMATION' => '更多訊息',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => '通過手機或電子郵件添加照片',
        'SEND_ONE_PHOTO_OR_VIDEO' => '每個電子郵件可發送一張照片或者一個視頻。 電子郵件的主題會設成照片或視頻的標題﹐ 而其內容會設成照片或視頻的描述。',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => '請點擊這裡以便獲得新的電子郵件地址',
        'UPLOAD_PHOTOS_FROM_YOUR' => '從電腦上傳照片',
        'PHOTO' => '照片',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => '您現在沒有顯示任何照片。',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => '只有當您選中至少一張照片, 其他人才能看得見這個框。',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => '您在%s上的照片"%s"（有一條新發表的評論',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => '您在%s上的某張照片有一條新發表的評論',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => '您添加到%s上的某個照片有一條新發表的評論',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => '有人在%s上傳了一張照片',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => '如果要從手機直接添加照片或視頻到%s，可將照片或視頻發送到一個電子郵件信箱。',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => '您確定從您的最愛中刪除這項嗎？',
        'DELETE_THIS_PHOTO_Q' => '刪除該照片？',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => '您確定要刪除這張照片？該過程可能會需要好幾分鐘。',
        'PHOTO_SLIDESHOW' => '幻燈片',
        'THUMBNAILS' => '縮略圖',
        'DETAIL' => '詳細內容',
        'TAG' => '標簽',
        'RATE' => '評分',
        'ALL_SIZES' => '所有尺寸',
        'ADD_TO_ALBUM' => '添加到相冊',
        'ROTATE_PHOTO' => '旋轉照片',
        'ABOUT_YOUR_PHOTO' => '關於您的照片',
        'SEE_PHOTOS_ON_NETWORK' => '在 %s 上看這些照片',
        'EMBED_CODE' => '內嵌代碼',
        'IMPORT_PHOTOS_FLICKR' => '從Flickr獲取您的照片',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => '按此處前往Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => '若想從Flickr獲取照片,你得先允許%S鏈接到您的Flickr帳戶。',
        'IMPORT_PHOTOS' => '導入照片',
        'GET_MY' => '獲取我的',
        'GET_PHOTOS' => '獲取照片',
        'MOST_RECENT_PHOTOS' => '最新的照片',
        'GET_ALL_MY_FLICKR' => '從Flickr獲取我所有的照片（可能需要一點時間）',
        'GET_ALL_MY_TAGGED' => '把我的所有照片夾上標籤',
        'GET_PHOTOS_FROM_SET' => '從一組照片中獲取：',
        'GET_STARTED_BY_IMPORT' => '我們將自動獲取您的標題，標記, 和任何匹配的訊息。 <br/>將要花費多長時間？</p><p><ul style="padding-top:10px;"><li>10張照片：<em>少於30秒</em>.</li><li>50張照片：<em>大約2分鐘</em>.</li><li>200張照片：<em>大約6分鐘</em>.</li><li>500張照片：<em>大約15分鐘.</em>.</li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => '如果您還沒有登錄到Flickr, 您會被要求登錄。 一旦您登錄了，請點擊按鈕“好K，我同意”。',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => '同時也獲取描述（這將會花費兩倍的時間）。',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => '請勿關閉此頁面以便我們完成照片的導入。',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => '獲取每張照片的全尺寸版本（因為這將會增加導入的時間,所以我們不建議超過20張照片）。',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => '點擊“編輯”可在該框內添加文字、視頻、照片、或任何其他小工具。 這可以使您的%s頁面更有個性。',
        'CLICK_EDIT_TO_ADD_TEXT' => '點擊「編輯」可在該框內添加文本、視頻、照片、或任何其他<a %1$s>第三方小工具</a>。',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => '如果您沒有更新該框的內容，其他人看不見該框。',
        'YOUR_X_BOX' => '您的%s框',
        'ABOUT_WIDGETS' => '關於小工具',
        'HELP' => '說明',
        'WIDGETS' => '小工具',
        'LOOKING_TO_ADD_FUNCTIONALITY' => '想為您的社交網絡添加更多功能嗎？比如日曆，當地天氣報告，事件倒計時表，或者網絡攝像頭什麼的？有了小工具，在您網絡的任何文字框裡添加新功能就變成容易的事。',
        'GETTING_STARTED' => '開始',
        'BELOW_IS_LIST_OF_WIDGET' => '您也許可以看看<a %s>這些小工具提供者</a>。我們從<a %s>yourminis.com</a>選了些小工具幫您起步。您只需在下面裝好小工具，拷貝內嵌代碼，然後直接粘貼到文字框裡就可以了。做做看吧！',
        'CALENDAR' => '日曆',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => '日曆小工具不僅可以顯示日期，還可以讓您搜索並添加iCal格式的事件（Google日曆和許多其他在線日曆提供商都使用這種格式）。',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => '用“編輯小工具”按鈕來選擇“搜索事件”選項，再輸入搜索項（如某個節假日，某個球隊等等）。然後選擇一個結果把對應的事件加到您日曆裡。您也可以手動輸入已有的iCal摘要網址。',
        'CUSTOMIZATION' => '自訂',
        'YOU_CAN_CUSTOMIZE_WIDGET' => '您可以自訂小工具的顏色外觀。將鼠標移到小工具上然後點擊顏色選擇框，可以改變背景、小工具的風格、以及透明程度。完成後，點擊“拷貝到網上”鏈接，然後“拷貝內嵌代碼”按鈕。代碼拷貝好後，就回到您網絡的任何一個文字框，粘貼並保存。這樣就完成了！',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => '從 yourminis.com獲得更多小工具 Â»',
        'WEATHER' => '天氣',
        'WEATHER_WIDGET_DISPLAYS' => '天氣小工具顯示來自“天氣頻道”的本地天氣預報。',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => '用“編輯小工具”按鈕來選擇您的地點以及攝氏還是華氏。您可以選擇只顯示當天的天氣，或者擴展到五天預報。',
        'COUNTDOWN' => '倒計時',
        'COUNTDOWN_WIDGET_LETS_YOU' => '倒計時小工具讓您可以為某個特殊事件建立倒計時。點擊“編輯小工具”，您可以輸入日期，事件，以及倒計時事件的標題或圖片。',
        'WEBCAM' => '網絡攝像頭',
        'WEBCAM_WIDGET_ALLOWS_YOU' => '網絡攝像頭小工具可以讓您監看公共網絡攝像頭。用&#8220; “編輯小工具” &#8221;按鈕來從預設的網絡攝像頭列表中選擇，也可以手動輸入一個網絡攝像頭的網址。',
        'MORE_WIDGETS' => '更多小工具',
        'NEED_MORE_OPTIONS' => '需要更多選擇嗎？我們推薦以下的一些網站：',
        'MODERATION_DENIED_ON_X' => '網絡負責人沒有批准%s 上的%s',
        'MODERATION_DENIED_ON_A_X' => '網絡負責人沒有批准您在%s上的%s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => '在%s有個新的的%s需要您協管',
        'NEW_X_TO_MODERATE' => '有個新的%s需要您協管。',
        'MODERATION_APPROVED_ON_X' => '網絡負責人批准了在 %s 上的%s',
        'MODERATION_APPROVED_ON_A_X' => '網絡負責人批准了您在 %s 上的%s',
        'JOIN' => '加入',
        'WELCOME' => '歡迎',
        'WELCOME_TO_X' => '歡迎來到%s',
        'WELCOME_TO_X_ELLIPSIS' => '歡迎來到%s…',
        'RSS_LINK' => '<a %s>真正簡易新聞訂閱方式 (RSS)</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top︰0">新功能!</h3>
            <ul><li><strong>小組</strong> &ndash; 讓您的成員在您的網絡上創建小組</li>
                <li><strong>音樂播放機</strong> &ndash; 添加音樂和播客至您的網絡</li></ul>
            <p><a href="%s" class="desc add">在此處按一下添加功能</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top︰0">新功能!</h3>
            <ul><li><strong>最近的活動</strong> &ndash;在您的網絡上跟蹤最近的成員活動</li>
<ul>                <li><strong>徽章和裝飾物</strong> &ndash; 用自定的徽章和裝飾物在網絡上推廣您的網絡</li></ul>
            <p><a href="%s" class="desc add">按一下這裡添加/編輯功能</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => '您的%2$s, %1$s, 上面有人在%3$s 上面添加的新評論!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => '有個在%2$s 上的人在您的%1$s上添加了新評論!',
        'HERE_IS_LINK' => '這裡 是加入 <a %s>%s</a>的鏈接',
        'THANKS_VALEDICTION' => '謝謝。',
        'THANKS' => '謝謝!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => '您在%s上面修改了您的電郵地址。',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => '您已在%s上面修改您的電子郵件地址...',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => '點擊此處來登入您的新的電子郵件地址登入:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => '假如您沒有修改您的電子郵件地址，點擊此處:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => '要停止收到有關新加討論的通知，前往:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s 在%2$s開始新的討論...',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s開始了“%2$s”討論。',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => '要瀏覽該項討論，前往:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s邀請您加入%s！',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s邀請您看看在%s上的"%s"！',
        'CHECK_OUT_TITLE_ON_APPNAME' => '看看在%s上的"%s"﹗',
        'ABOUT_X' => '關於%s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => '您收到這封電子郵件是因為%s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => '如果您不希望再收到來自%s的通知郵件，請<a %s>點擊此處</a>。',
        'CLICK_HERE' => '點擊此處',
        'YOU_CAN_CONTACT_US' => '若您有什麼問題或想更多了解您的隱私權﹐ 可到http︰//help.ning.com/?page_id=27與我們聯繫。',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => '給%s所有成員的訊息',
        'CLICK_TO_CHECK_OUT' => '點擊此處看看吧！',
        'CLICK_TO_APPROVE_X' => '點擊此處批准/刪除這個%s',
        'YOUR_X_HAS_BEEN_APPROVED' => '您在%s上的%s 已被批准',
        'YOUR_X_WAS_NOT_APPROVED' => '您在%s上的%s（屬%s)沒被批准',
        'CLICK_TO_VIEW_X' => '點擊此處觀看這個%s',
        'CLICK_TO_VIEW_IT' => '點擊此處來觀看！',
        'TO_VIEW_USER_PROFILE_VISIT' => '要瀏覽 %s的個人資訊, 訪問:',
        'YOU_ADDED_CONTENT' => '您把內容添加到%s，一個有人管理的社交網絡。',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s 報告了關於 %2$s 的問題...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s 報告了以下問題。',
        'URL_REPORTED_COLON' => '報告的網址:',
        'ISSUE_COLON' => '期號：',
        'ADDITIONAL_INFORMATION_COLON' => '更多資料:',
        'SEND_AN_INVITATION_TO_X' => '給%s發送邀請',
        'SOMEBODY_REQUESTED_JOIN_X' => '有人申請加入%s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => '要在%s的個人設定檔上添加至他們的歡迎詞？前往:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s 發送給您一封短信。',
        'TO_READ_THIS_MESSAGE_VISIT' => '要閱讀這封短信，到訪:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s 已在%s上面給您發送一則短信...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s 已將您添加為朋友...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s 已在 %s 將您添加為朋友...',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s接受了您在%s上做朋友的請求！',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => '要接受該朋友的請求，到訪:',
        'VIEW_XS_PAGE_ON_Y' => '在 %s上面瀏覽%s的頁面',
        'MEMBER_OF_X_ACCEPTED' => '%s的一位成員接受了您的朋友請求',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => '如果您不希望再收到來自%s的朋友請求通知，請<a %s>點擊此處</a>。',
        'YOU_RECEIVED_INVITATION_FROM_X' => '您從%1$s 的一位成員那裡收到一封邀請信。假如您不希望收到來自%1$s的邀請信，請到http︰//help.ning.com/?page_id=27此我們聯繫。.',
        'ON_X_COLON' => '在%s上',
        'ON_X' => '在%s上',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s 已要求獲得 %s的成員資格。',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s 申請加入 %3$s 上的 %2$s...',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s 已邀請您加入"%2$s"小組',
        'VISIT_GROUP_AT' => '到以下網址訪問%s:',
        'ABOUT_GROUP' => '關於%s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => '一個%s發給所有%s上的%s成員（屬%s)的信息 ﹗',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => '您可在此處用您的電子郵件地址登入:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s在%s上面為%s部落格的張貼發表評論',
        'SEND_X_A_MESSAGE_HERE' => '在此處發送一則短信給 %s:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => '有一位在 %s上的新成員等待您的批准...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => '您有一位新成員待批准。',
        'TO_APPROVE_XS_PROFILE_VISIT' => '要批准 %s的個人設定檔, 訪問:',
        'CANT_CLICK_CUT_AND_PASTE' => '無法點擊以上的鏈接？只需把網址粘貼到您的網絡瀏覽器。',
        'CLICK_HERE_TO_JOIN_COLON' => '點擊此處加入:',
        'CLICK_HERE_TO_JOIN_BANG' => '點擊此處加入!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => '您的 %s 成員資格已被批准...',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => '恭喜您！您的%s成員資格已被批准。',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => '您現在可在這裡使用您的電子郵件地址登入:',
        'VISIT_X_AT_Y' => '到%2$s︰訪問%1$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => '要控制在%1$s上面接收哪些電郵，前往:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => '一位被禁止進入的成員在%s上向您發送一則短信...',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => '一位被禁止進入的成員在%1$s上向您發送一則短信。%2$s寫道:',
        'WELCOME_TO_THE_GROUP_X' => '歡迎來到 "%s"小組',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => '歡迎%1$s到%2$s…',
        'TO_VIEW_THIS_GROUP_VISIT' => '要瀏覽該小組，到訪:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s 邀請您加入%2$s。',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s現在已是%2$s 的成員。',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s 現在已是 %2$¦的成員...',
        'SOMEBODY' => '某人',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => '要瀏覽您的新評論，到訪:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => '要瀏覽新的評論，到訪 :',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => '要瀏覽新的回覆，到訪 :',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => '歡迎來到 %s! 謝謝您加入。',
        'NAME_COLON' => '名字：',
        'EMAIL_COLON' => '電子郵件：',
        'AGE_COLON' => '年齡：',
        'GENDER_COLON' => '性別:',
        'LOCATION_COLON' => '地點:',
        'COUNTRY_COLON' => '國家:',
        'GET_NETWORK_BADGE' => '%s的徽章',
        'SPREAD_WORD_GET_BADGE' => '廣而告知！獲取一個%s的徽章，放在您的網站或您的MySpace頁面上(<a %s>Get Code</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => '廣而告知。<a href="%s">獲取您自己的%s徽章</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => '顯示您的忠誠。獲取您自己的%s徽章，放在您的網站或您的MySpace頁面上。 (<a %s>獲取編碼</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s在%3$s上面發表有關%2$s "%4$s"的評論',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => '很抱歉â€“我們無法從檔案中取出任何電郵地址。',
        'ADMINISTRATORS' => '系統管理員',
        'YOUR_INVITATION_HAS_EXPIRED' => '您的邀請信已過期',
        'SORRY_INVITATION_EXPIRED' => '對不起，您曾經使用過的邀請信已過期。要，您需要一封新邀請信來加入%s。',
        'DISABLE_INVITATION_LINK' => '停用邀請信鏈接?',
        'CREATING_LINK_WILL_DISABLE' => '創建一個新的邀請信鏈接會停用目前的鏈接。您確定要創建一個新的鏈接嗎？',
        'SHARE_LINK_WITH_PEOPLE' => '與您想邀請加入本網絡的人共享該鏈接﹕',
        'CREATE_INVITATION_LINK' => '創建新邀請信鏈接',
        'PLEASE_SELECT_SECOND_PART' => '請選擇您的電郵地址的第二部分，如gmail.com。',
        'AT_SYMBOL_NOT_ALLOWED' => '請確保電郵地址第一部分裡沒有@符號。',
        'SORRY_WE_DONT_SUPPORT' => '對不起，我們不支持您的電郵地址的網絡地址簿。請點擊下面的電郵申請來使用您的電腦裡的地址。',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => '請輸入您進入%s的密碼。',
        'IMPORTING_ADDRESS_BOOK' => '匯入通訊簿',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>請勿關閉此視窗，</strong>以便我們獲取您朋友們的電子郵件地址，。 之後您可以選擇邀請哪些朋友。',
        'SHARE_THIS_LINK' => '共享這個鏈接:',
        'SEND_WITH_EMAIL_PROGRAM' => '通過您電腦的電郵程序一并發出:',
        'EMAIL_THIS' => '用電郵發送此郵件',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(是您的朋友)',
        'CLEAR' => '清晰',
        'SEARCH_FRIENDS_TO_INVITE' => '搜尋要邀請的朋友:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => '已發出您的邀請信',
        'WANT_TO_INVITE_MORE' => '想邀請更多朋友？透過匯入來自您的網絡通訊簿或電郵申請的聯系資料來邀請更多朋友。',
        'MESSAGE_TOO_LONG' => '訊息太長。請使用少於 %s 個字元。',
        'FOLLOWING_DO_NOT_SEEM_VALID' => '以下電子郵件地址似乎已無效。未發出邀請信。請確定電子郵件地址重試。',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => '請輸入一個或多個電子郵件地址。',
        'ENTER_EMAIL_ADDRESSES' => '輸入電子郵件地址',
        'SEPARATE_MULTIPLE_ADDRESSES' => '用逗號將多項地址分開',
        'YOUR_MESSAGE_OPTIONAL' => '<label>您的信息</label> (可選)',
        'SEND_INVITATIONS' => '發送邀請信',
        'WEB_ADDRESS_BOOK' => '網絡通訊簿',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail、 Hotmail、GMail 或 AOL Mail',
        'YOUR_EMAIL_ADDRESS' => '您的電子郵件地址',
        'IMPORT_ADDRESS_BOOK' => '匯入通訊簿',
        'DONT_WORRY_WE_WONT_SAVE' => '別擔心。我們不會儲存您的密碼，而您將有機會選擇向哪些朋友發電郵。',
        'EMAIL_APPLICATION' => '電郵申請',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook、 Apple Mail、CSV等',
        'UPLOAD_CSV_OR_VCF' => '上傳一個從Microsoft Outlook或Apple 通訊錄上輸出的一個csv或vcf文件。',
        'BROWSE_FOR_FILE' => '尋找文件',
        'UPLOAD' => '上傳',
        'SELECT_ELLIPSIS' => '選取â€¦',
        'OTHER_ELLIPSIS' => '其他â€¦',
        'DONT_WORRY_YOULL_GET_CHANCE' => '別擔心。您將有機會選擇向哪些朋友發電郵。',
        'MEMBERSHIP_BY_INVITATION_ONLY' => '邀請會員制',
        'IF_YOU_ARE_ADMIN' => '假如您是系統管理員<a %s>點擊此處登入</a>.',
        'NAME_MUST_BE_SHORTER' => '名字得短於 %s 個字元',
        'CITY_NAME_MUST_BE_SHORTER' => '城市名稱必須短於 %s個字元',
        'EMAIL_ALREADY_REGISTERED' => '該電郵地址已被註冊。請選擇另一個電郵地址。',
        'EMAIL_NOT_VALID' => '該電郵地址似乎已失效。',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s 邀請您加入 %s',
        'YOU_ARE_SIGNING_UP_WITH' => '您正在用您的Ning身份登入。',
        'NOW_ENTER_PASSWORD' => '現在輸入您的密碼來繼續操作。',
        'OR_SIGN_IN' => '或 <a %s>登入</a>',
        'CHANGE_ADDRESS' => '修改地址',
        'CHANGE_PAGE_ADDRESS' => '修改頁面地址',
        'PAGE_ADDRESS_TAKEN' => '很抱歉，該地址已被使用。請另取一個地址。',
        'PAGE_ADDRESS_NOT_VALID' => '您只能在您的地址中使用字母A-Z、數字和下劃線(_)。',
        'ADD_BY_PHONE' => '透過電話添加',
        'PAGE_ADDRESS' => '頁面地址',
        'PHOTO_MUST_BE_TYPE' => '您的照片必須是.jpg, .gif 或.png檔案。',
        'USEFUL_ADDRESSES' => '有用的地址',
        'MY_DETAILS' => '我的詳細資料',
        'NONE_I_DO_NOT_WANT' => '不:我不想接收來自%s的電郵。',
        'CHANGE_PASSWORD' => '修改密碼',
        'PROFILE_SAVED' => '您的密碼已成功儲存。',
        'UPDATE_EMAIL_ADDRESS' => '更新電郵地址',
        'EDIT_EMAIL_ADDRESS' => '編輯您的電郵地址',
        'MY_SETTINGS' => '我的設定',
        'ABOUT_ME' => '關於本人',
        'SELECT' => '選取...',
        'CITY' => '城市',
        'COUNTRY' => '國家',
        'DATE_OF_BIRTH' => '出生日期',
        'DO_NOT_DISPLAY' => '不顯示',
        'GENDER' => '性別',
        'CREATE_YOUR_PROFILE' => '創建您的個人設定檔',
        'SYSTEM_REQUIREMENTS' => '系統需求',
        'WE_SUPPORT_INTERNET_EXPLORER' => '我們支援Internet Explorer 6 & 7、 Firefox 2.0 和Safari 2.0。假如您在使用不同的瀏覽器（或許您的網際網路服務供應商提供的一個瀏覽器），可能不兼容。',
        'MAKE_SURE_COOKIES' => '確定您的瀏覽器上可使用cookies和 JavaScript。',
        'WHAT_IS_MY_EMAIL' => '我的電郵地址是什麼？',
        'IF_JOINED_BEFORE_OCTOBER' => '假如您在2007年10月5日前加入，可能已向您提示使用一個Ning身份。我們請您用您註冊的電郵地址登入，不過，您仍可在本欄目內輸入您的Ning身份。',
        'CLICK_HERE_TO_RESET_PASSWORD' => '點擊此處重新設定您的密碼。',
        'STILL_HAVING_PROBLEMS' => '還有問題?',
        'VISIT_NING_HELP_CENTER' => '到訪<a %s>Ning 的幫助中心</a>來獲得更多有關查找問題的資料和支援。',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => '註冊或登入出現問題',
        'WE_SENT_YOU_EMAIL' => '我們已向您發送一封電郵，提供一個重新設定您的密碼的鏈接。',
        'RESET_PASSWORD_EMAIL_SUBJECT' => '重新設定密碼',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

我們已在 %2$s上面收到一個修改您密碼的請求。

點擊以下的鏈接設定新密碼︰

#{URL}

假如您不想修改您的密碼，您可以不理會這個電郵。

謝謝。
 "%2$s"隊

-----
%2$s 使用 Ning身份以授權。',
        'SET_PASSWORD' => '設定密碼',
        'NEW_PASSWORD' => '新密碼',
        'CREATE_NEW_PASSWORD' => '創建一個新密碼',
        'SET_NEW_PASSWORD' => '為帳戶設定新密碼。',
        'CHOOSE_NEW_PASSWORD' => '請選擇一個新密碼',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>您好， %s</strong> (<a %s>登出</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => '沒有與電郵地址%s有聯繫的帳戶。',
        'PLEASE_ENTER_CODE' => '請輸入出現在右側的編碼。',
        'PROBLEMS_SIGNING_UP' => '註冊有問題嗎？',
        'BY_SIGNING_UP_YOU_AGREE' => '您註冊即表明您同意<a %s>服務條款</a>和<a %s>隱私&nbsp;政策</a>。',
        'FEEDBACK' => '意見反映',
        'TERMS_OF_SERVICE' => '服務條款',
        'PROBLEM_SIGNING_UP' => '註冊時出現問題',
        'ALREADY_MEMBER_SIGN_IN' => '已是一名會員? <a %s>點擊此處登入</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => '您需要被邀請才能加入%s',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => '很抱歉，系統管理員已決定%s採用邀請會員制。若您有一封邀請信，點擊電郵中的鏈接以便加入。',
        'PROBLEM_SIGNING_IN' => '登入時有問題',
        'WE_USE_NING_ID' => '我們用Ning身份來驗證。 <a %s>什麼是 Ning身份?</a>',
        'PROBLEMS_SIGNING_IN' => '登入時有問題?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="登入" /> &#160;or&#160; <strong><a %s>註冊</a></strong>',
        'SIGN_IN_TO_APPNAME' => '登入 %s',
        'WHAT_IS_A_NING_ID' => '什麼是 Ning 身份?',
        'LARR_BACK' => '← <a %s>返回</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Ning身份的驗證系統讓您一次選擇一個電郵地址和密碼，并使用它加入或登入使用Ning ID的任何社交網絡。',
        'WHEN_YOU_CREATE_NING_ID' => '您創建Ning身份時，亦可添加一套基本詳細資料和您的照片至您的Ning ID帳戶。然后，在您加入使用Ning身份進行驗證的新社交網絡時，這些詳細資料會傳播出去。它亦幫助您記錄所有使用Ning身份的社交網絡上的朋友們以及電郵訊息。',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => '只要您看見這個符號: %s，便可用Ning身份電郵地址和密碼登入。',
        'HELLO_USER' => '您好，%s',
        'TEXT_FOR_HEADER_TAB' => '這個文字用在標題的標籤上',
        'BASED_ON' => '基於',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => '您確定要刪除這個語言嗎？',
        'DELETE_LANGUAGE' => '刪除語言',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => '文字已被重新設定為原有版本。',
        'UPLOAD_LANGUAGE_FILE' => '上傳語言檔案',
        'ADD_TO_LANGUAGE' => '添加至語言:',
        'IF_YOU_CREATED_TRANSLATION' => '假如您已在另一個Ning社交網絡上創建新的翻譯文字，您可以在這裡輸入。文件的內容會添加至您選擇的語言。看不見您已列出的語言嗎？ <a %s> 添加一個新的很容易</a>。',
        'EXAMPLES_SWEDISH_FINLAND' => '例如︰瑞典語 (芬蘭)、 菲律賓語、西班牙語 (波多黎各)',
        'START_FROM_SCRATCH_CREATE' => '從頭開始，把您的網絡翻譯成一個全新的語言！先輸入新語言的名字，然後選取一種現有語言作為參照基礎。',
        'KEY_MISSING_TEXT' => 'Key: <span %s>遺漏的文字</span> <span %s>修改的文字</span>',
        'SHOW_ALL_TEXT' => '顯示所有文字',
        'SHOW_MISSING_TEXT' => '顯示遺漏的文字',
        'SHOW_CHANGED_TEXT' => '顯示修改的文字',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => '例子︰標籤、成員、朋友',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => '重新設定文字為原有的版本',
        'ORIGINAL_TEXT_X' => '原有版本 %s',
        'EDIT_LANGUAGE_ON_NETWORK' => '編輯您網絡的語言',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => '在您的網絡上自訂任何文字，包括標籤名稱、電郵頁腳、錯誤信息和其它資料。',
        'ACTIVE_LANGUAGE_IS_X' => '<em> 您的網絡目前使用的語言是%1$s</em>. <a %2$s>修改目前使用的語言</a>',
        'CURRENT_LANGUAGE_OPTIONS' => '當前的語言選項',
        'ACTIVE' => '使用中',
        'MY_LANGUAGES' => '我的語言',
        'CREATE_NEW_TRANSLATION' => '創建一個新的翻譯',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => '沒有看見以上所列的您的語言？ <strong><a %s>為您的網絡創建一個新的翻譯版本</a></strong>.',
        'ADVANCED_IMPORT' => '進階匯入',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => '假如您已翻譯現有社交網絡上的語言，您可以<strong><a %s>匯入您的語言檔案</a></strong>並在這個網絡上使用它。',
        'LANGUAGE_EDITOR' => '語言編輯器',
        'PUBLIC' => '公開',
        'GRANDFATHERED_PRIVACY_SETTING' => '您當前的隱私權設定，即非會員僅可瀏覽登錄屏幕的公開網路，已不復存在。您的隱私權設定尚未被修改，但是，假如您在這裡作任何修改，您將無法返回。當前的設定等於一個任何人均可註冊成為會員的私人網絡。',
        'NO_MISSING_ITEMS' => '沒有遺漏的項目–  本翻譯已100%%全部完成。<a %s>瀏覽所有項目。</a>',
        'NO_CHANGED_ITEMS' => '沒有修改的項目。',
        'COULD_NOT_FIND_ITEMS_MATCHING' => '很抱歉 –  我們無法找到任何相一致的項目<em>%s</em>. <a %s>瀏覽所有項目。</a>',
        'FILE_N' => '文件%s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Ning 翻譯文件擁有一個文件名稱，如 <code>en_US.txt</code>。 <a %s>在此了解更多詳情。</a>',
        'SELECT_TRANSLATION_FILE' => '選取翻譯檔案:',
        'USE_THIS_TRANSLATION' => '使用這個翻譯',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => '注意，以下規則中遺漏的內容是: %s',
        'ALL' => '所有的',
        'MISSING' => '遺漏的',
        'VIEW' => '瀏覽',
        'TRANSLATION_CHANGES_SAVED' => '已儲存了您的修改. 該翻譯已經完成了%s%%.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => '已儲存了您的修改 該翻譯已經完成了%s%%. 您要不要用它作為您網絡的語言?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => '您的上傳成功。該翻譯已經完成了%s%%。',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => '您的上傳成功。 該翻譯已經完成了%s%%. 您要不要用這個作為您網絡的語言?',
        'X_IS_CURRENT_LANGUAGE' => '%s是您網絡的語言。',
        'SAVE_PAGE' => '儲存頁面',
        'LANGUAGE_NAME_TAKEN' => '很抱歉，該名稱已被使用。請另取一個名稱。',
        'ENTER_NAME_FOR_TRANSLATION' => '請為您的新翻譯輸入一個名稱, 比如 葡萄牙語(葡萄牙)',
        'CREATE' => '創建',
        'LANGUAGE_NAME' => '語言名稱',
        'SAVE_ITEMS_ON_PAGE' => '保存該頁面上的詞匯',
        'NEW_TRANSLATION' => '新的翻譯',
        'MISMATCHED_CURLY_BRACKETS' => '卷曲括號不相對',
        'MISMATCHED_SQUARE_BRACKETS' => '方括號不相對',
        'MISMATCHED_PARENTHESES' => '括號不相對',
        'ERROR_PROCESSING_SPECIAL_RULES' => '在處理特殊規則時有錯誤發生。',
        'ERROR_PROCESSING_TAB_NAMES' => '在處理標籤名稱時有錯誤發生。',
        'SPECIAL_RULES' => '特殊規則',
        'TAB_NAMES' => '標籤名稱',
        'SOURCE' => '來源',
        'LANGUAGE_EDITOR_X' => '語言編輯器︰%s',
        'BACK_TO_LANGUAGE_EDITOR' => '← 返回語言編輯器',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => '自訂您的網路文字和訊息或創建新語言。',
        'STOPWORDS' => 'a | about | an | are | as | at | be | by | com | de | en | for | from | how | i | in | is | it | la | of | on | or | that | the | this | to | was | what | when | where | who | will | with | und | the | www',
        'STOPWORDS_ARE' => '<a %s>停止詞匯單</a>是一個可有可無的詞匯單﹐當設定meta tag時﹐ 該詞匯單裡的字將會從網絡描述中被過濾掉。您不一定要創建這個停止詞匯單。',
        'I_AM_MEMBER' => '我是它的會員：',
        'VIEW_PAGE_ON_APPNAME' => '到<em>%s</em>瀏覽我的頁面',
        'VISIT_APPNAME' => '到訪<em>%s</em>',
        'JOIN_US' => '加入我們',
        'CREATED_BY_COLON' => '創建者：',
        'GET_MORE_BADGES' => '獲取更多徽章',
        'SHOW_LOGO' => '顯示標誌',
        'GALLERY' => '展覽廳',
        'BADGES' => '徽章',
        'MEMBER_BADGE' => '成員徽章',
        'WEAR_IT_WITH_PRIDE' => '自豪地戴上它！獲取一個您能夠在您的網站上或MySpace頁面上顯示的%s會員徽章。',
        'NETWORK_BADGE_LARGE' => '網絡徽章（大）',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => '廣而告之！ 獲取一個%s的可自動更新網絡最有人氣成員的徽章﹐ 放在您的網站或您的MySpace頁面上。',
        'NETWORK_BADGE_SMALL' => '網絡徽章（小）',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => '讓大家都看見！取得一個%s徽章﹐放在您的網站或您的MySpace頁面上。',
        'PHOTO_SLIDESHOW_PROPER' => '照片幻燈片',
        'DISPLAY_SELECTION_OF_PHOTOS' => '您可在您的網站或您的MySpace頁面上﹐用我們最酷的幻燈片播放器來播放您所選擇的照片。',
        'MUSIC_PLAYER' => '音樂播放器',
        'PLAY_MUSIC_ON_WEBSITE' => '您可在任何網站或MySpace頁面上﹐用我們最時髦的音樂播放器來播放您所選擇的音樂。',
        'ADD_A_VIDEO_MORE_OPTIONS' => '在您網站或MySpace頁面上加個視頻。  需要更多選擇嗎？在%s<a href="%s">瀏覽所有的視頻</a>。',
        'LARGE_N_PIXELS_WIDE' => '大 - 寬%d像素',
        'MEDIUM_N_PIXELS_WIDE' => '中 - 寬%d像素',
        'SMALL_N_PIXELS_WIDE' => '小 - 寬%d像素',
        'MY_MOST_RECENT' => '我最新的',
        'APP_ICON' => '應用圖標',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => '您需要被邀請才能加入%s',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '以下反饋是由%s提供的：',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s 在%2$s上提供反饋...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => '謝謝！ 您的訊息已經送出去了。',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s希望加入%s！',
        'X_HAS_REQUESTED_AN_INVITATION' => '％s想要得到%s的邀請函',
        'YOUR_REQUEST_HAS_BEEN_SENT' => '您的請求已發送給網絡創建者。',
        'TO_UNBAN_USERNAME_GO_TO' => '要解禁 %s, 前往:',
        'SEND_REQUEST' => '發送請求',
        'SEARCH' => '搜尋',
        'SEARCH_AGAIN' => '再搜索',
        'SEND_BROADCAST_MESSAGE' => '發送廣播訊息',
        'VERIFICATION_IMAGE' => '驗証圖片',
        'UNDER_CONSTRUCTION' => '正在建造中',
        'PROFILE_INFORMATION_SAVED' => '簡介信息已被儲存',
        'YOUR_SITES_DIRECTORY_PROFILE' => '已儲存了您網絡的簡介信息',
        'NO_ACCOUNT_WITH_EMAIL' => '沒有任何與該電郵地址有聯繫的帳戶。',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => '密碼錯誤。您的電腦是否鎖定了大寫字母﹖',
        'OOPS_THAT' => '對不起，– 出錯了。',
        'OOPS_THAT_DID_NOT_WORK' => '對不起，– 出錯了。 重試一下？',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => '對不起，– 出錯了 (%s)。',
        'NOT_FOUND' => '沒找到',
        'YOUR_SITES_FEATURE_LIST' => '已儲存了您網絡的功能表。',
        'ONE_LINE_ANSWER' => '簡潔答案',
        'LONGER_ANSWER' => '詳細答案',
        'MULTIPLE_CHOICE' => '多選項',
        'DATE' => '日期',
        'WEBSITE_ADDRESS' => '網絡地址',
        'EVERYTHING' => '所有項目',
        'JUST_THE_HOMEPAGE' => '只有首頁',
        'JUST_THE_SIGN_UP_PAGE' => '只有註冊頁面',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => '已儲存您的修改。',
        'JOIN_ME_ON_X' => '加入我的%s!',
        'NOT_ALLOWED' => '不允許',
        'COME_JOIN_ME_ON_X' => '來加入我的 %s。',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => '來加入我的%s...',
        'X_NOT_VALID_EMAIL' => '%s不是有效郵件地址或Ning 身份',
        'USER_BANNED_FROM_NETWORK' => '1$s已被該網絡禁止了。  <a %2$s>給%1$s發送訊息</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s已是該網絡的成員。<a %2$s>給%1$s發送訊息</a>',
        'YOU_CAN_SEND_AT_MOST_X' => '您一次只能發送%s個。',
        'PLEASE_ENTER_YOUR_FRIENDS' => '請輸入您朋友的郵件地址或Ning身份',
        'THERE_HAS_BEEN_AN_ERROR' => '有錯誤發生',
        'INVITATIONS_HAVE_BEEN_SENT' => '您的邀請信件已送出去了。',
        'SEARCH_RESULTS' => '搜索結果',
        'INVITE_YOUR_FRIENDS' => '邀請您的朋友',
        'SEND_INVITATIONS_FOR_FRIENDS' => '邀請您的朋友來加入',
        'INVITATION' => '邀請',
        'ADD_FROM_ADDRESS' => '從通訊錄裡添加',
        'TO' => '至：',
        'SEND_TO' => '送給',
        'SUBJECT' => '主題',
        'YOUR_MESSAGE' => '您的訊息',
        'SEND' => '發送',
        'REPORT_AN_ISSUE' => '報告問題',
        'TYPE_OF_ISSUE' => '問題種類',
        'ADULT' => '兒童不宜',
        'ABUSIVE' => '侵犯性言語',
        'BUG' => '程序缺陷',
        'FRAUD' => '欺騙',
        'SPAM' => '垃圾郵件',
        'OTHER' => '其他',
        'DESCRIBE_YOUR_ISSUE' => '描述您的問題',
        'SEND_REPORT' => '發送報告',
        'ADDED_BY_X_AT_X' => '由<a %s>%s</a>在%s添加有關%s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => '由<a %s>%s</a>在%s添加有關%s到%s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => '點擊瀏覽',
        'COMMENT_FOR' => '以下評論給予:',
        'COMMENT_ON' => '以下評語關於:',
        'ACTION_BUTTON_FEATURE' => '特点',
        'FEATURE_THIS_ON_YOUR' => '在主頁重點推薦這個',
        'ACTION_BUTTON_REMOVE' => '移除',
        'REMOVE' => '移除',
        'REMOVE_THIS_FROM_YOUR' => '從首頁移除這個',
        'FEATURE_ON_HOME' => '推薦到首頁',
        'REMOVE_FROM_HOME' => '從主頁中移除',
        'ITEM_WILL_APPEAR' => '這個項目將會顯示在主頁上的某些模組裡',
        'ITEM_WILL_NO_LONGER_APPEAR' => '這個項目將不在會顯示在主頁上的某些模組裡',
        'ADD_CONTENT' => '添加內容',
        'BROUGHT_TO_YOU_BY' => '%s 是由%s © %s 為您提供的',
        'GIVE_US_YOUR_FEEDBACK' => '請給我們一些反饋意見',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => '若有其他問題或想與Ning聯絡，請點擊此處：',
        'SEND_FEEDBACK' => '發送反饋',
        'SIGN_OUT' => '登出',
        'SIGN_OUT_TITLE' => '登出',
        'EDIT_MY_PROFILE' => '編輯我的簡介',
        'INVITE_MORE' => '邀請更多',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => '使用該表發送意見反饋給<a %s>%s</a>, <a %s>%s</a>的創建者。',
        'YOUR_FEEDBACK' => '您的反饋',
        'NETWORK_INFORMATION' => '網絡訊息',
        'ABOUT_YOUR_SITE' => '關於您的網絡',
        'WELCOME_TO_YOUR_SITE' => '歡迎來到您的社交網絡!',
        'EDIT_YOUR_NETWORKS_INFO' => '編輯您網絡的名字﹐  描述﹐和其它資料。',
        'TAGLINE' => '標籤',
        'APPEARS_IN_HEADER' => '顯示在您網絡的頁首',
        'APPEARS_IN_EMAILS' => '顯示在電子郵件及其他一些地方',
        'NETWORK_NAME' => '網絡名稱',
        'DESCRIPTION' => '描述',
        'KEYWORDS' => '關鍵字',
        'LANGUAGE' => '語言',
        'SEPARATE_EACH_KEYWORD' => '用逗號分隔多個關鍵字',
        'ICON' => '圖標',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => '請上傳一張照片(GIF, JPG or PNG), 我們會自動把它調整成正方形。  照片需要幾分鐘才能顯示出來。',
        'SAVE_SETTINGS' => '儲存設置',
        'SUCCESS_EXCLAMATION' => '成功！',
        'FEATURES' => '功能',
        'ADD_FEATURES' => '在您的網路上添加功能',
        'ORGANIZE_FEATURES' => '從以下清單上拉入功能，來組織您的主頁，然後按照您喜歡的任何方式進行安排。',
        'SKIP_FEATURES' => '點擊 <a href="%s">略過這個步驟</a>再進行預設的配置和功能的操作。',
        'FEATURES_FOR_ALL_PAGES' => '添加至這個框的功能出現在您的網路的所有頁面上。',
        'CUSTOMIZE_SITE_BY_ADDING' => '自訂您的社交網絡 - 您可以添加新的或刪減已有的功能。',
        'ADJUST_YOUR_SITES_COLORS' => '調整您網絡的顏色﹐圖片﹐和整體風格。',
        'APPEARANCE' => '外觀',
        'PROFILE_QUESTIONS' => '簡介問題',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => '編輯網絡成員在簡介裡必須回答的問題。',
        'MESSAGE_SENT' => '你的訊息已發送！',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => '你的訊息已發送到您網絡的所有成員。',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => '你的訊息已發送到您小組的所有成員。',
        'YOUR_MESSAGE_IS_BEING_SENT' => '你的訊息正在發送。請等一下, 可能會需要一會兒。',
        'BROADCAST_MESSAGE' => '廣播訊息',
        'TRACK_VISITORS_AND_TRENDS' => '跟蹤您社交網站的訪問者數量和趨勢。',
        'EDIT_SOURCE_CODE' => '編輯程式碼',
        'TAKE_FULL_CONTROL' => '打造一個全新獨特的網絡！現在就開始編輯您網絡的程式碼.',
        'DELETE_THIS_SITE' => '刪除您的社交網絡',
        'MAIN_PAGE' => '主頁',
        'MAIN' => '主頁',
        'MAIN_TAB_TEXT' => '主頁',
        'MANAGE' => '管理',
        'MANAGE_TAB_TEXT' => '管理',
        'PAGE_TITLE' => '頁面標題',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => '編輯您頁面的外觀',
        'CHOOSE_A_THEME' => '為您的社交網絡選個主題',
        'NOW_CUSTOMIZE_SITE' => '現在您可以自由設計您的社交網絡...',
        'THEME_SETTINGS' => '主題設定',
        'ADVANCED' => '高級',
        'TOP_BAR_AND_FOOTER' => '上方工具欄與頁腳',
        'HEADER_AND_NAVIGATION' => '頁首與導航欄',
        'ADD_A_LOGO' => '添加標誌',
        'THIS_IMAGE_WILL_REPLACE' => '該圖片將取代文字的網絡名字',
        'TABS' => '標籤',
        'TAB' => '標籤',
        'SITE' => '網絡',
        'SIDES' => '邊',
        'BODY' => '正文',
        'SHOW_NING_LOGO' => '顯示 Ning 標誌?',
        'LAUNCH' => '發表！',
        'NING_ID' => 'Ning身份',
        'PASSWORD' => '密碼',
        'RETYPE_PASSWORD' => '重新鍵入密碼',
        'TYPE_CODE_ON_RIGHT' => '在<br />右側鍵入編碼',
        'JOIN_X' => '加入 %s',
        'SIGN_UP_FOR_X' => '註冊%s',
        'HAS_INVITED_YOU_TO_X' => '邀請您來加入 %s。',
        'CONTENT_AWAITING_APPROVAL' => '正在等待批准',
        'NEW_MEMBER' => '新成員？',
        'JOIN_X_NOW' => '現在就加入%s!',
        'HIDE_THIS_MESSAGE' => '隱藏該訊息',
        'PAGE_NOT_FOUND' => '無法找到頁面',
        'THIS_PAGE_WAS_NOT_FOUND' => '對不起，– 無法找到頁面',
        'FOLLOW_THESE_LINKS_TO' => '點擊這些鏈接來連到一些可供使用的東西﹕',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => '或者，您也可以搜索這個社交網絡：',
        'IF_YOU_GET_THIS_MESSAGE' => '如果您再收到這個訊息, <a %s>請通知我們</a>',
        'GROUP_MEMBERS' => '小組成員',
        'VIDEOS' => '視頻',
        'BLOG' => '部落格',
        'ACCOUNT' => '帳戶',
        'WE_ARE_SORRY_WE_ARE_HAVING' => '對不起, 本頁面有問題。',
        'FOLLOW_LINK_TO_HOMEPAGE' => '請跟隨此鏈接到主頁。',
        'REQUEST_AN_INVITATION' => '要求獲得邀請！',
        'NAME' => '名字',
        'EMAIL_ADDRESS' => '電子郵件地址',
        'MESSAGE_OPTIONAL' => '訊息（可不填寫）',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>抱歉！</strong>  但是您可以很簡單的創建您自己的社交網絡。',
        'GET_YOUR_OWN_BAZEL' => '創建您自己的社交網絡！',
        'SITE_IS_NOT_READY' => '該社交網絡還沒准備好！',
        'BAZEL_IS_BEING_SET_UP' => '該社交網絡還在建造中﹗',
        'SIGN_IN' => '登入',
        'FORGOT_YOUR_PASSWORD' => '忘記了密碼?',
        'FORGOT_YOUR_PASSWORD_TITLE' => '忘記了密碼?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => '輸入您的電郵地址，並按一下重新設定密碼。您會收到一封電郵，內有重新設定您的密碼的一個鏈接。',
        'RESET_PASSWORD' => '重新設定密碼',
        'EXPLORE' => '瀏覽',
        'SIGN_UP' => '註冊',
        'CONFIRM_PASSWORD' => '確認密碼',
        'VERIFICATION' => '讓我們知道您<br />是一位使用者',
        'YOUR_PHOTO' => '您的照片',
        'SUMMARY' => '摘要',
        'YOUR_SITE_IS_READY' => '您的社交網絡已經可以發布了！如果您跳過了任何步驟，我們將用預設的設置。您可返回再修改，或點擊“發表”來發表您的網絡。',
        'WHEN_YOU_ARE_FINISHED' => '完成後 請點擊“瀏覽版面設計”來看看您的的創造！',
        'COMPLETE' => '完成',
        'INCOMPLETE' => '未完成',
        'VIEW_LAYOUT' => '瀏覽版面設計',
        'CLEAR_CONTENTS' => '清除內容',
        'ADD_MODULE' => '添加單元模組...',
        'ADD_COLUMNS' => '添加豎列...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>公開</strong> – 任何人都可加入',
        'PRIVATE_ONLY_INVITED' => '<strong>私人</strong> – 只有被邀請的人才能瀏覽及加入。',
        'INVITATIONS' => '邀請函',
        'MEMBERS_CAN_INVITE' => '本網絡的成員可以邀請其他人加入。',
        'QUESTION_TITLE' => '問題標題',
        'ANSWER_TYPE' => '答案類型',
        'REQUIRED' => '必填',
        'PRIVATE' => '私人',
        'CHOICES' => '選擇',
        'SEPARATE_EACH_CHOICE' => '用逗號分隔多個選擇',
        'CAN_PICK_MORE' => '可多項選擇',
        'ADD_ANOTHER_QUESTION' => '添加另一個問題',
        'WHAT_INFORMATION' => '當新成員加入您的網絡時﹐ 您想要他們回答哪些問題？ 您可以隨意調整問題的順序 - 先點擊問題, 再拖放到您想要的地方。',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => '假如您選擇“必答”，會員須回答問題，才能加入。假如您選擇“私人”，只有您和其他系統管理員能夠看見回答。',
        'WE_COULD_NOT_FIND_ANYTHING' => '我們無法找到和"%s"相關的東西。要不要找些別的？',
        'GET_CUSTOM_URL' => '獲取您自訂的網址 ﹐添加儲存容量和頻寬﹐或經營您自己的廣告 。',
        'VIEW_STATISTICS' => '瀏覽統計數據',
        'ADD_TRACKING_CODE' => '<a %s>添加您自己的跟蹤代碼</a>。',
        'TRACKING_CODE' => '跟蹤代碼',
        'ANY_JAVASCRIPT_CODE' => '您在此處粘貼的任何JavaScript代碼將會被放置在您的每一個網頁的底部。 您可用這項功能來增添外加的網絡跟蹤系統﹐比如Google Analytics。',
        'ANALYTICS_LEARN_MORE' => '想要知道更多關於Google Analytics及如何設置您的帳戶﹐請<a %s>點擊此處</a>。',
        'RESOURCES' => '資源',
        'LINKS' => '鏈接',
        'PAGE' => '頁面',
        'BACKGROUND' => '背景',
        'TEXT' => '文字',
        'HEADING_TEXT' => '頁首文字',
        'FONT' => '字體',
        'AABBCC' => 'AaBbCc',
        'COLOR' => '顏色',
        'LINK_COLOR' => '鏈接顏色',
        'BODY_TEXT' => '正文文字',
        'MIDDLE' => '中間',
        'FEATURE_BOXES' => '各項功能框',
        'TITLEBAR_TEXT_COLOR' => '標題文字的顏色',
        'TITLEBAR_BACKGROUND' => '標題條的背景',
        'UPLOADING_CONTENT' => '上傳內容...',
        'WHEN_UPLOADING_IS_COMPLETE' => '上傳完畢後您就可以瀏覽網絡了。',
        'FINISH' => '完成',
        'FLICKR_IMPORT_SETUP' => '設置Flickr導入設置',
        'FLICKR_API_KEY' => '您的API鍵',
        'FLICKR_SECRET' => '您的密鑰',
        'FLICKR_KEY_ERROR' => '您輸入的Flickr密鍵鑰或密鑰有問題。  您可不可以檢查一下再重新輸入？',
        'FLICKR_INTRO' => '想讓您的成員從Flickr導入他們的照片嗎？ 那您可來對地方啦！ 如果您已經有FlickrAPI鍵或密鑰的話﹐從這<a %s>跳到最後一步</a>。 如果您不知道這些是什麼，請按照以下這幾個簡單步驟：',
        'FLICKR_GET_ACCOUNT' => '您若還沒有Flickr帳戶﹐ 您可<a %s>在此申請一個</a>。',
        'FLICKR_STEP1_TITLE' => '第一步： 獲取一個Flickr API鍵',
        'FLICKR_STEP1_APPLY_SCREEN' => '到Flickr申請您的API鍵',
        'FLICKR_STEP1_API_SCREEN' => 'Flickr的API鍵畫面',
        'FLICKR_STEP1_INTRO' => '登錄至Flickr﹐<a %s>申請新API鍵</a> (點擊該鏈接將會開啟新視窗) 。',
        'FLICKR_STEP1_A' => '填寫<strong>您的名字</strong>和<strong>郵件地址</strong>。',
        'FLICKR_STEP1_B' => '在<strong>This key is for&hellip;</strong>下面選擇 "non-commercial"（非商業）這一項。',
        'FLICKR_STEP1_C' => '在 "Describe the application are you planning to build" 的框內描述您的社交網絡。',
        'FLICKR_STEP1_D' => '選中兩個接受框。',
        'FLICKR_STEP1_APPLY' => '完成後請按"Apply"(申請)鈕。',
        'FLICKR_STEP1_E' => '您會來到顯示您新API鍵的畫面。 點擊<strong>Click here</strong> ) （“點擊此處”）　鏈接來設置該鍵的用戶驗証。',
        'FLICKR_STEP2_TITLE' => '第二步：安裝您的API鍵',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Flickr的設置API鍵用戶驗証畫面',
        'FLICKR_STEP2_F' => '粘貼以下網址到<strong>Callback URL</strong> (回叫網址)裡：',
        'FLICKR_STEP2_SAVE_CHANGES' => '完成後請按 "Save Changes"(儲存修改)鈕。',
        'FLICKR_STEP3_TITLE' => '第三步：輸入您的資料',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Flickr的API鍵資料畫面',
        'FLICKR_STEP3_CONGRATULATIONS' => '恭喜您! 您已經安裝好了Flickr。',
        'FLICKR_STEP3_COMPLETE' => '最後一步就是拷貝並粘貼您的API鍵和密鑰到下面的文字欄：',
        'COMPLETE_SETUP' => '完成安裝',
        'SETUP_YOUR_SITE_TO' => '把Flickr的照片導入到您的社交網絡。',
        'FLICKR_IMPORTING' => '從Flickr導入',
        'YOU_NEED_TO_SET_UP_FLICKR' => '您得先設定您的社交網絡﹐ 讓成員能導入他們的Flickr照片。  這只要幾分鐘。<a %s>現在就開始吧！</a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => '請不要再顯示這個。',
        'YOUVE_SIGNED_OUT_OF_X' => '您已成功的登出%s。 請再回來看看我們！',
        'CREATED_THIS_SOCIAL_NETWORK' => '在<a href="http://www.ning.com">Ning</a>上創建了這個社交網絡。',
        'CREATE_YOUR_OWN' => '免費在Ning上創建您自己的社交網絡！',
        'DRAG_HERE_TO_REMOVE_FEATURE' => '拖放到這裡來刪除該功能',
        'LAYOUT' => '版面設計',
        'DRAG' => '拖動',
        'HERE' => '這裡',
        'YOU' => '您',
        'ADS' => '廣告',
        'MEMBERS' => '成員',
        'HELLO_USERNAME' => '您好，用戶名',
        'CREATED_BY' => '創建人',
        'SAVE_FEATURES' => '儲存功能',
        'FORUM' => '論壇',
        'CATEGORIES' => '類別',
        'FORUM_CATEGORIES' => '論壇類別',
        'A_THREADED_DISCUSSION_FORUM' => '一個分線討論的論壇',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => '允許成員在您的網絡創建自己的興趣小組',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => '展示您或其他成員的部落格的特選帖子',
        'TEXT_BOX' => '文字框',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => '將任何文字、小工具或 HTML 放在主頁',
        'A_LIST_OF_MEMBERS' => '您的社交網絡成員的清單',
        'ALLOW_USERS_PHOTOS' => '允許成員上傳及分享照片',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => '添加從整個網絡上導入的摘要',
        'INFORMATION_ABOUT_THE_USER' => '有關目前登錄人員的資料',
        'ALLOW_USERS_VIDEOS' => '(允許成員上傳及分享視頻',
        'SHOW_NETWORK_DESCRIPTION' => '顯示您的網絡說明',
        'PROMOTE_NETWORK_WITH_BADGES' => '用您獨特的徽章和小工具在整個網絡上推廣您的網路。',
        'MONETIZE_WITH_ADS' => '通過廣告讓您的網路為您帶來利潤',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => '讓您的成員知道誰創建了該網路',
        'FOLLOW_LATEST_ACTIVITY' => '在您的網路上跟蹤最近的成員活動。',
        'FAQ_FOR_NETWORK_CREATORS' => '網絡創建者的常見問題解答',
        'ANSWERS_TO_FAQS' => '有關自訂您的社交網絡的常見問題解答。',
        'MEET_OTHER_LIKEMINDED' => '和其他興趣相合的網絡創建者接觸，分享點子，並獲得 Ning 團隊的支持。',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => '自訂您社交網絡的外觀 - 您可在左邊加上您自己的階層串接樣式設計。（<a href="%s">什麼是階層串接樣式設計?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => '自訂您社交網絡的外觀 - 您可在左邊加上您自己的階層樣式設計。  (<a href="%s">什麼是階層樣式設計?</a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => '您社交網絡的階層樣式設計',
        'CSS_ON_YOUR_PAGE' => '您簡介頁面的階層樣式設計',
        'ADDING_YOUR_OWN_CSS_NETWORK' => '添加您自己的階層樣式設計可以讓您完全掌控您網絡的字體﹐顏色﹐間隔﹐和整體風格。',
        'ADDING_YOUR_OWN_CSS_PAGE' => '添加您自己的階層樣式設計到您的頁面可以讓您完全掌控您頁面的字體、顏色、間隔和整體風格。',
        'CSS_STYLES_WILL_OVERRIDE' => '您在此添加的階層串接樣式設計將會覆蓋現有的階層串接樣式設計。',
        'NEED_HELP_FIGURING_OUT_CSS' => '需要幫助弄明白任何特殊階層串接樣式設計樣板 的名稱嗎？我們建議使用免費的 Firebug 擴充件裡的“檢查 ”功能（專給Firefox瀏覽器使用）。',
        'WANT_TO_LEARN_MORE' => '想要知道更多嗎？ 查看我們的<a href="%s">高級自訂</a>部分。',
        'APPLY_XS_THEME' => '應用%s的主題',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => '已經有一個 Ning身份是以這個電子郵件地址 %s註冊的。在下方請以您的Ning 身份或電子郵件地址登錄。 如果您忘了您的密碼， <a href="%s">點擊此處重設密碼</a>。',
        'INVITED' => '已被邀請',
        'REQUESTED_INVITE' => '請求邀請',
        'BAN_FROM_NETWORK' => '禁止訪問該網',
        'REMOVE_BAN' => '解除禁令',
        'CANCEL_INVITATION' => '取消邀請',
        'IGNORE' => '拒接來電',
        'PROMOTE_TO_ADMINISTRATOR' => '升級到系統管理員',
        'DEMOTE_FROM_ADMINISTRATOR' => '從系統管理員降級',
        'STATUS' => '狀態',
        'DATE_JOINED' => '加入日期',
        'DATE_INVITED' => '邀請日期',
        'DATE_REQUESTED' => '請求日期',
        'DATE_APPLIED' => '申請的日期',
        'NETWORK_CREATOR' => '網絡創建者',
        'NETWORK_ADMINISTRATOR' => '系統管理員',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => '網絡管理者有類似網絡創建者的管理權。',
        'DOWNLOAD_ALL_MEMBER_DATA' => '匯出所有成員資料 (.CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => '您的成員資料已匯出。點擊<a %s>該鏈接</a>，以便將它儲存在您的桌面上。',
        'CLICK_GO_TO_START_EXPORT' => '按一下Go，開始匯出。假如您有很多成員，處理的程序可能會花上好幾分鐘。',
        'MEMBER' => '成員',
        'INVITED_BY_X' => '被%s邀請的',
        'DONE' => '完畢',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => '您被禁止訪問%s',
        'MESSAGE_TO_ADMINISTRATOR' => '致系統管理員的訊息',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => '抱歉，%s，您無法進入 %s，因為您已被禁止進入。假如您認為其中有錯誤，可以與系統管理員聯絡。',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => '抱歉，%s，您無法進入 %s，因為您已被禁止進入。',
        'SORRY_USERNAME' => '抱歉, %s',
        'PENDING' => '等待中',
        'ACCEPT' => '接受',
        'PENDING_APPROVAL' => '正等待批准',
        'ACCEPT_MEMBERSHIP' => '接受成為成員',
        'DECLINE_MEMBERSHIP' => '拒絕接受成為成員',
        'NO_PAGE_YET' => '還沒有頁面',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => '您在%s里的成員資格正在等待系統管理員的批准。',
        'MEMBERSHIP_PENDING_APPROVAL' => '會員申請待批準',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => '您的個人設定檔正在等待批准',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => '您的簡介詳細資料必須獲得系統管理員的批准，然後後後才能成為%s的成員。一旦您的個人設定檔獲得批准，您會收到一封電郵。',
        'CONTINUE_ARROW' => '繼續 →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← 返回等待批准的成員',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s正在等待批准，以成為%s的成員。',
        'VIEW_PAGE' => '瀏覽頁面',
        'MESSAGE' => '訊息',
        'SEND_MESSAGE' => '發送訊息',
        'MANAGE_FORUM_CATEGORIES' => '管理論壇類別',
        'START_DISCUSSIONS' => '開始討論',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => '歡迎進入您新創建的社交網絡',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => '現在您需要做的僅僅是<a %s>邀請您的朋友</a>﹗',
        'CONTRIBUTE' => '貢獻。',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>自訂</strong>調整<a %1$s>網路外觀</a> 及設計 <a %2$s>徽章及小工具</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>控制。</strong>  <a %s>管理的</a> 頁面是配置設定選項的主頁。',
        'CREATE_GROUPS' => '創建小組',
        'INVITE_MORE_PEOPLE' => '邀請更多的朋友',
        'VIEW_THREAD' => '瀏覽線索',
        'COMMENT_THREAD' => '評論線索',
        'COMMENT_BACK' => '回複評論',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => '您得開啟JavaScript才能用該網絡。',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => '請檢查您瀏覽器的設置或聯系網絡管理者。',
        'MANAGE_MEMBERS_ADMINS_INVITED' => '管理成員、 網絡管理者、 被邀請的人員和被禁止的人員。',
        'MANAGE_MEMBERS' => '管理成員',
        'MANAGE_INVITED_PEOPLE' => '管理被邀請的人員',
        'NETWORK_SETTINGS' => '網絡設置',
        'PROMOTE_YOUR_NETWORK' => '推廣您的網絡',
        'NING_RESOURCES' => 'Ning的資源',
        'ADD_PREMIUM_SERVICES' => '添加特級服務',
        'REQUEST_SOURCE_CODE' => '請求取用程式碼',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => '網頁工程師﹕請求取用您網絡的程式碼。',
        'JOIN_NETWORK_CREATORS' => '加入網絡創建者的社團',
        'SEND_MESSAGE_TO_ALL_THIS' => '給該網絡的所有成員發送訊息。',
        'CREATE_ANOTHER_NETWORK' => '創建另一個網絡',
        'HAVE_ANOTHER_GREAT_IDEA' => '您又有了一個社交網絡的好點子嗎？',
        'ALLOW_FACEBOOK_USERS_TO' => '允許Facebook的用戶把您網絡上的小工具放在他們的簡介頁面上。',
        'BADGES_AND_WIDGETS' => '徽章及小工具',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => '自訂您網絡徽章及小工具的外觀。',
        'GET_BADGES' => '獲取徽章',
        'CUSTOM_TEXT' => '自訂的文字',
        'IM_A_MEMBER_OF' => '我是它的會員：',
        'DONT_DISPLAY_ANY_BRANDING' => '不要顯示任何品牌',
        'WATERMARK_OR_LOGO_IMAGE' => '浮水印或標誌圖片：',
        'NETWORK_BRANDING_BADGES' => '網絡品牌：徽章',
        'NETWORK_BRANDING_WIDGETS' => '網絡品牌：小工具',
        'LOGO_IMAGE' => '標誌圖片',
        'SMALL_NETWORK_BADGE' => '小網絡徽章',
        'LARGE_NETWORK_BADGE' => '大網絡徽章',
        'REFRESH' => '刷新',
        'HTML_EMBED_CODE' => 'HTML內嵌代碼：',
        'CUSTOMIZE' => '自訂',
        'SHARE_TITLE' => '分享%s',
        'SHARE_TYPE' => '分享 %s',
        'YOUR_MESSAGE_SENT' => '您的訊息已發送成功。',
        'YOUR_MESSAGES_SENT' => '您的訊息已發送成功。',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => '您能夠用兩個方法&#8230分享這個%s。',
        'CHECK_OUT_THIS_TYPE_TITLE' => '看看這個%s: "%s"',
        'CHECK_OUT_THIS_TYPE' => '看看這個%s',
        'PHOTO_ALBUM' => '照片相冊',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => '用您喜愛的顏色和圖片來自訂徽章和小工具。您的修改最多需要四個小時就能在其他網站上顯示出來。',
        'BACKGROUND_IMAGE_AND_COLOR' => '背景圖片和顏色',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => '用該表報告一個問題給<a %s>%s</a>, 即<a %s>%s</a>的創建者。',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => '抱歉，網路創建者無法透過他們並不擁有的網路來修改電郵地址。',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => '抱歉，網路創建者無法透過他們並不擁有的網路修改密碼。',
        'GO' => '移至',
        'LARGE_THUMBNAILS' => '大號縮略圖',
        'SMALL_THUMBNAILS' => '小號縮略圖',
        'RECENTLY_JOINED' => '最新的',
        'MOST_POPULAR_MEMBERS' => '最有人氣的',
        'NO_MEMBERS_TO_DISPLAY' => '您現在沒有顯示任何成員',
        'BOX_WILL_NOT_SHOW_MEMBERS' => '只有當您選中至少一列﹐其他人才能看得見該框。',
        'DETAIL_VIEW' => '詳細資訊',
        'TITLES_ONLY' => '只有標題',
        'RECENTLY_ADDED_POSTS' => '最近添加',
        'POPULAR_POSTS' => '最多評論的',
        'PROMOTED_POSTS' => '特選的',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => '只有當您選中至少一個帖子, 其他人才能看得見該框。',
        'KEEP_WINDOW_OPEN_UPLOAD' => '在內容上傳時請勿關閉視窗。',
        'CANCEL_UPLOAD' => '取消上傳',
        'YOU_DO_NOT_HAVE_POSTS' => '您還未發表任何帖子。',
        'YOU_DO_NOT_HAVE_COMMENTS' => '沒有任何評論需要您的批准。',
        'REQUIRED_FIELD' => '（必填項）',
        'BLOG_POST_BY_X' => '%s發表的部落格帖子',
        'HELLO' => '您好﹐',
        'ADDED_BY_X' => '%s添加的',
        'CLICK_TO_ADD_A_TITLE' => '點擊這裡添加標題',
        'DELETE_BLOG_POST' => '刪除帖子',
        'DELETE_THIS_BLOG_POST_Q' => '刪除該部落格帖子？',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => '您確定您要刪除這個部落格帖子？ 該過程可能會需要好幾分鐘。',
        'SPINNER' => '轉輪。',
        'PLEASE_ENTER_SOMETHING_FOR_X' => '請填寫一些東西給：%s',
        'PLEASE_SELECT_OPTION_FOR_X' => '請選擇一個選項給：%s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => '請提供一個有效日期給：%s',
        'PLEASE_PROVIDE_DATE_FOR_X' => '請提供一個日期給：%s',
        'XS_BLOG_POSTS_FOR_M_Y' => '%s寫給%s %s的部落格帖子',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => '給%s %s的特選部落格帖子',
        'BLOG_POSTS_FOR_M_Y' => '給%s %s的部落格帖子',
        'FEATURED_BLOG_POSTS' => '特選部落格帖子',
        'EVERYONES_POSTS' => '每個人的部落格帖子',
        'PUBLISHED_N_OF_N' => '發表於%d 的%d',
        'DOWNLOAD_X' => '下載%s',
        'UPLOAD_DID_NOT_WORK' => '抱歉﹐該上傳不失敗',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M j Y',
        'XS_POSTS' => '%s的帖子',
        'USERNAMES_COMMENTS' => '%s的評論',
        'ADD_COMMENT' => '添加評論',
        'XS_PAGE' => '%s的頁面',
        'XS_BLOG' => '%s的部落格',
        'XS_FRIENDS' => '%s的朋友',
        'VIEW_XS_ELLIPSIS' => '瀏覽 %s的...',
        'DRAFT_BRACKETS' => '[ 草稿 ]',
        'FEATURED' => '特選的',
        'MY_POSTS' => '我的帖子',
        'MY_POSTS_ONLY' => '只有我的帖子',
        'OWNER_POSTS_ONLY' => '只有創建者的帖子',
        'JANUARY' => '一月',
        'FEBRUARY' => '二月',
        'MARCH' => '三月',
        'APRIL' => '四月',
        'MAY' => '五月',
        'JUNE' => '六月',
        'JULY' => '七月',
        'AUGUST' => '八月',
        'SEPTEMBER' => '九月',
        'OCTOBER' => '十月',
        'NOVEMBER' => '十一月',
        'DECEMBER' => '十二月',
        'MY_COMMENTS' => '我的評論',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => '我的頁面',
        'MY_PAGE_TAB_TEXT' => '我的頁面',
        'BLOG_POSTS' => '部落格帖子',
        'MY_BLOG' => '我的部落格',
        'MONTH' => '月',
        'DAY' => '日',
        'PICK_VALID_DEFAULT_VISIBILITY' => '請為”預設視角”問題挑一個有效的選擇',
        'PICK_VALID_WHO_CAN_COMMENT' => '請為”誰可以添加評論”的問題挑一個有效的選擇',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => '請為”部落格的評論管理”問題挑一個有效的選擇',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => '請為”活動通知”的問題挑一個有效的選擇',
        'PICK_VALID_MODERATION_NOTIFICATION' => '請為”管理通知”的問題挑一個有效的選擇',
        'PICK_VALID_APPROVAL_NOTIFICATION' => '請為”批准通知”的問題挑一個有效的選擇',
        'PICK_VALID_INVITEE_NOTIFICATION' => '請為”受邀者加入通知”的問題挑一個有效的選擇',
        'PICK_VALID_NEVER_NOTIFICATION' => '請為”永遠不要接受通知”的問題挑一個有效的選擇',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => '請為”朋友請求通知”的問題挑一個有效的選擇',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => '請為”新訊息通知”的問題挑一個有效的選擇',
        'APPROVE_COMMENT' => '批准評論',
        'MANAGE_BLOG' => '管理部落格',
        'COMMENTS_POSTED_ON_BLOG' => '貼在我部落格上的評論',
        'COMMENT' => '評論',
        'COMMENTER' => '評論者',
        'POST' => '開機自我測試 (POST)',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => '帖子已被刪除了',
        'COMMENTS_ARE_CLOSED' => '該部落格帖子已不再接受評論',
        'NO_COMMENTS' => '無評論',
        'FLAG' => '加旗標',
        'POST_TITLE' => '帖子標題',
        'DRAFT_PARENTHESES' => '（草稿）',
        'SCHEDULED_TO_PUBLISH_ON' => '預定發表於：%s',
        'EDIT_2' => '編輯',
        'NONE' => '無',
        'N_NEW' => '%s新',
        'NO_POSTS' => '無帖子',
        'ADD_NEW_BLOG_POST' => '添加一個新的部落格帖子',
        'HAPPY' => '高興',
        'SAD' => '傷心',
        'COOL' => '酷',
        'EVIL' => '邪惡',
        'MAD' => '生氣',
        'ENVIOUS' => '羨慕',
        'ENTRY' => '正文',
        'WHAT_DATE_FOR_YOUR_POST' => '您想要哪天發表這個帖子？',
        'NOW' => '現在',
        'CHOOSE_DATE_AND_TIME' => '為您的帖子選個日期和時間（如果是未來的日期, 您的帖子要到那時才會被發表）',
        'PRIVACY_AND_COMMENTS' => '隱私與評論',
        'WHO_CAN_VIEW_POST' => '誰可以看該帖子？',
        'EVERYONE' => '每個人',
        'ALLOW_COMMENTS' => '允許在該帖子上添加評論？',
        'YES' => '是',
        'NO' => '否',
        'COMMENT_MODERATION' => '審查評論',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => '您正在審查部落格評論',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => '您目前沒有在管理部落格評論',
        'SAVE_AS_DRAFT' => '儲存為草稿',
        'PREVIEW' => '預覽',
        'PUBLISH_POST' => '發表帖子',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => '這是您部落格帖子的預覽。您可點擊“返回”再繼續編輯, 或點擊“發表”來發表帖子﹗',
        'BACK' => '返回',
        'PUBLISH' => '發表',
        'BLOG_POST' => '部落格帖子',
        'PROFILE' => '簡介',
        'THIS_IS_UNPUBLISHED_DRAFT' => '這是個還未發表的草稿',
        'WILL_BE_PUBLISHED_ON_X' => '將發表於%s <small> %s </small>',
        'POSTED_ON_X' => '已發表於%s <small> %s </small>',
        'POSTED_ON_X_BY' => '<strong>%s</strong> <small>%s</small> 的發表者:',
        'ABOUT_THIS_POST' => '關於該帖子',
        'ABOUT_YOUR_POST' => '關於您的帖子',
        'ADDED_BY' => '添加者：',
        'JUST_FRIENDS' => '只是朋友',
        'RECENT_POSTS' => '最近的帖子',
        'THERE_ARE_NO_RECENT_POSTS' => '最近沒有帖子。',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => '您的帖子已添加, 但須經過審查後大家才能看到。',
        'AT_TIME_ON_DATE_USERNAME_SAID' => '在%s關於%s﹐%s 說了...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s在該社交網絡上還沒有朋友。',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => '您在該社交網絡上還沒有朋友。',
        'EDIT_PAGE_APPEARANCE' => '編輯頁面的外觀',
        'VIEW_PAGE_AS_OTHERS' => '查看會員們所看到頁面',
        'ADD_BLOG_POST' => '添加部落格帖子',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => '在%s的內容被刪除過程中請不要關閉視窗。該過程可能會需要好幾分鐘。',
        'BAN_MEMBER_FROM_NETWORK' => '禁止成員到訪網絡',
        'BAN_USERNAME' => '禁止%s?',
        'BLOCK' => '封鎖',
        'CREATE_NEW_BLOG_POST' => '創建新的部落格帖子！',
        'EDIT_POST' => '編輯帖子',
        'EDIT_POST_COLON' => '編輯帖子：',
        'CONTINUE_READING' => '繼續閱讀...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => '由<a %s>我</a>在 %s 發表關於 %s —',
        'POSTED_BY_X_ON_X_AT_X' => '由%s 在 %s發表關於 %s —',
        'POSTED_BY_ME_ON_X_AT_X' => '由我在%s發表關於 %s —',
        'ADD' => '添加',
        'SUBSCRIBE' => '訂閱',
        'VIEW_ARCHIVES' => '查看檔案',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => '您的設置已被儲存',
        'PLEASE_CORRECT_THE_FOLLOWING' => '請改正以下部分：',
        'PRIVACY' => '隱私',
        'NETWORK_PRIVACY' => '網路隱私權',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => '該網路是<strong>每個人能看見的</strong>。',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => '任何人能夠註冊成為成員。訪問者能...',
        'SEE_EVERYTHING' => '看見所有項目',
        'SEE_JUST_THE_MAIN_PAGE' => '只看見主頁',
        'SEE_JUST_THE_SIGN_UP_PAGE' => '只看見註冊頁面',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => '該網路 <strong>只有成員能看見</strong>。',
        'WHO_CAN_SIGN_UP' => '誰能夠註冊成為成員？',
        'MODERATION' => '內容控制',
        'APPROVE_MEMBERS_BEFORE_JOIN' => '新成員加入前先批准',
        'APPROVE_PHOTOS_VIDEOS' => '在照片和視頻出現前先批准',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => '在您的網路上顯示最近的活動！',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => '在您的網絡主頁上添加一個隨時更新的活動系列。',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => '點擊此處以添加最近的活動至您的網路。',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => '由於您的網路上沒有最近的活動﹐這些選項已被關閉。',
        'ACTIVITY' => '活動',
        'DISPLAY_PREFERENCES' => '顯示的偏好',
        'NEW_CONTENT' => '新的內容',
        'NEW_COMMENTS' => '新的評論',
        'NEW_MEMBERS' => '新的成員',
        'MEMBER_UPDATES' => '成員更新',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => '您的網路上的<br />最近的活動顯示什麼？',
        'LATEST_ACTIVITY' => '最近的活動',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s 對討論%2$s作出回覆',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s對討論<a %3$s>%4$s</a> <a %2$s>作出回覆</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => '您對討論 <a %2$s>%3$s</a>作出<a %1$s>回覆</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s對部部落格帖子%2$s作出評論',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s對部落格帖子  <a %3$s>%4$s</a><a %2$s>作出評論 </a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '您<a %1$s>部落格帖子<a %2$s>%3$s</a></a><a %1$s>作出評論</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s 開始了一個稱為 %s 的討論',
        'YOU_STARTED_A_DISCUSSION_Y' => '您開始了一個稱為 %s 的討論',
        'X_ADDED_THE_BLOG_POST_Y' => '%s 添加了部落格帖子%s',
        'YOU_ADDED_THE_BLOG_POST_Y' => '您添加了部落格帖子%s',
        'X_JOINED_THE_GROUP_Y' => '%s 已加入%s小組',
        'YOU_JOINED_THE_GROUP_X' => '您已加入%s小組',
        'X_JOINED_Y_GROUPS' => '%s 已加入 %s 小組',
        'YOU_JOINED_X_GROUPS' => '您已加入 %s 小組',
        'X_JOINED_APPNAME' => '%1$s 加入 %2$s。對 %4$s <a %3$s>發表評論</a>。',
        'WELCOME_MEMBER_N_OF_APPNAME' => '歡迎 %1$s! 您是%3$s的第%2$s位成員 。',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => '歡迎，%1$s! 您已是%3$s成員的#%2$s <a %4$s>現在就尋找朋友</a>。',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s 已是%3$s的第%2$s位成員。',
        'XS_PROFILE_CHANGED' => '%s的個人設定檔已修改',
        'YOUR_PROFILE_CHANGED' => '您的個人設定檔已修改',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s 給%s留了評論',
        'YOU_LEFT_A_COMMENT_FOR_X' => '您給%s留了評論。',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s 給您留了評論',
        'X_CREATED_A_GROUP_Y' => '%s 創建了一個稱為%s 的小組',
        'YOU_CREATED_A_GROUP_Y' => '您創建了一個稱為%s 的小組',
        'X_CREATED_Y_NEW_GROUPS' => '%s 創建了%s 新小組',
        'X_STARTED_Y_FORUM_POSTS' => '%s 開始了%s 新的論壇討論',
        'YOU_STARTED_Y_FORUM_POSTS' => '您開始了%s 新的論壇討論',
        'X_ADDED_Y_BLOG_POSTS' => '%s添加了 %s 新的部落格帖子',
        'YOU_ADDED_Y_BLOG_POSTS' => '您添加了 %s 新的部落格帖子',
        'VIEW_XS_BLOG_POSTS' => '瀏覽%s的部落格帖子',
        'VIEW_YOUR_BLOG_POSTS' => '瀏覽您的部落格帖子',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s 有 <a %s>有關新簡介的問題</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s 現在已有一個音樂播放機',
        'APPNAME_NOW_HAS_GROUPS' => '%s 現在已有 <a %s>小組</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s 現在已有 <a %s>視頻</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s 現在已有一個 <a %s>論壇</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s 現在已有 <a %s>照片</a>',
        'DID_YOU_KNOW' => '您知道嗎？',
        'ANNOUNCEMENT' => '宣告',
        'CONGRATULATIONS' => '祝賀',
        'YOU_CREATED_APPNAME' => '您創建了 %s 網路。',
        'USER_CREATED_APPNAME' => '%s創建了%s網路。',
        'ADD_MESSAGES_ACTIVITY_FEED' => '添加訊息並選擇什麼消息會顯示在您網絡的活動摘要上。',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => '您想將哪些活動顯示<br />在您網絡的最近的活動上?',
        'NEW_CONTENT_I_ADD' => '我所添加的新內容',
        'NEW_COMMENTS_I_ADD' => '我所添加的新評論',
        'WHEN_I_UPDATE_MY_PROFILE' => '當我更新我的個人設定檔',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => '最近的活動絕對不會顯示您發送的訊息、瀏覽的頁面或成員、拒絕的邀請、不想成為朋友或拒絕他們的人士、或您刪除的東西。',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => '您最近沒有任何活動。何不開始些什麼呢？',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => '您已關閉活動的顯示器。 <a %s>按一下這裡來把它啟動。</a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => '網路創建者已關閉所有活動的顯示器。',
        'NO_ACTIVITY_TO_DISPLAY' => '您現在沒有顯示任何活動。',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => '除非您選擇至少一個活動項目，否則，該信箱不會顯示給其他人士。',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => '您的網絡最近沒什麼活動。何不開始些什麼呢？',
        'MY_ACTIVITY_PREFERENCES' => '我的活動偏好',
        'DELETE_ACTIVITY_ITEM' => '刪除活動訊息',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => '刪除這個活動訊息?',
        'THIS_WILL_PREVENT_ACTIVITY' => '這會防止任何人看見活動訊息',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s已張貼最%2$s的照片%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s 是迄今最有人氣的照片',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s 已張貼最%2$s的視頻%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s 是迄今最有人氣的視頻',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s張貼了最多首歌曲',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s 是迄今最有人氣的歌曲',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s 是迄今最有人氣的論壇張貼',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s 是迄今為止最有人氣的部落格',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s在%s的最近活動',
        'LATEST_ACTIVITY_ON_APPNAME' => '在%s的最近活動',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => '將訊息添加至最近活動',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => '添加有關網路的基本知識...',
        'ADD_MESSAGE' => '添加訊息',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '...或是寫您自己的訊息',
        'NETWORK' => '網絡',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => '預設情況下哪些人可以看我的照片﹐視頻﹐和部落格帖子？',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(您在添加照片﹐視頻﹐ 和部落格帖子時, 可覆蓋此設置。）',
        'MODERATE_COMMENTS_ON_BLOG' => '評論是否需要您先批准才發表到您的部落格﹖',
        'YES_LET_ME_APPROVE' => '是，我要先批准評論',
        'NO_PUBLISH_COMMENTS' => '不，直接發表評論',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => '誰可以評論我的照片﹐ 視頻﹐和部落格？',
        'SAVE' => '儲存',
        'EMAIL' => '電郵',
        'YOUR_PRIVACY_IS_IMPORTANT' => '我們非常重視您的隱私。如果您對您的郵件通知有任何問題，您可以通過 <a href="http://help.ning.com/?page_id=27">協助中心</a>聯絡我們。',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => '要添加照片和視頻到 %s, 請發送至此郵件地址：',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => '如果要從手機直接添加視頻到%s，可將視頻發送到這個電子郵件信箱﹕',
        'GENERATE_NEW_EMAIL_ADDRESS' => '創造新的電郵地址',
        'SUPPORTS_TEXT_EMBEDDED' => '支持文字﹐內嵌視頻﹐ 照片﹐和小工具',
        'POST_COMMENT' => '發表評論',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => '您必須是成員才能加評論！',
        'MONTHLY_ARCHIVES' => '按月存檔',
        'NO_FRIENDS_ON_SITE' => '在此社交網絡上還沒朋友。',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => '該社交網絡沒有符合您搜索條件的朋友。',
        'MEMBERS_TAB_TEXT' => '成員',
        'SITE_HAS_NO_MEMBERS' => '這個社交網絡還沒有成員﹗',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => '該社交網絡沒有符合您搜索條件的成員。',
        'NO_COMMENTS_YET' => '目前還沒有評論﹗',
        'VIEW_ALL_COMMENTS' => '瀏覽所有的評論',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => '您還沒添加任何部落格帖子﹗',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => '您可寫任何東西﹐ 內嵌您喜愛的視頻﹐ 照片﹐ 和音樂。',
        'WRITE_YOUR_FIRST_ENTRY' => '寫您的第一個部落格帖子！',
        'THERE_ARE_NO_BLOG_POSTS' => '您的社交網絡目前沒有任何部落格帖子。',
        'THERE_ARE_NO_FEATURED_X' => '您的社交網絡沒有任何特選的 %s 。',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => '沒有任何%s符合您選擇的設定。',
        'START_FEATURING_X_CLICK_Y' => '當您看到“特選”這個選項時, 您可以推薦 %s。想要知道更多關於“特選”, 請<a %s>點擊此處</a>。',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => '這裡若沒有部落格帖子﹐該視頻框不會出現。。 現在就添加一個吧！',
        'YOUR_FRIEND' => '您的朋友',
        'REQUEST_SENT' => '請求已被發送.',
        'BLOCKED' => '封鎖',
        'BANNED' => '禁止',
        'ADD_YOUR_FIRST_BLOG_POST' => '添加您第一個博部落格帖子',
        'MY_FIRST_BLOG_POST' => '我的第一個部落格帖子！',
        'TELL_THE_PEOPLE_ON' => '向%s的成員介紹您自己。有<span %s>鎖住</span>標記的問題是是不公開的，只有系統管理員能看見。',
        'CHOOSE_A_THEME_FOR_PAGE' => '為您的頁面選擇一個主題',
        'NOW_CUSTOMIZE_PAGE' => '現在自訂您的頁面...',
        'NO_POSTS_TO_DISPLAY' => '沒有帖子可顯示。',
        'YOU_ARE_DISPLAYING_NO_POSTS' => '您目前沒有顯示任何帖子。',
        'DATE_COLON' => '日期：',
        'TIME_COLON' => '時間：',
        'CHANGE' => '修改',
        'UPLOAD_A_PHOTO' => '上傳照片',
        'OPTIONS' => '選項',
        'PIXELS' => '像素',
        'CANCEL' => '取消',
        'UPLOAD_A_FILE' => '上傳文件：',
        'TO_INSERT_A_FILE' => '要插入文件，點擊上面的“瀏覽”或“選擇v按鈕選定您電腦上的文件。',
        'UPLOADING' => '上傳...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => '最有人氣的成員',
        'INVITE_FRIENDS' => '邀請朋友',
        'VIEW_ALL' => '瀏覽全部',
        'REMOVE_X' => '移除 %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => '您確定您要禁止 %1$s 到訪您的社交網絡﹐ 並刪除 %1$s 所添加的所有內容？ 該過程可能會需要幾分鐘。',
        'REMOVING_X' => '正在刪除 %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => '您確定您要禁止這幾位成員到訪您的社交網絡﹐ 並刪除他們所添加的所有內容？ 該過程可能會需要幾分鐘。',
        'ARE_YOU_SURE_BAN_MEMBERS' => '您確定您要禁止這幾位成員到訪您的社交網絡？ 該過程可能會需要幾分鐘。',
        'BAN' => '禁止',
        'REMOVING_MEMBERS' => '刪除成員',
        'FEMALE' => '女',
        'MALE' => '男',
        'UNITED_STATES' => '美國',
        'AND' => '和',
        'FROM' => '來自',
        'GENDER_M' => '男',
        'GENDER_F' => '女',
        'XS_PAGE_ON_Y' => '%s在 %s上的頁面',
        'SEARCH_MEMBERS' => '搜索成員：',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => '有人評論了您在 %s 上的部落格帖子',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => '您的頁面上有新評論。',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => '您在 %s上的頁面有新的評論。',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => '您在%s上的頁面有新的評論...',
        'A_BLOG_POST' => '一個部落格帖子',
        'NOW_THAT_YOU_JOINED_INVITE' => '現在您已加入 <strong><a %s>邀請您的朋友 </a></strong> ﹗',
        'THIS_IS_YOUR_PROFILE' => '這是您的個人設定檔︰',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => '首先<a %s>自訂它的外觀</a>。',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => '用它來<a %1$s>寫一個部落格</a>，並且顯示<a %2$s>您的簡介</a>。',
        'START_CONTRIBUTING' => '開始貢獻︰',
        'UPLOAD_VIDEOS' => '上傳視頻',
        'CONTRIBUTE_TO_DISCUSSIONS' => '參與討論',
        'JOIN_GROUPS' => '加入小組',
        'ADD_A_BLOG_POST' => '添加一個部落格帖子',
        'CLICK_TO_ACCEPT_FRIENDS' => '點擊這裡查看您的朋友請求。',
        'LEAVE_X' => '離開%s',
        'LEAVE_X_Q' => '離開%s?',
        'ARE_YOU_SURE_LEAVE_X' => '您確定要離開%s並刪除您的所有內容嗎？該過程可能會需要幾分鐘。',
        'BACK_TO_USERNAMES_PAGE' => '&#8592; 返回 %s的頁面',
        'BACK_TO_MY_PAGE' => '&#8592; 返回我的頁面',
        'COMMENT_WALL' => '評論牆',
        'ONLINE' => '線上',
        'MEMBER_IS_ONLINE' => '成員在線上',
        'ONLINE_NOW' => '現在正在線上',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => '選擇誰可瀏覽，加入並提供內容到您的網絡。',
        'EMAIL_NOTIFICATIONS' => '電子郵件通知',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => '您想收到哪些網絡活動的電子郵件通知?',
        'NETWORK_MESSAGES' => '網絡訊息',
        'MEMBER_ACTIVITY' => '成員活動',
        'APPROVAL' => '批准',
        'FRIEND_REQUESTS' => '朋友請求',
        'PEOPLE_IVE_INVITED_JOIN' => '被我邀請加入該網絡的人員',
        'MESSAGES_SENT_TO_ME' => '發送給我的訊息',
        'MESSAGES_SENT_TO_GROUPS' => '發送至我所屬的小組的訊息',
        'MESSAGES_SENT_TO_NETWORK' => '發送給整個網絡的訊息',
        'I_HAVE_NEW_COMMENTS' => '我有新的評論要批准',
        'I_HAVE_NEW_NETWORK_CONTENT' => '我有新的網絡內容要批准',
        'CONTENT_ACTIVITY' => '內容活動',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => '我已添加的東西上的活動',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => '自動跟蹤我回覆的討論',
        'THINGS_IVE_ADDED_APPROVED' => '我所添加的內容已被批准',
        'NOTIFICATIONS' => '通知',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => '人們回覆時給我發電郵',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => '人們回覆時不要給我發電郵',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => '要停止追蹤這個%s，<a %s>點擊此處</a>。',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => '您不再跟蹤這個 %s。',
        'NOTIFY' => '通知',
        'STOP_NOTIFYING' => '停止發送通知',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => '有新討論時給我發電郵',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => '有新討論時不要給我發電郵',
        'STOP_FOLLOWING_ALL' => '停止追蹤所有討論和部落格的評論',
        'CHANGE_MY_PHOTO' => '修改我的照片',
        'COUNTRY_AF' => '阿富汗',
        'COUNTRY_AX' => '奧蘭群島',
        'COUNTRY_AL' => '阿爾巴尼亞',
        'COUNTRY_DZ' => '阿爾及利亞',
        'COUNTRY_AS' => '美屬薩摩亞',
        'COUNTRY_AD' => '安道爾',
        'COUNTRY_AO' => '安哥拉',
        'COUNTRY_AI' => '安圭拉',
        'COUNTRY_AQ' => '南極大陸',
        'COUNTRY_AG' => '安地卡及巴布達',
        'COUNTRY_AR' => '阿根廷',
        'COUNTRY_AM' => '亞美尼亞',
        'COUNTRY_AW' => '阿魯巴',
        'COUNTRY_AU' => '澳大利亞',
        'COUNTRY_AT' => '奧地利',
        'COUNTRY_AZ' => '阿塞拜彊',
        'COUNTRY_BS' => '巴哈馬',
        'COUNTRY_BH' => '巴林',
        'COUNTRY_BD' => '孟加拉',
        'COUNTRY_BB' => '巴貝多',
        'COUNTRY_BY' => '白俄羅斯',
        'COUNTRY_BE' => '比利時',
        'COUNTRY_BZ' => '貝里斯',
        'COUNTRY_BJ' => '貝南',
        'COUNTRY_BM' => '百慕達',
        'COUNTRY_BT' => '不丹',
        'COUNTRY_BO' => '玻利維亞',
        'COUNTRY_BA' => '波士尼亞赫塞哥維納',
        'COUNTRY_BW' => '波茲瓦納',
        'COUNTRY_BV' => '布威島',
        'COUNTRY_BR' => '巴西',
        'COUNTRY_IO' => '英屬印度洋領土',
        'COUNTRY_BN' => '汶萊',
        'COUNTRY_BG' => '保加利亞',
        'COUNTRY_BF' => '布吉納法索',
        'COUNTRY_BI' => '蒲隆地',
        'COUNTRY_KH' => '柬埔寨',
        'COUNTRY_CM' => '喀麥隆',
        'COUNTRY_CA' => '加拿大',
        'COUNTRY_CV' => '維德角',
        'COUNTRY_KY' => '開曼群島',
        'COUNTRY_CF' => '中非共和國',
        'COUNTRY_TD' => '查德',
        'COUNTRY_CL' => '智利',
        'COUNTRY_CN' => '中國大陸',
        'COUNTRY_CX' => '聖誕島',
        'COUNTRY_CC' => '可可斯群島',
        'COUNTRY_CO' => '哥倫比亞',
        'COUNTRY_KM' => '科莫洛',
        'COUNTRY_CG' => '剛果共和國',
        'COUNTRY_CD' => '剛果民主共和國',
        'COUNTRY_CK' => '柯克群島',
        'COUNTRY_CR' => '哥斯大黎加',
        'COUNTRY_CI' => '象牙海岸',
        'COUNTRY_HR' => '克羅埃西亞',
        'COUNTRY_CU' => '古巴',
        'COUNTRY_CY' => '賽普勒斯',
        'COUNTRY_CZ' => '捷克共和國',
        'COUNTRY_DK' => '丹麥',
        'COUNTRY_DJ' => '吉布地',
        'COUNTRY_DM' => '多米尼克',
        'COUNTRY_DO' => '多明尼加共和國',
        'COUNTRY_EC' => '厄瓜多',
        'COUNTRY_EG' => '埃及',
        'COUNTRY_SV' => '薩爾瓦多',
        'COUNTRY_GQ' => '赤道幾內亞',
        'COUNTRY_ER' => '厄利垂亞',
        'COUNTRY_EE' => '愛沙尼亞',
        'COUNTRY_ET' => '衣索比亞',
        'COUNTRY_EU' => '歐盟',
        'COUNTRY_FK' => '福克蘭群島',
        'COUNTRY_FO' => '法羅群島',
        'COUNTRY_FJ' => '斐濟',
        'COUNTRY_FI' => '芬蘭',
        'COUNTRY_FR' => '法國',
        'COUNTRY_GF' => '法屬圭亞那',
        'COUNTRY_PF' => '法屬玻里尼西亞',
        'COUNTRY_TF' => '法國南部領土',
        'COUNTRY_GA' => '加彭',
        'COUNTRY_GM' => '甘比亞',
        'COUNTRY_GE' => '喬治亞',
        'COUNTRY_DE' => '德國',
        'COUNTRY_GH' => '迦納',
        'COUNTRY_GI' => '直布羅陀',
        'COUNTRY_GR' => '希臘',
        'COUNTRY_GL' => '格陵蘭',
        'COUNTRY_GD' => '格瑞那達',
        'COUNTRY_GP' => '哥德洛普',
        'COUNTRY_GU' => '關島',
        'COUNTRY_GT' => '瓜地馬拉',
        'COUNTRY_GN' => '幾內亞',
        'COUNTRY_GW' => '幾內亞比索',
        'COUNTRY_GY' => '蓋亞那',
        'COUNTRY_HT' => '海地',
        'COUNTRY_HM' => '赫德島及麥當勞群島',
        'COUNTRY_HN' => '宏都拉斯',
        'COUNTRY_HK' => '香港',
        'COUNTRY_HU' => '匈牙利',
        'COUNTRY_IS' => '冰島',
        'COUNTRY_IN' => '印度',
        'COUNTRY_ID' => '印尼',
        'COUNTRY_IR' => '伊朗伊斯蘭共和國',
        'COUNTRY_IQ' => '伊拉克',
        'COUNTRY_IE' => '愛爾蘭',
        'COUNTRY_IL' => '以色列',
        'COUNTRY_IT' => '義大利',
        'COUNTRY_JM' => '牙買加',
        'COUNTRY_JP' => '日本',
        'COUNTRY_JO' => '約旦',
        'COUNTRY_KZ' => '哈薩克',
        'COUNTRY_KE' => '肯亞',
        'COUNTRY_KI' => '吉里巴斯',
        'COUNTRY_KP' => '朝鮮民主主義人民共和國',
        'COUNTRY_KR' => '大韓民國',
        'COUNTRY_KW' => '科威特',
        'COUNTRY_KG' => '吉爾吉斯斯坦',
        'COUNTRY_LA' => '老撾人民民主共和國',
        'COUNTRY_LV' => '拉脫維亞',
        'COUNTRY_LB' => '黎巴嫩',
        'COUNTRY_LS' => '賴索托',
        'COUNTRY_LR' => '賴比瑞亞',
        'COUNTRY_LY' => '利比亞阿拉伯群眾國',
        'COUNTRY_LI' => '列支敦士敦',
        'COUNTRY_LT' => '立陶宛',
        'COUNTRY_LU' => '盧森堡',
        'COUNTRY_MO' => '澳門',
        'COUNTRY_MK' => '前南斯拉夫共和國的馬其頓共和國',
        'COUNTRY_MG' => '馬達加斯加',
        'COUNTRY_MW' => '馬拉威',
        'COUNTRY_MY' => '馬來西亞',
        'COUNTRY_MV' => '馬爾地夫',
        'COUNTRY_ML' => '馬利',
        'COUNTRY_MT' => '馬爾他',
        'COUNTRY_MH' => '馬歇爾群島',
        'COUNTRY_MQ' => '馬丁尼克',
        'COUNTRY_MR' => '茅利塔尼亞',
        'COUNTRY_MU' => '模里西斯',
        'COUNTRY_YT' => '馬約特',
        'COUNTRY_MX' => '墨西哥',
        'COUNTRY_FM' => '密克羅尼西亞聯邦',
        'COUNTRY_MD' => '摩爾多瓦共和國',
        'COUNTRY_MC' => '摩納哥',
        'COUNTRY_MN' => '蒙古',
        'COUNTRY_MS' => '蒙塞拉特島',
        'COUNTRY_MA' => '摩洛哥',
        'COUNTRY_MZ' => '莫三比克',
        'COUNTRY_MM' => '緬甸',
        'COUNTRY_NA' => '納米比亞',
        'COUNTRY_NR' => '諾魯',
        'COUNTRY_NP' => '尼泊爾',
        'COUNTRY_NL' => '荷蘭',
        'COUNTRY_AN' => '荷屬安的列斯',
        'COUNTRY_NC' => '新喀里多尼亞',
        'COUNTRY_NZ' => '紐西蘭',
        'COUNTRY_NI' => '尼加拉瓜',
        'COUNTRY_NE' => '尼日',
        'COUNTRY_NG' => '奈及利亞',
        'COUNTRY_NU' => '尼烏埃島',
        'COUNTRY_NF' => '諾福克島',
        'COUNTRY_MP' => '北馬里安納群島',
        'COUNTRY_NO' => '挪威',
        'COUNTRY_OM' => '阿曼',
        'COUNTRY_PK' => '巴基斯坦',
        'COUNTRY_PW' => '帛琉',
        'COUNTRY_PS' => '被占巴勒斯坦領土',
        'COUNTRY_PA' => '巴拿馬',
        'COUNTRY_PG' => '巴布亞紐幾內亞',
        'COUNTRY_PY' => '巴拉圭',
        'COUNTRY_PE' => '秘魯',
        'COUNTRY_PH' => '菲律賓',
        'COUNTRY_PN' => '匹特開恩島',
        'COUNTRY_PL' => '波蘭',
        'COUNTRY_PT' => '葡萄牙',
        'COUNTRY_PR' => '波多黎各',
        'COUNTRY_QA' => '卡塔爾',
        'COUNTRY_RE' => '留尼旺島',
        'COUNTRY_RO' => '羅馬尼亞',
        'COUNTRY_RU' => '俄羅斯聯邦',
        'COUNTRY_RW' => '盧安達',
        'COUNTRY_SH' => '聖海倫娜',
        'COUNTRY_KN' => '聖克里斯多福及尼維斯',
        'COUNTRY_LC' => '聖盧西亞',
        'COUNTRY_PM' => '聖皮埃爾和密克隆',
        'COUNTRY_VC' => '聖文森特和格瑞那丁群島',
        'COUNTRY_WS' => '薩摩亞',
        'COUNTRY_SM' => '聖馬力諾',
        'COUNTRY_ST' => '聖多美和普林西比',
        'COUNTRY_SA' => '沙烏地阿拉伯',
        'COUNTRY_SN' => '塞內加爾',
        'COUNTRY_CS' => '塞爾維亞和蒙特內哥羅',
        'COUNTRY_SC' => '塞薛爾',
        'COUNTRY_SL' => '獅子山',
        'COUNTRY_SG' => '新加坡',
        'COUNTRY_SK' => '斯洛伐克',
        'COUNTRY_SI' => '斯洛文尼亞',
        'COUNTRY_SB' => '所羅門群島',
        'COUNTRY_SO' => '索馬利亞',
        'COUNTRY_ZA' => '南非',
        'COUNTRY_GS' => '南喬治亞和南桑德韋奇群島',
        'COUNTRY_ES' => '西班牙',
        'COUNTRY_LK' => '斯里蘭卡',
        'COUNTRY_SD' => '蘇丹',
        'COUNTRY_SR' => '蘇里南',
        'COUNTRY_SJ' => '斯瓦爾巴群島和賈麥恩',
        'COUNTRY_SZ' => '史瓦濟蘭',
        'COUNTRY_SE' => '瑞典',
        'COUNTRY_CH' => '瑞士',
        'COUNTRY_SY' => '敘利亞阿拉伯共和國',
        'COUNTRY_TW' => '臺灣',
        'COUNTRY_TJ' => '塔吉克斯坦',
        'COUNTRY_TZ' => '坦桑尼亞聯合共和國',
        'COUNTRY_TH' => '泰國',
        'COUNTRY_TL' => '東帝汶',
        'COUNTRY_TG' => '多哥',
        'COUNTRY_TK' => '托克勞',
        'COUNTRY_TO' => '東加',
        'COUNTRY_TT' => '特立尼達和多巴哥',
        'COUNTRY_TN' => '突尼斯',
        'COUNTRY_TR' => '土耳其',
        'COUNTRY_TM' => '土庫曼斯坦',
        'COUNTRY_TC' => '特克斯和凱科斯群島',
        'COUNTRY_TV' => '圖瓦盧',
        'COUNTRY_UG' => '烏干達',
        'COUNTRY_UA' => '烏克蘭',
        'COUNTRY_AE' => '阿拉伯聯合酋長國',
        'COUNTRY_GB' => '英國',
        'COUNTRY_US' => '美國',
        'COUNTRY_UM' => '美國外島',
        'COUNTRY_UY' => '烏拉圭',
        'COUNTRY_UZ' => '烏茲別克斯坦',
        'COUNTRY_VU' => '瓦努阿圖',
        'COUNTRY_VA' => '梵蒂岡',
        'COUNTRY_VE' => '委內瑞拉',
        'COUNTRY_VN' => '越南',
        'COUNTRY_VG' => '英屬維爾京群島',
        'COUNTRY_VI' => '美屬維爾京群島',
        'COUNTRY_WF' => '瓦利斯和富圖那',
        'COUNTRY_EH' => '西撒哈拉',
        'COUNTRY_YE' => '也門',
        'COUNTRY_ZM' => '贊比亞',
        'COUNTRY_ZW' => '津巴布韋',
        'ERROR_LOG' => '錯誤日誌',
        'CANNOT_READ_ERROR_LOG' => '無法閱讀錯誤日誌',
        'CANNOT_OPEN_ERROR_LOG' => '無法打開錯誤日誌',
        'CANNOT_SCAN_ERROR_LOG' => '無法掃描錯誤日誌',
        'MODELS_RESET' => '重設模式﹕',
        'NO_MODELS_RESET' => '未重設模式。',
        'NO_FEED_TO_DISPLAY' => '您現在沒有顯示任何項目 。',
        'BOX_WILL_NOT_SHOW_FEED' => '只有當您選中至少一個項目﹐ 其他人才能看得見該框。',
        'CLICK_EDIT_TO_SPECIFY_FEED' => '請點擊 "編輯" 來制定該框的真正簡易新聞訂閱方式 (RSS)',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => '無法取得該真正簡易新聞訂閱方式 (RSS)。',
        'MORE_ELLIPSIS' => '更多的...',
        'RSS' => '真正簡易新聞訂閱方式 (RSS)',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => '對不起, 這個網絡出了點錯。',
        'PLEASE_TRY_REFRESHING' => '請30秒後刷新本頁。 如果您又得到了這個訊息<a %s>請通知我們<a/>。',
        'NO_DISCUSSIONS_TAGGED_X' => '沒有任何討論被貼上 "%1$s"標籤。',
        'PAGE_TITLE_COLON' => '頁面標題：',
        'PAGE_CONTENT' => '內容：',
        'CREATE_PAGE' => '創建頁面',
        'CREATE_NEW_PAGE' => '創建一個新頁面',
        'YOUR_COMMENT' => '您的評論',
        'ADD_YOUR_COMMENT' => '添加您的評論',
        'DELETE_PAGE' => '刪除此頁',
        'DELETE_THIS_PAGE_Q' => '刪除此頁？',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => '您確定要刪除此頁（包括所有的評論）？該過程可能會需要幾分鐘。',
        'SEARCH_PAGES' => '搜索頁面',
        'ALL_PAGES' => '全部頁面',
        'SUBSCRIBE_TO_PAGES' => '訂閱這些頁面',
        'NOBODY_HAS_ADDED_PAGES' => '還沒人添加任何頁面﹗',
        'ADD_PAGES_CALL_TO_ACTION' => '開始創建新頁面。',
        'CREATE_A_PAGE' => '創建一個新頁面',
        'PLEASE_ENTER_PAGE_CONTENT' => '請輸入該頁面的內容',
        'SEARCH_RESULTS_FOR_X' => '<em>%s</em> 的搜索結果',
        'EDIT_YOUR_PAGE' => '編輯您的頁面',
        'UPDATE_PAGE' => '更新頁面',
        'CLOSE_DISCUSSION' => '關閉討論',
        'REOPEN_DISCUSSION' => '開啟討論',
        'CLOSING_DISCUSSION_PREVENTS' => '關閉討論後便不再有任何後續回覆',
        'NO_DISCUSSION_TO_DISPLAY' => '您現在沒有顯示任何討論。',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => '您若沒有選擇至少一個討論﹐該視頻框不會出現。',
        'NEWEST_DISCUSSIONS' => '最新的討論',
        'LATEST_REPLIES' => '最近的回覆',
        'REPLIES_CLOSED_FOR_DISCUSSION' => '該討論已不再接受回覆。',
        'SORRY_DISCUSSION_CLOSED' => '抱歉，但該討論已不再接受後續的回覆。',
        'MOST_REPLIES' => '最多的回覆',
        'OWNER_DISCUSSIONS_ONLY' => '只有網絡創建者的討論',
        'MY_DISCUSSIONS_ONLY' => '只有我的討論',
        'DISCUSSION_DELETED' => '討論已被刪除',
        'DISCUSSION_HAS_BEEN_DELETED' => '該討論已被刪除。',
        'REPLY_DELETED' => '回覆已被刪除',
        'REPLY_HAS_BEEN_DELETED' => '該回覆已被刪除。<a %s>回到討論。</a>',
        'VIEW_ALL_DISCUSSIONS' => '瀏覽全部討論',
        'ADD_CATEGORIES' => '添加類別',
        'CATEGORY' => '類別：',
        'NO_DISCUSSIONS_IN_CATEGORY' => '該類別還沒任何討論。',
        'ADD_MANAGE_CATEGORIES' => '添加/管理類別',
        'VIEW_ALL_N_CATEGORIES' => '瀏覽所有 %s 類別',
        'UNTITLED_CATEGORY' => '無題類別',
        'SAMPLE_TITLE' => '樣本標題',
        'UNCATEGORIZED' => '無類別的',
        'EXISTING_DISCUSSIONS' => '還未被分類的討論。',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => '這裡還沒有任何類別。 現在就添加一個吧！',
        'ADD_A_CATEGORY' => '添加類別',
        'ADD_ANOTHER_CATEGORY' => '添加另一個類別',
        'MANAGE_CATEGORIES' => '管理類別',
        'CATEGORY_TITLE' => '類別標題',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => '允許成員在該類別裡展開討論',
        'ONLY_I_CAN_START_DISCUSSIONS' => '只有我能在該類別裡展開討論',
        'ALLOW_MEMBERS_TO_REPLY' => '只有成員能回覆',
        'SUGGESTIONS' => '建議：',
        'TRY_DIFFERENT_KEYWORDS' => '試試別的或較籠統的關鍵字',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>瀏覽全部討論</a> 或 <a %s>開始新的討論</a>',
        'MAKE_SURE_WORDS_SPELLED' => '請確定所有的字都正確',
        'REPLY_WAS_DELETED' => '該回覆已被刪除',
        'TAGS_X' => '<strong>標籤:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => '發送 訊息',
        'PERMALINK_TO_REPLY' => '永久鏈接到該回覆',
        'PERMALINK' => '永久鏈接',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => '對不起 - 我們無法找到符合您搜索的討論。',
        'DISCUSSIONS_MATCHING_X' => '符合<em>\'%s\'</em>的討論',
        'SEARCH_DISCUSSIONS' => '搜索討論',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => '您還未添加任何討論﹗',
        'ADD_DISCUSSIONS_AND_SHARE' => '添加討論，並和你的朋友，家人或者其他人分享！',
        'DISCUSSION' => '討論',
        'DISCUSSIONS' => '討論',
        'KEEP_PAGE_OPEN_FORUM' => '在上傳文件時請不要關閉該瀏覽窗口。',
        'MEANWHILE_FEEL_FREE_FORUM' => '在此同時, 您可<a %s>另開一個瀏覽視窗</a>繼續瀏覽 %s。',
        'START_A_NEW_DISCUSSION' => '開始新討論',
        'DISCUSSION_TITLE' => '討論標題：',
        'FIRST_POST' => '帖子：',
        'UPLOAD_FILES' => '附加文件：',
        'START_DISCUSSION' => '開始討論',
        'EDIT_DISCUSSION' => '編輯討論',
        'START_A_DISCUSSION' => '開始一個討論',
        'ALL_DISCUSSIONS' => '全部討論',
        'CONTRIBUTORS' => '貢獻者',
        'MY_DISCUSSIONS' => '我的討論',
        'READ_MORE' => '閱讀全文',
        'STARTED_T_BY' => '開始<strong>%s</strong>：',
        'ADDED_BY_X_T' => '由 %s %s添加',
        'STARTED_BY_X_T' => '由 %s %s 開始',
        'REPLY_BY_X_T' => '由<strong>%s</strong>在%s回覆',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => '由 %s開始討論。  最後<a %s>回覆</a>是由%s %s。',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>開始該討論。</strong> 最後<a %s>回覆</a>是由 %s %s。',
        'STARTED_DISCUSSION_T' => '<strong>開始該討論</strong>',
        'ADDED_REPLY_T' => '<strong>添加回覆</strong> %s',
        'ADDED_POST_T' => '<strong>添加帖子</strong> %s',
        'STARTED_BY_X_ON' => '由 %s在 %s開始',
        'STARTED_DISCUSSION_ON' => '<strong>開始該討論</strong>',
        'STARTED_ON' => '<strong>開始</strong> %s',
        'ADDED_REPLY_ON' => '<strong>添加回覆</strong> %s',
        'ADDED_POST_ON' => '<strong>添加帖子</strong> %s',
        'XS_DISCUSSIONS' => '%s 的討論',
        'XS_DISCUSSIONS_LOWERCASE' => '%s 的討論',
        'VIEW_XS_DISCUSSIONS' => '瀏覽%s\'的討論',
        'VIEW_YOUR_DISCUSSIONS' => '瀏覽您的討論',
        'TAGGED_X' => '標籤： %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => '訂閱這些討論',
        'SUBSCRIBE_TO_DISCUSSION' => '訂閱這個討論',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => '訂閱 %s 的討論',
        'ALL_DISCUSSIONS_TAGGED_X' => '全部標籤<em>\'%s\'</em> 標籤的討論',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => '訂閱標籤\'%s\'標籤的討論',
        'N_KB' => '%s  KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => '上傳文件',
        'ATTACHMENTS' => '附加文件',
        'YOUR_POST' => '您的帖子：',
        'YOUR_REPLY' => '您的回覆：',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => '您要上傳文件嗎？',
        'ADD_YOUR_REPLY' => '添加您的回覆',
        'REPLIES_TO_THIS_DISCUSSION' => '該討論的回覆',
        'POSTED_BY_X_ON' => '由%s %s 發表',
        'PLEASE_ENTER_TITLE' => '請輸入本項討論的標題',
        'PLEASE_ENTER_FIRST_POST' => '請寫您第一個討論帖子。',
        'REPLY_TO_THIS' => '回覆',
        'DELETE_ATTACHMENT' => '刪除附加文件',
        'DELETE_ATTACHMENT_Q' => '刪除該附加文件？',
        'DELETE_REPLY' => '刪除回複',
        'DELETE_THIS_DISCUSSION_Q' => '刪除該討論？',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => '您確定要刪除這個討論及全部回覆？ 該過程可能會需要幾分鐘。',
        'DELETE_DISCUSSION' => '刪除該討論',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => '還沒人添加任何討論。',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => '還沒人添加任何討論！ 現在就加第一條吧﹗',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => '您還沒開始任何討論. 現在就加一條吧﹗',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => '您還沒開始任何討論。',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => '您還沒開始任何討論。',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s 還沒添加任何討論。',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s 還沒開始任何討論。',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s 還沒參與任何討論。',
        'VIEW_DISCUSSIONS' => '瀏覽討論',
        'VIEW_ALL_PEOPLE_ON_X' => '瀏覽全部在 %s 的人員',
        'THERE_ARE_NO_DISCUSSIONS' => '您的網絡現在還沒任何討論.',
        'GROUP_HAS_NO_DISCUSSIONS' => '該網絡現在還沒任何討論。',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => '瀏覽全部在 <a %s>%s 論壇 </a>上的討論。',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => '沒有任何標籤為 "%1$s" 的討論。 您可以看看標籤為<a %2$s>"%1$s"的照片</a>﹐ 或標籤為<a %3$s>"%1$s"的視頻</a>﹐ 或添加您自己的討論並加標籤﹗',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => '沒有任何標籤為 "%1$s" 的討論。  您可以看看標籤為<a %2$s>"%1$s"的照片</a>, 或標籤為<a %3$s>"%1$s"的視頻</a>。',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => '這裡至少要有一個討論其他人才能看得見該視頻框。現在就添加一個吧！',
        'DISCUSSIONS_I_STARTED' => '我開始的討論',
        'DISCUSSIONS_X_STARTED' => '%s開始的討論',
        'DISCUSSIONS_I_REPLIED_TO' => '我回覆的討論',
        'DISCUSSIONS_X_REPLIED_TO' => '%s回覆的討論',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => '請填寫您的帖子。',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => '請填寫您的回覆。',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => '您在 %s 上的"%s"討論有新的評論',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => '您在 %s 上的某個討論有新的評論',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => '有人評論了您在 %s 上開始的討論',
        'ABOUT_YOUR_DISCUSSION' => '關於您的討論',
        'ABOUT_THIS_DISCUSSION' => '關於該討論',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s 在%s上面對討論作出回覆',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s 在%s上面對討論"%s"作出回覆',
        'PROBLEM_WITH_ICON' => '您的圖標文件有問題',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => '小組管理者有等同小組創建者的管理權。',
        'CREATE_NEW_GROUP' => '建立新群組',
        'CREATE_A_NEW_GROUP' => '創建一個新小組',
        'CREATE_A_GROUP' => '創建一個小組',
        'VIEW_GROUPS' => '瀏覽小組',
        'CREATE_GROUP' => '創建小組',
        'PLEASE_ENTER_NAME_FOR_GROUP' => '請給您的小組取名.',
        'PLEASE_ENTER_URL_FOR_GROUP' => '請給您的小組選擇網址.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => '網址只能有字母和數字（無空格）.',
        'NAME_TAKEN' => '很抱歉，該名稱已被使用。請另取一個名稱。',
        'URL_TAKEN' => '很抱歉，該網址已被使用。請另擇網址。',
        'GROUP_INFORMATION' => '小組資料',
        'EXTERNAL_WEBSITE' => '其他網站',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => '您的小組是否有其他網站？',
        'URL' => '網址',
        'GROUPS' => '小組',
        'SEARCH_GROUPS' => '搜索小組',
        'NOBODY_HAS_CREATED_GROUPS' => '還沒人創建任何小組。',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => '還沒人創建任何小組﹗您現在就創建一個吧。',
        'MY_GROUPS' => '我的小組',
        'FEATURED_GROUPS' => '特選的小組',
        'YOU_CAN_CREATE_GROUP' => '您可在 %2$s 上<a %1$s>創建新的小組</a>﹗',
        'GROUP_FORUM' => '%s 論壇',
        'USER_CREATED_GROUP' => '%s在 %s 上創建了該小組。',
        'GROUP_MEMBERS_COUNT' => '%s 成員（%d）',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => '抱歉, 您沒被允許加入該小組。',
        'JOIN_GROUP_NOW' => '現在就加入%s!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s 邀請您加入 %s',
        'DECLINE' => '拒絕',
        'WELCOME_TO_GROUP' => '歡迎來到%s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => '您可以參與 %s 的論壇。',
        'SEND_MESSAGE_TO_GROUP' => '給小組發送訊息',
        'LEAVE_THIS_GROUP' => '離開小組',
        'EDIT_GROUP_INFO' => '編輯該小組的訊息',
        'EDIT_GROUP_INFORMATION' => '編輯小組訊息',
        'MANAGE_GROUP_MEMBERS' => '管理小組成員',
        'GROUP_HAS_NO_MEMBERS' => '該小組還沒有任何成員！',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => '該小組沒有符合您搜索條件的成員。',
        'USERS_GROUPS' => '%s的小組',
        'YOU_HAVE_NOT_CREATED_GROUPS' => '您還沒創建任何小組。',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s 還沒創建任何小組。',
        'THERE_ARE_NO_FEATURED_GROUPS' => '您的社交網絡沒有任何特選的小組。',
        'START_FEATURING_GROUPS' => '當您看到“特選”這個選項時，您可以推薦該小組。想要知道更多關於“特選”， 請<a %s>點擊此處</a>。',
        'NO_GROUPS_TO_DISPLAY' => '您現在沒顯示任何小組。',
        'BOX_WILL_NOT_SHOW_GROUPS' => '只有當您選中至少一個小組，其他人才能看得見該框。',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => '您還未創建任何小組！',
        'CREATE_GROUPS_AND_SHARE' => '添加小組，並和你的朋友，家人或者其他人分享！',
        'THERE_ARE_NO_GROUPS' => '您網絡現在還沒小組。',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => '這裡至少要有一個小組其他人才能看得見該框。 現在就添加一個如何﹖',
        'GROUPS_MATCHING_SEARCH_TERM' => '符合<em>%s</em> 的小組',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => '抱歉 － 我們沒有符合您搜索要求的小組。',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>瀏覽所有小組</a> 或 <a %s>創建新小組p</a>',
        'VIEW_ALL_GROUPS' => '瀏覽所有小組',
        'DELETE_GROUP' => '刪除該小組',
        'DELETE_GROUP_Q' => '您確定要刪除該小組？',
        'GROUP_INVITATIONS' => '小組邀請函',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => '您被邀請加入：',
        'VISIT' => '到訪',
        'WHO_CAN_JOIN_GROUP' => '誰可加入該小組？',
        'PRIVACY_CANNOT_BE_CHANGED' => '小組創建後, 就不能更改隱私設定。',
        'ONLY_INVITED_PEOPLE' => '只有被邀請的人員',
        'ALLOW_PEOPLE_TO_REQUEST' => '允許到訪者請求邀請函',
        'ANYONE_CAN_JOIN_GROUP' => '任何人都可加入該小組',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => '只有被邀請的成員才能加入該小組',
        'WHY_NOT_CREATE_GROUP' => '為何不<a %s>創建您自己的小組</a>？',
        'PLEASE_ENTER_NAME' => '請輸入您的名字',
        'PLEASE_ENTER_EMAIL_ADDRESS' => '請輸入您的電子郵件地址',
        'PLEASE_ENTER_PAGE_ADDRESS' => '請輸入一個新頁面地址。',
        'PLEASE_ENTER_PASSWORD' => '請輸入您的密碼。',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>點擊此處創建一個帳戶</a> 或在嘗試在此簽入。',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>點擊此處創建一個帳戶</a>或嘗試用您的Ning 身份加入。',
        'CHOOSE_SHORTER_PASSWORD' => '請選擇一個更短的密碼。',
        'CHOOSE_SHORTER_NAME' => '請選擇一個更短的名字。',
        'ENTER_SHORTER_CITY_NAME' => '請輸入較短的城市名。',
        'PLEASE_ENTER_PASSWORD_AGAIN' => '請在“重新鍵入密碼” 欄裡再次輸入您的密碼。',
        'PLEASE_ENTER_CURRENT_PASSWORD' => '請輸入您當前的密碼。',
        'PLEASE_ENTER_NEW_PASSWORD' => '請輸入您的新密碼。',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => '請在下面的“確認密碼”欄裡再次輸入您的新密碼。',
        'CURRENT_PASSWORD' => '當前的密碼',
        'PASSWORDS_DO_NOT_MATCH' => '兩個密碼不符合。',
        'NEW_AND_CONFIRMATION_PASSWORDS' => '新密碼和確認密碼不符合。',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => '已發送您的請求給小組創建者。',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s 不是有效電郵地址',
        'COME_JOIN_ME_ON_GROUP' => '來加入我的%s﹗',
        'INVITE_PEOPLE_TO_GROUP' => '邀請朋友加入 %s',
        'INVITE_FRIENDS_TO_GROUP' => '邀請朋友到%s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => '邀請別人加入 %s。',
        'GROUPNAME_MEMBERS' => '%s 的成員',
        'GROUP_CREATOR' => '小組創建者',
        'GROUP_ADMINISTRATOR' => '小組管理者',
        'DATE_BANNED' => '被禁止的日期',
        'BAN_FROM_GROUP' => '被該小組禁止參與',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => '您確定要禁止這幾位成員訪問您的小組？ 該過程可能會需要幾分鐘。',
        'ALSO_DELETE_FORUM_POSTINGS' => '同時刪除他們的論壇帖子及回複。',
        'GROUP_WEB_ADDRESS' => '小組網址',
        'GROUP' => '小組',
        'BACK_TO_GROUP' => '← 返回至%s',
        'USER_BANNED_FROM_GROUP' => '%1$s 已被禁止訪問該小組。<a %2$s>給 %1$s 發個訊息</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s 已是該小組成員。 <a %2$s>給 %1$s 發個訊息</a>',
        'GROUP_ADMIN_DISCUSSIONS' => '小組管理討論',
        'BACK_TO_NETWORK_GROUPS' => '返回 %s 小組',
        'MOST_MEMBERS' => '最多成員的',
        'THIS_SETS_URL_OF_GROUP' => '這是您小組的網址：<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => '喜歡您在%s看到的嗎？現在就加入﹗',
        'LIKE_WHAT_YOU_SEE_GROUP' => '喜歡您在%s看到的嗎？現在加入﹗',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => '您已建立了 %1$s小組。您可在 %1$s 論壇上開始一個討論，或邀請更多人加入。',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => '您現在已是 %1$s 的成員。您可參與 %1$s 論壇上的討論，或邀請更多人加入。',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => '該網絡還沒有任何音樂。',
        'PERSON_DOES_NOT_HAVE_MUSIC' => '該成員還沒有任何音樂。',
        'FIND_MORE_MUSIC_LIKE_THIS' => '在 <em>%s</em> 上面找更多和這個類似的音樂。',
        'TRACKS' => '曲目',
        'ADD_MUSIC_TRACKS' => '添加音樂',
        'CHOOSE_MUSIC_TRACKS' => '選擇添加的歌曲',
        'YOU_CAN_ADD_UP_TO_MP3' => '您一次可添加最多4個MP3。',
        'UPLOAD_TRACKS' => '上傳歌曲',
        'ADD_TRACKS' => '添加歌曲',
        'ENTER_THE_URL_MP3_TO_ADD' => '輸入您想添加的MP3的網址：',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => '您可以上傳最多100個 MP3！每個 MP3 不能超過20MB。 文件越小﹐上傳速度越快。',
        'BE_NICE' => '小心別亂來哦！',
        'PLEASE_UPLOAD_ONLY_TRACKS' => '請您只上傳您有版權﹐ 或得到藝術家或版權持有者許可的歌曲。',
        'PLEASE_LINK_ONLY_TRACKS' => '請您只鏈接到已被授權可在網上發表的的音樂。',
        'MORE_WAY_TO_ADD_MUSIC' => '更多添加音樂的方法...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '...從別的網站',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => '只需粘貼鏈接到您的MP3就可通過任何網站添加音樂。',
        'KEEP_PAGE_OPEN_MUSIC' => '在歌曲上傳時請不要關閉該瀏覽窗口。歌曲被批准後候我們會通知你！',
        'MEANWHILE_FEEL_FREE_MUSIC' => '在此同時﹐ 您可<a %s>另開新的瀏覽視窗</a>繼續瀏覽%s。上傳結束後﹐ 您可以為歌曲添加標題和描述。',
        'TRACKS_EXCEEDED_LIMIT' => '曲目超過了每首10MB的限制。',
        'EDIT_TRACK_INFORMATION' => '編輯歌曲信息',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => '給剛上傳的歌曲添加一個標題，描述和其他信息。',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => '給這首歌添加一個標題，描述和其他信息。',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => 'Â« 取消並回到播放清單',
        'EACH_VIDEO_MAY_BE_100MB' => '每個視頻最大可以達到 100MB。我們支援 .mov、.mpg、.avi、.wmv 和 .3gp 格式的視頻檔案。',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => '根據<a %s>服務條款</a>，我有上傳此視頻的權限。',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => '批量視頻上傳程式要求最近版本的 Java。<strong><a %s>點擊此處以獲取 Java</a></strong>，或<strong><a %s>返回簡單上傳程式</a></strong>。',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => '從您的電腦上傳視頻',
        'HAVE_LOT_OF_VIDEOS' => '您有很多視頻想要分享嗎？',
        'TRY_BULK_VIDEO_UPLOADER' => '嘗試批量視頻上傳程式',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => '您的視頻已成功上傳。',
        'VIDEOS_UPLOADED_AWAITING' => '您的視頻已成功上傳，正等待 %s 的建立者核准。',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => '如果要從手機直接添加視頻或照片到 %s，可將照片或視頻發送到一個電子郵件信箱。',
        'GRAB_HTML_EMBED' => '從任何熱門視頻網站抓取 HTML 內嵌代碼 (embed)，並添加該視頻到這個網絡裡。',
        'GOOGLE' => 'Google',
        'YOUTUBE' => 'YouTube',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => '使用批量視頻上傳程式有困難嗎？<strong><a %s>返回簡單上傳程式</a></strong>。',
        'ADD_VIDEOS_FROM_YOUTUBE' => '從 YouTube 或 Google 添加視頻',
        'TAGS_NO_COLON' => '標籤',
        'NO_VIDEOS_TAGGED_X_CHECK' => '沒有任何標籤為"%1$s"的視頻。您可以看看<a %2$s>"%1$s"標籤的論談</a>、<a %4$s>"%1$s"標籤的部落格帖子</a>或<a %3$s> "%1$s"標籤的照片</a>。或添加您自己的視頻並加標籤﹗',
        'UPLOAD_VIDEOS_FROM' => '從您的電腦上傳視頻',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => '您上傳到 %s 的視頻由於轉換錯誤沒有完成。',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => '為了幫助排除故障，請提供此視頻 ID：%s',
        'TO_VIEW_THE_VIDEO_VISIT' => '要檢視視頻，請瀏覽：',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => '您的視頻 "%1$s"（在 %2$s 上）有一條新評論。',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => '您在 %s 上的視頻有一條新評論。',
        'ADD_VIDEOS_BY_PHONE_OR' => '通過手機或電子郵件添加視頻',
        'FEATURING_ELLIPSIS' => '精采推薦…',
        'NOW_FEATURED_ON_MAIN' => '主頁的精采推薦',
        'DONT_FEATURE' => '不要推薦',
        'UNFEATURING_ELLIPSIS' => '正在從主頁中移除...',
        'REMOVED_FROM_MAIN' => '已從主頁中移除',
        'ADDED_EXCLAMATION' => '已添加！',
        'ERROR' => '錯誤',
        'ADDING_ELLIPSIS' => '正在添加…',
        'TRACK_COULD_NOT_BE_LOADED' => '無法載入歌曲',
        'INVALID_URL' => '無效的網址',
        'NORMAL_PLAYBACK_ON' => '正常播放：開啟',
        'REPEAT_PLAYBACK_ON' => '重複播放：開啟',
        'SHUFFLE_PLAYBACK_ON' => '隨機播放：開啟',
        'OPEN_POPUP_WINDOW' => '開啟彈跳視窗',
        'LOADING_PLAYLIST_ELLIPSIS' => '正在載入播放清單...',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => '每張照片最大可以達到 10MB。我們支援 .jpg、.gif 和 .png 格式的照片檔案。',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => '根據<a %s>服務條款</a>，我有上傳這些照片的權限。',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => '批量照片上傳程式要求最近版本的 Java。<strong><a %s>點擊此處以獲取 Java</a></strong>，或<strong><a %s>返回簡單上傳程式</a></strong>。',
        'TRY_BULK_PHOTO_UPLOADER' => '嘗試批量照片上傳程式',
        'HAVE_LOT_OF_PHOTOS' => '您有很多照片想要分享嗎？',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => '您的照片已成功上傳。',
        'PHOTOS_UPLOADED_AWAITING' => '您的照片已成功上傳，正等待 %s 的建立者核准。',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => '從 Flickr 添加照片',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => '如果要從手機直接添加照片或視頻到 %s，可將照片或視頻發送到一個電子郵件信箱。',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => '使用批量照片上傳程式有困難嗎？<strong><a %s>返回簡單上傳程式</a></strong>。',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => '從您的電腦上傳照片',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => '您的照片 "%1$s"（在 %2$s 上）有一條新評論。',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => '您在 %s 上的照片有一條新評論。',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => '有一位新 %1$s 在 %2$s 上等待您的批准...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => '有一位新 %1$s 在 %2$s 上等待您的批准。',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => '有一位新 %1$s "%2$s" 在 %3$s 上等待您的批准。',
        'TO_APPROVE_THIS_X_VISIT' => '要批准此 %s，請瀏覽：',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => '您的 %1$s 在 %2$s 上已被批准...',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => '您的 "%1$s"（在 %2$s 上）有一條新評論...',
        'CLICK_HERE_TO_JOIN' => '點擊此處加入:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s 邀請您看看在 %3$s 上的 "%2$s"！',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => '您的 %s 在 %s 上已被批准。',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => '您的 %1$s "%2$s" 在 %3$s 上已被批准。',
        'TO_VIEW_YOUR_X_VISIT' => '要檢視您的 %s，請瀏覽：',
        'TO_VIEW_THIS_X_VISIT' => '要檢視此 %s，請瀏覽：',
        'TO_VIEW_IT_VISIT' => '要檢視它，請瀏覽：',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s 報告了關於 %2$s 的以下問題...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s 已在 %2$s 上面給您發送了一則短信。',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s 申請加入 %3$s 上的 %2$s。',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => '要批准或拒絕  %s\'s 申請，請瀏覽：',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s 把評論添加到 %3$s 上的部落格帖子 "%2$s"。',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s 把評論添加到 %2$s 上的部落格帖子...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => '有一位新成員在 %s 上等待您的批准。',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => '歡迎來到 %2$s 上的 "%1$s" 小組',
        'PLEASE_SELECT_A_MEMBER' => '請選擇一位或多位成員',
        'LOADING_YOUR_FRIENDS' => '我們正在載入您的朋友...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => '您的訊息已發送',
        'TO_SEND_ANOTHER_MESSAGE' => '要發送其他訊息，請在下面輸入文本。',
        'PLEASE_CHOOSE_FRIENDS' => '請在發送訊息之前選擇一些朋友。',
        'RESEND_INVITATION' => '重新發送邀請信',
        'CHOOSE_FRIENDS' => '選擇朋友...',
        'ALL_FRIENDS' => '所有朋友',
        'ALL_FRIENDS_ON_APPNAME' => '%s 上的所有朋友',
        'SHARE_WITH_FRIENDS' => '與朋友分享',
        'SHARE_THIS_WITH_FRIENDS' => '與您的朋友分享此項目',
        'COMPOSE_MESSAGE' => '編寫訊息',
        'INVITATION_LINK_ONLY_VISIBLE' => '只有網絡建立者和管理員能夠看到此邀請住處鏈接。使用此鏈接加入的成員將自動成為網絡建立者的朋友。',
        'WE_ARE_LOADING_ADDRESSES' => '我們正在載入您的地址簿...',
        'SELECT_ALL_NONE' => '選擇全部/無',
        'INVITE_TO_APPNAME' => '邀請參與 \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => '邀請您的朋友參與 \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '（已是此網絡的成員）',
        'OR_SHARE_THIS_INVITATION_LINK' => '或共享此邀請鏈接：',
        'CLICK_TO_MAIL' => '<a %s>點擊此處以立即郵寄</a>。',
        'MESSAGE_HAS_BEEN_SENT' => '您的訊息已發送',
        'YOU_CAN_SHARE_THIS' => '您可以與下面的更多人分享，或<a %s>返回到上一頁</a>。',
        'VCARD_IMPORT_UNAVAILABLE' => '很抱歉，目前不提供 vCard 匯入服務。',
        'CSV_IMPORT_UNAVAILABLE' => '很抱歉，目前不提供 CSV 匯入服務。',
        'ERROR_OCCURRED' => '很抱歉，出現錯誤。',
        'IMPORT_FAILED' => '很抱歉，匯入失敗。',
        'LOGIN_FAILED' => '很抱歉，登入失敗。',
        'UNABLE_TO_FIND_EMAIL' => '很抱歉，我們找不到電子郵件欄位。',
        'CANNOT_READ_VCARDS' => '很抱歉，我們無法讀取這些 vCard。',
        'SORRY_WE_DO_NOT_SUPPORT' => '對不起，我們不支持您的電郵地址的網絡地址簿。請嘗試點擊下面的「通訊簿申請」來使用您電腦裡的地址。',
        'NO_ADDRESSES_FOUND' => '找不到地址',
        'WE_DID_NOT_FIND_ADDRESSES' => '我們在匯入的地址簿中找不任何地址。',
        'WANT_TO_INVITE_MORE_FRIENDS' => '想邀請更多朋友？從網路或桌面地址簿應用程式中匯入聯絡方式。',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => '從網路地址簿匯入',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => '從地址簿應用程式匯入',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook、Apple Address Book、.CSV 等',
        'PRIVACY_POLICY' => '隱私權政策',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => '現在就申請成為會員。已是會員了嗎？<a %s>點擊此處登入</a>。',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '以下關於 %2$s 的意見由 %1$s 提供：',
        'TRACK_STATISTICS' => '追蹤統計數據',
        'FEATURED_MEMBERS' => '特別推薦會員',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => '看看在 %2$s 上的 "%1$s"...',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => '看看在 %2$s 上的此 %1$s...',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => '抱歉，沒有找到符合 "%s" 的會員。',
        'WHO_CAN_COMMENT_ON_POST' => '該能在該帖子上添加評論？',
        'SEND_MESSAGE_TO_FRIENDS' => '向朋友發送訊息',
        'PREVIOUS_POST' => '← 上一個帖子',
        'NEXT_POST' => '下一個帖子 →',
        'PREVIOUS_POSTS' => '← 前面的帖子',
        'NEXT_POSTS' => '後面的帖子 →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => '沒有任何標籤為"%1$s"的部落格帖子。您可以看看<a %2$s>"%1$s"標籤的論談</a>、<a %4$s>"%1$s"標籤的照片</a>或<a %3$s> "%1$s"標籤的視頻</a>。或添加您自己的部落格帖子並加標籤﹗',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => '為 %s %s 標記為 <em>\'%s\'</em> 的所有照片',
        'ALL_POSTS_TAGGED_X' => '標記為 <em>\'%s\'</em> 的所有照片',
        'MY_BLOG_POSTS_FOR_M_Y' => '我給 %s %s 的部落格帖子',
        'MY_BLOG_POSTS' => '我的部落格帖子',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => '請為發送給所有朋友的訊息通知挑一個有效的選擇',
        'PRIVACY_CONTENT_CONTROL' => '隱私和內容控制',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => '啟用音樂播放器下載鏈接',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => '歡迎，%1$s！您是 %3$s 的第 #%2$s位成員。<a %4$s>現在就邀請朋友</a>。',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => '您對照片 <a %s>%s</a> 進行了評論',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s 對照片 <a %s>%s</a> 進行了評論',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => '您對視頻 <a %s>%s</a> 進行了評論',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s 對視頻 <a %s>%s</a> 進行了評論',
        'NOTIFY_BLOG_PING_SERVICES' => '當您添加新帖子時，是否想通知第三方部落格帖子追蹤服務？',
        'YES_NOTIFY_BLOG_SERVICES' => '是 – 當我添加新部落格帖子時，通知<a %s>現場更新服務</a>',
        'THERE_ARE_NO_FEATURED_MEMBERS' => '您的社交網絡沒有任何特選的會員。',
        'START_FEATURING_MEMBERS_CLICK_Y' => '當您看到「特選」這個選項時，您可以推薦會員。要知道關於特選的更多資訊，請<a %s>點擊此處</a>。',
        'THIS_IS_YOUR_PAGE' => '這是您的頁面：',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => '發送給所有朋友的訊息',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => '要停止追蹤此 %s，請移至：',
        'SHOW_ALL' => '顯示全部',
        'CHOOSE_GADGETS' => '從這些好玩的 OpenSocial 小工具中選擇一個，添加到您的設定檔頁！您可以<a %s>在此處檢視和評估小工具</a>，或<a %s>在此處了解關於 OpenSocial 的更多資訊</a>。',
        'GADGETS_UNAVAILABLE' => '小工具暫時不提供',
        'APOLOGIES_GADGETS_UNAVAILABLE' => '很抱歉 - 小工具暫時不提供。',
        'BOX_WILL_NOT_SHOW_GADGET' => '只有當您選中一個小工具﹐其他人才能看得見該框。',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => '請點擊「編輯」為該框指定小工具網絡地址，或瀏覽<a %s>小工具目錄</a>。',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => '無法取得該小工具網絡地址訂閱方式。',
        'ADD_GADGET_TO_YOUR_PAGE' => '把此小工具添加到您的設定檔',
        'GADGETS_BETA' => '小工具 (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => '嘗試 OpenSocial 小工具。警告：該功能已經過試驗。',
        'ADD_TO_MY_PAGE' => '添加我的頁面',
        'GADGETS' => '小工具',
        'GADGETS_TAB_TEXT' => '小工具',
        'GADGET' => '小工具',
        'GADGETS_IS_IN_BETA' => '小工具 (Beta)。',
        'SORRY_GADGET_UNAVAILABLE' => '很抱歉，但該小工具不可用。請檢查確定您有正確的網絡地址。如果您仍有問題，<a %s>請告訴我們</a>。',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => '沒有任何標籤為"%1$s"的討論。您可以看看<a %2$s>"%1$s"標籤的照片</a>、<a %4$s>"%1$s"標籤的部落格帖子</a>或<a %3$s> "%1$s"標籤的視頻</a>。或添加您自己的照片並加討論﹗',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => '沒有任何標籤為"%1$s"的討論。您可以看看<a %2$s>"%1$s"標籤的照片</a>、<a %4$s>"%1$s"標籤的部落格帖子</a>或<a %3$s> "%1$s"標籤的視頻</a>。',
        'ALREADY_MEMBER_OF_GROUP' => '（已是該組成員）',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => '邀請您的朋友參與 \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => '來加入我在 %2$s 上的 %1$s。',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => '來加入我在 %2$s 上的 %1$s...',
        'INVITE_TO_GROUP' => '邀請參與 \'%s\'',
        'YOU_CAN_ADD_100_SONGS' => '您總共可添加 100 首歌曲，每首歌曲最大可達 20MB。我們支持 .mp3 格式的檔案。',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => '根據<a %s">服務條款</a>，我有上傳這些歌曲的權限。',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => '批量音樂上傳程式要求最近版本的 Java。<strong><a %s>點擊此處以獲取 Java</a></strong>，或<strong><a %s>返回簡單上傳程式</a></strong>。',
        'HAVE_LOT_OF_MUSIC' => '您有很多音樂想要分享嗎？',
        'TRY_BULK_MUSIC_UPLOADER' => '嘗試批量音樂上傳程式',
        'SONGS_SUCCESSFULLY_UPLOADED' => '您的歌曲已成功上傳。',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => '抱歉，您在播放清單中只能有 %s 首歌曲。請刪除一些現有的歌曲，然後再添加。',
        'ADD_MUSIC_FROM_WEBSITE' => '從別的網站添加音樂',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => '使用此音樂上傳程式有困難嗎？<strong><a %s>返回簡單上傳程式</a></strong>。',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => '從您的電腦上傳音樂',
        'ADD_MUSIC' => '添加音樂',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => '選擇<strong>使用者</strong>和<strong>所有頁面</strong>。',
        'TRACK_TITLE' => '歌曲標題',
        'TRACK_ARTIST' => '歌手',
        'TRACK_ALBUM' => '專輯',
        'ENABLE_DOWNLOAD_LINK' => '開啟下載鏈接',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => '允許大家將該歌曲放入他們的頁面',
        'TRACK_ARTWORK' => '藝術作品',
        'EDIT_PLAYLIST' => '編輯播放列表',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => '您可以隨意調整歌曲的順序 － 先點擊歌曲﹐ 再拖放到您想要的地方。',
        'ADD_MUSIC_ELLIPSIS' => '添加音樂...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '...從您的電腦上',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => '從電腦上傳MP3。',
        'DELETE_THIS_TRACK_Q' => '刪除這首歌曲？',
        'DELETE_TRACK' => '刪除歌曲',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => '您確定要刪除這首歌曲嗎？',
        'PLAY' => '播放',
        'GENRE' => '風格',
        'YEAR' => '年份',
        'LABEL' => '唱片公司',
        'EXPLICIT_LYRICS' => '限制級歌詞',
        'ARTIST_SITE' => '歌手網站',
        'HOSTING_SITE' => '寄存網站',
        'LABEL_SITE' => '唱片公司網站',
        'LICENSE' => '授權',
        'SELECT_LICENSE' => '— 選擇授權 —',
        'LICENSE_NAME' => '授權名稱',
        'LICENSE_URL' => '授權網址',
        'MUSIC' => '音樂',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => '允許成員上傳及分享音樂',
        'PLAYLIST' => '播放列表',
        'PODCAST' => '播客',
        'MOST_RECENT_TRACKS' => '最新的',
        'FEATURED_TRACKS' => '特選的',
        'HIGHEST_RATED_TRACKS' => '最高評分的',
        'NO_TRACKS_TO_PLAY' => '您的網絡還沒有音樂。',
        'BOX_WILL_NOT_SHOW_TRACKS' => '這裡至少要有一首歌曲或播客其他人才能看得見該框。現在就添加一個吧。',
        'NO_TRACKS_ON_PLAYLIST' => '您的播放列表目前沒有歌曲。',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => '這裡至少要有一首歌曲或播客才會顯示播放器。 現在就添加一個吧。',
        'NO_FEATURED_TRACKS' => '您網絡上還沒有被推薦的歌曲。',
        'START_FEATURING_TRACKS' => '當您聽到您喜歡的歌時﹐您可以推薦它到首頁。',
        'VIEW_MUSICPLAYER' => '瀏覽音樂播放器',
        'MY_PLAYLIST' => '我的播放列表',
        'NETWORK_PLAYLIST' => '網絡上的播放列表',
        'COPYRIGHT' => 'Â©版權所有',
        'CC_BY_X' => '創意公共園地原作者：%s',
        'CC_BY_SA_X' => '創意公共園地授權條款一致%s',
        'CC_BY_ND_X' => '創意公共園地－不允許衍生著作：%s',
        'CC_BY_NC_X' => '創意公共園地－非商業用途：%s',
        'CC_BY_NC_SA_X' => '創意公共園地－非商業用途授權條款一致：%s',
        'CC_BY_NC_ND_X' => '創意公共園地－非商業用途－不允許衍生著作：%s',
        'PUBLICDOMAIN' => '公共領域',
        'FACEBOOK_CONFIRM_DISABLE' => '您確定？',
        'FACEBOOK_PLAYER_DISABLE' => '停用',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => '音樂播放器',
        'FACEBOOK_MUSIC_PLAYER_DESC' => '允許任何人在他們的Facebook簡介頁面上添加可播放您選擇的音樂的應用程序。',
        'FACEBOOK_MUSIC_BUTTON' => '創建音樂播放應用程序 &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => '已開啟 Facebook 音樂播放器。',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => '視頻播放器',
        'FACEBOOK_VIDEO_PLAYER_DESC' => '允許任何人在他們的Facebook簡介頁面上添加可播放您網絡上的視頻的應用程序。',
        'FACEBOOK_VIDEO_BUTTON' => '創建視頻播放應用程序 &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => '已開啟 Facebook 視頻播放器。',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => '照片幻燈片',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => '允許任何人在他們的Facebook簡介頁面上添加可播放您網絡上的照片幻燈片的應用程序。',
        'FACEBOOK_SLIDESHOW_BUTTON' => '創建照片幻燈片應用程序 &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => '已開啟 Facebook 照片幻燈片.',
        'FACEBOOK_PLATFORM_LOGO' => 'Facebook 平台標誌',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook﹐一個熱門的社交網絡﹐允許第三方開發者創建一些可加在Facebook 成員簡介頁面上的應用程序。  這些應用程序不僅可增加簡介頁面的功能﹐也可將 Facebook 的用戶帶到其他網站。',
        'FACEBOOK_QUICK_INTRO_2' => '通過 Ning﹐您不必是網路工程師也可以Facebook推廣您的社交網絡。 我們已經為您建造好了基礎, 您的網絡已有了和 Facebook 應用程序集成的功能。  您只要從以下選擇您要的選項﹐ 您的社交網絡馬上就可與Facebook集成。',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => '添加開發者按鈕',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => '安裝新應用程序按鈕',
        'FACEBOOK_YOUR_APPLICATIONS' => '您的 Facebook 應用程序',
        'FACEBOOK_EMBEDDING' => 'Facebook網站推廣',
        'FACEBOOK_SETUP' => 'Facebook網站推廣',
        'FACEBOOK_PROMOTING' => '在 Facebook 上推廣應用程序',
        'FACEBOOK_VIEW_APP' => '查看應用程序',
        'FACEBOOK_ADD_THE' => '添加',
        'FACEBOOK_RECENT' => '最新的',
        'FACEBOOK_RECENTLY_FEATURED' => '最新特選的',
        'FACEBOOK_RECENTLY_ADDED' => '最新添加的',
        'FACEBOOK_PROMOTED' => '特選的',
        'FACEBOOK_RATED' => '最高評分的',
        'FACEBOOK_POPULAR' => '最有人氣的',
        'FACEBOOK_MUSIC_WIDGET' => '音樂小工具',
        'FACEBOOK_VIDEO_WIDGET' => '視頻小工具',
        'FACEBOOK_PHOTO_WIDGET' => '照片小工具',
        'FACEBOOK_INSTR_FIRST_STEPS' => '第一步',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => '點擊這裡到 Facebook 並創建您的應用程序。',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => '這將在另一視窗打開 Facebook。您若還沒登錄 Facebook，您必須現在在此登錄。',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => '您還沒創建您在 Facebook 上的應用程序﹐ 您會被要求添加 Facebook 開發者應用程序。當您看到 "You have no applications"（您還沒有應用程序）時﹐ 請點擊<strong>Create one</strong>（創建）。',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => '如果您在 Facebook 上已有應用程序﹐ 您將會到達 Facebook 開發者應用程序頁面。 請點擊<strong>Set Up New Application</strong>（安裝新應用程序）。',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => '下一步：如何安裝您 %s 應用程序使其在 Facebook 上運作。',
        'FACEBOOK_INSTR_SETUP' => '安裝說明',
        'FACEBOOK_INSTR_SETUP_1' => 'Facebook 需要知道您應用程序的一些基本資料。  請按照以下這幾個簡單步驟來做！',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => '必填項',
        'FACEBOOK_INSTR_SETUP_2' => '選擇 <strong>應用程序名稱</strong>。',
        'FACEBOOK_INSTR_SETUP_3' => '請勾選表示您已讀過 Facebook 的用戶協議。',
        'FACEBOOK_INSTR_SETUP_4' => '打開 <em>Optional Fields</em>（可選項）部分。',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => '基本項',
        'FACEBOOK_INSTR_SETUP_5' => '在<strong>Support E-Mail</strong>（支持電郵）裡輸入您電郵地址',
        'FACEBOOK_INSTR_SETUP_6' => '粘貼以下網址到<strong>Callback URL</strong> (回叫網址)裡：',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => '選擇一個<strong>畫布頁面網址</strong> (e.g. <em>%s</em>)。',
        'FACEBOOK_INSTR_SETUP_8' => '在<em>Can your application be added on Facebook</em>（可否在 Facebook 上添加您的應用程序）這項選<strong>Yes</strong>（是）。',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => '安裝選項',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => '填寫<strong>應用程序描述</strong>。',
        'FACEBOOK_INSTR_SETUP_9' => '粘貼以下代碼到<strong>Default FBML</strong>(預設Facebook標識語言)裡﹕',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => '在 <strong>Default Profile Box Column</strong>(預設簡介框列) ﹐ 選<strong>Wide</strong>（寬）。',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => '在 <strong>Default Profile Box Column</strong>(預設簡介框列) ﹐ 選<strong>Narrow</strong>（窄）。',
        'FACEBOOK_INSTR_SETUP_10' => '在 <strong>Side Nav URL</strong>(側邊導航網址)裡﹐ 輸入您的<em>Canvas Page URL</em>（上面&#8216;f&#8217;步) 。請確定有包括網址 的 http://apps.facebook.com/ 部分。',
        'FACEBOOK_INSTR_SETUP_11' => '填寫 <strong>Attachment action</strong> （附加行動） 的文字內容。 如果您想在Facebook上發送訊息給其他人並包括您的一個應用程序﹐ 這將是被顯示出來的內容。  如果您的應用程序是照片幻燈片﹐您可輸入“某某網絡的照片”。 如果您的應用程序是視頻﹐ 您可輸入 "某某網絡的視頻" 。',
        'FACEBOOK_INSTR_SETUP_12' => '粘貼以下網址到<strong>Callback URL</strong> (回叫網址)裡：',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Facebook 應用程序安裝網頁',
        'FACEBOOK_INSTR_SETUP_DONE' => '當您完成後﹐ 請點擊<strong>Submit</strong>(提交)按鈕。',
        'FACEBOOK_INSTR_SETUP_NEXT' => '下一步：獲取您的API鍵與密鑰。',
        'FACEBOOK_API_INFO_TITLE' => 'Facebook API資料',
        'FACEBOOK_API_INFO_DESC' => '請輸入您的API鍵﹐密鑰﹐及應用程序網址以完成安裝。',
        'FACEBOOK_API_INFO_FIND_KEY' => '您可在 <a %s> My Applications page on Facebook (我在Facebook的應用程序) 頁面</a>上(點擊該鏈接將會開啟新視窗) ，在應用程序標題下找到您的API鍵和密鑰。',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => '“我的應用程序”頁面（突出API資料的位置）',
        'FACEBOOK_API_INFO_KEY' => 'API 鍵',
        'FACEBOOK_API_INFO_SECRET' => 'API 密鑰',
        'FACEBOOK_URL_INFO_TITLE' => 'Facebook 應用程序網址',
        'FACEBOOK_URL_INFO_DESC' => '應用程序網址就是您在上頁(&#8216;f&#8217;步)所設定的<strong>Canvas Page URL</strong>(畫布頁面網址)。',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Facebook音樂應用程序將播放：',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Facebook視頻應用程序將播放：',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Facebook幻燈片應用程序將播放：',
        'FACEBOOK_PROMOTING_ON' => '在Facebook網站上推廣',
        'FACEBOOK_SETUP_INSTR' => '安裝說明',
        'FACEBOOK_API_INFO' => 'API資料',
        'FACEBOOK_DISABLE' => '關閉該應用程序',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => '到您的Facebook簡介頁面上',
        'FACEBOOK_BACK_TO_EMBEDDING' => '返回到Facebook上的推廣',
        'FACEBOOK_EMBEDDING_DESC' => '允許 Facebook 用戶把您網絡的小工具及徽章放在他們的簡介頁面上。',
        'FACEBOOK_PROMOTE' => '如何最有效推廣您的應用程序？ 我們建議您採取以下幾個步驟。  您可通過 Facebook的 <strong><a %s>My Applications</a></strong> （我的應用程序） 頁面訪問這些選項 (點擊該鏈接將會開啟新視窗) 。',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => '提供一個“關於” 的頁面',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => '給您的應用程序提供一個清楚的描述﹐ 向Facebook用戶介紹您的應用程序。 請點擊您要修改應用程序的<strong>Edit About Page</strong> (編輯關於頁面)的鏈接﹐進行編輯。',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => '提交應用程序至 Facebook 目錄',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => '讓大家都知道你的新應用程序－把它添加在 Facebook 目錄裡。',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => '點擊您在修改的應用程序旁﹐ "<strong>Submit Application</strong>"(提交應用程序)的鏈接來提交您的應用程序。 在下面一頁﹐ 您還可以編輯應用程序描述﹐ 並添加應用程序標誌。',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => '添加該應用程序到您 Facebook 的簡介頁面',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => '您現在可以炫燿一下您的應用程序！將您的應用程序加入您 Facebook 的簡介頁面﹐然後坐看您的朋友競相模仿。',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => '請點擊您所要添加的應用程序旁的<strong>View About Page</strong>(瀏覽關于頁面) 的鏈接﹐ 然後在下一頁點擊“Add Application” (添加應用程序)按鈕。 。',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => '您的應用程序現已顯示在您 Facebook 簡介頁面的最下面﹗',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => '我在 Facebook 上的應用程序頁面',
        'FACEBOOK_MY_APPS' => '我的應用程序',
        'FORUM_TAB_TEXT' => '論壇',
        'VIDEOS_TAB_TEXT' => '視頻',
        'PHOTOS_TAB_TEXT' => '照片',
        'GROUPS_TAB_TEXT' => '小組',
        'ADD_PHOTOS_LOWER' => '添加照片',
        'WHICH_FRIENDS_TO_SHARE_WITH' => '您想和哪些朋友分享？',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}